/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.file.AbstractFileStorageTier;
import io.axoniq.axonserver.localstorage.file.ByteBufferEventSource;
import io.axoniq.axonserver.localstorage.file.EventInformation;
import io.axoniq.axonserver.localstorage.file.EventSource;
import io.axoniq.axonserver.localstorage.file.FilePreparedTransaction;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.Segment;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.StorageTier;
import io.axoniq.axonserver.localstorage.file.Synchronizer;
import io.axoniq.axonserver.localstorage.file.WritableEventSource;
import io.axoniq.axonserver.localstorage.file.WritePosition;
import io.axoniq.axonserver.localstorage.file.a;
import io.axoniq.axonserver.localstorage.transformation.EventTransformer;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.localstorage.transformation.ProcessedEvent;
import io.axoniq.axonserver.localstorage.transformation.WrappedEvent;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WritableFileStorageTier
extends AbstractFileStorageTier {
    private final EventTransformer g;
    private final Synchronizer C;
    private final MeterFactory H;
    protected final ConcurrentNavigableMap<Long, ByteBufferEventSource> K;
    private static final Logger i = LoggerFactory.getLogger(WritableFileStorageTier.class);
    private final FileSystemMonitor F;
    private Path c;
    protected final AtomicLong I;
    private final Gauge j;
    protected final AtomicReference<WritePosition> G;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FilePreparedTransaction b(List<Event> list, int n) {
        void a22;
        Object a3 = list;
        WritableFileStorageTier a4 = this;
        a3 = a3.stream().map(event -> {
            WritableFileStorageTier a2 = event;
            WritableFileStorageTier a3 = this;
            return new WrappedEvent((Event)a2, a3.g);
        }).collect(Collectors.toList());
        WritableFileStorageTier writableFileStorageTier = a4;
        int n2 = writableFileStorageTier.b((List)a3);
        WritePosition a22 = writableFileStorageTier.b(n2, a3.size(), (int)a22);
        return new FilePreparedTransaction(a22, n2, (List)a3);
    }

    public long A() {
        WritableFileStorageTier a3;
        return (Long)a3.b((T a2) -> a2.allSegments().findFirst().orElse(-1L), (Object)-1L);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    protected WritableEventSource b(FileVersion fileVersion, int n, boolean bl) {
        WritableEventSource a2322;
        Object a32222;
        Object object;
        void a4;
        WritableFileStorageTier writableFileStorageTier;
        block21: {
            void a223322;
            writableFileStorageTier = this;
            StorageProperties storageProperties = (StorageProperties)writableFileStorageTier.C.get();
            File file = storageProperties.dataFile(writableFileStorageTier.g, (FileVersion)a4);
            int n2 = Math.max(storageProperties.getSegmentSize(), (int)a223322);
            if (file.exists()) {
                void a2322;
                if (a2322 != false && file.length() < (long)a223322) {
                    object = (ByteBufferEventSource)writableFileStorageTier.K.remove(a4.b());
                    if (object != null) {
                        object.b(0L);
                    }
                    FileUtils.b((File)file);
                } else {
                    n2 = (int)file.length();
                }
            } else if (a4.b() > 0) {
                object = storageProperties.dataFile(writableFileStorageTier.g, new FileVersion(a4.b(), 0));
                if (((File)object).exists()) {
                    a32222 = (ByteBufferEventSource)writableFileStorageTier.K.remove(a4.b());
                    if (a32222 != null) {
                        a32222.b(0L);
                    }
                    FileUtils.b((File)object);
                }
            }
            object = new RandomAccessFile(file, ClusterTemplateController.b((Object)"J+"));
            a32222 = ((RandomAccessFile)object).getChannel();
            i.info(TaskPublisher.b((Object)"\u001aO[\u0012.B\u0004\\\b\\\u0006\u0012\u0007[\rWAI\u001c"), (Object)writableFileStorageTier.e, (Object)file);
            MappedByteBuffer mappedByteBuffer = ((FileChannel)a32222).map(FileChannel.MapMode.READ_WRITE, 0L, n2);
            mappedByteBuffer.put((byte)2);
            mappedByteBuffer.putInt(storageProperties.getFlags());
            WritableEventSource a223322 = new WritableEventSource(file.getAbsolutePath(), (ByteBuffer)mappedByteBuffer, a4.b(), a4.b(), writableFileStorageTier.g, storageProperties);
            writableFileStorageTier.K.put(a4.b(), a223322);
            a2322 = a223322;
            if (a32222 == null) break block21;
            ((AbstractInterruptibleChannel)a32222).close();
        }
        ((RandomAccessFile)object).close();
        return a2322;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Throwable throwable2;
                        block22: {
                            if (a32222 != null) {
                                try {
                                    ((AbstractInterruptibleChannel)a32222).close();
                                    throwable2 = throwable;
                                    break block22;
                                }
                                catch (Throwable a223322) {
                                    throwable.addSuppressed(a223322);
                                }
                            }
                            throwable2 = throwable;
                        }
                        throw throwable2;
                    }
                    catch (Throwable a32222) {
                        Throwable throwable3;
                        try {
                            ((RandomAccessFile)object).close();
                            throwable3 = a32222;
                        }
                        catch (Throwable throwable4) {
                            Throwable throwable5 = a32222;
                            throwable3 = throwable5;
                            throwable5.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Exception exception) {
                    throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, writableFileStorageTier.e + ": Failed to create segment: " + (FileVersion)a4, (Throwable)exception);
                }
            }
        }
    }

    private /* synthetic */ int b(List<ProcessedEvent> list) {
        Object a2 = list;
        WritableFileStorageTier a3 = this;
        long l = 0L;
        Object object = a2 = a2.iterator();
        while (object.hasNext()) {
            ProcessedEvent processedEvent = (ProcessedEvent)a2.next();
            l += (long)(4 + processedEvent.getSerializedSize());
            object = a2;
        }
        if (l > Integer.MAX_VALUE) {
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, a3.e + ": Transaction size exceeds maximum size");
        }
        return (int)l;
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeSegment(long l, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        if (a4.K.containsKey((long)a2)) {
            return a4.b((long)a2, a3);
        }
        return (Boolean)a4.b(arg_0 -> WritableFileStorageTier.b((long)a2, a3, arg_0), (Object)true);
    }

    /*
     * WARNING - void declaration
     */
    public void activateSegmentVersion(long l, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        a4.b(arg_0 -> WritableFileStorageTier.b((long)a2, a3, arg_0));
    }

    private static /* synthetic */ Optional f(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(Map map, ProcessedEvent processedEvent, long l, int n) {
        void a2;
        void a3;
        void a4;
        void a5;
        int n2 = n;
        WritableFileStorageTier a6 = this;
        a6.b((ProcessedEvent)a5, (long)a4, (int)a3, (Map)a2);
    }

    /*
     * WARNING - void declaration
     */
    public WritableFileStorageTier(EventTypeContext eventTypeContext, IndexManager indexManager, Supplier<StorageProperties> supplier, Supplier<StorageTier> supplier2, MeterFactory meterFactory, ScheduledExecutorService scheduledExecutorService, String string, EventTransformerFactory eventTransformerFactory, FileSystemMonitor fileSystemMonitor) {
        void a2;
        void a3;
        void a4;
        void a5;
        WritableFileStorageTier a6;
        void a7;
        void a8;
        void a9;
        void a10;
        WritableFileStorageTier a11;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = meterFactory;
        WritableFileStorageTier writableFileStorageTier3 = a11 = writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier4 = a11;
        super((EventTypeContext)a10, (IndexManager)a9, (Supplier)a8, (Supplier)a7, (MeterFactory)a6, (String)a5);
        WritableFileStorageTier writableFileStorageTier5 = a11;
        writableFileStorageTier5.G = new AtomicReference();
        WritableFileStorageTier writableFileStorageTier6 = a11;
        writableFileStorageTier4.I = new AtomicLong(-1L);
        WritableFileStorageTier writableFileStorageTier7 = a11;
        writableFileStorageTier4.K = new ConcurrentSkipListMap(Comparator.reverseOrder());
        writableFileStorageTier4.H = a6;
        writableFileStorageTier3.F = a4;
        writableFileStorageTier3.g = a3.get(((StorageProperties)a8.get()).getFlags());
        WritableFileStorageTier writableFileStorageTier8 = a11;
        writableFileStorageTier8.C = new Synchronizer((EventTypeContext)a10, (StorageProperties)a8.get(), (MeterFactory)a6, (ScheduledExecutorService)a2, writePosition -> {
            WritableFileStorageTier a2;
            WritableFileStorageTier a3 = writePosition;
            WritableFileStorageTier writableFileStorageTier = a2 = this;
            writableFileStorageTier.H.complete(new FileVersion(a3.j.longValue(), 0));
            writableFileStorageTier.b(arg_0 -> writableFileStorageTier.b((WritePosition)a3, arg_0));
        });
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a10.b();
        stringArray[2] = "type";
        stringArray[3] = a10.b().name();
        a11.j = a6.gauge((MetricName)BaseMetricName.Ga, Tags.of((String[])stringArray), (Object)a11.C, synchronizer -> {
            WritableFileStorageTier a2 = synchronizer;
            WritableFileStorageTier a3 = this;
            return (double)a3.I.get() - (double)a2.b();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ FileVersion b(FileVersion fileVersion, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        WritableEventSource a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier2 = this;
        if (!writableFileStorageTier2.H.validIndex((FileVersion)a3)) {
            return a3;
        }
        a2 = writableFileStorageTier2.b((FileVersion)a3, a2.getSegmentSize(), false);
        long l = a3.b();
        try {
            WritableFileStorageTier a42222 = a2.createEventIterator(a3.b());
            try {
                while (a42222.hasNext()) {
                    a42222.b();
                    ++l;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (a42222 != null) {
                    try {
                        a42222.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable a42222) {
                        throwable.addSuppressed(a42222);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        catch (Throwable a42222) {
            writableFileStorageTier2.K.remove(a3.b());
            a2.b(0L);
            throw a42222;
        }
        if (a42222 != null) {
            writableFileStorageTier = writableFileStorageTier2;
            a42222.close();
        } else {
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.K.remove(a3.b());
        a2.b(0L);
        return new FileVersion(l, 0);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(WritePosition writePosition) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.K.remove(a2.j);
        i.debug(ClusterTemplateController.b((Object)"p=V8]8\u00183N9J|C!\u0014|J9U=Q2Q2_|K9_1]2L/\u0002|C!"), (Object)a2.j, (Object)writableFileStorageTier.getSegments());
        if (a3 != null) {
            a3.b((long)((StorageProperties)writableFileStorageTier.C.get()).getPrimaryCleanupDelay());
        }
    }

    private static /* synthetic */ Flux b(String string, StorageTier storageTier) {
        String a2 = storageTier;
        String a3 = string;
        return a2.fileVersions(a3);
    }

    public int b() {
        WritableFileStorageTier a2;
        return a2.K.size();
    }

    /*
     * WARNING - void declaration
     */
    public void b(long l, long l2) {
        void a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a4 = (StorageProperties)writableFileStorageTier.C.get();
        File file = new File(writableFileStorageTier.g);
        FileUtils.b((File)file);
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
        writableFileStorageTier.H.init();
        writableFileStorageTier2.b((long)a3, file, (long)a2, (StorageProperties)a4);
        writableFileStorageTier2.c = file.toPath();
        writableFileStorageTier2.F.registerPath(writableFileStorageTier.b(), writableFileStorageTier.c, a4.minFreeSpace(), a4.warnFreeSpace());
    }

    private static /* synthetic */ Stream f(long l, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    private /* synthetic */ String b() {
        WritableFileStorageTier a2;
        WritableFileStorageTier writableFileStorageTier = a2;
        return writableFileStorageTier.e + "-" + writableFileStorageTier.e.b().name().toLowerCase();
    }

    public void initSegments(long a2) {
    }

    private static /* synthetic */ Optional b(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    private /* synthetic */ void b(SortedSet<FileVersion> sortedSet) {
        SortedSet<FileVersion> a2 = sortedSet;
        WritableFileStorageTier a3 = this;
        i.warn(ClusterTemplateController.b((Object)"'Ef\u0018\u001eM0Sq[.]=L5V;\u00185V8]$\u00189V(J5]/\u0018:W.\u0018'E|K9_1]2L/"), (Object)a3.e, (Object)a2.size());
        Instant instant = Instant.now();
        if (a3.H.canBatchIndexParallel() && ((StorageProperties)a3.C.get()).isBulkIndexAllowParallel()) {
            i.info(TaskPublisher.b((Object)"I\u001c\bA{\u000fV\u0004J\b\\\u0006\u0012\u0016[\u0015ZAB\u0000@\u0000^\rW\r\u0012\u0012G\u0011B\u000e@\u0015"), (Object)a3.e);
            a2.parallelStream().forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.b(arg_0 -> WritableFileStorageTier.b((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.b());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.b();
                        if (!eventInformation.b()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.b().getAggregateSequenceNumber(), eventInformation.b(), eventInformation.b());
                        hashMap.computeIfAbsent(eventInformation.b().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.H.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        } else {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.e;
            objectArray[1] = a3.H.canBatchIndexParallel();
            objectArray[2] = ((StorageProperties)a3.C.get()).isBulkIndexAllowParallel();
            i.info(ClusterTemplateController.b((Object)"'Ef\u0018\u0015V8]$Q2_|K9I)]2L5Y0T%\u0018t}*Y0M=L5W2\u00183^|H=J=T0]0\u00185V8]$Q2_f\u00185V8]${=H=Z5T5L5]/\u0002'E|\u001ez\u0018?W2L9@(k9L(Q2_/\u0002'Eu"), objectArray);
            a2.forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.b(arg_0 -> WritableFileStorageTier.b((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.b());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.b();
                        if (!eventInformation.b()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.b().getAggregateSequenceNumber(), eventInformation.b(), eventInformation.b());
                        hashMap.computeIfAbsent(eventInformation.b().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.H.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        }
        i.warn(TaskPublisher.b((Object)"\u001aO[\u0012#G\rYLQ\u0013W\u0000F\b\\\u0006\u0012\b\\\u0005W\u0019\u0012\u0015]\u000eYAI\u001c"), (Object)a3.e, (Object)Duration.between(instant, Instant.now()));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ WritePosition b(int n, int n2, int n3, WritePosition writePosition) {
        void a2;
        void a3;
        WritePosition a4 = writePosition;
        int a5 = n;
        return a4.b(a5, (int)a3, (int)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean b(long l, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.K.remove((long)a2);
        if (byteBufferEventSource != null) {
            byteBufferEventSource.b(0L);
        }
        if (a4.H.remove(a3 = new FileVersion((long)a2, a3)) && FileUtils.b((File)a4.f(a3))) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ WritePosition b(int n, int n2, int n3) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        int n4 = (int)Math.ceil((double)a3 / 32767.0);
        if ((n4 = a4 + n4 * 11) > 0x7FFFFFF6 || a4 <= 0) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a4;
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, String.format(ClusterTemplateController.b((Object)"q0T9_=T|L.Y2K=[(Q3V|K5B9\u0002|\u001d8"), objectArray));
        }
        do {
            if (!(a4 = (WritePosition)a5.G.getAndUpdate(arg_0 -> WritableFileStorageTier.b((int)a3, n4, (int)a2, arg_0))).f(n4) && !a4.A((int)a2)) continue;
            i.debug(TaskPublisher.b((Object)"\u001aO[\u0012\"@\u0004S\u0015[\u000fUA\\\u0004EAA\u0004U\fW\u000fFAI\u001c"), (Object)a5.e, (Object)a4.G);
            WritePosition writePosition = a4;
            writePosition.F.b(writePosition.c, -1);
            WritableEventSource writableEventSource = a5.b(new FileVersion(a4.G, (int)a2), n4 + 5 + 4, true);
            a5.G.set(a4.b(writableEventSource, (int)a2));
        } while (!a4.b(n4) || a4.A((int)a2));
        return a4;
    }

    private static /* synthetic */ Optional b(long a2, StorageTier a3) {
        return a3.eventSource(a2);
    }

    /*
     * WARNING - void declaration
     */
    public Integer currentSegmentVersion(Long l) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.K.get(a2);
        if (a3 != null) {
            return a3.b();
        }
        return (Integer)writableFileStorageTier.b(arg_0 -> WritableFileStorageTier.b((Long)a2, arg_0), (Object)0);
    }

    private static /* synthetic */ void b(long l, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        a3.activateSegmentVersion(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(ProcessedEvent processedEvent, long l, int n, Map<String, List<IndexEntry>> map) {
        WritableFileStorageTier a3 = processedEvent;
        WritableFileStorageTier a4 = this;
        if (a3.isDomainEvent()) {
            void a5;
            void a6;
            void a7;
            a7.computeIfAbsent(a3.getAggregateIdentifier(), a2 -> new ArrayList()).add(new IndexEntry(a3.getAggregateSequenceNumber(), (int)a6, (long)a5));
        }
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(long l) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.b((long)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.b(arg_0 -> WritableFileStorageTier.b((long)a2, arg_0), Optional.empty());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(long l, File file, long l2, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        int n;
        WritableFileStorageTier a3;
        HashMap<String, List> a222;
        WritableEventSource a4;
        FileVersion a5;
        long a6;
        WritableFileStorageTier writableFileStorageTier2;
        block10: {
            block8: {
                void a222;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier2 = this;
                a5 = writableFileStorageTier3.b(a6, (File)a5, new FileVersion((long)a222, 0), (StorageProperties)a4);
                writableFileStorageTier3.b(a5.b());
                a5 = writableFileStorageTier3.b(a5, (StorageProperties)a4);
                writableFileStorageTier3.b((T storageTier) -> {
                    FileVersion a2 = storageTier;
                    FileVersion a3 = a5;
                    a2.initSegments(a3.b());
                });
                WritableFileStorageTier writableFileStorageTier4 = writableFileStorageTier2;
                writableFileStorageTier4.f();
                a4 = writableFileStorageTier4.b(a5, a4.getSegmentSize(), false);
                writableFileStorageTier4.H.remove(a5);
                a6 = a5.b();
                a222 = new HashMap<String, List>();
                a3 = a4.createEventIterator();
                try {
                    WritableFileStorageTier writableFileStorageTier5 = a3;
                    while (writableFileStorageTier5.hasNext()) {
                        EventInformation eventInformation = a3.b();
                        if (eventInformation.b()) {
                            IndexEntry indexEntry = new IndexEntry(eventInformation.b().getAggregateSequenceNumber(), eventInformation.b(), a6);
                            a222.computeIfAbsent(eventInformation.b().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                        }
                        ++a6;
                        writableFileStorageTier5 = a3;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (a3 != null) {
                            try {
                                a3.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                n = a3.b();
                writableFileStorageTier2.I.set(a6 - 1L);
                if (a3 == null) break block8;
                writableFileStorageTier = writableFileStorageTier2;
                a3.close();
                break block10;
            }
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.H.addToActiveSegment(Long.valueOf(a5.b()), a222);
        a4.b(n, 0);
        a3 = new WritePosition(a6, n, a5.b(), a4, Long.valueOf(a5.b()), 0);
        WritableFileStorageTier writableFileStorageTier6 = writableFileStorageTier2;
        writableFileStorageTier6.G.set(a3);
        writableFileStorageTier6.C.b((WritePosition)a3);
        i.info(ClusterTemplateController.b((Object)"C!\u0002|k9_1]2L/\u00185V5L5Y0Q&]8"), (Object)writableFileStorageTier2.e);
    }

    public Flux<FileVersion> fileVersions(String string) {
        Object a2 = string;
        WritableFileStorageTier a3 = this;
        return (Flux)a3.b(arg_0 -> WritableFileStorageTier.b((String)a2, arg_0), (Object)Flux.empty());
    }

    protected Optional<EventSource> b(FileVersion fileVersion) {
        WritableFileStorageTier a2 = fileVersion;
        WritableFileStorageTier a3 = this;
        return a3.b(a2.b());
    }

    public void handover(Segment segment, Runnable runnable) {
        Runnable a2 = runnable;
        WritableFileStorageTier a3 = this;
        a2.run();
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(FileVersion fileVersion) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.b((FileVersion)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.b(arg_0 -> WritableFileStorageTier.f((FileVersion)a2, arg_0), Optional.empty());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(long l, Integer n) {
        void a2;
        Integer a3 = n;
        WritableFileStorageTier a4 = this;
        a4.b((long)a2, a3.intValue());
    }

    /*
     * WARNING - void declaration
     */
    public void A(long l) {
        void a22;
        WritableFileStorageTier writableFileStorageTier = this;
        if (!writableFileStorageTier.K.containsKey((long)a22)) {
            return;
        }
        if (a22 == ((Long)writableFileStorageTier.K.firstKey()).longValue()) {
            i.info(ClusterTemplateController.b((Object)"C!\u0002|~3J?Q2_|V9@(\u0018/];U9V(\u0018(W|Z9\u0018?J9Y(]8"), (Object)writableFileStorageTier.e);
            StorageProperties a22 = (StorageProperties)writableFileStorageTier.C.get();
            WritePosition writePosition2 = (WritePosition)writableFileStorageTier.G.getAndUpdate(writePosition -> {
                StorageProperties a2 = writePosition;
                StorageProperties a3 = a22;
                return a2.b(0, a3.getSegmentSize(), 0);
            });
            if (writePosition2.f(a22.getSegmentSize())) {
                i.debug(TaskPublisher.b((Object)"\u001aO[\u0012\"@\u0004S\u0015[\u000fUA\\\u0004EAA\u0004U\fW\u000fFAI\u001c"), (Object)writableFileStorageTier.e, (Object)writePosition2.G);
                WritePosition writePosition3 = writePosition2;
                writePosition3.F.b(writePosition3.c, -1);
                WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier;
                WritableFileStorageTier a3 = writableFileStorageTier2.b(new FileVersion(writePosition2.G, 0), a22.getSegmentSize(), false);
                writableFileStorageTier.G.set(writePosition2.b((WritableEventSource)a3, 0));
                writableFileStorageTier2.C.f(new WritePosition(writePosition2.G, 0, 0, (WritableEventSource)a3, Long.valueOf(writePosition2.G), writePosition2.K));
            }
        }
        writableFileStorageTier.b();
    }

    public SortedSet<FileVersion> segmentsWithoutIndex() {
        WritableFileStorageTier a2;
        return (SortedSet)a2.b(StorageTier::segmentsWithoutIndex, Collections.emptySortedSet());
    }

    private static /* synthetic */ Stream b(long l, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FileVersion b(long l, File file, FileVersion fileVersion, StorageProperties storageProperties) {
        void a2;
        void a3;
        WritableFileStorageTier a4;
        void a5;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = storageProperties;
        WritableFileStorageTier a6 = writableFileStorageTier;
        return Arrays.stream(FileUtils.b((File)a5, (String)a4.getEventsSuffix())).map(FileUtils::b).filter(arg_0 -> WritableFileStorageTier.b((long)a3, arg_0)).max(FileVersion::b).orElse((FileVersion)a2);
    }

    private /* synthetic */ void f() {
        WritableFileStorageTier writableFileStorageTier = this;
        Object a2 = writableFileStorageTier.segmentsWithoutIndex();
        if (a2.size() > 0) {
            writableFileStorageTier.b((SortedSet)a2);
        }
        i.info(TaskPublisher.b((Object)"\u001aO[\u0012(\\\u0005W\u0019\u0012\u000e\\AV\bA\n\u0012\bAAG\u0011\u0012\u0015]AV\u0000F\u0004"), (Object)writableFileStorageTier.e);
    }

    /*
     * WARNING - void declaration
     */
    public Stream<String> b(long l, int n, boolean bl) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        if (a3 != false) {
            return Stream.concat(a5.K.entrySet().stream().map(entry -> {
                Map.Entry a2 = entry;
                Object a3 = this;
                return FileUtils.b((File)a3.f(new FileVersion(((Long)a2.getKey()).longValue(), ((ByteBufferEventSource)a2.getValue()).b())));
            }), (Stream)a5.b(arg_0 -> WritableFileStorageTier.b((long)a2, a4, arg_0), Stream.empty()));
        }
        return (Stream)a5.b(arg_0 -> WritableFileStorageTier.f((long)a2, a4, arg_0), Stream.empty());
    }

    public long f() {
        WritableFileStorageTier a2;
        return ((WritePosition)a2.G.get()).G;
    }

    public long b(List<Event> list, int n) {
        FilePreparedTransaction a2;
        WritableFileStorageTier a3;
        int a222 = n;
        WritableFileStorageTier writableFileStorageTier = a3 = this;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.F.checkFreeSpace(writableFileStorageTier2.c);
        HashMap hashMap = new HashMap();
        a2 = writableFileStorageTier.b((List)a2, a222);
        WritePosition a222 = a2.b();
        writableFileStorageTier2.b(a222, a2.b(), hashMap);
        writableFileStorageTier.H.addToActiveSegment(a222.j, hashMap);
        writableFileStorageTier.I.set(a222.G + (long)a2.b().size() - 1L);
        writableFileStorageTier.C.f(a222);
        return a222.G;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(WritePosition writePosition, List<ProcessedEvent> list, Map<String, List<IndexEntry>> map) {
        void a2;
        void a3;
        WritableFileStorageTier a4 = writePosition;
        WritableFileStorageTier a5 = this;
        WritableFileStorageTier writableFileStorageTier = a4;
        a4.F.b((List)a3, writableFileStorageTier.c, writableFileStorageTier.G, (arg_0, arg_1, arg_2) -> a5.b((Map)a2, arg_0, arg_1, arg_2));
    }

    private /* synthetic */ void b() {
        WritableFileStorageTier writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier = this;
        while (true) {
            if (writableFileStorageTier2.K.size() == 1) break;
            try {
                Thread.sleep(10L);
                writableFileStorageTier2 = writableFileStorageTier;
            }
            catch (InterruptedException a2) {
                Thread.currentThread().interrupt();
                throw new MessagingPlatformException(ErrorCode.OTHER, writableFileStorageTier.e + ": Interrupted while waiting for completion", (Throwable)a2);
            }
        }
    }

    protected Optional<EventSource> b(long a2) {
        WritableFileStorageTier a3;
        if (a3.K.containsKey(a2)) {
            return Optional.of((EventSource)a3.K.get(a2));
        }
        return Optional.empty();
    }

    public SortedSet<Long> getSegments() {
        WritableFileStorageTier a2;
        return a2.K.keySet();
    }

    private static /* synthetic */ Boolean b(long l, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.removeSegment(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(WritePosition writePosition, StorageTier storageTier) {
        void a2;
        WritableFileStorageTier a3 = writePosition;
        WritableFileStorageTier a4 = this;
        a2.handover((Segment)new a(a4, (WritePosition)a3), () -> a4.b((WritePosition)a3));
    }

    private static /* synthetic */ Integer b(Long l, StorageTier storageTier) {
        Long a2 = storageTier;
        Long a3 = l;
        return a2.currentSegmentVersion(a3);
    }

    public long size() {
        WritableFileStorageTier a3;
        return a3.K.values().stream().mapToLong(a2 -> a2.C.capacity()).sum() + (Long)a3.b(StorageTier::size, (Object)0L);
    }

    public long b() {
        WritableFileStorageTier a2;
        return a2.I.get();
    }

    public void close(boolean bl) {
        boolean a2 = bl;
        WritableFileStorageTier a3 = this;
        File file = new File(a3.g);
        WritableFileStorageTier writableFileStorageTier = a3;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.F.unregisterPath(writableFileStorageTier2.b());
        writableFileStorageTier.H.remove((Meter)a3.j);
        writableFileStorageTier2.C.b();
        writableFileStorageTier.K.forEach((l, byteBufferEventSource) -> {
            void a2;
            WritableFileStorageTier a3 = byteBufferEventSource;
            WritableFileStorageTier a4 = this;
            a3.b(0L);
            if (a2 != false) {
                void a5;
                a4.f(a5.longValue());
            }
        });
        a3.b((T storageTier) -> {
            StorageTier a2 = storageTier;
            boolean a3 = a2;
            a2.close(a3);
        });
        boolean bl2 = a2;
        a3.H.cleanup(bl2);
        if (bl2) {
            FileUtils.b((File)file);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void f(long l) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)writableFileStorageTier.K.remove((long)a2);
        int a3 = 0;
        if (byteBufferEventSource != null) {
            ByteBufferEventSource byteBufferEventSource2 = byteBufferEventSource;
            a3 = byteBufferEventSource2.b();
            byteBufferEventSource2.b(0L);
        }
        writableFileStorageTier.b((long)a2, a3).forEach(arg_0 -> writableFileStorageTier.b((long)a2, arg_0));
    }

    private static /* synthetic */ boolean b(long a2, FileVersion a3) {
        if (a3.b() < a2) {
            return true;
        }
        return false;
    }
}

