/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.enterprise.replication.SnapshotDataProviders;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.rest.json.MessageJson;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="QueryCache")
public class QueryCache
implements NonReplacingConstraintCache<String, ActiveQuery> {
    private final int F = 25000;
    private final long c;
    private final Map<String, ActiveQuery> I;
    private final Logger j;
    private final long G;

    @EventListener
    public void on(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected) {
        QueryCache a2 = queryHandlerDisconnected;
        QueryCache a3 = this;
        a3.I.forEach((arg_0, arg_1) -> a3.b((TopologyEvents.QueryHandlerDisconnected)a2, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    public ActiveQuery putIfAbsent(String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3;
        QueryCache a4 = activeQuery;
        QueryCache queryCache = a3 = this;
        queryCache.b();
        return (ActiveQuery)queryCache.I.putIfAbsent(a2, a4);
    }

    public ActiveQuery remove(String string) {
        QueryCache a2;
        Object a3 = string;
        QueryCache queryCache = a2 = this;
        queryCache.j.debug(MessageJson.b((Object)"\u001b9$3?9i1,/:=.9\u00008i'4"), a3);
        return (ActiveQuery)queryCache.I.remove(a3);
    }

    public QueryCache(@Value(value="${axoniq.axonserver.default-query-timeout:300000}") long defaultQueryTimeout, @Value(value="${axoniq.axonserver.query-cache-capacity:0}") long a2) {
        QueryCache queryCache = this;
        QueryCache queryCache2 = this;
        queryCache2.j = LoggerFactory.getLogger(QueryCache.class);
        queryCache2.F = 25000;
        QueryCache queryCache3 = this;
        queryCache.I = new ConcurrentHashMap();
        queryCache.c = defaultQueryTimeout;
        if (a2 > 0L) {
            this.G = a2;
            return;
        }
        defaultQueryTimeout = DataSize.ofBytes((long)Runtime.getRuntime().maxMemory()).toGigabytes();
        this.G = defaultQueryTimeout > 0L ? 25000L * defaultQueryTimeout : 25000L;
    }

    public ActiveQuery get(String string) {
        Object a2 = string;
        QueryCache a3 = this;
        return (ActiveQuery)a3.I.get(a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(ActiveQuery activeQuery, String string) {
        void a2;
        Object a3 = string;
        QueryCache a4 = this;
        a4.j.debug(SnapshotDataProviders.b((Object)";K\u0015T\u0014A\fAXU\rA\n]X_\u0005\u0004\u001eK\n\u0004\tQ\u001dV\u0001\u0004\u0010E\u0016@\u0014A\n\u0004\u0011@\u001dJ\fM\u001eM\u001d@XF\u0001\u0004\u001bH\u0011A\u0016P+P\nA\u0019I1@X_\u0005\n"), (Object)a2.b(), a3);
        if (a2.b((String)a3)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a3;
            if (a2.b((String)a3, ErrorCode.CONNECTION_TO_HANDLER_LOST, String.format(MessageJson.b((Object)"\n3'2,?=5&2i(&|!='8%9;|l/i0&/="), objectArray))) {
                a4.remove(a2.b());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected, String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3 = activeQuery;
        QueryCache a4 = this;
        a4.b((ActiveQuery)a3, a2.f());
    }

    public Collection<Map.Entry<String, ActiveQuery>> entrySet() {
        QueryCache a2;
        return a2.I.entrySet();
    }

    public Set<Map.Entry<String, ActiveQuery>> timedOut() {
        QueryCache a4;
        long l = System.currentTimeMillis() - a4.c;
        return a4.entrySet().stream().filter(a3 -> {
            if (((ActiveQuery)a3.getValue()).b() < l) {
                return true;
            }
            return false;
        }).filter(a2 -> {
            if (!((ActiveQuery)a2.getValue()).b()) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
    }

    public boolean isEmpty() {
        QueryCache a2;
        return a2.I.isEmpty();
    }

    public int size() {
        QueryCache a2;
        return a2.I.size();
    }

    private /* synthetic */ void b() {
        QueryCache a2;
        if ((long)a2.I.size() >= a2.G) {
            throw new InsufficientBufferCapacityException("Query buffer is full (" + a2.G + "/" + a2.G + ") Query handlers might be slow. Try increasing 'axoniq.axonserver.query-cache-capacity' property.");
        }
    }
}

