/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.enterprise.replication.BackupInfoController;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.BackupInfoRestController;
import io.axoniq.axonserver.rest.RestResponse;
import io.axoniq.axonserver.transport.rest.ApplicationRestController;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.security.Principal;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/backup"})
public class ClusterBackupInfoRestController {
    private static final Logger c = AuditLog.getLogger();
    private final BackupInfoRestController I;
    private final GrpcRaftController j;
    private final BackupInfoController G;

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/log/filenames"})
    public List<String> b(@Parameter(deprecated=true, description="Indicates the replication group, use 'replicationgroup' paramater") @RequestParam(value="context", defaultValue="default") String string, @RequestParam(value="replicationgroup", required=false) String string2, @Parameter(hidden=true) Principal principal) {
        RaftGroup context;
        ClusterBackupInfoRestController clusterBackupInfoRestController = object;
        Object object = string2;
        ClusterBackupInfoRestController replicationGroup = clusterBackupInfoRestController;
        if (object == null) {
            object = context;
        }
        if (c.isInfoEnabled()) {
            void a2;
            c.info(RestResponse.b((Object)"V~pX-Whtx`~q-qb%al~q-glffp}%kla`~%kj\u007f%\u007f`}idflqdjc%jwbp}%vx#"), (Object)AuditLog.username((Principal)a2), (Object)StringUtils.sanitize((String)object));
        }
        if ((context = replicationGroup.j.getRaftGroup((String)object)) == null) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, (String)object + ": replication group not found");
        }
        return context.localLogEntryStore().getBackupFilenames().collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    public ClusterBackupInfoRestController(BackupInfoRestController backupInfoRestController, GrpcRaftController grpcRaftController, BackupInfoController backupInfoController) {
        void a2;
        void a3;
        ClusterBackupInfoRestController a4;
        ClusterBackupInfoRestController a5 = backupInfoController;
        ClusterBackupInfoRestController clusterBackupInfoRestController = a4 = this;
        a4.I = a3;
        clusterBackupInfoRestController.j = a2;
        clusterBackupInfoRestController.G = a5;
    }

    @PostMapping(value={"/createControlDbBackup"})
    public String b(@Parameter(hidden=true) Principal principal) throws SQLException {
        ClusterBackupInfoRestController clusterBackupInfoRestController = object;
        Object object = principal;
        ClusterBackupInfoRestController a2 = clusterBackupInfoRestController;
        c.info(ApplicationRestController.b((Object)"m\u0019K?\u00160S\u0013C\u0007E\u0016\u0016\u0016YBU\u0010S\u0003B\u0007\u0016\u0001Y\fB\u0010Y\u000eR\u0000\u0016\u0000W\u0001]\u0017FL"), (Object)AuditLog.username((Principal)object));
        a2.j.getRaftGroups().forEach(string -> {
            ClusterBackupInfoRestController a2;
            Object a3 = string;
            ClusterBackupInfoRestController clusterBackupInfoRestController = a2 = this;
            Object object = a3;
            clusterBackupInfoRestController.G.registerControlDbBackup((String)object, clusterBackupInfoRestController.j.getRaftGroup((String)object).logEntryProcessor().f(), System.currentTimeMillis());
        });
        return a2.I.b();
    }
}

