/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.interceptor.PluginEnabledEvent;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.rest.json.UserInfo;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private final ClusterTemplateController m;
    private final ClusterController B;
    private final ApplicationEventPublisher g;
    private final FeatureChecker C;
    public static final String H = "_none";
    private final RaftConfigServiceFactory K;
    private final ClusterTopology F;
    private static final Logger c = AuditLog.getLogger();
    private final DistributeLicenseService I;
    private final Predicate<String> j;
    private static final Logger G = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    /*
     * WARNING - void declaration
     */
    public ClusterRestController(ClusterController clusterController, RaftConfigServiceFactory raftConfigServiceFactory, FeatureChecker featureChecker, DistributeLicenseService distributeLicenseService, ApplicationEventPublisher applicationEventPublisher, ClusterTopology clusterTopology, ClusterTemplateController clusterTemplateController) {
        ClusterRestController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        ClusterRestController a9;
        ClusterRestController clusterRestController = clusterRestController2;
        ClusterRestController clusterRestController2 = clusterTemplateController;
        ClusterRestController clusterRestController3 = a9 = clusterRestController;
        ClusterRestController clusterRestController4 = a9;
        ClusterRestController clusterRestController5 = a9;
        ClusterRestController clusterRestController6 = a9;
        a9.j = new ContextNameValidation();
        a9.B = a8;
        clusterRestController5.K = a7;
        clusterRestController5.C = a6;
        clusterRestController4.I = a5;
        clusterRestController4.g = a4;
        clusterRestController3.F = a3;
        clusterRestController3.m = a2;
    }

    @GetMapping(path={"{name}"})
    public JsonClusterNode b(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        ClusterNode a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        c.info(PluginEnabledEvent.b((Object)"b4D\u0012\u0019\u001d\\>L*J;\u0019!V+\\o]*M.P#Jo_ KoB2\u0017"), (Object)AuditLog.username((Principal)a2), object);
        a2 = name.B.getNode((String)object);
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + (String)object + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a2, (boolean)name.B.isActive((String)object));
    }

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void b(HttpServletResponse httpServletResponse, @Parameter(hidden=true) Principal principal) throws IOException {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        c.info(PluginEnabledEvent.b((Object)"b4D\u0012\u0019\u001d\\>L*J;\u0019,U:J;\\=\u0019;\\\"I#X;\\o] N!U X+\u0017"), (Object)AuditLog.username((Principal)object));
        if (a2.F.isAdminNode()) {
            ServletOutputStream resp;
            object = UserInfo.b((Object)"{_m@lVj\u001elVuCtRlV6Ju_");
            String string = a2.m.buildYamlTemplate();
            void v1 = resp;
            resp = v1.getOutputStream();
            v1.setContentType(PluginEnabledEvent.b((Object)"M*A;\u0016?U.P!\u0002oZ'X=J*MrL;_b\u0001"));
            v1.addHeader(UserInfo.b((Object)"pw]lVvG5wq@h\\kZlZw]"), "attachment; filename=\"" + (String)object + "\"");
            ServletOutputStream servletOutputStream = resp;
            servletOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            servletOutputStream.flush();
            servletOutputStream.close();
            return;
        }
        throw new RuntimeException(PluginEnabledEvent.b((Object)"` LoZ.WoL<\\oM'P<\u0019)L!Z;P W.U&M6\u0019 W#@o_=V\"\u0019.]\"P!\u0019!V+\\"));
    }

    @PostMapping
    public ResponseEntity<RestResponse> b(@Valid @RequestBody ClusterJoinRequest clusterJoinRequest, @Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController;
        NodeInfo.Builder a2;
        ClusterRestController clusterRestController2 = clusterRestController3;
        ClusterRestController clusterRestController3 = clusterJoinRequest;
        ClusterRestController jsonClusterNode = clusterRestController2;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = clusterRestController3.getInternalHostName();
        objectArray[2] = clusterRestController3.internalGrpcPort;
        c.info(UserInfo.b((Object)"CHen8a}BmVkG8Gw\u0013r\\q]8PtFkG}A8Rl\u0013cN\"He\u001d"), objectArray);
        a2 = NodeInfo.newBuilder((NodeInfo)jsonClusterNode.B.getMe().toNodeInfo());
        String string = clusterRestController3.getContext();
        if (string != null && !string.isEmpty()) {
            if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, PluginEnabledEvent.b((Object)"z.W!V;\u0019,V\"[&W*\u0019%V&W&W(\u0019,V!M*A;\u00198P;QoW z W;\\7M<\u0017"));
            }
            if (!RaftAdminGroup.b((String)string) && !jsonClusterNode.j.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            G.debug(UserInfo.b((Object)"yW|\u001b1\t8a}Tq@lVjZvT8^a@}_~\u0013y]|\u0013yW|ZvT8^}\u0013l\\8Pw]lV`G8\u0011cN:\u001d"), (Object)string);
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
            G.debug(PluginEnabledEvent.b((Object)"X+]g\u0010u\u0019\u001d\\(P<M*K&W(\u0019\"@<\\#_oX!]oX+]&W(\u0019\"\\oM \u0019!VoZ W;\\7M<\u0017"));
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            G.debug(UserInfo.b((Object)"yW|\u001b1\t8a}Tq@lVjZvT8^a@}_~\u0013y]|\u0013yW|ZvT8^}\u0013l\\8Rt_8Pw]lV`Gk\u001d"));
            clusterRestController = jsonClusterNode;
        }
        if (clusterRestController.B.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new RestResponse(false, PluginEnabledEvent.b((Object)"\u0001V+\\oX#K*X+@oK*^&J;\\=\\+\u0019&WoXoZ#L<M*K")));
        }
        try {
            ClusterRestController clusterRestController4 = jsonClusterNode;
            ClusterRestController clusterRestController5 = clusterRestController3;
            clusterRestController3 = clusterRestController4.K.getRaftConfigServiceStub(clusterRestController5.internalHostName, clusterRestController5.internalGrpcPort.intValue()).joinCluster(a2.build());
            clusterRestController4.g.publishEvent((Object)new ClusterEvents.LicenseUpdated(clusterRestController3.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, UserInfo.b((Object)"YP{VhG}W8YwZv\u0013jViF}@l\u001f8^yJ8GyX}\u0013y\u0013o[q_}\u0013l\\8Cj\\{Vk@")));
        }
        catch (Exception this2) {
            return new RestResponse(false, this2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)this2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"{name}"})
    public void b(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        c.info(PluginEnabledEvent.b((Object)"b4D\u0012\u0019\u001d\\>L*J;\u0019;Vo]*U*M*\u0019!V+\\oB2\u0017"), (Object)AuditLog.username((Principal)a2), object);
        name.K.getRaftConfigService().deleteNode((String)object);
    }

    @GetMapping
    public List<JsonClusterNode> b(@Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        c.info(UserInfo.b((Object)"hcNE\u0013JViF}@l\u0013l\\8_q@l\u0013v\\|Vk\u001d"), (Object)AuditLog.username((Principal)object));
        return a2.B.nodes().map(clusterNode -> {
            ClusterRestController a2 = clusterNode;
            ClusterRestController a3 = this;
            ClusterRestController clusterRestController = a2;
            return JsonClusterNode.from((ClusterNode)clusterRestController, (boolean)a3.B.isActive(clusterRestController.getName()));
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/upload-license"})
    public void b(@RequestParam(value="licenseFile") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        void a2;
        ClusterRestController clusterRestController = this;
        c.info(UserInfo.b((Object)"CHen8a}BmVkG8_qP}]kV8FhWyG}\u001d"), (Object)AuditLog.username((Principal)a2));
        G.info(PluginEnabledEvent.b((Object)"\u0001\\8\u0019#P,\\!J*\u0019:I#V.]*]c\u0019?\\=_ K\"P!^oU&Z*W<\\oL?].M*\u0017a\u0017"));
        try {
            void licenseFile;
            clusterRestController.I.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, UserInfo.b((Object)"}w\u0013tVyW}A8UwA8lyWuZv\u001d8vv@mA}\u0013l[yG8GpV8lyWuZv\u0013jVh_qPyGq\\v\u0013\u007fAwFh\u0013q@8PjVyG}W8Q}UwA}\u0013mCt\\yWq]\u007f\u0013y\u0013tZ{Vv@}\u001d"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException messagingPlatformException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, messagingPlatformException.getMessage());
        }
    }
}

