/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.transport.rest;

import io.axoniq.axonserver.PrincipalAuthentication;
import io.axoniq.axonserver.access.roles.RoleController;
import io.axoniq.axonserver.admin.user.api.UserAdminService;
import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.configuration.admin.AdminUserRole;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.file.multitier.MultiTierInformationProvider;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.transport.rest.ApplicationRestController;
import io.axoniq.axonserver.transport.rest.UserRestController;
import io.axoniq.axonserver.transport.rest.a;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="UserRestController")
@CrossOrigin
@RequestMapping(value={"/v1"})
public class UserRestController {
    private static final Logger c;
    private static final Logger I;
    private final RoleController j;
    private final UserAdminService G;

    /*
     * WARNING - void declaration
     */
    public UserRestController(UserAdminService userAdminService, RoleController roleController) {
        void a2;
        UserRestController a3;
        UserRestController a4 = roleController;
        UserRestController userRestController = a3 = this;
        userRestController.G = a2;
        userRestController.j = a4;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"users"})
    public void b(@RequestBody @Valid UserJson userJson, @Parameter(hidden=true) Principal principal) {
        void a2;
        UserRestController userRestController = userRestController2;
        UserRestController userRestController2 = userJson;
        UserRestController userJson2 = userRestController;
        if (a2 != null && userRestController2.userName.equals(a2.getName())) {
            throw new MessagingPlatformException(ErrorCode.AUTHENTICATION_INVALID_TOKEN, ApplicationRestController.b((Object)"x\rBBW\u000eZ\rA\u0007RBB\r\u0016\u0001^\u0003X\u0005SBO\rC\u0010\u0016\rA\f\u0016\u0001D\u0007R\u0007X\u0016_\u0003Z\u0011"));
        }
        Set<Object> set = new HashSet();
        if (userRestController2.roles != null) {
            set = Arrays.stream(userRestController2.roles).map(AdminUserRole::parse).collect(Collectors.toSet());
        }
        UserRestController userRestController3 = userRestController2;
        userJson2.G.createOrUpdateUser(userRestController3.userName, userRestController3.password, set.stream().map(adminUserRole -> {
            UserRestController a2 = adminUserRole;
            UserRestController a3 = this;
            return new a(a3, (AdminUserRole)a2);
        }).collect(Collectors.toSet()), (Authentication)new PrincipalAuthentication((Principal)a2));
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"public/users"})
    public List<UserJson> b(@Parameter(hidden=true) Principal principal) {
        void a2;
        UserRestController userRestController = this;
        try {
            return userRestController.G.users((Authentication)new PrincipalAuthentication((Principal)a2)).stream().map(UserJson::new).sorted(Comparator.comparing(UserJson::getUserName)).collect(Collectors.toList());
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            I.info(MultiTierInformationProvider.b((Object)"c@Ef\u0018wQHL\u001bMH]IK\u001b^ZQW]_\u0018\u0016\u0018@E"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"users/{name}"})
    public void b(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        void name;
        UserRestController userRestController = this;
        try {
            userRestController.G.deleteUser((String)name, (Authentication)new PrincipalAuthentication((Principal)a2));
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = AuditLog.username((Principal)a2);
            objectArray[1] = name;
            objectArray[2] = exception.getMessage();
            c.error(ApplicationRestController.b((Object)"9M\u001fkBr\u0007Z\u0007B\u0007\u0016\u0017E\u0007DBM\u001f\u0016\u0004W\u000bZ\u0007RB\u001bBM\u001f"), objectArray);
            throw new MessagingPlatformException(ErrorCode.OTHER, exception.getMessage());
        }
    }

    static {
        I = LoggerFactory.getLogger(UserRestController.class);
        c = AuditLog.getLogger();
    }
}

