/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.ui;

import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.ContextConfigurationMapping;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.ui.ClusterUpdatesService;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;

@Service
public class ClusterUpdatesService {
    private final Logger I = LoggerFactory.getLogger(ClusterUpdatesService.class);
    private final Sinks.Many<SimpleUpdate> j = Sinks.many().multicast().onBackpressureBuffer();
    private static final Logger G = AuditLog.getLogger();

    @EventListener
    public void on(ClusterEvents.BecomeLeader becomeLeader) {
        ClusterUpdatesService a2 = becomeLeader;
        ClusterUpdatesService a3 = this;
        a3.b(UpdateType.c, a2.replicationGroup(), SimpleUpdateState.K);
    }

    private static /* synthetic */ void b(Authentication a2) {
        G.info(ContextConfigurationMapping.b((Object)"\t\u0003/%r+'\u001a!\u001b \u00110\u001d6X&\u0017r\u001b=\u0016&\u001d*\fr\r\"\u001c3\f7\u000b|"), (Object)AuditLog.username((String)a2.username()));
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeDeleted axonServerNodeDeleted) {
        ClusterUpdatesService a2 = axonServerNodeDeleted;
        ClusterUpdatesService a3 = this;
        a3.b(UpdateType.F, a2.node(), SimpleUpdateState.F);
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation leaderConfirmation) {
        ClusterUpdatesService a2 = leaderConfirmation;
        ClusterUpdatesService a3 = this;
        a3.b(UpdateType.c, a2.replicationGroup(), SimpleUpdateState.K);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupCreated replicationGroupCreated) {
        ClusterUpdatesService a2 = replicationGroupCreated;
        ClusterUpdatesService a3 = this;
        a3.b(UpdateType.K, a2.replicationGroup(), SimpleUpdateState.I);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceDisconnected axonServerInstanceDisconnected) {
        ClusterUpdatesService a2 = axonServerInstanceDisconnected;
        ClusterUpdatesService a3 = this;
        a3.b(UpdateType.j, a2.getNodeName(), SimpleUpdateState.j);
    }

    public ClusterUpdatesService() {
        ClusterUpdatesService a2;
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceConnected axonServerInstanceConnected) {
        ClusterUpdatesService a2 = axonServerInstanceConnected;
        ClusterUpdatesService a3 = this;
        a3.b(UpdateType.j, a2.getNodeName(), SimpleUpdateState.G);
    }

    @EventListener
    public void on(ContextEvents.ContextUpdatedInAdmin contextUpdatedInAdmin) {
        ClusterUpdatesService a2 = contextUpdatedInAdmin;
        ClusterUpdatesService a3 = this;
        a3.b(UpdateType.H, a2.b(), SimpleUpdateState.K);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void b(UpdateType updateType, String string, SimpleUpdateState simpleUpdateState) {
        void a2;
        void a3;
        ClusterUpdatesService a4 = simpleUpdateState;
        ClusterUpdatesService a5 = this;
        a5.j.emitNext((Object)new SimpleUpdate((UpdateType)a3, (String)a2 + ":" + a4.name()), (signalType, emitResult) -> {
            SignalType a2 = emitResult;
            SignalType a3 = signalType;
            if (a2 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }

    @EventListener
    public void on(ContextEvents.ContextUnregisteredInAdmin contextUnregisteredInAdmin) {
        ClusterUpdatesService a2 = contextUnregisteredInAdmin;
        ClusterUpdatesService a3 = this;
        a3.b(UpdateType.H, a2.context(), SimpleUpdateState.F);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupDeleted replicationGroupDeleted) {
        ClusterUpdatesService a2 = replicationGroupDeleted;
        ClusterUpdatesService a3 = this;
        a3.b(UpdateType.K, a2.replicationGroup(), SimpleUpdateState.F);
    }

    @EventListener
    public void on(ContextEvents.ContextRegisteredInAdmin contextRegisteredInAdmin) {
        ClusterUpdatesService a2 = contextRegisteredInAdmin;
        ClusterUpdatesService a3 = this;
        a3.b(UpdateType.H, a2.context(), SimpleUpdateState.I);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated replicationGroupUpdated) {
        ClusterUpdatesService a2 = replicationGroupUpdated;
        ClusterUpdatesService a3 = this;
        a3.b(UpdateType.K, a2.replicationGroup(), SimpleUpdateState.K);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeConnected axonServerNodeConnected) {
        ClusterUpdatesService a2 = axonServerNodeConnected;
        ClusterUpdatesService a3 = this;
        a3.b(UpdateType.F, a2.getNodeInfo().getHostName(), SimpleUpdateState.G);
    }

    public Flux<SimpleUpdate> subscribeToUpdates(@Nonnull Authentication authentication) {
        ClusterUpdatesService clusterUpdatesService = clusterUpdatesService2;
        ClusterUpdatesService clusterUpdatesService2 = authentication;
        ClusterUpdatesService a2 = clusterUpdatesService;
        return a2.j.asFlux().publish().autoConnect().doFirst(() -> ClusterUpdatesService.b((Authentication)clusterUpdatesService2));
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected applicationConnected) {
        ClusterUpdatesService a2 = applicationConnected;
        ClusterUpdatesService a3 = this;
        a3.b(UpdateType.G, a2.f(), SimpleUpdateState.G);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        ClusterUpdatesService a2 = applicationDisconnected;
        ClusterUpdatesService a3 = this;
        a3.b(UpdateType.G, a2.j(), SimpleUpdateState.j);
    }

    @EventListener
    public void on(ClusterEvents.LeaderStepDown leaderStepDown) {
        ClusterUpdatesService a2 = leaderStepDown;
        ClusterUpdatesService a3 = this;
        a3.b(UpdateType.c, a2.replicationGroup(), SimpleUpdateState.K);
    }
}

