/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.diagnostics.DiagnosticsService;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.NodeAddress;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.transport.rest.v2.ApplicationRestControllerV2;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ClusterController
implements SmartLifecycle {
    private final AdminNodes m;
    private final CurrentNodeProvider j;
    private final RemoteConnections i;
    private final AdminConfigurationFactory M;
    private final ClusterTagsCache G;
    private volatile boolean J;
    private final Logger b;
    private final ApplicationEventPublisher g;
    private final MessagingPlatformConfiguration k;
    private final Limits A;

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        ClusterController clusterController = a2;
        a3.g(clusterController.getNodeName());
        if (clusterController.getNodeName().equals(a3.k.getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.b.info(DiagnosticsService.g((Object)"Q{|`kn%}j)oflg%~l}m)f|w{`gq)kfal%gdd`3%rx"), (Object)a2.getNodeName());
            return clusterController2.getMe();
        }
        if (a2.getInternalHostName().equals(a3.k.getInternalHostname()) && a2.getGrpcInternalPort() == a3.k.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, ApplicationRestControllerV2.g((Object)"9d\u0014k\u0015qZo\u0015l\u0014%\u0019i\u000fv\u000e`\b%\rl\u000emZv\u001bh\u001f%\u0012j\tq\u0014d\u0017`Zd\u0014aZl\u0014q\u001fw\u0014d\u0016%\nj\bq"));
        }
        ClusterNode clusterNode = a3.m.findById(a2.getNodeName()).orElseGet(() -> a3.g((NodeInfo)a2));
        if (!a3.i.contains(a2.getNodeName())) {
            a3.g((NodeInfo)a2);
        }
        return clusterNode;
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.i.nodes();
    }

    public synchronized void handleRemoteConnection(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.g((NodeInfo)a3);
        clusterController.i.updateNodeInfo((NodeInfo)a3);
        clusterController.g.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected((NodeInfo)a3));
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a2;
        return a2.nodes().filter(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            return a3.isActive(a2.getName());
        });
    }

    private /* synthetic */ void g(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if (a3.i.contains((String)a2) || a3.k.getName().equals(a2)) {
            return;
        }
        a3.A.getMaxClusterSize().ifPresent(arg_0 -> a3.g((String)a2, arg_0));
    }

    private /* synthetic */ ClusterNode g(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.b.info(DiagnosticsService.g((Object)"Dma)kfal%rx"), (Object)a3);
        a3 = clusterController.M.clusterNode((NodeInfo)a3);
        return clusterController.m.save((ClusterNode)a3);
    }

    /*
     * WARNING - void declaration
     */
    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, AdminNodes adminNodes, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, RemoteConnections remoteConnections, CurrentNodeProvider currentNodeProvider) {
        void remoteConnections2;
        void limits2;
        void applicationEventPublisher2;
        void clusterTagsCache2;
        void adminConfigurationFactory2;
        void clusterNodeRepository;
        void messagingPlatformConfiguration2;
        ClusterController a2;
        ClusterController clusterController = clusterController2;
        ClusterController clusterController2 = currentNodeProvider;
        ClusterController clusterController3 = a2 = clusterController;
        ClusterController clusterController4 = a2;
        ClusterController clusterController5 = a2;
        ClusterController clusterController6 = a2;
        a2.b = LoggerFactory.getLogger(ClusterController.class);
        clusterController6.k = messagingPlatformConfiguration2;
        clusterController6.m = clusterNodeRepository;
        clusterController5.M = adminConfigurationFactory2;
        clusterController5.G = clusterTagsCache2;
        clusterController4.g = applicationEventPublisher2;
        clusterController4.A = limits2;
        clusterController3.i = remoteConnections2;
        clusterController3.j = clusterController2;
    }

    private /* synthetic */ ClusterNode g(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if ((a2 = a3.i.get((String)a2)) == null) {
            return null;
        }
        return a2.getClusterNode();
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.i.connections();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void g(String string, Integer n) {
        Integer a2 = n;
        ClusterController a3 = this;
        if (a3.i.size() + 1 >= a2) {
            void a4;
            throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + (String)a4);
        }
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.j.isAdmin();
    }

    public void deleteOtherNodes() {
        ClusterController a2;
        ClusterController clusterController = a2;
        a2.m.deleteAllByNameNot(clusterController.getName());
        clusterController.i.sync();
    }

    @Transactional
    public void start() {
        ClusterController a2;
        a2.g();
        a2.J = true;
    }

    public ClusterNode getNode(String string) {
        Object a2 = string;
        Object a3 = this;
        if (((String)a2).equals(a3.getName())) {
            return a3.getMe();
        }
        a2 = a3.m.findById((String)a2).orElseGet(() -> ((ClusterController)a3).g((String)a2));
        return a3.g((ClusterNode)a2);
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.i.activeConnections();
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a2;
        return a2.m.findAll().peek(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            if (a2 == null) {
                return null;
            }
            a2.setTags(a3.G.getClusterTags().getOrDefault(a2.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    public void closeConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.i.disconnect((String)a2);
    }

    public void stop() {
        a.J = false;
    }

    private /* synthetic */ void g(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        if (a2.getNodeName().equals(a3.k.getName())) {
            return;
        }
        a3.i.connect((NodeInfo)a2, true);
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.J;
    }

    @Transactional
    public synchronized void deleteNode(String string) {
        ClusterController clusterController;
        ClusterController a2;
        Object a3 = string;
        ClusterController clusterController2 = a2 = this;
        clusterController2.b.info(ApplicationRestControllerV2.g((Object)"A\u001fi\u001fq\u001f%\u0014j\u001e`@%\u0001x"), a3);
        clusterController2.g.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested((String)a3));
        if (clusterController2.k.getName().equals(a3)) {
            ClusterController clusterController3 = a2;
            clusterController = clusterController3;
            clusterController3.m.deleteAllByNameNot((String)a3);
            clusterController3.i.closeAll();
        } else {
            a2.m.findById((String)a3).ifPresent(arg_0 -> a2.g((String)a3, arg_0));
            clusterController = a2;
        }
        clusterController.g.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted((String)a3));
        a2.i.sync();
    }

    public boolean isActive(String string) {
        String a2 = string;
        ClusterController a3 = this;
        if (a2.equals(a3.k.getName()) || a3.i.get(a2) != null && a3.i.get(a2).isConnected()) {
            return true;
        }
        return false;
    }

    public ClusterNode getMe() {
        ClusterController a2;
        ClusterController clusterController = a2;
        return clusterController.g((ClusterNode)clusterController.j.get());
    }

    private /* synthetic */ void g() {
        Object a2;
        ClusterController clusterController;
        ClusterController clusterController2 = clusterController = this;
        Object object = clusterController2.m.findById(clusterController2.k.getName());
        if (((Optional)object).isEmpty()) {
            if (clusterController.m.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = clusterController.k.getName();
                a2 = String.format(DiagnosticsService.g((Object)"Jp{wlk}%gjm`)khhl%adz%jmhkn`m))klr)khhl%,v'%Zqhw}%H}fkZ`{slw)r`qa%{`jj\u007f`{|)c`il+"), objectArray);
                throw new FailedToStartException((String)a2);
            }
            ClusterController clusterController3 = clusterController;
            a2 = clusterController3.M.clusterNode(clusterController3.k.getName(), clusterController.k.getFullyQualifiedHostname(), clusterController.k.getFullyQualifiedInternalHostname(), clusterController.k.getPort(), clusterController.k.getInternalPort(), clusterController.k.getHttpPort());
            clusterController3.m.save((ClusterNode)a2);
            return;
        }
        a2 = (ClusterNode)((Optional)object).get();
        if (!a2.getInternalHostName().equals(clusterController.k.getFullyQualifiedInternalHostname()) || !a2.getGrpcInternalPort().equals(clusterController.k.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getInternalHostName();
            objectArray[1] = a2.getGrpcInternalPort();
            objectArray[2] = clusterController.k.getFullyQualifiedInternalHostname();
            objectArray[3] = clusterController.k.getInternalPort();
            object = String.format(ApplicationRestControllerV2.g((Object)"9p\bw\u001fk\u000e%\u0014j\u001e`]vZl\u0014q\u001fw\u0014d\u0016%\u0012j\tq\u0014d\u0017`Uu\u0015w\u000e%R \t?_aS%\u0012d\t%\u0019m\u001bk\u001d`\u001e)Z%\u0014`\r%\fd\u0016p\u001fvZ \t?_aT%)q\u001bw\u000e%;}\u0015k)`\bs\u001fwZr\u0013q\u0012%\b`\u0019j\f`\b|Zc\u0013i\u001f+"), objectArray);
            throw new FailedToStartException((String)object);
        }
    }

    public String getName() {
        ClusterController a2;
        return a2.getMe().getName();
    }

    /*
     * WARNING - void declaration
     */
    public NodeAddress nodeAddress(String string) {
        ClusterController a2;
        void a3;
        ClusterController clusterController = this;
        if (a3.equals(clusterController.getName())) {
            return new NodeAddress(clusterController.getMe());
        }
        RemoteConnection remoteConnection = clusterController.i.get((String)a3);
        ClusterNode clusterNode = a2 = remoteConnection == null ? (ClusterNode)clusterController.m.findById((String)a3).orElse(null) : remoteConnection.getClusterNode();
        if (a2 == null) {
            return null;
        }
        return new NodeAddress((ClusterNode)a2);
    }

    private /* synthetic */ void g(String string, ClusterNode clusterNode) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.m.deleteById((String)a2);
    }

    public int getPhase() {
        return 50;
    }

    public void publishEvent(Object object) {
        Object a2 = object;
        ClusterController a3 = this;
        a3.g.publishEvent(a2);
    }

    public Optional<RemoteConnection> getRemoteConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        return Optional.ofNullable(a3.i.get((String)a2));
    }
}

