/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.cluster.grpc.LeaderElectionService;
import io.axoniq.axonserver.cluster.grpc.LogReplicationService;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalAuthenticationInterceptor;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AxonServerInternalService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.taskscheduler.task.AddContextToReplicationGroup;
import io.axoniq.axonserver.transport.rest.v2.ApplicationRestControllerV2;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="MessagingClusterServer")
public class MessagingClusterServer
implements SmartLifecycle {
    private final ApplicationEventPublisher h;
    private final List<AxonServerInternalService> F;
    private Server m;
    private boolean j;
    private static final DataSize i = DataSize.ofMegabytes((long)32L);
    private final LeaderElectionService M;
    private final ExecutorService G;
    private final LogReplicationService J;
    private AdvancedTlsX509KeyManager.Closeable b;
    private final Supplier<ScheduledExecutorService> g;
    private final Logger k;
    private final MessagingPlatformConfiguration A;

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void g(NettyServerBuilder nettyServerBuilder, AxonServerInternalService axonServerInternalService) {
        void a2;
        NettyServerBuilder nettyServerBuilder2 = nettyServerBuilder;
        LinkedList a3 = new LinkedList(a2.interceptors());
        if (a2.requiresContextInterceptor()) {
            a3.add(new ContextInterceptor());
        }
        nettyServerBuilder2.addService(ServerInterceptors.intercept((BindableService)a2, (List)a3));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        MessagingClusterServer messagingClusterServer = this;
        try {
            NettyServerBuilder nettyServerBuilder;
            MessagingClusterServer a2;
            String string = AddContextToReplicationGroup.g((Object)"|\u001b2'A8");
            if (messagingClusterServer.A.getSsl() != null && messagingClusterServer.A.getSsl().isEnabled()) {
                Object object = messagingClusterServer.A.getSsl().getInternalCertChainFile();
                if (object == null) {
                    throw new RuntimeException(ApplicationRestControllerV2.g((Object)"d\u0002j\u0014l\u000b+\u001b}\u0015k\t`\bs\u001fwTv\tiTf\u001fw\u000e(\u0019m\u001bl\u0014(\u001cl\u0016`Zk\u0015qZv\u001fq"));
                }
                Object object2 = messagingClusterServer.A.getSsl().getInternalPrivateKeyFile();
                if (object2 == null) {
                    throw new RuntimeException(AddContextToReplicationGroup.g((Object)"s\f}\u001a{\u0005<\u0015j\u001b|\u0007w\u0006d\u0011`Za\u0007~Zb\u0006{\u0002s\u0000wYy\u0011kYt\u001d~\u00112\u001a}\u00002\u0007w\u0000"));
                }
                object2 = new File((String)object2);
                object = new File((String)object);
                if (!((File)object2).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object2).getCanonicalPath());
                }
                if (!((File)object).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object).getCanonicalPath());
                }
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                messagingClusterServer.b = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile((File)object2, (File)object, 1L, TimeUnit.MINUTES, (ScheduledExecutorService)messagingClusterServer.g.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                object = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.A.getInternalPort(), (ServerCredentials)object);
                string = ApplicationRestControllerV2.g((Object)"V)IZ`\u0014d\u0018i\u001fa");
                nettyServerBuilder = a2;
            } else {
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.A.getInternalPort());
                nettyServerBuilder = a2;
            }
            nettyServerBuilder.permitKeepAliveTime(messagingClusterServer.A.getMinKeepAliveTime(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(true);
            a2.maxInboundMessageSize((int)Math.max(i.toBytes(), Math.min(Integer.MAX_VALUE, (long)messagingClusterServer.A.getMaxMessageSize() + DataSize.ofMegabytes((long)1L).toBytes())));
            a2.intercept((ServerInterceptor)new InternalAuthenticationInterceptor(messagingClusterServer.A));
            messagingClusterServer.F.forEach(arg_0 -> MessagingClusterServer.g((NettyServerBuilder)a2, arg_0));
            MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
            a2.addService((BindableService)messagingClusterServer.M);
            a2.addService((BindableService)messagingClusterServer2.J);
            if (messagingClusterServer2.A.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(messagingClusterServer.A.getKeepAliveTime(), TimeUnit.MILLISECONDS);
                a2.keepAliveTimeout(messagingClusterServer.A.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(messagingClusterServer.A.getGrpcBufferedMessages()));
            a2.executor((Executor)messagingClusterServer.G);
            if (Epoll.isAvailable()) {
                v3 = messagingClusterServer;
                a2.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(AddContextToReplicationGroup.g((Object)"\u0017~\u0001a\u0000w\u0006?\u0016}\u0007aY"))));
                a2.workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(ApplicationRestControllerV2.g((Object)"f\u0016p\tq\u001fwWr\u0015w\u0011`\b("))));
                a2.channelType(EpollServerSocketChannel.class);
            } else {
                a2.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(AddContextToReplicationGroup.g((Object)"\u0017~\u0001a\u0000w\u0006?\u0016}\u0007aY"))));
                a2.workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(ApplicationRestControllerV2.g((Object)"f\u0016p\tq\u001fwWr\u0015w\u0011`\b("))));
                a2.channelType(NioServerSocketChannel.class);
                v3 = messagingClusterServer;
            }
            v3.m = a2.build();
            messagingClusterServer.m.start();
            messagingClusterServer.k.info(AddContextToReplicationGroup.g((Object)"5j\u001b|TA\u0011`\u0002w\u000627~\u0001a\u0000w\u00062'w\u0006d\u0011`Ta\u0000s\u0006f\u0011vT}\u001a2\u0004}\u0006fN2\u000foT?Ti\t"), (Object)messagingClusterServer.A.getInternalPort(), (Object)string);
            messagingClusterServer.h.publishEvent((Object)new ReplicationServerStarted());
            messagingClusterServer.j = true;
            return;
        }
        catch (Exception a2) {
            throw new FailedToStartException(ApplicationRestControllerV2.g((Object)"V\u000ed\bq\u0013k\u001d%;}\u0015kZV\u001fw\f`\b%9i\u000fv\u000e`\b%)`\bs\u001fwZc\u001bl\u0016`\u001e%"), (Throwable)a2);
        }
    }

    public void stop() {
        MessagingClusterServer messagingClusterServer = this;
        if (messagingClusterServer.b != null) {
            messagingClusterServer.b.close();
        }
        messagingClusterServer.G.shutdown();
        try {
            if (!messagingClusterServer.m.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
                messagingClusterServer2.k.debug(ApplicationRestControllerV2.g((Object)"<j\bf\u001fc\u000fi\u0016|Zv\u000ej\nu\u0013k\u001d%9i\u000fv\u000e`\b%)`\bs\u001fw"));
                messagingClusterServer2.m.shutdownNow();
            }
        }
        catch (InterruptedException a2) {
            messagingClusterServer.k.debug(AddContextToReplicationGroup.g((Object)"[\u001af\u0011`\u0006g\u0004f\u0011vTv\u0001`\u001d|\u00132\u0007z\u0001f\u0010}\u0003|T}\u00122\u001d|\u0000w\u0006|\u0015~TS\f}\u001aA\u0011`\u0002w\u0006"), (Throwable)a2);
            Thread.currentThread().interrupt();
        }
        messagingClusterServer.j = false;
        messagingClusterServer.k.info(ApplicationRestControllerV2.g((Object)";}\u0015kZV\u001fw\f`\b%9i\u000fv\u000e`\b%)`\bs\u001fwZv\u000ej\nu\u001fa"));
    }

    public boolean isAutoStartup() {
        return true;
    }

    public boolean isRunning() {
        MessagingClusterServer a2;
        return a2.j;
    }

    /*
     * WARNING - void declaration
     */
    public MessagingClusterServer(MessagingPlatformConfiguration messagingPlatformConfiguration, LogReplicationService logReplicationService, LeaderElectionService leaderElectionService, List<AxonServerInternalService> list, Supplier<ScheduledExecutorService> supplier, ApplicationEventPublisher applicationEventPublisher) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        MessagingClusterServer a7;
        MessagingClusterServer a8 = messagingPlatformConfiguration;
        MessagingClusterServer messagingClusterServer = a7 = this;
        MessagingClusterServer messagingClusterServer2 = a7;
        MessagingClusterServer messagingClusterServer3 = a7;
        MessagingClusterServer messagingClusterServer4 = a7;
        messagingClusterServer4.k = LoggerFactory.getLogger(MessagingClusterServer.class);
        messagingClusterServer4.A = a8;
        messagingClusterServer3.J = a6;
        messagingClusterServer3.M = a5;
        messagingClusterServer2.F = a4;
        messagingClusterServer2.g = a3;
        messagingClusterServer.h = a2;
        messagingClusterServer.G = Executors.newFixedThreadPool(a8.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(AddContextToReplicationGroup.g((Object)"\u0017~\u0001a\u0000w\u0006?\u0011j\u0011q\u0001f\u001b`Y")));
    }

    public int getPhase() {
        return 50;
    }
}

