/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.cluster.util.AxonThreadFactory;
import io.axoniq.axonserver.config.ClusterConfiguration;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.events.serializer.XStreamEventSerializer;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalNode;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteNodesProvider;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.enterprise.cluster.internal.StubFactory;
import io.axoniq.axonserver.grpc.ChannelExceptionHandler;
import io.axoniq.axonserver.grpc.internal.ConnectorCommand;
import io.axoniq.axonserver.grpc.internal.ConnectorResponse;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.localstorage.query.QueryExecutionException;
import io.axoniq.axonserver.util.CompetableFutureUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class RemoteConnections
implements SmartLifecycle {
    private final Set<String> c;
    private final Map<ConnectorResponse.ResponseCase, Set<BiConsumer<RemoteConnection, ConnectorResponse>>> f;
    private final ClusterConfiguration L;
    private final StubFactory D;
    private final AtomicBoolean B;
    private static final int I = 10;
    private final AtomicInteger h;
    private final CurrentNodeProvider F;
    private final RemoteNodesProvider m;
    private boolean j;
    private final long i;
    private final ScheduledExecutorService M;
    private final XStreamEventSerializer G;
    private final ApplicationEventPublisher J;
    private static final BiConsumer<RemoteConnection, ConnectorResponse> b = (remoteConnection, connectorResponse) -> {
        RemoteConnection a2 = connectorResponse;
        connectorResponse = remoteConnection;
    };
    private final ChannelExceptionHandler g;
    private final Map<String, RemoteConnection> k;
    private static final Logger A = LoggerFactory.getLogger(RemoteConnections.class);

    public boolean contains(String string) {
        Object a2 = string;
        RemoteConnections a3 = this;
        return a3.k.containsKey(a2);
    }

    public void stop() {
        RemoteConnections a2;
        RemoteConnections remoteConnections = a2;
        remoteConnections.M.shutdown();
        remoteConnections.closeAll();
        remoteConnections.j = false;
    }

    public Set<String> nodes() {
        RemoteConnections a2;
        return a2.k.keySet();
    }

    public void checkConnections() {
        RemoteConnections a2;
        a2.c.forEach(string -> {
            Object a2 = string;
            RemoteConnections a3 = this;
            Optional.ofNullable((RemoteConnection)a3.k.get(a2)).ifPresent(RemoteConnection::checkConnection);
        });
    }

    public void start() {
        RemoteConnections a2;
        a2.M.scheduleWithFixedDelay(() -> a2.checkConnections(), a2.L.getConnectionCheckDelay(), a2.L.getConnectionCheckInterval(), TimeUnit.MILLISECONDS);
        a2.j = true;
    }

    public boolean isRunning() {
        RemoteConnections a2;
        return a2.j;
    }

    @EventListener
    public void on(ReplicationServerStarted replicationServerStarted) {
        RemoteConnections a2 = replicationServerStarted;
        RemoteConnections a3 = this;
        ((Set)a3.m.get()).forEach(internalNode -> {
            void a2;
            RemoteConnections remoteConnections;
            RemoteConnections remoteConnections2 = remoteConnections = this;
            RemoteConnections a3 = new RemoteConnectionImpl(remoteConnections2, (InternalNode)a2, remoteConnections2.B.get());
            remoteConnections.k.put(a2.name(), a3);
            remoteConnections.c.add(a2.name());
            a3.g();
        });
    }

    public Stream<RemoteConnection> activeConnections() {
        RemoteConnections a2;
        return a2.k.values().stream().filter(RemoteConnection::isConnected);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupDeleted replicationGroupDeleted) {
        RemoteConnections a2 = replicationGroupDeleted;
        RemoteConnections a3 = this;
        A.debug(CompetableFutureUtils.g((Object)"Dzfs\u007f|wk\u007fpx?qmyjf?rzzzbzr%6dk"), (Object)a2.replicationGroup());
        a3.M.schedule(() -> a3.sync(), 100L, TimeUnit.MILLISECONDS);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated replicationGroupUpdated) {
        RemoteConnections a2 = replicationGroupUpdated;
        RemoteConnections a3 = this;
        a3.sync();
    }

    private static /* synthetic */ void g(NodeInfo nodeInfo, RemoteConnection remoteConnection) {
        NodeInfo a2 = remoteConnection;
        NodeInfo a3 = nodeInfo;
        ((RemoteConnectionImpl)a2).g(a3);
    }

    public Collection<RemoteConnection> connections() {
        RemoteConnections a2;
        return a2.k.values();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void M(String string, RemoteConnection remoteConnection) {
        void a2;
        Object a3 = string;
        RemoteConnections a4 = this;
        a2.disconnect();
        if (!a4.c.contains(a3)) {
            a4.k.remove(a3);
        }
    }

    public void disconnect(String string) {
        Object a2 = string;
        RemoteConnections a3 = this;
        Optional.ofNullable((RemoteConnection)a3.k.get(a2)).ifPresent(arg_0 -> a3.M((String)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public RemoteConnections(ClusterConfiguration clusterConfiguration, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, StubFactory stubFactory, ChannelExceptionHandler channelExceptionHandler, XStreamEventSerializer xStreamEventSerializer, RemoteNodesProvider remoteNodesProvider, CurrentNodeProvider currentNodeProvider) {
        void a2;
        void remoteNodesProvider2;
        void xStreamEventSerializer2;
        void channelExceptionHandler2;
        void stubFactory2;
        void applicationEventPublisher2;
        RemoteConnections clusterConfiguration2;
        RemoteConnections remoteConnections = remoteConnections2;
        RemoteConnections remoteConnections2 = clusterConfiguration;
        RemoteConnections remoteConnections3 = clusterConfiguration2 = remoteConnections;
        RemoteConnections remoteConnections4 = clusterConfiguration2;
        RemoteConnections remoteConnections5 = clusterConfiguration2;
        RemoteConnections remoteConnections6 = clusterConfiguration2;
        clusterConfiguration2.k = new ConcurrentHashMap();
        RemoteConnections remoteConnections7 = clusterConfiguration2;
        remoteConnections6.h = new AtomicInteger(10);
        RemoteConnections remoteConnections8 = clusterConfiguration2;
        clusterConfiguration2.c = new HashSet();
        RemoteConnections remoteConnections9 = clusterConfiguration2;
        clusterConfiguration2.B = new AtomicBoolean();
        RemoteConnections remoteConnections10 = clusterConfiguration2;
        clusterConfiguration2.M = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new AxonThreadFactory(QueryExecutionException.g((Object)"LsZl[z]2]zLpAqJ|[")));
        RemoteConnections remoteConnections11 = clusterConfiguration2;
        clusterConfiguration2.f = new ConcurrentHashMap();
        remoteConnections5.L = remoteConnections2;
        remoteConnections5.J = applicationEventPublisher2;
        remoteConnections4.D = stubFactory2;
        remoteConnections4.i = remoteConnections2.getConnectionWaitTime();
        remoteConnections3.g = channelExceptionHandler2;
        remoteConnections3.G = xStreamEventSerializer2;
        clusterConfiguration2.m = remoteNodesProvider2;
        clusterConfiguration2.F = a2;
        clusterConfiguration2.registerResponseHandler(ConnectorResponse.ResponseCase.CONFIRMATION, b);
    }

    private static /* synthetic */ void g(ConnectorCommand connectorCommand, RemoteConnection remoteConnection) {
        ConnectorCommand a2 = remoteConnection;
        ConnectorCommand a3 = connectorCommand;
        a2.publish(a3);
    }

    public void close(String string) {
        Object a2 = string;
        RemoteConnections a3 = this;
        Optional.ofNullable((RemoteConnection)a3.k.remove(a2)).ifPresent(RemoteConnection::close);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void g(String string, RemoteConnection remoteConnection) {
        void a2;
        RemoteConnections a3 = remoteConnection;
        RemoteConnections a4 = this;
        a3.close();
        a4.k.remove(a2);
    }

    public void sync() {
        RemoteConnections remoteConnections = this;
        Set set = (Set)remoteConnections.m.get();
        TreeSet a2 = new TreeSet(remoteConnections.c);
        RemoteConnections remoteConnections2 = remoteConnections;
        remoteConnections2.c.clear();
        set.forEach(internalNode -> {
            RemoteConnectionImpl a2;
            RemoteConnections a3;
            RemoteConnections a4 = internalNode;
            RemoteConnections remoteConnections = a3 = this;
            a2.remove(a4.name());
            remoteConnections.c.add(a4.name());
            if (!remoteConnections.k.containsKey(a4.name())) {
                RemoteConnections remoteConnections2 = a3;
                a2 = new RemoteConnectionImpl(remoteConnections2, (InternalNode)a4, remoteConnections2.B.get());
                a3.k.put(a4.name(), a2);
                A.debug(CompetableFutureUtils.g((Object)"Efx|626vxvb?upxqs|bvyq6\"6dk"), (Object)a4);
                a2.g();
            }
        });
        A.debug(QueryExecutionException.g((Object)"LVqL?\u0002?B~A~Hz\u000f|@qAzLkFpAl\u000f\"\u000fdR3\u000fk@?]zBpYz\u000f\"\u000fdR"), (Object)remoteConnections.c, (Object)a2);
        a2.forEach(string -> {
            Object a2 = string;
            RemoteConnections a3 = this;
            Optional.ofNullable((RemoteConnection)a3.k.get(a2)).ifPresent(arg_0 -> a3.g((String)a2, arg_0));
        });
    }

    public void setReadyForConnections(boolean bl) {
        RemoteConnections a2;
        boolean a3 = bl;
        RemoteConnections remoteConnections = a2 = this;
        remoteConnections.B.set(a3);
        remoteConnections.k.forEach((string, remoteConnection) -> {
            RemoteConnection a2 = remoteConnection;
            boolean a3 = a3;
            a2.setReadyForConnections(a3);
        });
    }

    /*
     * WARNING - void declaration
     */
    public void connect(NodeInfo nodeInfo, boolean bl) {
        RemoteConnections a2 = nodeInfo;
        RemoteConnections a3 = this;
        if (!a3.k.containsKey(a2.getNodeName())) {
            void a4;
            RemoteConnections remoteConnections = a3;
            RemoteConnections remoteConnections2 = a3;
            RemoteConnectionImpl remoteConnectionImpl = new RemoteConnectionImpl(remoteConnections2, new InternalNode(a2.getNodeName(), a2.getInternalHostName(), a2.getGrpcInternalPort()), remoteConnections2.B.get());
            a3.k.put(a2.getNodeName(), remoteConnectionImpl);
            if (a4 != false) {
                remoteConnectionImpl.g();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void registerResponseHandler(ConnectorResponse.ResponseCase responseCase, BiConsumer<RemoteConnection, ConnectorResponse> biConsumer) {
        void a3;
        Object a4 = biConsumer;
        RemoteConnections a5 = this;
        a5.f.computeIfAbsent(a3, a2 -> new CopyOnWriteArraySet()).add(a4);
    }

    public void closeAll() {
        RemoteConnections a2;
        RemoteConnections remoteConnections = a2;
        remoteConnections.c.clear();
        remoteConnections.k.forEach((string, remoteConnection) -> {
            String a2 = remoteConnection;
            String a3 = string;
            a2.close();
        });
        a2.k.clear();
    }

    public void updateNodeInfo(NodeInfo nodeInfo) {
        RemoteConnections a2 = nodeInfo;
        RemoteConnections a3 = this;
        Optional.ofNullable((RemoteConnection)a3.k.get(a2.getNodeName())).ifPresent(arg_0 -> RemoteConnections.g((NodeInfo)a2, arg_0));
    }

    public void publish(ConnectorCommand connectorCommand) {
        RemoteConnections a2 = connectorCommand;
        RemoteConnections a3 = this;
        a3.k.values().forEach(arg_0 -> RemoteConnections.g((ConnectorCommand)a2, arg_0));
    }

    public RemoteConnection get(String string) {
        Object a2 = string;
        RemoteConnections a3 = this;
        return (RemoteConnection)a3.k.get(a2);
    }

    public int size() {
        RemoteConnections a2;
        return a2.k.size();
    }
}

