/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.LifecycleController;
import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.StateChanged;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.RaftProperties;
import io.axoniq.axonserver.configuration.runtime.ReplicationGroupMember;
import io.axoniq.axonserver.enterprise.cluster.GrpcRaftGroupFactory;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftGroup;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.enterprise.replication.group.ReplicationGroupController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.util.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;

@Controller
public class GrpcRaftController
implements SmartLifecycle,
RaftGroupManager {
    private final GrpcRaftGroupFactory B;
    private final ReplicationGroupController I;
    private final Map<String, Long> h;
    private final AtomicBoolean F;
    private final ApplicationEventPublisher m;
    public static final String j = "replication-logs";
    private volatile boolean i;
    private final Logger M;
    private final Map<String, RaftGroup> G;
    private final MessagingPlatformConfiguration J;
    private final LifecycleController b;
    private final RaftProperties g;
    private final RaftGroupRepositoryManager k;
    private final FileSystemMonitor A;

    public RaftGroup getRaftGroup(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return (RaftGroup)a3.G.get(a2);
    }

    public Optional<RaftNode> raftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if ((a2 = (RaftGroup)a3.G.get(a2)) != null) {
            return Optional.of(a2.localNode());
        }
        return Optional.empty();
    }

    public RaftNode waitForLeader(RaftGroup raftGroup) {
        GrpcRaftController a2 = raftGroup;
        GrpcRaftController a3 = this;
        GrpcRaftController grpcRaftController = a2;
        while (!grpcRaftController.localNode().M() || a2.logEntryProcessor().C() == 0L) {
            try {
                Thread.sleep(100L);
                grpcRaftController = a2;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(RaftGroupServiceFactory.g((Object)"wFJMLZKXJ\bI@WD[\bIIW\\WFY\bJG\u001eJ[KQE[\bRM_L[Z"));
            }
        }
        return a2.localNode();
    }

    private /* synthetic */ void g(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        a3.h.put(a2, System.currentTimeMillis() + 2L * (long)a3.g.getMaxElectionTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public RaftNode getOrCreateRaftNode(String string, String string2) {
        void a2;
        GrpcRaftController grpcRaftController = this;
        if (!grpcRaftController.i) {
            throw new IllegalStateException(RaftAdminGroup.g((Object)"'H\u0006[\u0011_T^\u0000L\u0006Y\u0001][^\u001cX\u0000I\u001bZ\u001a\r\u001dCT]\u0006B\u0013_\u0011^\u0007"));
        }
        GrpcRaftController a3 = (RaftGroup)grpcRaftController.G.get(a2);
        if (a3 != null) {
            return a3.localNode();
        }
        Map map = grpcRaftController.G;
        synchronized (map) {
            a3 = (RaftGroup)grpcRaftController.G.get(a2);
            if (a3 == null) {
                void a4;
                if (grpcRaftController.g((String)a2)) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, RaftGroupServiceFactory.g((Object)"lMNDWK_\\WGP\bYZQ]N\bZMRMJAQF\u001eAP\bNZQOLMM["));
                }
                a3 = grpcRaftController.g((String)a2, (String)a4);
                a3.startAndWait(null);
            }
        }
        return a3.localNode();
    }

    public Iterable<String> getAllNonAdminContexts() {
        GrpcRaftController a2;
        return a2.k.contexts();
    }

    public void stop() {
        GrpcRaftController a2;
        GrpcRaftController grpcRaftController = a2;
        grpcRaftController.A.unregisterPath(j);
        grpcRaftController.G.forEach((string, raftGroup) -> {
            String a2 = raftGroup;
            String a3 = string;
            a2.stop();
        });
        a2.i = false;
    }

    /*
     * WARNING - void declaration
     */
    public RaftGroup initRaftGroup(String string, String string2, String string3) {
        void a2;
        Node a3;
        Object a4 = string2;
        GrpcRaftController a5 = this;
        a3 = Node.newBuilder().setNodeId((String)a4).setHost(a5.J.getFullyQualifiedInternalHostname()).setPort(a5.J.getInternalPort()).setNodeName((String)a3).setRole(Role.PRIMARY).build();
        GrpcRaftController grpcRaftController = a5;
        a4 = grpcRaftController.g((String)a2, (String)a4);
        a4.raftConfiguration().update(Collections.singletonList(a3));
        grpcRaftController.M.debug(RaftAdminGroup.g((Object)"'Y\u0015_\u0000\r\u0012_\u001b@TD\u001aD\u0000\u007f\u0015K\u0000j\u0006B\u0001]TV\t"), (Object)a2);
        Object object = a4;
        object.startAndWait(Role.PRIMARY);
        return object;
    }

    public String getMyLabel(List<Node> list) {
        Object a2 = list;
        GrpcRaftController a3 = this;
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Node node = (Node)a2.next();
            if (!node.getNodeName().equals(a3.J.getName())) continue;
            return node.getNodeId();
        }
        throw new RuntimeException(RaftAdminGroup.g((Object)"n\u001bX\u0018ITC\u001bYTK\u001dC\u0010\r\u0017X\u0006_\u0011C\u0000\r\u001aB\u0010HTD\u001a\r\u001aB\u0010H\u0007"));
    }

    public Collection<String> getRaftGroups() {
        GrpcRaftController a2;
        return a2.G.keySet();
    }

    /*
     * WARNING - void declaration
     */
    public GrpcRaftController(MessagingPlatformConfiguration messagingPlatformConfiguration, RaftProperties raftProperties, RaftGroupRepositoryManager raftGroupRepositoryManager, ApplicationEventPublisher applicationEventPublisher, ReplicationGroupController replicationGroupController, GrpcRaftGroupFactory grpcRaftGroupFactory, FileSystemMonitor fileSystemMonitor, LifecycleController lifecycleController) {
        GrpcRaftController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        GrpcRaftController a10;
        GrpcRaftController grpcRaftController = grpcRaftController2;
        GrpcRaftController grpcRaftController2 = lifecycleController;
        GrpcRaftController grpcRaftController3 = a10 = grpcRaftController;
        GrpcRaftController grpcRaftController4 = a10;
        GrpcRaftController grpcRaftController5 = a10;
        GrpcRaftController grpcRaftController6 = a10;
        GrpcRaftController grpcRaftController7 = a10;
        a10.M = LoggerFactory.getLogger(GrpcRaftController.class);
        GrpcRaftController grpcRaftController8 = a10;
        grpcRaftController7.G = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController9 = a10;
        grpcRaftController8.h = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController10 = a10;
        grpcRaftController7.F = new AtomicBoolean();
        grpcRaftController6.J = a9;
        grpcRaftController6.k = a8;
        grpcRaftController5.I = a7;
        grpcRaftController5.g = a6;
        grpcRaftController4.m = a5;
        grpcRaftController4.B = a4;
        grpcRaftController3.A = a3;
        grpcRaftController3.b = a2;
    }

    public RaftNode getRaftNodeForContext(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.I.findReplicationGroupByContext((String)a2).map(arg_0 -> a3.getRaftNode(arg_0)).orElseThrow(() -> a3.g((String)a2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private /* synthetic */ RaftGroup g(String string, String string2) {
        Object a2 = string2;
        GrpcRaftController a3 = this;
        Map map = a3.G;
        synchronized (map) {
            void a4;
            block4: {
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.M.info(RaftGroupServiceFactory.g((Object)"EU\u0004\bWFW\\\u001eZ[XRA]IJAQF\u001eOLGKX"), (Object)a4);
                RaftGroup raftGroup = (RaftGroup)grpcRaftController.G.get(a4);
                if (raftGroup == null) break block4;
                return raftGroup;
            }
            a2 = a3.B.create((String)a4, (String)a2);
            a2.localNode().g(arg_0 -> a3.g((RaftGroup)a2, arg_0));
            a3.G.put(a4, a2);
            return a2;
        }
    }

    public int getPhase() {
        return 100;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void g(ReplicationGroupMember replicationGroupMember, AtomicInteger atomicInteger, Void void_, Throwable throwable) {
        Object a2;
        GrpcRaftController grpcRaftController = object;
        Object object = throwable;
        GrpcRaftController a3 = grpcRaftController;
        if (a2 == null) {
            void a4;
            a3.M.info(RaftGroupServiceFactory.g((Object)"SC\u0012\u001ez[XRA]IJAQF\u001eOLGKX\u001e[JIL\\[L"), (Object)a.groupId());
            if (a4.decrementAndGet() == 0) {
                GrpcRaftController grpcRaftController2 = a3;
                grpcRaftController2.b.setCleanShutdown();
                grpcRaftController2.F.set(true);
                return;
            }
        } else {
            a3.M.warn(RaftAdminGroup.g((Object)"V\t\u0017T\u007f\u0011]\u0018D\u0017L\u0000D\u001bCTJ\u0006B\u0001]T^\u0000L\u0006YTK\u0015D\u0018H\u0010"), (Object)a.groupId(), a2);
        }
    }

    private /* synthetic */ MessagingPlatformException g(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.J.getName() + ": Not a member of " + (String)a2);
    }

    public RaftNode getRaftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (!a3.i) {
            throw new IllegalStateException(RaftAdminGroup.g((Object)"d\u001aD\u0000D\u0015A\u001dW\u0015Y\u001dB\u001a\r\u001b_T^\u001cX\u0000I\u001bZ\u001a\r\u001dCT]\u0006B\u0013_\u0011^\u0007"));
        }
        if (!a3.G.containsKey(a2)) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.J.getName() + ": Not a member of " + (String)a2);
        }
        return ((RaftGroup)a3.G.get(a2)).localNode();
    }

    public void start() {
        GrpcRaftController grpcRaftController = this;
        Object a2 = new File(grpcRaftController.g.getLogStorageFolder());
        GrpcRaftController grpcRaftController2 = grpcRaftController;
        FileUtils.g((File)a2);
        grpcRaftController2.A.registerPath(j, ((File)a2).toPath(), grpcRaftController.g.minFreeSpace(), grpcRaftController.g.warnFreeSpace());
        a2 = grpcRaftController2.k.getMyReplicationGroups();
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            a3.g(a2.groupId(), a2.nodeId());
        });
        grpcRaftController.i = true;
        AtomicInteger atomicInteger = new AtomicInteger(a2.size());
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            try {
                void a4;
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.M.info(RaftGroupServiceFactory.g((Object)"EU\u0004\blMNDWK_\\WGP\bYZQ]N\bM\\_ZJAPO"), (Object)a2.groupId());
                ((RaftGroup)grpcRaftController.G.get(a2.groupId())).start(a2.role()).whenComplete((arg_0, arg_1) -> a3.g((ReplicationGroupMember)a2, (AtomicInteger)a4, arg_0, arg_1));
                return;
            }
            catch (Exception a4) {
                a3.M.warn(RaftAdminGroup.g((Object)"\u000fPN\r2L\u001dA\u0011ITY\u001b\r\u001dC\u001dY\u001dL\u0018D\u000eHT_\u0011]\u0018D\u0017L\u0000D\u001bC3_\u001bX\u0004"), (Object)a2.groupId(), (Object)a4);
                return;
            }
        });
        grpcRaftController.M.info(RaftGroupServiceFactory.g((Object)"lMNDWK_\\WGP\bYZQ]N\b]GP\\LGRD[Z\u001eZKFPAPO"));
        if (a2.isEmpty()) {
            grpcRaftController.F.set(true);
        }
    }

    public String getMyName() {
        GrpcRaftController a2;
        return a2.J.getName();
    }

    public Set<String> raftGroups() {
        GrpcRaftController a2;
        return a2.G.keySet();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void g(RaftGroup raftGroup, StateChanged stateChanged) {
        void a2;
        GrpcRaftController a3 = stateChanged;
        GrpcRaftController a4 = this;
        a4.g(a2.localNode(), (StateChanged)a3);
    }

    public boolean ready() {
        GrpcRaftController a2;
        return a2.F.get();
    }

    /*
     * WARNING - void declaration
     */
    public void delete(String string, boolean bl) {
        void a2;
        Object a3 = string;
        GrpcRaftController a4 = this;
        if (a2 == false) {
            a4.g((String)a3);
        }
        a4.G.remove(a3);
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.I.deleteReplicationGroup((String)a3, (boolean)a2);
        grpcRaftController.m.publishEvent((Object)new ClusterEvents.ReplicationGroupDeleted((String)a3, (boolean)a2));
    }

    public int electionTimeout() {
        GrpcRaftController a2;
        return a2.g.getMaxElectionTimeout();
    }

    public boolean isHealthy(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.getRaftNodeForContext((String)a2).i();
    }

    @Scheduled(fixedDelay=1000L)
    public void syncStore() {
        GrpcRaftController a2;
        if (a2.i) {
            a2.G.forEach((string, raftGroup) -> {
                String a2 = raftGroup;
                String a3 = string;
                ((GrpcRaftGroup)a2).g();
            });
        }
    }

    public boolean isRunning() {
        GrpcRaftController a2;
        return a2.i;
    }

    /*
     * WARNING - void declaration
     */
    public void prepareDeleteNodeFromReplicationGroup(String string, String string2) {
        void a2;
        GrpcRaftController a3;
        Object a4 = string2;
        GrpcRaftController grpcRaftController = a3 = this;
        grpcRaftController.k.prepareDeleteNodeFromReplicationGroup((String)a2, (String)a4);
        grpcRaftController.m.publishEvent((Object)new ClusterEvents.DeleteNodeFromReplicationGroupRequested((String)a2, (String)a4));
    }

    private /* synthetic */ boolean g(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (a3.h.getOrDefault(a2, 0L) > System.currentTimeMillis()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void g(RaftNode raftNode, StateChanged stateChanged) {
        void a2;
        void a3;
        GrpcRaftController grpcRaftController = this;
        void v0 = a3;
        Object a4 = v0.M();
        long l2 = a2.g();
        if (v0.g() && !a3.C()) {
            grpcRaftController.m.publishEvent((Object)new ClusterEvents.LeaderStepDown((String)a4, l2));
            return;
        }
        if (a3.C() && !a3.g()) {
            grpcRaftController.m.publishEvent((Object)new ClusterEvents.BecomeLeader((String)a4, () -> ((RaftNode)a2).g(), l2));
            return;
        }
        if (a3.i()) {
            grpcRaftController.m.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, null, l2));
            return;
        }
        if (!StringUtils.isEmpty((String)a2.M())) {
            grpcRaftController.m.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, a2.M(), l2));
        }
    }
}

