/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.config.AxonServerRoutingConfiguration;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.CommandService;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcCommandDispatcherListener;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.grpc.SerializedCommandProviderInbound;
import io.axoniq.axonserver.grpc.SerializedCommandResponse;
import io.axoniq.axonserver.grpc.command.CommandProviderOutbound;
import io.axoniq.axonserver.grpc.command.CommandServiceGrpc;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.message.ByteStringMarshaller;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.websocket.WebsocketProcessorContext;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.PreDestroy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service(value="CommandService")
public class CommandService
implements AxonServerClientService {
    private static final MethodDescriptor<ByteString, SerializedCommandResponse> B = CommandServiceGrpc.getDispatchMethod().toBuilder((MethodDescriptor.Marshaller)ByteStringMarshaller.g(), ProtoUtils.marshaller((Message)SerializedCommandResponse.getDefaultInstance())).build();
    private final ApplicationEventPublisher I;
    private final CommandDispatcher h;
    private final ClientIdRegistry F;
    private final ContextProvider m;
    private final MeterFactory j;
    @Value(value="${axoniq.axonserver.command-threads:1}")
    private int i;
    private final Topology M;
    private static final MethodDescriptor<CommandProviderOutbound, SerializedCommandProviderInbound> G = CommandServiceGrpc.getOpenStreamMethod().toBuilder(ProtoUtils.marshaller((Message)CommandProviderOutbound.getDefaultInstance()), ProtoUtils.marshaller((Message)SerializedCommandProviderInbound.getDefaultInstance())).build();
    private final AxonServerRoutingConfiguration J;
    private final InstructionAckSource<SerializedCommandProviderInbound> b;
    private final AuthenticationProvider g;
    private final Logger k;
    private final Map<ClientStreamIdentification, GrpcCommandDispatcherListener> A;

    /*
     * WARNING - void declaration
     */
    public StreamObserver<CommandProviderOutbound> openStream(StreamObserver<SerializedCommandProviderInbound> streamObserver) {
        void a2;
        CommandService commandService = this;
        String string = commandService.m.getContext();
        Object a3 = new ConcurrentHashMap();
        1 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        CommandService commandService2 = commandService;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    /*
     * WARNING - void declaration
     */
    public CommandService(Topology topology, CommandDispatcher commandDispatcher, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, MeterFactory meterFactory, ApplicationEventPublisher applicationEventPublisher, @Qualifier(value="commandInstructionAckSource") InstructionAckSource<SerializedCommandProviderInbound> instructionAckSource, AxonServerRoutingConfiguration axonServerRoutingConfiguration) {
        void instructionAckSource2;
        void eventPublisher;
        void meterFactory2;
        void clientIdRegistry2;
        void authenticationProvider2;
        void contextProvider2;
        void commandDispatcher2;
        void topology2;
        CommandService a2;
        CommandService commandService = commandService2;
        CommandService commandService2 = axonServerRoutingConfiguration;
        CommandService commandService3 = a2 = commandService;
        CommandService commandService4 = a2;
        CommandService commandService5 = a2;
        CommandService commandService6 = a2;
        CommandService commandService7 = a2;
        a2.k = LoggerFactory.getLogger(CommandService.class);
        CommandService commandService8 = a2;
        a2.A = new ConcurrentHashMap();
        commandService7.i = 1;
        commandService7.M = topology2;
        commandService6.h = commandDispatcher2;
        commandService6.m = contextProvider2;
        commandService5.g = authenticationProvider2;
        commandService5.F = clientIdRegistry2;
        commandService4.j = meterFactory2;
        commandService4.I = eventPublisher;
        commandService3.b = instructionAckSource2;
        commandService3.J = commandService2;
    }

    /*
     * WARNING - void declaration
     */
    public void completeStreamForInactivity(String string, ClientStreamIdentification clientStreamIdentification) {
        CommandService a2 = clientStreamIdentification;
        CommandService a3 = this;
        if (a3.A.containsKey(a2)) {
            void a4;
            String string2 = "Command stream inactivity for " + a2.C();
            string2 = new ApplicationInactivityException(string2);
            ((GrpcCommandDispatcherListener)a3.A.remove(a2)).cancelAndCompleteStreamExceptionally((Throwable)((Object)string2));
            CommandService commandService = a3;
            commandService.k.debug(WebsocketProcessorContext.g((Object)"\u001f\u00061\u0004=\u00078I\u000f\u001d.\f=\u0004|\n0\u0006/\f8I:\u0006.I?\u00055\f2\u001dfI'\u0014"), (Object)a2);
            commandService.I.publishEvent((Object)new TopologyEvents.CommandHandlerDisconnected(a2.M(), (String)a4, a2.C()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void g(String string, StreamObserver streamObserver, SerializedCommandResponse serializedCommandResponse) {
        void a2;
        void a3;
        CommandService a4 = serializedCommandResponse;
        CommandService a5 = this;
        a5.g((String)a3, (SerializedCommandResponse)a4, (StreamObserver)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void g(String string, SerializedCommandResponse serializedCommandResponse, StreamObserver<SerializedCommandResponse> streamObserver) {
        CommandService a22 = serializedCommandResponse;
        CommandService a3 = this;
        try {
            void a4;
            void v0 = a4;
            v0.onNext((Object)a22);
            v0.onCompleted();
            return;
        }
        catch (RuntimeException a22) {
            void a5;
            a3.k.debug(WebsocketProcessorContext.g((Object)"\u000e\f/\u00193\u0007/\f|\u001d3I?\u00055\f2\u001d|\u0012!I:\b5\u00059\r"), (Object)a5, (Object)a22);
            return;
        }
    }

    @PreDestroy
    public void cleanup() {
        CommandService a2;
        a2.A.forEach((clientStreamIdentification, grpcCommandDispatcherListener) -> {
            ClientStreamIdentification a2 = grpcCommandDispatcherListener;
            ClientStreamIdentification a3 = clientStreamIdentification;
            a2.cancel();
        });
        a2.A.clear();
    }

    public final ServerServiceDefinition bindService() {
        CommandService a2;
        return ServerServiceDefinition.builder((String)WebsocketProcessorContext.g((Object)"5\u0006r\b$\u00062\u0000-G=\u00113\u0007/\f.\u001f9\u001br\u000e.\u0019?G?\u00061\u0004=\u00078G\u001f\u00061\u0004=\u00078:9\u001b*\u0000?\f")).addMethod(G, ServerCalls.asyncBidiStreamingCall(arg_0 -> a2.openStream(arg_0))).addMethod(B, ServerCalls.asyncUnaryCall((arg_0, arg_1) -> a2.dispatch(arg_0, arg_1))).build();
    }

    public Set<GrpcCommandDispatcherListener> listeners() {
        CommandService a2;
        return new HashSet<GrpcCommandDispatcherListener>(a2.A.values());
    }

    /*
     * WARNING - void declaration
     */
    public void dispatch(ByteString byteString, StreamObserver<SerializedCommandResponse> streamObserver) {
        void a2;
        CommandService a222 = byteString;
        CommandService a3 = this;
        a222 = new SerializedCommand((ByteString)a222);
        String string = a222.wrapped().getClientId();
        if (a3.k.isTraceEnabled()) {
            a3.k.trace(WebsocketProcessorContext.g((Object)"'\u0014fI\u000e\f?\f5\u001f9\r|\n3\u00041\b2\rfI'\u0014"), (Object)string, (Object)a222.wrapped().getName());
        }
        try {
            CommandService commandService = a3;
            commandService.h.dispatch(commandService.m.getContext(), (Authentication)a3.g.get(), (SerializedCommand)a222, arg_0 -> a3.g(string, (StreamObserver)a2, arg_0));
            return;
        }
        catch (Exception a222) {
            Exception exception = a222;
            a3.k.warn(WebsocketProcessorContext.g((Object)"\u0018\u0000/\u0019=\u001d?\u00015\u0007;I:\b5\u00059\r|\u001e5\u001d4I)\u00079\u0011,\f?\u001d9\r|\f.\u001b3\u001b"), (Throwable)exception);
            a2.onError((Throwable)GrpcExceptionBuilder.build((Throwable)exception));
            return;
        }
    }

    private /* synthetic */ boolean g(InstructionAck instructionAck) {
        CommandService a2 = instructionAck;
        CommandService a3 = this;
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }
}

