/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.AxonServerAccessController;
import io.axoniq.axonserver.LicenseAccessController;
import io.axoniq.axonserver.admin.user.requestprocessor.UserController;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AuthenticationInterceptor;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.grpc.LicenseInterceptor;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.rest.json.MessageJson;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerTransportFilter;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component(value="Gateway")
public class Gateway
implements SmartLifecycle {
    private Server h;
    private final Logger F;
    private AdvancedTlsX509KeyManager.Closeable m;
    private final List<ServerTransportFilter> j;
    private final ExecutorService i;
    private final MessagingPlatformConfiguration M;
    private boolean G;
    private final LicenseAccessController J;
    private final MeterFactory b;
    private final AxonServerAccessController g;
    private final List<AxonServerClientService> k;
    private final Supplier<ScheduledExecutorService> A;

    public void stop() {
        Gateway gateway = this;
        if (gateway.m != null) {
            gateway.m.close();
        }
        Gateway gateway2 = gateway;
        gateway2.i.shutdown();
        if (gateway2.G) {
            try {
                if (!gateway.h.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                    Gateway gateway3 = gateway;
                    gateway3.F.debug(UserController.g((Object)"\rg9k.n>d'qk{?g;x\"f,(\bd>{?m9(\u0018m9~.z"));
                    gateway3.h.shutdownNow();
                }
            }
            catch (InterruptedException a2) {
                gateway.F.debug(MessageJson.g((Object)".\u001a\u0013\u0011\u0015\u0006\u0012\u0004\u0013\u0011\u0003T\u0003\u0001\u0015\u001d\t\u0013G\u0007\u000f\u0001\u0013\u0010\b\u0003\tT\b\u0012G35$$T\u0014\u0011\u0015\u0002\u0002\u0006"), (Throwable)a2);
                Thread.currentThread().interrupt();
            }
        }
        gateway.G = false;
        gateway.F.info(UserController.g((Object)"I3g%(\u0018m9~.zkO*|.\u007f*qk{?g;x.l"));
    }

    public boolean isRunning() {
        Gateway a2;
        return a2.G;
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, Supplier<ScheduledExecutorService> supplier, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        Gateway a9;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway gateway3 = a9 = gateway;
        Gateway gateway4 = a9;
        Gateway gateway5 = a9;
        Gateway gateway6 = a9;
        gateway6.F = LoggerFactory.getLogger(Gateway.class);
        gateway6.M = a8;
        gateway5.k = a7;
        gateway5.j = a6;
        gateway4.g = a5;
        gateway4.J = a4;
        a9.A = a3;
        gateway3.b = a2;
        gateway3.i = Executors.newFixedThreadPool(a9.M.getExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(MessageJson.g((Object)"\u0000\u0006\u0017\u0017J\u0011\u001f\u0011\u0004\u0001\u0013\u001b\u0015Y")));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        Gateway gateway = this;
        String string = MessageJson.g((Object)"\t\u001bG'48");
        try {
            Gateway a2;
            Gateway gateway2;
            if (gateway.M.getSsl() != null && gateway.M.getSsl().isEnabled()) {
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                gateway.m = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile(new File(gateway.M.getSsl().getPrivateKeyFile()), new File(gateway.M.getSsl().getCertChainFile()), 1L, TimeUnit.MINUTES, (ScheduledExecutorService)gateway.A.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                ServerCredentials serverCredentials = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                string = UserController.g((Object)"[\u0018Dkm%i)d.l");
                Gateway gateway3 = gateway;
                gateway2 = gateway3;
                a2 = NettyServerBuilder.forPort((int)gateway3.M.getPort(), (ServerCredentials)serverCredentials);
            } else {
                Gateway gateway4 = gateway;
                gateway2 = gateway4;
                a2 = NettyServerBuilder.forPort((int)gateway4.M.getPort());
            }
            if (gateway2.M.getMaxMessageSize() > 0) {
                a2.maxInboundMessageSize(gateway.M.getMaxMessageSize());
            }
            a2.permitKeepAliveWithoutCalls(true).permitKeepAliveTime(gateway.M.getMinKeepAliveTime(), TimeUnit.MILLISECONDS);
            gateway.k.forEach(arg_0 -> ((NettyServerBuilder)a2).addService(arg_0));
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(gateway.M.getGrpcBufferedMessages()));
            if (gateway.M.getAccesscontrol().isEnabled()) {
                Gateway gateway5 = gateway;
                a2.intercept((ServerInterceptor)new AuthenticationInterceptor(gateway5.g, gateway5.b));
            }
            a2.intercept((ServerInterceptor)new LicenseInterceptor(gateway.J));
            a2.intercept((ServerInterceptor)new ContextInterceptor());
            if (gateway.M.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(gateway.M.getKeepAliveTime(), TimeUnit.MILLISECONDS).keepAliveTimeout(gateway.M.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.executor((Executor)gateway.i);
            gateway.j.forEach(arg_0 -> ((NettyServerBuilder)a2).addTransportFilter(arg_0));
            gateway.h = a2.build();
            gateway.h.start();
            gateway.F.info(MessageJson.g((Object)"&\f\b\u001aG'\u0002\u0006\u0011\u0011\u0015T \u0015\u0013\u0011\u0010\u0015\u001eT\u0014\u0000\u0006\u0006\u0013\u0011\u0003T\b\u001aG\u0004\b\u0006\u0013NG\u000f\u001aTJT\u001c\t"), (Object)gateway.M.getPort(), (Object)string);
            gateway.G = true;
            return;
        }
        catch (Exception exception) {
            throw new FailedToStartException(UserController.g((Object)"[?i9|\"f,(\np$fk[.z=m9(\fi?m<i2(-i\"d.l"), (Throwable)exception);
        }
    }

    public boolean isAutoStartup() {
        return true;
    }

    public int getPhase() {
        return 200;
    }

    /*
     * WARNING - void declaration
     */
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway a8 = gateway;
        a8((MessagingPlatformConfiguration)a7, (List)a6, (List)a5, (AxonServerAccessController)a4, (LicenseAccessController)a3, Executors::newSingleThreadScheduledExecutor, (MeterFactory)a2);
    }
}

