/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.licensing;

import io.axoniq.axonserver.config.AxonServerEnterpriseProperties;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.licensing.LicenseConfiguration;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.licensing.LicenseManager;
import io.axoniq.axonserver.licensing.e;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.command.CommandMetricsWebSocket;
import io.axoniq.axonserver.util.StringUtils;
import io.netty.buffer.Unpooled2;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.axonserver.marketplace"}, havingValue="false", matchIfMissing=true)
public class FileLicenseManager
implements LicenseManager {
    private static final String K = "axoniq.license";
    private static final String l = "contexts";
    private static final String c = "expiry_date";
    private static final String f = "issue_date";
    private final AtomicReference<e> L;
    private static final String D = "licensee";
    private static final Logger B;
    private static final String I = "AXONIQ_LICENSE";
    private static final Logger h;
    private static final String F = "signature";
    private static final String m = "grace_date";
    private final AdminNodes j;
    private final AtomicReference<Properties> i;
    private static final String M = "license_key_id";
    private static final String G = "clusterNodes";
    private static final String J = "product";
    private static final String b = "AxonServer";
    private static final String g = "MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA0xyNKA5aL42X7eXy1zwe\n9V6do3TYhrH7smWa6RBtCkhQ2holCEalrdiEX3LQoyhPmvV8lqWrDc9JHuYheWQL\npQXKB84sb9DCCWZWTPV0OZpe8nyotgmwBYohvEzTGLLRrAp+pM/J+/IVSiMyiP5E\nKf6ODcRWQH/us+4x4IsjTZC+o0HsYjSXG62Bo7pXFXLKjUqA3rpTyT1v3Yafgp4C\n78wHa/fqKCE562B2IEEhxWdsJl//wOsk/I8bYH+YoZtceGpRJlkMjK3t/KOExU61\nae5NJruyXbqRBWOtrcBb37b2cgykqaZlCwQczsZwl8Pglm1Yl0t8lTdTM+wxLErI\nAbxYE50UtvMLCaIG8lqT9W28UQgOr+RPdkEwUWYNeWWH2R0Kukva9loB+LBDe/Ce\nYhRvh41KpekJhU0NYjymCizNFohQ0rUDtt8p+i/IpIxfWBtgJODOrP2tbr8necX8\nX5oMyN4H/ar6favdWCHXi9FtTrHv1lchisXn3R9/obJptkxyZc8yvWuEBhXBFJ6H\nydOPNdbiWIH9TptZ2vaQrSFyaPR5yCoG/kyZ6o7TQE8lK6MrULiJNB/6ZKujri5x\nLovNJrtY/w69qVkC/8lIJhwJMSJKySeUYBhOjVN4f7vVEVYncYx8HJU2utQ1j6+e\n9T0pQ8CjhkOpmcTcaaMmU0UCAwEAAQ==";
    private final String k;
    private static final String A = "license";

    private /* synthetic */ void M(String string) {
        Object a2 = string;
        FileLicenseManager a3 = this;
        if (!e.A.equals((Object)a3.L.getAndSet(e.A))) {
            h.info(Unpooled2.g((Object)"\u0014a;m6{=(4g9l=lxi6lx~9d1l9|=lxn7zx/#u\u007f&"), a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public FileLicenseManager(AxonServerEnterpriseProperties axonServerEnterpriseProperties, AdminNodes adminNodes) {
        void a2;
        FileLicenseManager a3;
        FileLicenseManager a4 = axonServerEnterpriseProperties;
        FileLicenseManager fileLicenseManager = a3 = this;
        FileLicenseManager fileLicenseManager2 = a3;
        fileLicenseManager.i = new AtomicReference();
        FileLicenseManager fileLicenseManager3 = a3;
        fileLicenseManager.L = new AtomicReference<e>(e.b);
        fileLicenseManager.k = a4.getLicenseDirectory() == null ? Paths.get("", new String[0]).toAbsolutePath().toString() : a4.getLicenseDirectory();
        a3.j = a2;
    }

    private /* synthetic */ LocalDate g(String string) {
        Object a2 = string;
        FileLicenseManager a3 = this;
        if (StringUtils.isEmpty((String)a2)) {
            return null;
        }
        return LocalDate.parse((CharSequence)a2);
    }

    public Properties readLicenseProperties() {
        FileLicenseManager fileLicenseManager = this;
        Object a2 = (Properties)fileLicenseManager.i.get();
        if (a2 != null) {
            return a2;
        }
        FileLicenseManager fileLicenseManager2 = fileLicenseManager;
        a2 = fileLicenseManager2.g(fileLicenseManager2.g());
        fileLicenseManager2.g((Properties)a2);
        fileLicenseManager2.i.set(a2);
        return a2;
    }

    /*
     * WARNING - void declaration
     */
    public void createOrUpdate(byte[] byArray) {
        File file;
        Object a23;
        void a222;
        FileLicenseManager fileLicenseManager = this;
        B.debug(Unpooled2.g((Object)"^9d1l9|1f?(6m/(4a;m6{=&v&"));
        FileLicenseManager fileLicenseManager2 = fileLicenseManager;
        Properties properties = fileLicenseManager2.g((byte[])a222);
        fileLicenseManager2.g(properties);
        String string = System.getProperty(A, System.getenv(I));
        if (StringUtils.isEmpty((String)string)) {
            a23 = new File(fileLicenseManager.k);
            if (!((File)a23).exists() && !((File)a23).mkdirs()) {
                throw new MessagingPlatformException(ErrorCode.OTHER, "Failed to create directory: " + ((File)a23).getAbsolutePath());
            }
            file = new File((File)a23, K);
        } else {
            file = new File(string);
        }
        a23 = new FileOutputStream(file);
        try {
            Object object = a23;
            ((FileOutputStream)object).write((byte[])a222);
            ((OutputStream)object).flush();
        }
        catch (Throwable a222) {
            try {
                Throwable throwable;
                try {
                    ((FileOutputStream)a23).close();
                    throwable = a222;
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = a222;
                    throwable = throwable3;
                    throwable3.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException a23) {
                throw LicenseException.g((String)file.getAbsolutePath(), (Throwable)a23);
            }
        }
        ((FileOutputStream)a23).close();
        B.info(CommandMetricsWebSocket.g((Object)"3\u0006\nC\u0011\n\u001e\u0006\u0013\u0010\u0018C\u000e\u0002\u000b\u0006\u0019C\t\f]\u0018\u0000M"), (Object)file);
        FileLicenseManager fileLicenseManager3 = fileLicenseManager;
        fileLicenseManager3.L.set(e.b);
        fileLicenseManager3.M(properties.getProperty(J));
    }

    @NotNull
    private /* synthetic */ String g() {
        FileLicenseManager fileLicenseManager = this;
        String string = System.getProperty(A, System.getenv(I));
        Object a2 = null;
        if (string != null) {
            a2 = new File(string);
        }
        if (a2 == null || !((File)a2).exists()) {
            a2 = new File(fileLicenseManager.k, K);
            if (!((File)a2).exists()) {
                throw LicenseException.g((File)a2);
            }
            string = ((File)a2).getAbsolutePath();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Properties g(byte[] byArray) {
        FileLicenseManager fileLicenseManager = this;
        B.debug(CommandMetricsWebSocket.g((Object)"/\u0012\u0002\u0019\n\u0013\u0004]\u000f\u0014\u0000\u0018\r\u000e\u0006]\u0005\u000f\f\u0010C\u001e\f\u0013\u0017\u0018\r\tMSM"));
        Properties a2 = new Properties();
        try {
            void a3;
            a2.load(new ByteArrayInputStream((byte[])a3));
            return a2;
        }
        catch (IOException iOException) {
            throw LicenseException.g();
        }
    }

    public byte[] readLicense() {
        FileLicenseManager a2;
        B.info(Unpooled2.g((Object)"\u0014g9l1f?(4a;m6{=(;g6|=f,&v&"));
        FileLicenseManager fileLicenseManager = a2;
        return fileLicenseManager.g(fileLicenseManager.g());
    }

    public long nodesCount() {
        FileLicenseManager a2;
        return a2.j.findAll().count();
    }

    public void validate(byte[] byArray) {
        FileLicenseManager a2;
        Object a3 = byArray;
        FileLicenseManager fileLicenseManager = a2 = this;
        fileLicenseManager.g(fileLicenseManager.g((byte[])a3));
    }

    private /* synthetic */ boolean g(String string) {
        String a2 = string;
        FileLicenseManager a3 = this;
        if (a2 != null && a2.contains(b)) {
            return true;
        }
        return false;
    }

    @Scheduled(fixedRate=3600000L, initialDelay=3600000L)
    private /* synthetic */ void g() {
        FileLicenseManager a2;
        B.debug(CommandMetricsWebSocket.g((Object)"4\r\u000b\u0002\u0011\n\u0019\u0002\t\n\u0013\u0004]\u0000\u001c\u0000\u0015\u0006\u0019C\u0011\n\u001e\u0006\u0013\u0010\u0018MSM"));
        a2.i.set(null);
    }

    public String property(String string) {
        Object a2 = string;
        FileLicenseManager a3 = this;
        return a3.readLicenseProperties().getProperty((String)a2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void g(Properties properties) {
        String string;
        FileLicenseManager fileLicenseManager = this;
        try {
            void v3;
            void a22;
            block13: {
                Object object;
                KeyFactory keyFactory = KeyFactory.getInstance(Unpooled2.g((Object)"Z\u000bI"));
                Object a322 = Base64.getMimeDecoder().decode(g);
                a322 = new X509EncodedKeySpec((byte[])a322);
                a322 = keyFactory.generatePublic((KeySpec)a322);
                Object object2 = Signature.getInstance(CommandMetricsWebSocket.g((Object)"05\"OVK\u0014\u0014\u0017\u00151.\""));
                ((Signature)object2).initVerify((PublicKey)a322);
                Object object3 = a322 = new ArrayList<String>(a22.stringPropertyNames());
                Collections.sort(object3);
                if (!object3.remove(F)) {
                    throw LicenseException.g((String)Unpooled2.g((Object)"{1o6i,}*mxn1m4lxe1{+a6o"));
                }
                Object object4 = a322 = a322.iterator();
                while (object4.hasNext()) {
                    object = (String)a322.next();
                    object4 = a322;
                    Signature signature = object2;
                    signature.update(((String)object).getBytes(StandardCharsets.UTF_8));
                    signature.update(a22.getProperty((String)object, "").getBytes(StandardCharsets.UTF_8));
                }
                boolean a322 = ((Signature)object2).verify(Base64.getDecoder().decode(a22.getProperty(F)));
                if (!a322) {
                    fileLicenseManager.g(CommandMetricsWebSocket.g((Object)"/\u0014\u0000\u0018\r\u000e\u0006]\u0010\u0014\u0004\u0013\u0002\t\u0016\u000f\u0006]\n\u000eC\u0014\r\u000b\u0002\u0011\n\u0019M"));
                    throw LicenseException.g((String)Unpooled2.g((Object)"{1o6i,}*mxa6~9d1l"));
                }
                object = Objects.requireNonNull(fileLicenseManager.g(a22.getProperty(c)));
                LocalDate a322 = Objects.requireNonNull(fileLicenseManager.g(a22.getProperty(m)));
                object2 = LocalDate.now();
                if (((LocalDate)object2).isAfter((ChronoLocalDate)object)) {
                    if (((LocalDate)object2).isBefore(a322)) {
                        h.warn(CommandMetricsWebSocket.g((Object)"1\n\u001e\u0006\u0013\u0010\u0018C\u0015\u0002\u000eC\u0018\u001b\r\n\u000f\u0006\u0019O]\"\u0005\f\u00130\u0018\u0011\u000b\u0006\u000fC\n\n\u0011\u000f]\u0000\u0012\r\t\n\u0013\u0016\u0018C\n\f\u000f\b\u0014\r\u001aC\b\r\t\n\u0011C\u0006\u001e"), (Object)a322);
                        B.warn(Unpooled2.g((Object)"\u0014a;m6{=(0i+(=p(a*m<$xI g6[=z.m*(/a4dxk7f,a6}=(/g*c1f?(-f,a4(#u"), (Object)a322);
                        v3 = a22;
                        break block13;
                    } else {
                        fileLicenseManager.g(CommandMetricsWebSocket.g((Object)"<\u001b\u0012\r.\u0006\u000f\u0015\u0018\u0011]/\u0014\u0000\u0018\r\u000e\u0006]\u000b\u001c\u0010]\u0006\u0005\u0013\u0014\u0011\u0018\u0007"));
                        throw LicenseException.g((LocalDate)object);
                    }
                }
                v3 = a22;
            }
            string = v3.getProperty(J);
            if (!fileLicenseManager.g(string)) {
                throw LicenseException.M((String)string);
            }
            int a22 = Integer.parseInt((String)a22.get(G));
            long l2 = fileLicenseManager.nodesCount();
            if (l2 > (long)a22) {
                Object[] objectArray = new Object[2];
                objectArray[0] = a22;
                objectArray[1] = l2;
                fileLicenseManager.g(String.format(Unpooled2.g((Object)"K4}+|=zxd1e1|=lx|7(}lxj-|xn7}6lx-<(6g<m+&"), objectArray));
                throw LicenseException.g((int)a22, (long)l2);
            }
        }
        catch (SignatureException signatureException) {
            fileLicenseManager.g(CommandMetricsWebSocket.g((Object)".\n\u001a\r\u001c\u0017\b\u0011\u0018C\u000b\u0002\u0011\n\u0019\u0002\t\n\u0012\r]\u0005\u001c\n\u0011\u0006\u0019M"));
            throw LicenseException.g((String)("SignatureException: " + signatureException.getMessage()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new Error(Unpooled2.g((Object)"\f`1{x{0g-d<(6m.m*(0i(x=f"), generalSecurityException);
        }
        fileLicenseManager.M(string);
    }

    public boolean validateSilently() {
        FileLicenseManager fileLicenseManager = this;
        try {
            fileLicenseManager.g();
        }
        catch (Exception a2) {
            fileLicenseManager.g(a2.getMessage());
            return false;
        }
        return true;
    }

    private /* synthetic */ void g(String string) {
        Object a2 = string;
        FileLicenseManager a3 = this;
        if (!e.k.equals((Object)a3.L.getAndSet(e.k))) {
            h.error(CommandMetricsWebSocket.g((Object)"1\n\u001e\u0006\u0013\u0010\u0018C\u000b\u0002\u0011\n\u0019\u0002\t\n\u0012\r]\u0005\u001c\n\u0011\u0006\u0019Y]\u0018\u0000M"), a2);
            B.error(Unpooled2.g((Object)"\u0014a;m6{=(.i4a<i,a7fxn9a4m<2xs%&"), a2);
        }
    }

    private /* synthetic */ LicenseConfiguration g() {
        Object object = this;
        Object a2 = object.readLicenseProperties();
        if (a2 == null) {
            throw LicenseException.g();
        }
        a2 = new LicenseConfiguration(object.g(((Properties)a2).getProperty(c)), ((Properties)a2).getProperty(CommandMetricsWebSocket.g((Object)"\u0006\u0019\n\t\n\u0012\r")), ((Properties)a2).getProperty(M), Integer.parseInt(((Properties)a2).getProperty(l, Unpooled2.g((Object)"9"))), Integer.parseInt(((Properties)a2).getProperty(G, CommandMetricsWebSocket.g((Object)"P"))), ((Properties)a2).getProperty(D), object.g(((Properties)a2).getProperty(m)), object.g(((Properties)a2).getProperty(f)), (Properties)a2);
        B.debug(Unpooled2.g((Object)"D1k=f+m<(,gb(#u"), (Object)a2.getLicensee());
        B.debug(CommandMetricsWebSocket.g((Object)"1\b\r\u0013\n\u0013\u0004]\u0018\u0000C\u0010\f\u0019\u0006"), (Object)a2.getEdition());
        B.debug(Unpooled2.g((Object)"D1k=f+mxm x1z!(<i,mxa+(#u"), (Object)a2.getExpiryDate());
        return a2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private /* synthetic */ byte[] g(String string) {
        byte[] byArray;
        Object a2 = string;
        FileLicenseManager a3 = this;
        B.debug(CommandMetricsWebSocket.g((Object)"1\f\u001c\u0007\u0014\r\u001aC\u0011\n\u001e\u0006\u0013\u0010\u0018C\u001e\f\u0013\u0017\u0018\r\tC\u001b\u0011\u0012\u000e]\u0018\u0000MSM"), a2);
        a2 = new File((String)a2);
        FileInputStream fileInputStream = new FileInputStream((File)a2);
        try {
            byte[] byArray2 = new byte[Math.toIntExact(((File)a2).length())];
            fileInputStream.read(byArray2);
            byArray = byArray2;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            try {
                fileInputStream.close();
                throwable2 = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                try {
                    Throwable throwable4 = throwable;
                    throwable2 = throwable4;
                    throwable4.addSuppressed(throwable3);
                    throw throwable2;
                }
                catch (IOException iOException) {
                    throw LicenseException.g((File)a2);
                }
            }
        }
        fileInputStream.close();
        return byArray;
    }

    public int getClusterNodes() {
        FileLicenseManager a2;
        return a2.g().getClusterNodes();
    }

    public LocalDate getGraceDate() {
        FileLicenseManager a2;
        return a2.g().getGraceDate();
    }

    public LocalDate getIssueDate() {
        FileLicenseManager a2;
        return a2.g().getIssueDate();
    }

    @EventListener
    @Order(value=-2147483648)
    public void on(ClusterEvents.LicenseUpdated licenseUpdated) {
        FileLicenseManager a2;
        FileLicenseManager a3 = licenseUpdated;
        FileLicenseManager fileLicenseManager = a2 = this;
        fileLicenseManager.g();
        fileLicenseManager.createOrUpdate(a3.getLicense());
    }

    public boolean isEnterprise() {
        FileLicenseManager a2;
        return a2.g().isEnterprise();
    }

    static {
        h = AuditLog.getLogger();
        B = LoggerFactory.getLogger(LicenseManager.class);
    }

    public LocalDate getExpiryDate() {
        FileLicenseManager a2;
        return a2.g().getExpiryDate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private /* synthetic */ Properties g(String string) {
        File a2;
        FileLicenseManager fileLicenseManager = this;
        B.debug(Unpooled2.g((Object)"D7i<a6oxd1k=f+mxx*g(m*|1m+(>z7exs%&v&"), (Object)a2);
        a2 = new File((String)((Object)a2));
        Properties properties = new Properties();
        FileInputStream a32 = new FileInputStream(a2);
        try {
            properties.load(a32);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            try {
                a32.close();
                throwable2 = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                try {
                    Throwable throwable4 = throwable;
                    throwable2 = throwable4;
                    throwable4.addSuppressed(throwable3);
                    throw throwable2;
                }
                catch (IOException a32) {
                    throw LicenseException.g((File)a2);
                }
            }
        }
        a32.close();
        return properties;
    }

    public boolean validateSilently(byte[] byArray) {
        Object a22 = byArray;
        FileLicenseManager a3 = this;
        try {
            FileLicenseManager fileLicenseManager = a3;
            a22 = fileLicenseManager.g((byte[])a22);
            fileLicenseManager.g((Properties)a22);
        }
        catch (Exception a22) {
            a3.g(a22.getMessage());
            return false;
        }
        B.debug(CommandMetricsWebSocket.g((Object)"1\n\u001e\u0006\u0013\u0010\u0018C\u000b\u0002\u0011\n\u0019\u0002\t\u0006\u0019M"));
        return true;
    }
}

