/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage;

import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.grpc.event.EventWithToken;
import io.axoniq.axonserver.localstorage.DataFetcherSchedulerProvider;
import io.axoniq.axonserver.localstorage.EventStorageEngine;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.IndexBackup;
import io.axoniq.axonserver.localstorage.QueryOptions;
import io.axoniq.axonserver.localstorage.Registration;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.localstorage.SerializedTransactionWithToken;
import io.axoniq.axonserver.transport.rest.EventStoreTransformationRestController;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.springframework.data.util.CloseableIterator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface EventStorageEngine {
    public CloseableIterator<SerializedEventWithToken> getGlobalIterator(long var1);

    public long size();

    public long getFirstToken();

    default public void init(boolean bl) {
        boolean a2 = bl;
        EventStorageEngine a3 = this;
        a3.init(a2, 0L);
    }

    default public IndexBackup.BackupIndexResult backupIndex(IndexBackup.BackupIndexConfig backupIndexConfig) {
        EventStorageEngine a2 = backupIndexConfig;
        EventStorageEngine a3 = this;
        throw new UnsupportedOperationException();
    }

    public Flux<SerializedEvent> eventsPerAggregate(String var1, long var2, long var4, long var6);

    default public byte transactionVersion() {
        return 0;
    }

    public CloseableIterator<SerializedTransactionWithToken> transactionIterator(long var1, long var3);

    public long getTokenAt(long var1);

    default public Mono<Void> deleteOldVersions() {
        return Mono.error((Throwable)new UnsupportedOperationException(EventStoreTransformationRestController.g((Object)"~\u000fv\u000fn\u000fI\u000f}\u0007\u007f\u0004n\u0019 JU\u001a\u007f\u0018{\u001es\u0005tJt\u0005nJi\u001fj\u001au\u0018n\u000f~Jx\u0013:\u001er\u0003iJ_\u001c\u007f\u0004n9n\u0005h\u000b}\u000f_\u0004}\u0003t\u000f")));
    }

    default public long getLastToken() {
        return -1L;
    }

    public long nextToken();

    public EventTypeContext getType();

    public Registration registerCloseListener(Runnable var1);

    default public void validateTransaction(long l2, List<Event> eventStorageEngine) {
        Object a2 = eventStorageEngine;
        eventStorageEngine = this;
    }

    public void processEventsPerAggregateHighestFirst(String var1, long var2, long var4, int var6, Predicate<SerializedEvent> var7, Consumer<SerializedEvent> var8);

    public void init(boolean var1, long var2);

    public void processEventsPerAggregate(String var1, long var2, long var4, long var6, Consumer<SerializedEvent> var8);

    public Optional<SerializedEvent> getLastEvent(String var1, long var2, long var4);

    default public Stream<String> getBackupFilenames(long l2, int n, boolean bl) {
        boolean bl2 = bl;
        EventStorageEngine a2 = this;
        throw new UnsupportedOperationException();
    }

    default public Registration registerEventListener(BiConsumer<Long, List<Event>> biConsumer) {
        Object a2 = biConsumer;
        EventStorageEngine a3 = this;
        return () -> {};
    }

    public Optional<Long> getLastSequenceNumber(String var1, SearchHint ... var2);

    default public long getFirstCompletedSegment() {
        return -1L;
    }

    public void query(QueryOptions var1, Predicate<EventWithToken> var2);

    default public boolean validateSnapshot(SerializedEvent serializedEvent) {
        EventStorageEngine a2 = serializedEvent;
        EventStorageEngine a3 = this;
        return true;
    }

    default public void close(boolean bl) {
        boolean a2 = bl;
        EventStorageEngine eventStorageEngine = this;
    }

    default public Optional<Long> getLastSequenceNumber(String string, SearchHint searchHint, long l2) {
        Object a2 = string;
        EventStorageEngine a3 = this;
        return a3.getLastSequenceNumber((String)a2, new SearchHint[0]);
    }

    default public long store(List<Event> list) {
        Object a2 = list;
        EventStorageEngine a3 = this;
        return a3.store((List)a2, 0);
    }

    default public long store(List<Event> list, int n) {
        int a2 = n;
        EventStorageEngine a3 = this;
        throw new UnsupportedOperationException(DataFetcherSchedulerProvider.g((Object)"\u0000n<h6:<j6h2n:u=:=u': o#j<h'\u007f7"));
    }

    public Flux<Long> transformContents(int var1, Flux<EventWithToken> var2);
}

