/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.config.MetricsConfiguration;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="QueryCache")
public class QueryCache
implements NonReplacingConstraintCache<String, ActiveQuery> {
    private final Map<String, ActiveQuery> J;
    private final long b;
    private final long g;
    private final int k = 25000;
    private final Logger A;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void g(ActiveQuery activeQuery, String string) {
        void a2;
        Object a3 = string;
        QueryCache a4 = this;
        a4.A.debug(ClientContext.g((Object)"T\u0018z\u0007{\u0012c\u00127\u0006b\u0012e\u000e7\fjWq\u0018eWf\u0002r\u0005nW\u007f\u0016y\u0013{\u0012eW~\u0013r\u0019c\u001eq\u001er\u00137\u0015nWt\u001b~\u0012y\u0003D\u0003e\u0012v\u001a^\u00137\fjY"), (Object)a2.M(), a3);
        if (a2.g((String)a3)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a3;
            if (a2.g((String)a3, ErrorCode.CONNECTION_TO_HANDLER_LOST, String.format(MetricsConfiguration.g((Object)"\u0000C-B&O7E,BcX,\f+M-H/I1\ff_c@,_7"), objectArray))) {
                a4.remove(a2.M());
            }
        }
    }

    @EventListener
    public void on(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected) {
        QueryCache a2 = queryHandlerDisconnected;
        QueryCache a3 = this;
        a3.J.forEach((arg_0, arg_1) -> a3.g((TopologyEvents.QueryHandlerDisconnected)a2, arg_0, arg_1));
    }

    public Set<Map.Entry<String, ActiveQuery>> timedOut() {
        QueryCache a4;
        long l2 = System.currentTimeMillis() - a4.b;
        return a4.entrySet().stream().filter(a3 -> {
            if (((ActiveQuery)a3.getValue()).g() < l2) {
                return true;
            }
            return false;
        }).filter(a2 -> {
            if (!((ActiveQuery)a2.getValue()).M()) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
    }

    public ActiveQuery remove(String string) {
        QueryCache a2;
        Object a3 = string;
        QueryCache queryCache = a2 = this;
        queryCache.A.debug(MetricsConfiguration.g((Object)"\u0011I.C5IcA&_0M$I\nHcW>"), a3);
        return (ActiveQuery)queryCache.J.remove(a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void g(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected, String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3 = activeQuery;
        QueryCache a4 = this;
        a4.g((ActiveQuery)a3, a2.g());
    }

    public QueryCache(@Value(value="${axoniq.axonserver.default-query-timeout:300000}") long defaultQueryTimeout, @Value(value="${axoniq.axonserver.query-cache-capacity:0}") long a2) {
        QueryCache queryCache = this;
        QueryCache queryCache2 = this;
        queryCache2.A = LoggerFactory.getLogger(QueryCache.class);
        queryCache2.k = 25000;
        QueryCache queryCache3 = this;
        queryCache.J = new ConcurrentHashMap();
        queryCache.b = defaultQueryTimeout;
        if (a2 > 0L) {
            this.g = a2;
            return;
        }
        defaultQueryTimeout = DataSize.ofBytes((long)Runtime.getRuntime().maxMemory()).toGigabytes();
        this.g = defaultQueryTimeout > 0L ? 25000L * defaultQueryTimeout : 25000L;
    }

    public boolean isEmpty() {
        QueryCache a2;
        return a2.J.isEmpty();
    }

    public int size() {
        QueryCache a2;
        return a2.J.size();
    }

    private /* synthetic */ void g() {
        QueryCache a2;
        if ((long)a2.J.size() >= a2.g) {
            throw new InsufficientBufferCapacityException("Query buffer is full (" + a2.g + "/" + a2.g + ") Query handlers might be slow. Try increasing 'axoniq.axonserver.query-cache-capacity' property.");
        }
    }

    public ActiveQuery get(String string) {
        Object a2 = string;
        QueryCache a3 = this;
        return (ActiveQuery)a3.J.get(a2);
    }

    /*
     * WARNING - void declaration
     */
    public ActiveQuery putIfAbsent(String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3;
        QueryCache a4 = activeQuery;
        QueryCache queryCache = a3 = this;
        queryCache.g();
        return (ActiveQuery)queryCache.J.putIfAbsent(a2, a4);
    }

    public Collection<Map.Entry<String, ActiveQuery>> entrySet() {
        QueryCache a2;
        return a2.J.entrySet();
    }
}

