/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.logging.TopologyEventsLogger;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.SubscriptionQueryMetricRestController;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private final ClusterController F;
    private final ClusterTopology m;
    private final FeatureChecker j;
    private final RaftConfigServiceFactory i;
    private static final Logger M = AuditLog.getLogger();
    private static final Logger G = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ApplicationEventPublisher J;
    private final Predicate<String> b;
    private final DistributeLicenseService g;
    private final ClusterTemplateController k;
    public static final String A = "_none";

    @GetMapping(path={"{name}"})
    public JsonClusterNode g(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        ClusterNode a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        M.info(TopologyEventsLogger.g((Object)"G:a\u001c<\u0013y0i$o5</s%yax$h u-oaz.nag<2"), (Object)AuditLog.username((Principal)a2), object);
        a2 = name.F.getNode((String)object);
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + (String)object + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a2, (boolean)name.F.isActive((String)object));
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"{name}"})
    public void g(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        M.info(TopologyEventsLogger.g((Object)"G:a\u001c<\u0013y0i$o5<5sax$p$h$</s%yag<2"), (Object)AuditLog.username((Principal)a2), object);
        name.i.getRaftConfigService().deleteNode((String)object);
    }

    @PostMapping
    public ResponseEntity<RestResponse> g(@Valid @RequestBody ClusterJoinRequest clusterJoinRequest, @Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController;
        NodeInfo.Builder a2;
        ClusterRestController clusterRestController2 = clusterRestController3;
        ClusterRestController clusterRestController3 = clusterJoinRequest;
        ClusterRestController jsonClusterNode = clusterRestController2;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = clusterRestController3.getInternalHostName();
        objectArray[2] = clusterRestController3.internalGrpcPort;
        M.info(SubscriptionQueryMetricRestController.g((Object)"}+[\r\u0006\u0002C!S5U$\u0006$IpL?O>\u00063J%U$C\"\u00061Rp]-\u001c+[~"), objectArray);
        a2 = NodeInfo.newBuilder((NodeInfo)jsonClusterNode.F.getMe().toNodeInfo());
        String string = clusterRestController3.getContext();
        if (string != null && !string.isEmpty()) {
            if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, TopologyEventsLogger.g((Object)"_ r/s5<\"s,~(r$<+s(r(r&<\"s/h$d5<6u5tar._.r5y9h22"));
            }
            if (!RaftAdminGroup.g((String)string) && !jsonClusterNode.b.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            G.debug(SubscriptionQueryMetricRestController.g((Object)"G4Bx\u000fj\u0006\u0002C7O#R5T9H7\u0006=_#C<@pG>BpG4B9H7\u0006=CpR?\u00063I>R5^$\u0006r]-\u0004~"), (Object)string);
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
            G.debug(TopologyEventsLogger.g((Object)"}%xi5{<\u0013y&u2h$n(r&<,e2y-za}/xa}%x(r&<,yah.</sa\u007f.r5y9h22"));
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            G.debug(SubscriptionQueryMetricRestController.g((Object)"G4Bx\u000fj\u0006\u0002C7O#R5T9H7\u0006=_#C<@pG>BpG4B9H7\u0006=CpR?\u00061J<\u00063I>R5^$U~"));
            clusterRestController = jsonClusterNode;
        }
        if (clusterRestController.F.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new RestResponse(false, TopologyEventsLogger.g((Object)"\u000fs%ya}-n$}%ean${(o5y3y%<(ra}a\u007f-i2h$n")));
        }
        try {
            ClusterRestController clusterRestController4 = jsonClusterNode;
            ClusterRestController clusterRestController5 = clusterRestController3;
            clusterRestController3 = clusterRestController4.i.getRaftConfigServiceStub(clusterRestController5.internalHostName, clusterRestController5.internalGrpcPort.intValue()).joinCluster(a2.build());
            clusterRestController4.J.publishEvent((Object)new ClusterEvents.LicenseUpdated(clusterRestController3.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, SubscriptionQueryMetricRestController.g((Object)"g3E5V$C4\u0006:I9HpT5W%C#R|\u0006=G)\u0006$G;CpGpQ8O<CpR?\u0006 T?E5U#")));
        }
        catch (Exception this2) {
            return new RestResponse(false, this2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)this2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/upload-license"})
    public void g(@RequestParam(value="licenseFile") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        void a2;
        ClusterRestController clusterRestController = this;
        M.info(SubscriptionQueryMetricRestController.g((Object)"}+[\r\u0006\u0002C!S5U$\u0006<O3C>U5\u0006%V4G$C~"), (Object)AuditLog.username((Principal)a2));
        G.info(TopologyEventsLogger.g((Object)"\u000fy6<-u\"y/o$<4l-s x$xm<1y3z.n,u/{ap(\u007f$r2yai1x h$2o2"));
        try {
            void licenseFile;
            clusterRestController.g.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, SubscriptionQueryMetricRestController.g((Object)"\u001eIpJ5G4C\"\u00066I\"\u0006\u000fG4K9H~\u0006\u0015H#S\"CpR8G$\u0006$N5\u0006\u000fG4K9HpT5V<O3G$O?HpA\"I%VpO#\u00063T5G$C4\u00062C6I\"CpS J?G4O>ApGpJ9E5H#C~"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException messagingPlatformException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, messagingPlatformException.getMessage());
        }
    }

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void g(HttpServletResponse httpServletResponse, @Parameter(hidden=true) Principal principal) throws IOException {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        M.info(TopologyEventsLogger.g((Object)"G:a\u001c<\u0013y0i$o5<\"p4o5y3<5y,l-}5yax.k/p.}%2"), (Object)AuditLog.username((Principal)object));
        if (a2.m.isAdminNode()) {
            ServletOutputStream resp;
            object = SubscriptionQueryMetricRestController.g((Object)"E<S#R5T}R5K J1R5\b)K<");
            String string = a2.k.buildYamlTemplate();
            void v1 = resp;
            resp = v1.getOutputStream();
            v1.setContentType(TopologyEventsLogger.g((Object)"h$d531p u/'a\u007f)}3o$h|i5zl$"));
            v1.addHeader(SubscriptionQueryMetricRestController.g((Object)"\u0013I>R5H$\u000b\u0014O#V?U9R9I>"), "attachment; filename=\"" + (String)object + "\"");
            ServletOutputStream servletOutputStream = resp;
            servletOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            servletOutputStream.flush();
            servletOutputStream.close();
            return;
        }
        throw new RuntimeException(TopologyEventsLogger.g((Object)"E.ia\u007f rai2yah)u2<'i/\u007f5u.r p(h8<.r-eaz3s,< x,u/</s%y"));
    }

    /*
     * WARNING - void declaration
     */
    public ClusterRestController(ClusterController clusterController, RaftConfigServiceFactory raftConfigServiceFactory, FeatureChecker featureChecker, DistributeLicenseService distributeLicenseService, ApplicationEventPublisher applicationEventPublisher, ClusterTopology clusterTopology, ClusterTemplateController clusterTemplateController) {
        ClusterRestController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        ClusterRestController a9;
        ClusterRestController clusterRestController = clusterRestController2;
        ClusterRestController clusterRestController2 = clusterTemplateController;
        ClusterRestController clusterRestController3 = a9 = clusterRestController;
        ClusterRestController clusterRestController4 = a9;
        ClusterRestController clusterRestController5 = a9;
        ClusterRestController clusterRestController6 = a9;
        a9.b = new ContextNameValidation();
        a9.F = a8;
        clusterRestController5.i = a7;
        clusterRestController5.j = a6;
        clusterRestController4.g = a5;
        clusterRestController4.J = a4;
        clusterRestController3.m = a3;
        clusterRestController3.k = a2;
    }

    @GetMapping
    public List<JsonClusterNode> g(@Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        M.info(SubscriptionQueryMetricRestController.g((Object)"\u000b]-{pt5W%C#RpR?\u0006<O#RpH?B5U~"), (Object)AuditLog.username((Principal)object));
        return a2.F.nodes().map(clusterNode -> {
            ClusterRestController a2 = clusterNode;
            ClusterRestController a3 = this;
            ClusterRestController clusterRestController = a2;
            return JsonClusterNode.from((ClusterNode)clusterRestController, (boolean)a3.F.isActive(clusterRestController.getName()));
        }).collect(Collectors.toList());
    }
}

