/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.interceptor.InterceptorTimer;
import io.axoniq.axonserver.localstorage.StorageResolver;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.plugin.PluginController;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import io.axoniq.axonserver.rest.PluginConfigurationJSON;
import io.axoniq.axonserver.rest.PluginPropertyGroup;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/plugins"})
@CrossOrigin
public class PluginsRestController {
    private final boolean G;
    private final FeatureChecker J;
    private static final Logger b = AuditLog.getLogger();
    private final PluginController g;
    public static final String k = "Plugins disabled";
    private final Logger A;

    private /* synthetic */ String g(String string) {
        String a2 = string;
        PluginsRestController a3 = this;
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.OTHER, InterceptorTimer.g((Object)"\u000e2`-,('4.}0<#6!:%}0//+)9%9"));
        }
        if (a2.contains(File.separator)) {
            throw new MessagingPlatformException(ErrorCode.OTHER, StorageResolver.g((Object)"B(h$j i$$2l.q-`aj.pag.j5e(ja`(v$g5k3}aw$t v p.v"));
        }
        int n = a2.lastIndexOf(46);
        if (n > 0) {
            return a2.substring(0, n) + "-" + System.currentTimeMillis() + a2.substring(n);
        }
        return (String)a2 + "-" + System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    public PluginsRestController(PluginController pluginController, MessagingPlatformConfiguration messagingPlatformConfiguration, FeatureChecker featureChecker) {
        void a2;
        void a3;
        PluginsRestController a4;
        PluginsRestController a5 = featureChecker;
        PluginsRestController pluginsRestController = a4 = this;
        PluginsRestController pluginsRestController2 = a4;
        pluginsRestController2.A = LoggerFactory.getLogger(PluginsRestController.class);
        pluginsRestController2.G = a3.isPluginsEnabled();
        pluginsRestController.g = a2;
        pluginsRestController.J = a5;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"configuration"})
    public void g(@RequestBody PluginConfigurationJSON pluginConfigurationJSON, @Parameter(hidden=true) Principal principal) {
        void a2;
        PluginsRestController pluginsRestController = pluginsRestController2;
        PluginsRestController pluginsRestController2 = pluginConfigurationJSON;
        PluginsRestController configurationJSON = pluginsRestController;
        if (!configurationJSON.G || !configurationJSON.J.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, k);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)pluginsRestController2.getName());
        objectArray[2] = StringUtils.sanitize((String)pluginsRestController2.getVersion());
        b.info(InterceptorTimer.g((Object)"\u0006; \u001d}\u001281(%.4}42`(09!)%}#2.;):5/!))2.}/;`&=r; n}"), objectArray);
        configurationJSON.g.updateConfiguration((PluginKey)new SimplePluginKey(pluginsRestController2.getName(), pluginsRestController2.getVersion()), pluginsRestController2.getContext(), pluginsRestController2.getProperties());
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"status"})
    public void g(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @RequestParam(value="active") boolean bl, @Parameter(hidden=true) Principal principal) {
        void context;
        void version;
        void name;
        void a2;
        boolean bl2 = bl;
        PluginsRestController active = this;
        if (!active.G || !active.J.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, k);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = this != false ? InterceptorTimer.g((Object)".4<2)") : StorageResolver.g((Object)"2p.t");
        objectArray[2] = StringUtils.sanitize((String)name);
        objectArray[3] = StringUtils.sanitize((String)version);
        b.info(StorageResolver.g((Object)"_:y\u001c$\u0013a0q$w5$5ka\u007f<$1h4c(ja\u007f<+:yo$"), objectArray);
        active.g.updatePluginStatus((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context, (boolean)this);
    }

    @PostMapping(consumes={"multipart/form-data"})
    public PluginKey g(@RequestPart(value="bundle") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        PluginKey pluginBundle2;
        block6: {
            PluginsRestController pluginsRestController = object;
            Object object = principal;
            PluginsRestController a2 = pluginsRestController;
            if (!a2.G || !a2.J.plugins()) {
                throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, k);
            }
            b.info(StorageResolver.g((Object)"_:y\u001c$\u0013a0q$w5$5kam/w5e-hat-q&m/$:yo$"), (Object)AuditLog.username((Principal)object), (Object)StringUtils.sanitize((String)pluginBundle2.getOriginalFilename()));
            object = pluginBundle2.getInputStream();
            try {
                PluginsRestController pluginsRestController2 = a2;
                String string = pluginsRestController2.g(pluginBundle2.getOriginalFilename());
                pluginBundle2 = pluginsRestController2.g.addPlugin(string, (InputStream)object);
                if (object == null) break block6;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block7: {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                            throwable2 = throwable;
                            break block7;
                        }
                        catch (Throwable pluginBundle2) {
                            throwable.addSuppressed(pluginBundle2);
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            ((InputStream)object).close();
        }
        return pluginBundle2;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"configuration"})
    public Iterable<PluginPropertyGroup> g(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = this;
        if (!pluginsRestController.G || !pluginsRestController.J.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, k);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        b.info(StorageResolver.g((Object)"_:y\u001c$\u0013a0q$w5$'k3$\"k/b(c4v p(k/$.ba\u007f<+:yo$"), objectArray);
        try {
            void context;
            return pluginsRestController.g.listProperties((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = name;
            objectArray2[1] = version;
            objectArray2[2] = runtimeException;
            pluginsRestController.A.warn(InterceptorTimer.g((Object)"\u001b!4,8$}42`/%)24%+%}0//-%/44%.`;//`&=g; "), objectArray2);
            throw runtimeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping
    public void g(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @Parameter(hidden=true) Principal principal) {
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string2;
        PluginsRestController version = pluginsRestController;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)object);
        b.info(InterceptorTimer.g((Object)"\u001b&=\u0000`\u000f%,583)`)/}53)33)!1,}015:)3`&=r; n}"), objectArray);
        version.g.uninstallPlugin((PluginKey)new SimplePluginKey((String)name, (String)object));
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"context"})
    public void g(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string3;
        PluginsRestController context = pluginsRestController;
        if (!context.G || !context.J.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, k);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        objectArray[3] = StringUtils.sanitize((String)object);
        b.info(InterceptorTimer.g((Object)"\u0006; \u001d}\u001281(%.4}42`(./%:).482}015:)3`&=r; `;//`>/3488)`&=s"), objectArray);
        context.g.unregisterPluginForContext((PluginKey)new SimplePluginKey((String)name, (String)version), (String)object);
    }

    @GetMapping
    public Iterable<PluginInfo> g(@Parameter(hidden=true) Principal principal) {
        PluginsRestController pluginsRestController = object;
        Object object = principal;
        PluginsRestController a2 = pluginsRestController;
        b.info(StorageResolver.g((Object)"\u001a\u007f<YaV$u4a2pap.$-m2pag4v3a/pat-q&m/wo$"), (Object)AuditLog.username((Principal)object));
        return a2.g.listPlugins();
    }
}

