/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.AxonServerAccessController;
import io.axoniq.axonserver.KeepNames;
import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.TransformationConfiguration;
import io.axoniq.axonserver.rest.RestRequestAccessDecisionVoter;
import io.axoniq.axonserver.rest.WebSecurityConfigurer;
import io.axoniq.axonserver.transport.rest.v2.URIUtils;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@KeepNames
public class WebSecurityConfigurer {
    private final AxonServerAccessController accessController;
    private final AccessControlConfiguration accessControlConfiguration;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public HttpSecurity configureHttpSecurity(HttpSecurity httpSecurity) throws Exception {
        WebSecurityConfigurer webSecurityConfigurer;
        WebSecurityConfigurer a3 = httpSecurity;
        WebSecurityConfigurer a4 = this;
        a3.csrf(AbstractHttpConfigurer::disable);
        if (a4.accessControlConfiguration.isSameOrigin()) {
            a3.headers(a2 -> a2.frameOptions(HeadersConfigurer.FrameOptionsConfig::sameOrigin));
            webSecurityConfigurer = a4;
        } else {
            a3.headers(a2 -> a2.frameOptions(HeadersConfigurer.FrameOptionsConfig::disable));
            webSecurityConfigurer = a4;
        }
        if (webSecurityConfigurer.accessControlConfiguration.isEnabled()) {
            logger.debug(URIUtils.g((Object)"y+[-K;\u0018+W&L:W$\u0018!Kh}\u0006y\nt\r|f\u0018\u001b]<L!V/\u0018=Hh^!T<]:KhY&\\hU)L+P-J;\u0016"));
            TokenAuthenticationFilter tokenAuthenticationFilter = new TokenAuthenticationFilter(a4.accessController);
            WebSecurityConfigurer webSecurityConfigurer2 = a3;
            webSecurityConfigurer2.addFilterBefore((Filter)tokenAuthenticationFilter, BasicAuthenticationFilter.class);
            webSecurityConfigurer2.exceptionHandling(exceptionHandlingConfigurer -> {
                WebSecurityConfigurer a2 = exceptionHandlingConfigurer;
                WebSecurityConfigurer a3 = this;
                a2.accessDeniedHandler((httpServletRequest, httpServletResponse, accessDeniedException) -> {
                    void a2;
                    WebSecurityConfigurer a3 = httpServletRequest;
                    WebSecurityConfigurer a4 = this;
                    if (TransformationConfiguration.g((Object)"\u0018L\u0014]CL\u001aL\u0002]AZ\u0018[\tH\u0001").equals(a3.getHeader(URIUtils.g((Object)"\t[+]8L")))) {
                        void v0 = a2;
                        v0.setHeader(TransformationConfiguration.g((Object)"j\u0003G\u0018L\u0002]A}\u0015Y\t"), URIUtils.g((Object)"L-@<\u0017-N-V<\u0015;L:])U"));
                        a3 = v0.getOutputStream();
                        a3.println(TransformationConfiguration.g((Object)"\t_\tG\u0018\u0013\t[\u001eF\u001e"));
                        a3.println("data:" + HttpStatus.FORBIDDEN.getReasonPhrase());
                        WebSecurityConfigurer webSecurityConfigurer = a3;
                        webSecurityConfigurer.println();
                        webSecurityConfigurer.close();
                        return;
                    }
                    a2.sendError(HttpStatus.FORBIDDEN.value(), HttpStatus.FORBIDDEN.getReasonPhrase());
                });
                a2.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(TransformationConfiguration.g((Object)"\u0006\u0000F\u000b@\u0002")), (RequestMatcher)new AntPathRequestMatcher(URIUtils.g((Object)"b\u0016 L%T")));
            });
            a3.authorizeHttpRequests(authorizationManagerRequestMatcherRegistry -> {
                WebSecurityConfigurer a2 = authorizationManagerRequestMatcherRegistry;
                WebSecurityConfigurer a3 = this;
                DispatcherType[] dispatcherTypeArray = new DispatcherType[2];
                dispatcherTypeArray[0] = DispatcherType.ASYNC;
                dispatcherTypeArray[1] = DispatcherType.FORWARD;
                String[] stringArray = new String[10];
                stringArray[0] = TransformationConfiguration.g((Object)"C");
                stringArray[1] = URIUtils.g((Object)"gU-K;Y/];\u0017b\u0012");
                stringArray[2] = TransformationConfiguration.g((Object)"\u0006\rJ\u000fL\u001fZC\u0003F");
                stringArray[3] = URIUtils.g((Object)"g]>]&L;L'J-\u0017b\u0012");
                stringArray[4] = TransformationConfiguration.g((Object)"C\\\u0018@\u0000@\u0018@\tZC\u0003F");
                stringArray[5] = URIUtils.g((Object)"g\\)K Z'Y:\\;\u0017b\u0012");
                stringArray[6] = TransformationConfiguration.g((Object)"\u0003BA\u0018D\u0000");
                stringArray[7] = URIUtils.g((Object)"gNy\u0017b\u0012");
                stringArray[8] = TransformationConfiguration.g((Object)"\u0006\u001a\u001bC\u0003F");
                stringArray[9] = URIUtils.g((Object)"gQ&L-J&Y$\u0017b\u0012");
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)a2.dispatcherTypeMatchers(dispatcherTypeArray)).permitAll().requestMatchers(stringArray)).access((AuthorizationManager)new RestRequestAccessDecisionVoter(a3.accessController)).anyRequest()).permitAll();
            }).formLogin(a2 -> a2.loginPage(URIUtils.g((Object)"gT'_!V")).permitAll()).logout(LogoutConfigurer::permitAll).httpBasic(Customizer.withDefaults());
            return a3;
        }
        a3.authorizeHttpRequests(a2 -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)a2.anyRequest()).permitAll());
        return a3;
    }

    public SecurityFilterChain securityFilterChain(HttpSecurity httpSecurity) throws Exception {
        WebSecurityConfigurer a2 = httpSecurity;
        WebSecurityConfigurer a3 = this;
        logger.debug(TransformationConfiguration.g((Object)"/F\u0002O\u0005N\u0019[\u0005G\u000b\t;L\u000e\t?L\u000f\\\u001e@\u0018PB"));
        return (SecurityFilterChain)a3.configureHttpSecurity((HttpSecurity)a2).build();
    }

    /*
     * WARNING - void declaration
     */
    public WebSecurityConfigurer(MessagingPlatformConfiguration messagingPlatformConfiguration, AxonServerAccessController axonServerAccessController) {
        void a2;
        WebSecurityConfigurer a3;
        WebSecurityConfigurer a4 = axonServerAccessController;
        WebSecurityConfigurer webSecurityConfigurer = a3 = this;
        webSecurityConfigurer.accessControlConfiguration = a2.getAccesscontrol();
        webSecurityConfigurer.accessController = a4;
    }
}

