/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.ui;

import io.axoniq.axonserver.api.Authentication;
import io.axoniq.axonserver.applicationevents.ContextEvents;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.axoniq.axonserver.ui.ClusterUpdatesService;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;

@Service
public class ClusterUpdatesService {
    private final Sinks.Many<SimpleUpdate> g;
    private static final Logger k = AuditLog.getLogger();
    private final Logger A = LoggerFactory.getLogger(ClusterUpdatesService.class);

    @EventListener
    public void on(ContextEvents.ContextUnregisteredInAdmin contextUnregisteredInAdmin) {
        ClusterUpdatesService a2 = contextUnregisteredInAdmin;
        ClusterUpdatesService a3 = this;
        a3.g(UpdateType.M, a2.context(), SimpleUpdateState.G);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeConnected axonServerNodeConnected) {
        ClusterUpdatesService a2 = axonServerNodeConnected;
        ClusterUpdatesService a3 = this;
        a3.g(UpdateType.A, a2.getNodeInfo().getHostName(), SimpleUpdateState.J);
    }

    @EventListener
    public void on(ClusterEvents.BecomeLeader becomeLeader) {
        ClusterUpdatesService a2 = becomeLeader;
        ClusterUpdatesService a3 = this;
        a3.g(UpdateType.g, a2.replicationGroup(), SimpleUpdateState.A);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupCreated replicationGroupCreated) {
        ClusterUpdatesService a2 = replicationGroupCreated;
        ClusterUpdatesService a3 = this;
        a3.g(UpdateType.J, a2.replicationGroup(), SimpleUpdateState.g);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationConnected applicationConnected) {
        ClusterUpdatesService a2 = applicationConnected;
        ClusterUpdatesService a3 = this;
        a3.g(UpdateType.G, a2.M(), SimpleUpdateState.J);
    }

    @EventListener
    public void on(ContextEvents.ContextUpdatedInAdmin contextUpdatedInAdmin) {
        ClusterUpdatesService a2 = contextUpdatedInAdmin;
        ClusterUpdatesService a3 = this;
        a3.g(UpdateType.M, a2.g(), SimpleUpdateState.A);
    }

    public ClusterUpdatesService() {
        ClusterUpdatesService a2;
        a2.g = Sinks.many().multicast().onBackpressureBuffer();
    }

    public Flux<SimpleUpdate> subscribeToUpdates(@Nonnull Authentication authentication) {
        ClusterUpdatesService clusterUpdatesService = clusterUpdatesService2;
        ClusterUpdatesService clusterUpdatesService2 = authentication;
        ClusterUpdatesService a2 = clusterUpdatesService;
        return a2.g.asFlux().publish().autoConnect().doFirst(() -> ClusterUpdatesService.g((Authentication)clusterUpdatesService2));
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceConnected axonServerInstanceConnected) {
        ClusterUpdatesService a2 = axonServerInstanceConnected;
        ClusterUpdatesService a3 = this;
        a3.g(UpdateType.b, a2.getNodeName(), SimpleUpdateState.J);
    }

    @EventListener
    public void on(ClusterEvents.LeaderStepDown leaderStepDown) {
        ClusterUpdatesService a2 = leaderStepDown;
        ClusterUpdatesService a3 = this;
        a3.g(UpdateType.g, a2.replicationGroup(), SimpleUpdateState.A);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeDeleted axonServerNodeDeleted) {
        ClusterUpdatesService a2 = axonServerNodeDeleted;
        ClusterUpdatesService a3 = this;
        a3.g(UpdateType.A, a2.node(), SimpleUpdateState.G);
    }

    @EventListener
    public void on(ClusterEvents.AxonServerInstanceDisconnected axonServerInstanceDisconnected) {
        ClusterUpdatesService a2 = axonServerInstanceDisconnected;
        ClusterUpdatesService a3 = this;
        a3.g(UpdateType.b, a2.getNodeName(), SimpleUpdateState.b);
    }

    private static /* synthetic */ void g(Authentication a2) {
        k.info(TransientException.g((Object)"\u0017L1jld9U?T>^.R(\u00178XlT#Y8R4ClB<S-C)Db"), (Object)AuditLog.username((String)a2.username()));
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupDeleted replicationGroupDeleted) {
        ClusterUpdatesService a2 = replicationGroupDeleted;
        ClusterUpdatesService a3 = this;
        a3.g(UpdateType.J, a2.replicationGroup(), SimpleUpdateState.G);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated replicationGroupUpdated) {
        ClusterUpdatesService a2 = replicationGroupUpdated;
        ClusterUpdatesService a3 = this;
        a3.g(UpdateType.J, a2.replicationGroup(), SimpleUpdateState.A);
    }

    @EventListener
    public void on(ContextEvents.ContextRegisteredInAdmin contextRegisteredInAdmin) {
        ClusterUpdatesService a2 = contextRegisteredInAdmin;
        ClusterUpdatesService a3 = this;
        a3.g(UpdateType.M, a2.context(), SimpleUpdateState.g);
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation leaderConfirmation) {
        ClusterUpdatesService a2 = leaderConfirmation;
        ClusterUpdatesService a3 = this;
        a3.g(UpdateType.g, a2.replicationGroup(), SimpleUpdateState.A);
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        ClusterUpdatesService a2 = applicationDisconnected;
        ClusterUpdatesService a3 = this;
        a3.g(UpdateType.G, a2.C(), SimpleUpdateState.b);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void g(UpdateType updateType, String string, SimpleUpdateState simpleUpdateState) {
        void a2;
        void a3;
        ClusterUpdatesService a4 = simpleUpdateState;
        ClusterUpdatesService a5 = this;
        a5.g.emitNext((Object)new SimpleUpdate((UpdateType)a3, (String)a2 + ":" + a4.name()), (signalType, emitResult) -> {
            SignalType a2 = emitResult;
            SignalType a3 = signalType;
            if (a2 == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
                return true;
            }
            return false;
        });
    }
}

