create table adm_conf_change_entries (
                                         id bigint generated by default as identity,
                                         index bigint,
                                         data blob,
                                         description varchar(2000),
                                         entry_type varchar(255),
                                         replication_group varchar(255),
                                         primary key (id)
);
create table adm_conf_changes (
                                  retries integer not null,
                                  created bigint not null,
                                  index bigint not null,
                                  next_run_at bigint not null,
                                  added_node varbinary(8000),
                                  last_error varchar(255),
                                  removed_node varbinary(8000),
                                  replication_group varchar(255) not null,
                                  primary key (replication_group, index)
);

alter table if exists adm_conf_change_entries
    add constraint fk_adm_conf_changes
        foreign key (replication_group, index)
            references adm_conf_changes;