/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.config;

import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.EventTransformationConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.config.SystemInfoProvider;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.DataFetcherSchedulerProvider;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.command.CommandTypeIdentifier;
import io.axoniq.axonserver.replication.ServerProperties;
import io.axoniq.axonserver.util.StringUtils;
import jakarta.annotation.PostConstruct;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

@Configuration
@ConfigurationProperties(prefix="axoniq.axonserver")
public class MessagingPlatformConfiguration
implements ServerProperties {
    private int executorThreadCount;
    private int eventStoreProcessorsThreadCount;
    private Duration keepAliveTimeout;
    @NestedConfigurationProperty
    private EventTransformationConfiguration eventTransformation;
    private String pluginCacheDirectory;
    private Duration keepAliveTime;
    private static final int RESERVED = 10000;
    private static final Logger logger = LoggerFactory.getLogger(MessagingPlatformConfiguration.class);
    private String name;
    private int internalPort;
    private int maxMessageSize;
    private final Map<String, Boolean> preview;
    private int metricsSynchronizationRate;
    private String webSocketAllowedOrigins;
    private int port;
    @NestedConfigurationProperty
    private AccessControlConfiguration accesscontrol;
    private int httpPort;
    private boolean pluginsEnabled;
    private String pluginCleanPolicy;
    private boolean forceConnectionToPrimaryOrMessagingNode;
    private Duration minKeepAliveTime;
    private String controldbBackupLocation;
    private String internalDomain;
    private static final int DEFAULT_MAX_TRANSACTION_SIZE = 4184304;
    private String internalHostname;
    private String hostname;
    private String pidFileLocation;
    private static final Logger auditLog = AuditLog.getLogger();
    private String domain;
    private int clusterExecutorThreadCount;
    private int eventStoreBackgroundThreadCount;
    private int grpcBufferedMessages;
    @Value(value="${spring.datasource.url:#{null}}")
    private String datasourceUrl;
    private final SystemInfoProvider systemInfoProvider;
    public static final int DEFAULT_INTERNAL_GRPC_PORT = 8224;
    private Duration metricsInterval;
    private String pluginPackageDirectory;
    private boolean setWebSocketAllowedOrigins;
    @NestedConfigurationProperty
    private SslConfiguration ssl;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(String string, String string2, boolean bl, BiConsumer<String, String> biConsumer) {
        void a2;
        boolean a3 = bl;
        MessagingPlatformConfiguration a4 = this;
        String string3 = a3 = a3 ? DataFetcherSchedulerProvider.d((Object)"fN{E}NnL/") : "";
        if (StringUtils.isEmpty((String)a2)) {
            logger.error(CommandTypeIdentifier.d((Object)"+C\u001d@\f\f\u0006C\u001c\f\fI\u001cI\u001aA\u0001B\r\f\t\f\u001eM\u0004E\f\f\u0013Q\u0000C\u001bX\u0006M\u0005IF"), (Object)a3);
            throw new MessagingPlatformException(ErrorCode.VALIDATION_FAILED, "No " + a3 + "hostname set and system could not provide one.");
        }
        if (Character.isDigit(a2.charAt(0))) {
            logger.warn(DataFetcherSchedulerProvider.d((Object)"tgE/[rH`S{NnMj\u0000gA|\u0000mEjN/SjT/A|\u0000nN/i_\u0000nDkRjS|\u000e/tgI|\u0000bAv\u0000\u007fR`DzCj\u0000zNxAaTjD/RjSzL{S!"), (Object)a3);
            return;
        }
        int n = a2.indexOf(46);
        if (n != -1) {
            void a5;
            void a6;
            void v1 = a2;
            String string4 = v1.substring(0, n);
            String string5 = v1.substring(n + 1);
            if (StringUtils.isEmpty((String)a6)) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a3;
                objectArray[1] = string4;
                objectArray[2] = string5;
                logger.info(CommandTypeIdentifier.d((Object)"+C\u0006J\u0001K\u001d^\u0001B\u000f\f\fC\u0005M\u0001BHJ\u001aC\u0005\f\u0013Q\u0000C\u001bX\u0006M\u0005IH\\\u001aC\u0018I\u001aX\u0011\u0016HD\u0007_\u001cB\tA\r\u0011\u0013QD\f\fC\u0005M\u0001BUW\u0015"), objectArray);
                a5.accept(string4, string5);
                return;
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = a3;
            objectArray[1] = a2;
            objectArray[2] = string4;
            objectArray[3] = a6;
            logger.warn(DataFetcherSchedulerProvider.d((Object)"FGaO}IaG/D`MnIa\u0000\u007fA}T/Oi\u0000{Hj\u0000t]gO|TaAbE/\u0007t](\u001a/H`S{NnMj\u001dt]#\u0000kObAfN2[r"), objectArray);
            a5.accept(string4, a6);
        }
    }

    public void setKeepAliveTime(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.keepAliveTime = a2;
    }

    public void setSetWebSocketAllowedOrigins(boolean bl) {
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        a3.setWebSocketAllowedOrigins = a2;
    }

    public long getKeepAliveTimeout() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTimeout.toMillis();
    }

    public int getGrpcBufferedMessages() {
        MessagingPlatformConfiguration a2;
        return a2.grpcBufferedMessages;
    }

    public void setMinKeepAliveTime(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.minKeepAliveTime = a2;
    }

    public int getHttpPort() {
        MessagingPlatformConfiguration a2;
        if (a2.httpPort == 0) {
            a2.httpPort = a2.systemInfoProvider.getPort();
        }
        return a2.httpPort;
    }

    public int getEventStoreBackgroundThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreBackgroundThreadCount;
    }

    public void setAccesscontrol(AccessControlConfiguration accessControlConfiguration) {
        MessagingPlatformConfiguration a2;
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    a2 = accessControlConfiguration;
                    a3 = this;
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.accesscontrol == null) break block1;
                    auditLog.info(CommandTypeIdentifier.d((Object)")O\u000bI\u001b_HO\u0007B\u001c^\u0007@HO\u0007B\u000eE\u000fY\u001aM\u001cE\u0007BH~-a'z-hF"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.accesscontrol == null || a2.isEnabled() != a3.accesscontrol.isEnabled()) {
                    auditLog.info(DataFetcherSchedulerProvider.d((Object)"NClE|S/C`N{R`L/I|\u0000aOx\u0000t]!"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.accesscontrol = a2;
    }

    public void setForceConnectionToPrimaryOrMessagingNode(boolean bl) {
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        a3.forceConnectionToPrimaryOrMessagingNode = a2;
    }

    public void setClusterExecutorThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.clusterExecutorThreadCount = a2;
    }

    public void setDomain(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.domain = a2;
    }

    private /* synthetic */ void c() {
        if (auditLog.isInfoEnabled()) {
            MessagingPlatformConfiguration a2;
            a2.preview.forEach((string, bl) -> {
                Boolean a2 = bl;
                String a3 = string;
                if (Boolean.TRUE.equals(a2)) {
                    auditLog.info(CommandTypeIdentifier.d((Object)"|\u001aI\u001eE\r[HC\u000e\f\u000eI\tX\u001d^\r\f\u0013QHI\u0006M\n@\rHF"), (Object)a3);
                }
            });
            auditLog.info(CommandTypeIdentifier.d((Object)"o\u0007B\u000eE\u000fY\u001aM\u001cE\u0007BHE\u0006E\u001cE\t@\u0001V\rHH[\u0001X\u0000\f;\u007f$\f\u0013QHM\u0006HHM\u000bO\r_\u001b\f\u000bC\u0006X\u001aC\u0004\f\u0013QF"), (Object)AuditLog.enablement((boolean)a2.ssl.isEnabled()), (Object)AuditLog.enablement((boolean)a2.accesscontrol.isEnabled()));
        }
    }

    public String getFullyQualifiedHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        Object a2 = messagingPlatformConfiguration.getDomain();
        if (!StringUtils.isEmpty((String)a2)) {
            return messagingPlatformConfiguration.getHostname() + "." + (String)a2;
        }
        return messagingPlatformConfiguration.getHostname();
    }

    public Duration getMetricsInterval() {
        MessagingPlatformConfiguration a2;
        return a2.metricsInterval;
    }

    public void setInternalDomain(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.internalDomain = a2;
    }

    public void setPluginPackageDirectory(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginPackageDirectory = a2;
    }

    public void setHostname(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.hostname = a2;
    }

    public String getPluginCleanPolicy() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCleanPolicy;
    }

    public void setGrpcBufferedMessages(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.grpcBufferedMessages = a2;
    }

    public long getKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.keepAliveTime.toMillis();
    }

    public void setInternalPort(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.internalPort = a2;
    }

    public boolean isForceConnectionToPrimaryOrMessagingNode() {
        MessagingPlatformConfiguration a2;
        return a2.forceConnectionToPrimaryOrMessagingNode;
    }

    public String getInternalDomain() {
        MessagingPlatformConfiguration a2;
        if (a2.internalDomain == null) {
            a2.internalDomain = a2.getDomain();
        }
        return a2.internalDomain;
    }

    public void setSsl(SslConfiguration sslConfiguration) {
        MessagingPlatformConfiguration a2;
        block3: {
            MessagingPlatformConfiguration messagingPlatformConfiguration;
            MessagingPlatformConfiguration a3;
            block1: {
                block2: {
                    a2 = sslConfiguration;
                    a3 = this;
                    if (!auditLog.isInfoEnabled()) break block1;
                    if (a2 != null) break block2;
                    if (a3.ssl == null) break block1;
                    auditLog.info(CommandTypeIdentifier.d((Object)"\u007f;`HO\u0007B\u000eE\u000fY\u001aM\u001cE\u0007BH~-a'z-hF"));
                    messagingPlatformConfiguration = a3;
                    break block3;
                }
                if (a3.ssl == null || a2.isEnabled() != a3.ssl.isEnabled()) {
                    auditLog.info(DataFetcherSchedulerProvider.d((Object)"s\\l/I|\u0000aOx\u0000t]!"), (Object)AuditLog.enablement((boolean)a2.isEnabled()));
                }
            }
            messagingPlatformConfiguration = a3;
        }
        messagingPlatformConfiguration.ssl = a2;
    }

    public String getPluginPackageDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginPackageDirectory;
    }

    public boolean isPluginsEnabled() {
        MessagingPlatformConfiguration a2;
        return a2.pluginsEnabled;
    }

    public int getPort() {
        MessagingPlatformConfiguration a2;
        return a2.port;
    }

    public long getMinKeepAliveTime() {
        MessagingPlatformConfiguration a2;
        return a2.minKeepAliveTime.toMillis();
    }

    public void setInternalHostname(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.internalHostname = a2;
    }

    public boolean isExperimentalFeatureEnabled(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        return a3.preview.getOrDefault(a2, false);
    }

    public void setEventTransformation(EventTransformationConfiguration eventTransformationConfiguration) {
        MessagingPlatformConfiguration a2 = eventTransformationConfiguration;
        MessagingPlatformConfiguration a3 = this;
        a3.eventTransformation = a2;
    }

    public int getEventStoreProcessorsThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.eventStoreProcessorsThreadCount;
    }

    public boolean isSetWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.setWebSocketAllowedOrigins;
    }

    public EventTransformationConfiguration getEventTransformation() {
        MessagingPlatformConfiguration a2;
        return a2.eventTransformation;
    }

    public void setPluginCacheDirectory(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginCacheDirectory = a2;
    }

    private /* synthetic */ void M() {
        MessagingPlatformConfiguration a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a2;
        messagingPlatformConfiguration.d(a2.getHostname(), messagingPlatformConfiguration.getDomain(), false, (string, string2) -> {
            void a2;
            MessagingPlatformConfiguration a3;
            Object a4 = string2;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a3 = this;
            messagingPlatformConfiguration.setHostname((String)a2);
            messagingPlatformConfiguration.setDomain((String)a4);
        });
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a2;
        messagingPlatformConfiguration2.d(a2.getInternalHostname(), messagingPlatformConfiguration2.getInternalDomain(), true, (string, string2) -> {
            void a2;
            MessagingPlatformConfiguration a3;
            Object a4 = string2;
            MessagingPlatformConfiguration messagingPlatformConfiguration = a3 = this;
            messagingPlatformConfiguration.setInternalHostname((String)a2);
            messagingPlatformConfiguration.setInternalDomain((String)a4);
        });
    }

    public String getInternalHostname() {
        MessagingPlatformConfiguration a2;
        if (StringUtils.isEmpty((String)a2.internalHostname)) {
            a2.internalHostname = a2.getHostname();
        }
        return a2.internalHostname;
    }

    public void setExecutorThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.executorThreadCount = a2;
    }

    public int getExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.executorThreadCount;
    }

    public AccessControlConfiguration getAccesscontrol() {
        MessagingPlatformConfiguration a2;
        return a2.accesscontrol;
    }

    private /* synthetic */ void d() {
        MessagingPlatformConfiguration a2;
        if (a2.datasourceUrl != null && !a2.datasourceUrl.contains(DataFetcherSchedulerProvider.d((Object)"5MjM5")) && !a2.datasourceUrl.contains(CommandTypeIdentifier.d((Object)"\tT\u0007B\u001bI\u001aZ\r^EO\u0007B\u000eE\u000fH\n"))) {
            throw new FailedToStartException(DataFetcherSchedulerProvider.d((Object)"[Hj\u0000kA{AmA|E/NnMj\u0000iO}\u0000NX`N/sjRyE}\u0000bU|T/Bj\u0000(AwOaSjRyE}\rlOaFfGkB(\u000e/ii\u0000vOz\u0000nRj\u0000bIhRnTfNh\u0000iR`M/Aa\u0000`LkE}\u0000yE}SfOa\u0000jN|U}E/TgA{\u0000{Hj\u0000LOaT}Oc\u0000Kb/I|\u0000fN/\u0007nX`N|E}VjR\"C`N{R`LkB(\u0000nNk\u0000zPkA{E/TgE/S\u007fRfNh\u000ekA{A|OzRlE!U}L/P}O\u007fE}Tv\u0000{O/U|E/DnTnBnSj\u0000aAbE/\u0007nX`N|E}VjR\"C`NiIhDm\u0007!"));
        }
    }

    public int getMaxMessageSize() {
        MessagingPlatformConfiguration a2;
        return a2.maxMessageSize;
    }

    public int getClusterExecutorThreadCount() {
        MessagingPlatformConfiguration a2;
        return a2.clusterExecutorThreadCount;
    }

    public void setPidFileLocation(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pidFileLocation = a2;
    }

    public Map<String, Boolean> getPreview() {
        MessagingPlatformConfiguration a2;
        return a2.preview;
    }

    public MessagingPlatformConfiguration(SystemInfoProvider systemInfoProvider) {
        MessagingPlatformConfiguration a2;
        MessagingPlatformConfiguration a3 = systemInfoProvider;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a2 = this;
        MessagingPlatformConfiguration messagingPlatformConfiguration2 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration3 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration4 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration5 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration6 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration7 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration8 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration9 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration10 = a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration11 = a2;
        a2.port = 8124;
        messagingPlatformConfiguration11.internalPort = 8224;
        messagingPlatformConfiguration11.keepAliveTimeout = Duration.ofMillis(5000L);
        messagingPlatformConfiguration10.keepAliveTime = Duration.ofMillis(2500L);
        messagingPlatformConfiguration10.minKeepAliveTime = Duration.ofMillis(1000L);
        messagingPlatformConfiguration9.setWebSocketAllowedOrigins = false;
        messagingPlatformConfiguration9.webSocketAllowedOrigins = "*";
        MessagingPlatformConfiguration messagingPlatformConfiguration12 = a2;
        messagingPlatformConfiguration9.ssl = new SslConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration13 = a2;
        messagingPlatformConfiguration8.accesscontrol = new AccessControlConfiguration();
        MessagingPlatformConfiguration messagingPlatformConfiguration14 = a2;
        messagingPlatformConfiguration8.eventTransformation = new EventTransformationConfiguration();
        messagingPlatformConfiguration8.forceConnectionToPrimaryOrMessagingNode = true;
        messagingPlatformConfiguration7.metricsInterval = Duration.ofMinutes(15L);
        messagingPlatformConfiguration7.controldbBackupLocation = ".";
        messagingPlatformConfiguration6.maxMessageSize = 0x400000;
        messagingPlatformConfiguration6.pidFileLocation = ".";
        messagingPlatformConfiguration5.grpcBufferedMessages = 500;
        messagingPlatformConfiguration5.executorThreadCount = 4;
        messagingPlatformConfiguration4.clusterExecutorThreadCount = 4;
        messagingPlatformConfiguration4.eventStoreBackgroundThreadCount = 8;
        messagingPlatformConfiguration3.eventStoreProcessorsThreadCount = 8;
        messagingPlatformConfiguration3.pluginsEnabled = true;
        messagingPlatformConfiguration2.pluginCacheDirectory = "plugins/cache";
        messagingPlatformConfiguration2.pluginPackageDirectory = "plugins/bundles";
        messagingPlatformConfiguration.pluginCleanPolicy = "onFirstInit";
        MessagingPlatformConfiguration messagingPlatformConfiguration15 = a2;
        messagingPlatformConfiguration.preview = new HashMap();
        messagingPlatformConfiguration.systemInfoProvider = a3;
    }

    public String getPidFileLocation() {
        MessagingPlatformConfiguration a2;
        return a2.pidFileLocation;
    }

    public void setMaxMessageSize(DataSize dataSize) {
        MessagingPlatformConfiguration a2 = dataSize;
        MessagingPlatformConfiguration a3 = this;
        Assert.isTrue((a2.toBytes() >= 0L ? 1 : 0) != 0, (String)CommandTypeIdentifier.d((Object)"%M\u0010\f\u0005I\u001b_\tK\r\f\u001bE\u0012IHA\u001d_\u001c\f\nIHK\u001aI\tX\r^HX\u0000M\u0006\fX"));
        Assert.isTrue((a2.toBytes() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)DataFetcherSchedulerProvider.d((Object)"BAw\u0000bE|SnGj\u0000|IuE/MzS{\u0000mE/LjS|\u0000{HnN/\u0012>\u00148\u00147\u00139\u00148"));
        a3.maxMessageSize = (int)a2.toBytes();
    }

    public int getInternalPort() {
        MessagingPlatformConfiguration a2;
        return a2.internalPort;
    }

    public void setEventStoreProcessorsThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.eventStoreProcessorsThreadCount = a2;
    }

    public void setControldbBackupLocation(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.controldbBackupLocation = a2;
    }

    public String getPluginCacheDirectory() {
        MessagingPlatformConfiguration a2;
        return a2.pluginCacheDirectory;
    }

    public void setKeepAliveTimeout(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.keepAliveTimeout = a2;
    }

    public void setMetricsInterval(Duration duration) {
        Object a2 = duration;
        MessagingPlatformConfiguration a3 = this;
        a3.metricsInterval = a2;
    }

    public String getControldbBackupLocation() {
        MessagingPlatformConfiguration a2;
        return a2.controldbBackupLocation;
    }

    public String getName() {
        MessagingPlatformConfiguration a2;
        if (a2.name == null) {
            a2.name = a2.getHostname();
        }
        return a2.name;
    }

    public void setEventStoreBackgroundThreadCount(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.eventStoreBackgroundThreadCount = a2;
    }

    @PostConstruct
    public void postConstruct() {
        MessagingPlatformConfiguration a2;
        MessagingPlatformConfiguration messagingPlatformConfiguration = a2;
        messagingPlatformConfiguration.c();
        messagingPlatformConfiguration.M();
        messagingPlatformConfiguration.d();
    }

    public String getFullyQualifiedInternalHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        Object a2 = messagingPlatformConfiguration.getInternalDomain();
        if (!StringUtils.isEmpty((String)a2)) {
            return messagingPlatformConfiguration.getInternalHostname() + "." + (String)a2;
        }
        return messagingPlatformConfiguration.getInternalHostname();
    }

    public SslConfiguration getSsl() {
        MessagingPlatformConfiguration a2;
        return a2.ssl;
    }

    public void setMetricsSynchronizationRate(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.metricsSynchronizationRate = a2;
    }

    public void setWebSocketAllowedOrigins(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.webSocketAllowedOrigins = a2;
    }

    public void setPort(int n) {
        int a2 = n;
        MessagingPlatformConfiguration a3 = this;
        a3.port = a2;
    }

    public void setName(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.name = a2;
    }

    public String getWebSocketAllowedOrigins() {
        MessagingPlatformConfiguration a2;
        return a2.webSocketAllowedOrigins;
    }

    public void setPluginsEnabled(boolean bl) {
        boolean a2 = bl;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginsEnabled = a2;
    }

    public void setPluginCleanPolicy(String string) {
        Object a2 = string;
        MessagingPlatformConfiguration a3 = this;
        a3.pluginCleanPolicy = a2;
    }

    public int getMaxTransactionSize() {
        MessagingPlatformConfiguration a2;
        if (a2.maxMessageSize == 0) {
            return 4184304;
        }
        return a2.maxMessageSize - 10000;
    }

    public String getHostname() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        if (StringUtils.isEmpty((String)messagingPlatformConfiguration.hostname)) {
            try {
                MessagingPlatformConfiguration messagingPlatformConfiguration2 = messagingPlatformConfiguration;
                messagingPlatformConfiguration2.hostname = messagingPlatformConfiguration2.systemInfoProvider.getHostName();
                if (!StringUtils.isEmpty((String)messagingPlatformConfiguration2.domain)) {
                    MessagingPlatformConfiguration messagingPlatformConfiguration3 = messagingPlatformConfiguration;
                    if (messagingPlatformConfiguration3.hostname.endsWith("." + messagingPlatformConfiguration3.domain)) {
                        messagingPlatformConfiguration.hostname = messagingPlatformConfiguration.hostname.substring(0, messagingPlatformConfiguration.hostname.length() - messagingPlatformConfiguration.domain.length() - 1);
                    }
                }
            }
            catch (UnknownHostException a2) {
                logger.warn(CommandTypeIdentifier.d((Object)"o\u0007Y\u0004HHB\u0007XHH\rX\r^\u0005E\u0006IHD\u0007_\u001cB\tA\r\f\u000e^\u0007AHE\u0006I\u001c\f\tH\f^\r_\u001b\u0016HW\u0015"), (Object)a2.getMessage());
            }
        }
        return messagingPlatformConfiguration.hostname;
    }

    public String getDomain() {
        MessagingPlatformConfiguration messagingPlatformConfiguration = this;
        if (messagingPlatformConfiguration.domain == null) {
            block4: {
                String a2 = messagingPlatformConfiguration.systemInfoProvider.getHostName();
                int n = a2.indexOf(46);
                if (n == -1) break block4;
                messagingPlatformConfiguration.domain = a2.substring(n + 1);
            }
            try {
                messagingPlatformConfiguration.domain = "";
            }
            catch (UnknownHostException a2) {
                logger.warn(DataFetcherSchedulerProvider.d((Object)"c`UcD/N`T/DjTjRbIaE/H`S{NnMj\u0000iR`M/IaE{\u0000nDkRjS|\u001a/[r"), (Object)a2.getMessage());
            }
        }
        return messagingPlatformConfiguration.domain;
    }
}

