/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.tags.ClientTagsCache;
import io.axoniq.axonserver.enterprise.cluster.NodeSelector;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.ReadyForConnections;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.message.query.QueryDispatcher;
import io.axoniq.axonserver.transport.rest.v2.ApplicationRestControllerV2;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AutoRebalancing {
    private final boolean I;
    private final NavigableSet<PlatformService.ClientComponent> E;
    private final PlatformService M;
    private final Logger F;
    private final NodeSelector K;
    private final ClientTagsCache a;

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        AutoRebalancing a2;
        AutoRebalancing a3 = applicationDisconnected;
        AutoRebalancing autoRebalancing = a2 = this;
        autoRebalancing.F.debug(ApplicationRestControllerV2.d((Object)"(?\u0019#\u0000,\b;\u0000 \u0007o-&\u001a,\u0006!\u0007*\n;\f+So\u00122"), (Object)a3.c());
        a3 = new PlatformService.ClientComponent(a3.c(), a3.e(), a3.M(), a3.m());
        autoRebalancing.E.remove(a3);
        a2.F.debug(QueryDispatcher.d((Object)"t\u001eJ\u0002F\u001aJ\u0005WL\u0003\r^"), (Object)a2.E);
    }

    private /* synthetic */ Map<String, String> d(String string, String string2) {
        Object a2 = string2;
        AutoRebalancing a3 = this;
        return a3.a.apply((String)a2);
    }

    private /* synthetic */ void d(PlatformService.ClientComponent clientComponent) {
        AutoRebalancing a2;
        AutoRebalancing a3 = clientComponent;
        AutoRebalancing autoRebalancing = a2 = this;
        autoRebalancing.F.info(QueryDispatcher.d((Object)"q\u0013R\u0003F\u0005W\u001fM\u0011\u0003\u0004F\u0015L\u0018M\u0013@\u0002\u0003\u0010L\u0004\u0003\r^"), (Object)a3.getClientStreamId());
        autoRebalancing.M.requestReconnect((PlatformService.ClientComponent)a3, ApplicationRestControllerV2.d((Object)"=\f,\u0006!\u0007*\n;I=\f>\u001c*\u001a;\f+I-\u0010o\b:\u001d I-\b#\b!\n&\u0007("));
    }

    /*
     * WARNING - void declaration
     */
    public AutoRebalancing(PlatformService platformService, ClientTagsCache clientTagsCache, NodeSelector nodeSelector, @Value(value="${axoniq.axonserver.cluster.auto-balancing:true}") boolean bl) {
        void nodeSelector2;
        void clientsTags;
        void platformService2;
        AutoRebalancing a2;
        boolean bl2 = bl;
        AutoRebalancing autoRebalancing = a2 = this;
        AutoRebalancing autoRebalancing2 = a2;
        a2.F = LoggerFactory.getLogger(AutoRebalancing.class);
        AutoRebalancing autoRebalancing3 = a2;
        a2.E = new ConcurrentSkipListSet();
        autoRebalancing2.M = platformService2;
        autoRebalancing2.a = clientsTags;
        autoRebalancing.K = nodeSelector2;
        autoRebalancing.I = this;
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeHealthChanged axonServerNodeHealthChanged) {
        AutoRebalancing a2;
        AutoRebalancing a3 = axonServerNodeHealthChanged;
        AutoRebalancing autoRebalancing = a2 = this;
        autoRebalancing.F.debug(QueryDispatcher.d((Object)"$F\u0015F\u001fU\u0013GVK\u0013B\u001aW\u001e\u0003\u0015K\u0017M\u0011F\u0012\u0003\u0010L\u0004\u0003\r^"), (Object)a3.getNode());
        autoRebalancing.E.clear();
        autoRebalancing.E.addAll(a2.M.getConnectedClients());
    }

    @Scheduled(fixedRateString="${axoniq.axonserver.cluster.balancing-rate:15000}")
    protected void d() {
        boolean bl;
        AutoRebalancing autoRebalancing = this;
        if (!autoRebalancing.I) {
            return;
        }
        autoRebalancing.F.debug(ApplicationRestControllerV2.d((Object)"\u001d\f-\b#\b!\n*So\u00122"), (Object)autoRebalancing.E);
        do {
            boolean bl2;
            AutoRebalancing a2;
            if ((a2 = (PlatformService.ClientComponent)autoRebalancing.E.pollFirst()) != null && autoRebalancing.K.canRebalance(a2.getClientId(), a2.getComponent(), a2.getContext(), autoRebalancing.d(a2.getContext(), a2.getClientStreamId()))) {
                autoRebalancing.d((PlatformService.ClientComponent)a2);
                bl = bl2 = false;
                continue;
            }
            bl = bl2 = a2 != null;
        } while (bl);
    }

    @EventListener
    public void on(ReadyForConnections readyForConnections) {
        AutoRebalancing a2 = readyForConnections;
        AutoRebalancing a3 = this;
        if (a2.ready()) {
            AutoRebalancing autoRebalancing = a3;
            autoRebalancing.E.clear();
            autoRebalancing.E.addAll(a3.M.getConnectedClients());
        }
    }
}

