/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.NodeAddress;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.localstorage.StorageResolver;
import io.axoniq.axonserver.transport.rest.EventStoreTransformationRestController;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ClusterController
implements SmartLifecycle {
    private final MessagingPlatformConfiguration l;
    private volatile boolean k;
    private final RemoteConnections J;
    private final ClusterTagsCache A;
    private final CurrentNodeProvider I;
    private final Logger E;
    private final AdminNodes M;
    private final Limits F;
    private final AdminConfigurationFactory K;
    private final ApplicationEventPublisher a;

    private /* synthetic */ ClusterNode d(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.E.info(EventStoreTransformationRestController.d((Object)"=g\u0018#\u0012l\u0018f\\x\u0001"), (Object)a3);
        a3 = clusterController.K.clusterNode((NodeInfo)a3);
        return clusterController.M.save((ClusterNode)a3);
    }

    private /* synthetic */ ClusterNode d(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if ((a2 = a3.J.get((String)a2)) == null) {
            return null;
        }
        return a2.getClusterNode();
    }

    @Transactional
    public synchronized void deleteNode(String string) {
        ClusterController clusterController;
        ClusterController a2;
        Object a3 = string;
        ClusterController clusterController2 = a2 = this;
        clusterController2.E.info(StorageResolver.d((Object)"dBLBTB\u0000IOCE\u001d\u0000\\]"), a3);
        clusterController2.a.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested((String)a3));
        if (clusterController2.l.getName().equals(a3)) {
            ClusterController clusterController3 = a2;
            clusterController = clusterController3;
            clusterController3.M.deleteAllByNameNot((String)a3);
            clusterController3.J.closeAll();
        } else {
            a2.M.findById((String)a3).ifPresent(arg_0 -> a2.d((String)a3, arg_0));
            clusterController = a2;
        }
        clusterController.a.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted((String)a3));
        a2.J.sync();
    }

    private /* synthetic */ void d() {
        Object a2;
        ClusterController clusterController;
        ClusterController clusterController2 = clusterController = this;
        Object object = clusterController2.M.findById(clusterController2.l.getName());
        if (((Optional)object).isEmpty()) {
            if (clusterController.M.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = clusterController.l.getName();
                a2 = String.format(EventStoreTransformationRestController.d((Object)"@\tq\u000ef\u0012w\\m\u0013g\u0019#\u0012b\u0011f\\k\u001dp\\`\u0014b\u0012d\u0019gP#\u0012f\u000b#\u0012b\u0011f\\&\u000f-\\P\bb\u000ew\\B\u0004l\u0012P\u0019q\nf\u000e#\u000bj\bk\\q\u0019`\u0013u\u0019q\u0005#\u001aj\u0010fR"), objectArray);
                throw new FailedToStartException((String)a2);
            }
            ClusterController clusterController3 = clusterController;
            a2 = clusterController3.K.clusterNode(clusterController3.l.getName(), clusterController.l.getFullyQualifiedHostname(), clusterController.l.getFullyQualifiedInternalHostname(), clusterController.l.getPort(), clusterController.l.getInternalPort(), clusterController.l.getHttpPort());
            clusterController3.M.save((ClusterNode)a2);
            return;
        }
        a2 = (ClusterNode)((Optional)object).get();
        if (!a2.getInternalHostName().equals(clusterController.l.getFullyQualifiedInternalHostname()) || !a2.getGrpcInternalPort().equals(clusterController.l.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getInternalHostName();
            objectArray[1] = a2.getGrpcInternalPort();
            objectArray[2] = clusterController.l.getFullyQualifiedInternalHostname();
            objectArray[3] = clusterController.l.getInternalPort();
            object = String.format(StorageResolver.d((Object)"dUURBNS\u0000IOCE\u0000S\u0007IITBRIAK\u0000OOTTIAJE\bPHRS\u0000\u000f\u0005T\u001a\u0002D\u000e\u0000OAT\u0000DHFN@EC\f\u0007\u0000IEP\u0000QAKUBS\u0007\u0005T\u001a\u0002D\t\u0000tTFRS\u0000fXHNtEUVBR\u0007WNTO\u0000UEDOQEUY\u0007FNLB\u000e"), objectArray);
            throw new FailedToStartException((String)object);
        }
    }

    public void closeConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.J.disconnect((String)a2);
    }

    public boolean isActive(String string) {
        String a2 = string;
        ClusterController a3 = this;
        if (a2.equals(a3.l.getName()) || a3.J.get(a2) != null && a3.J.get(a2).isConnected()) {
            return true;
        }
        return false;
    }

    private /* synthetic */ void d(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if (a3.J.contains((String)a2) || a3.l.getName().equals(a2)) {
            return;
        }
        a3.F.getMaxClusterSize().ifPresent(arg_0 -> a3.d((String)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public NodeAddress nodeAddress(String string) {
        ClusterController a2;
        void a3;
        ClusterController clusterController = this;
        if (a3.equals(clusterController.getName())) {
            return new NodeAddress(clusterController.getMe());
        }
        RemoteConnection remoteConnection = clusterController.J.get((String)a3);
        ClusterNode clusterNode = a2 = remoteConnection == null ? (ClusterNode)clusterController.M.findById((String)a3).orElse(null) : remoteConnection.getClusterNode();
        if (a2 == null) {
            return null;
        }
        return new NodeAddress((ClusterNode)a2);
    }

    public synchronized void handleRemoteConnection(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.d((NodeInfo)a3);
        clusterController.J.updateNodeInfo((NodeInfo)a3);
        clusterController.a.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected((NodeInfo)a3));
    }

    public String getName() {
        ClusterController a2;
        return a2.getMe().getName();
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.k;
    }

    public void deleteOtherNodes() {
        ClusterController a2;
        ClusterController clusterController = a2;
        a2.M.deleteAllByNameNot(clusterController.getName());
        clusterController.J.sync();
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.I.isAdmin();
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.J.connections();
    }

    public int getPhase() {
        return 50;
    }

    public void publishEvent(Object object) {
        Object a2 = object;
        ClusterController a3 = this;
        a3.a.publishEvent(a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(String string, Integer n) {
        Integer a2 = n;
        ClusterController a3 = this;
        if (a3.J.size() + 1 >= a2) {
            void a4;
            throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + (String)a4);
        }
    }

    private /* synthetic */ void d(String string, ClusterNode clusterNode) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.M.deleteById((String)a2);
    }

    public ClusterNode getMe() {
        ClusterController a2;
        ClusterController clusterController = a2;
        return clusterController.d((ClusterNode)clusterController.I.get());
    }

    private /* synthetic */ void d(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        if (a2.getNodeName().equals(a3.l.getName())) {
            return;
        }
        a3.J.connect((NodeInfo)a2, true);
    }

    @Transactional
    public void start() {
        ClusterController a2;
        a2.d();
        a2.k = true;
    }

    public ClusterNode getNode(String string) {
        Object a2 = string;
        Object a3 = this;
        if (((String)a2).equals(a3.getName())) {
            return a3.getMe();
        }
        a2 = a3.M.findById((String)a2).orElseGet(() -> ((ClusterController)a3).d((String)a2));
        return a3.d((ClusterNode)a2);
    }

    public Optional<RemoteConnection> getRemoteConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        return Optional.ofNullable(a3.J.get((String)a2));
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.J.activeConnections();
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.J.nodes();
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a2;
        return a2.nodes().filter(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            return a3.isActive(a2.getName());
        });
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a2;
        return a2.M.findAll().peek(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            if (a2 == null) {
                return null;
            }
            a2.setTags(a3.A.getClusterTags().getOrDefault(a2.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    public void stop() {
        a.k = false;
    }

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        ClusterController clusterController = a2;
        a3.d(clusterController.getNodeName());
        if (clusterController.getNodeName().equals(a3.l.getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.E.info(EventStoreTransformationRestController.d((Object)"(q\u0005j\u0012d\\w\u0013#\u0016l\u0015m\\t\u0015w\u0014#\u001fv\u000eq\u0019m\b#\u0012l\u0018f\\m\u001dn\u00199\\x\u0001"), (Object)a2.getNodeName());
            return clusterController2.getMe();
        }
        if (a2.getInternalHostName().equals(a3.l.getInternalHostname()) && a2.getGrpcInternalPort() == a3.l.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, StorageResolver.d((Object)"dAINHT\u0007JHII\u0000DLRSSEU\u0000PISH\u0007SFMB\u0000OOTTIAJE\u0007AID\u0007IITBRIAK\u0000WOUT"));
        }
        ClusterNode clusterNode = a3.M.findById(a2.getNodeName()).orElseGet(() -> a3.d((NodeInfo)a2));
        if (!a3.J.contains(a2.getNodeName())) {
            a3.d((NodeInfo)a2);
        }
        return clusterNode;
    }

    /*
     * WARNING - void declaration
     */
    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, AdminNodes adminNodes, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, RemoteConnections remoteConnections, CurrentNodeProvider currentNodeProvider) {
        void remoteConnections2;
        void limits2;
        void applicationEventPublisher2;
        void clusterTagsCache2;
        void adminConfigurationFactory2;
        void clusterNodeRepository;
        void messagingPlatformConfiguration2;
        ClusterController a2;
        ClusterController clusterController = clusterController2;
        ClusterController clusterController2 = currentNodeProvider;
        ClusterController clusterController3 = a2 = clusterController;
        ClusterController clusterController4 = a2;
        ClusterController clusterController5 = a2;
        ClusterController clusterController6 = a2;
        a2.E = LoggerFactory.getLogger(ClusterController.class);
        clusterController6.l = messagingPlatformConfiguration2;
        clusterController6.M = clusterNodeRepository;
        clusterController5.K = adminConfigurationFactory2;
        clusterController5.A = clusterTagsCache2;
        clusterController4.a = applicationEventPublisher2;
        clusterController4.F = limits2;
        clusterController3.J = remoteConnections2;
        clusterController3.I = clusterController2;
    }
}

