/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.admin.user.requestprocessor.UserController;
import io.axoniq.axonserver.cluster.grpc.LeaderElectionService;
import io.axoniq.axonserver.cluster.grpc.LogReplicationService;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalAuthenticationInterceptor;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AxonServerInternalService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="MessagingClusterServer")
public class MessagingClusterServer
implements SmartLifecycle {
    private final ExecutorService h;
    private Server e;
    private final ApplicationEventPublisher l;
    private static final DataSize k = DataSize.ofMegabytes((long)32L);
    private final List<AxonServerInternalService> J;
    private boolean A;
    private final Logger I;
    private final Supplier<ScheduledExecutorService> E;
    private final LogReplicationService M;
    private AdvancedTlsX509KeyManager.Closeable F;
    private final MessagingPlatformConfiguration K;
    private final LeaderElectionService a;

    public int getPhase() {
        return 50;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        MessagingClusterServer messagingClusterServer = this;
        try {
            NettyServerBuilder nettyServerBuilder;
            MessagingClusterServer a2;
            String string = TransientException.d((Object)"r\r<1O.");
            if (messagingClusterServer.K.getSsl() != null && messagingClusterServer.K.getSsl().isEnabled()) {
                Object object = messagingClusterServer.K.getSsl().getInternalCertChainFile();
                if (object == null) {
                    throw new RuntimeException(UserController.d((Object)"\u0016C\u0018U\u001eJYZ\u000fT\u0019H\u0012I\u0001^\u0005\u0015\u0004H\u001b\u0015\u0014^\u0005OZX\u001fZ\u001eUZ]\u001eW\u0012\u001b\u0019T\u0003\u001b\u0004^\u0003"));
                }
                Object object2 = messagingClusterServer.K.getSsl().getInternalPrivateKeyFile();
                if (object2 == null) {
                    throw new RuntimeException(TransientException.d((Object)"}\u001as\fu\u00132\u0003d\rr\u0011y\u0010j\u0007nLo\u0011pLl\u0010u\u0014}\u0016yOw\u0007eOz\u000bp\u0007<\fs\u0016<\u0011y\u0016"));
                }
                object2 = new File((String)object2);
                object = new File((String)object);
                if (!((File)object2).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object2).getCanonicalPath());
                }
                if (!((File)object).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object).getCanonicalPath());
                }
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                messagingClusterServer.F = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile((File)object2, (File)object, 1L, TimeUnit.MINUTES, (ScheduledExecutorService)messagingClusterServer.E.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                object = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.K.getInternalPort(), (ServerCredentials)object);
                string = UserController.d((Object)"$h;\u001b\u0012U\u0016Y\u001b^\u0013");
                nettyServerBuilder = a2;
            } else {
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.K.getInternalPort());
                nettyServerBuilder = a2;
            }
            nettyServerBuilder.permitKeepAliveTime(messagingClusterServer.K.getMinKeepAliveTime(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(true);
            a2.maxInboundMessageSize((int)Math.max(k.toBytes(), Math.min(Integer.MAX_VALUE, (long)messagingClusterServer.K.getMaxMessageSize() + DataSize.ofMegabytes((long)1L).toBytes())));
            a2.intercept((ServerInterceptor)new InternalAuthenticationInterceptor(messagingClusterServer.K));
            messagingClusterServer.J.forEach(arg_0 -> MessagingClusterServer.d((NettyServerBuilder)a2, arg_0));
            MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
            a2.addService((BindableService)messagingClusterServer.a);
            a2.addService((BindableService)messagingClusterServer2.M);
            if (messagingClusterServer2.K.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(messagingClusterServer.K.getKeepAliveTime(), TimeUnit.MILLISECONDS);
                a2.keepAliveTimeout(messagingClusterServer.K.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(messagingClusterServer.K.getGrpcBufferedMessages()));
            a2.executor((Executor)messagingClusterServer.h);
            if (Epoll.isAvailable()) {
                v3 = messagingClusterServer;
                a2.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(TransientException.d((Object)"\u0001p\u0017o\u0016y\u00101\u0000s\u0011oO"))));
                a2.workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(UserController.d((Object)"\u0014W\u0002H\u0003^\u0005\u0016\u0000T\u0005P\u0012IZ"))));
                a2.channelType(EpollServerSocketChannel.class);
            } else {
                a2.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(TransientException.d((Object)"\u0001p\u0017o\u0016y\u00101\u0000s\u0011oO"))));
                a2.workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(UserController.d((Object)"\u0014W\u0002H\u0003^\u0005\u0016\u0000T\u0005P\u0012IZ"))));
                a2.channelType(NioServerSocketChannel.class);
                v3 = messagingClusterServer;
            }
            v3.e = a2.build();
            messagingClusterServer.e.start();
            messagingClusterServer.I.info(TransientException.d((Object)"#d\rrBO\u0007n\u0014y\u0010<!p\u0017o\u0016y\u0010<1y\u0010j\u0007nBo\u0016}\u0010h\u0007xBs\f<\u0012s\u0010hX<\u0019aB1Bg\u001f"), (Object)messagingClusterServer.K.getInternalPort(), (Object)string);
            messagingClusterServer.l.publishEvent((Object)new ReplicationServerStarted());
            messagingClusterServer.A = true;
            return;
        }
        catch (Exception a2) {
            throw new FailedToStartException(UserController.d((Object)"$O\u0016I\u0003R\u0019\\Wz\u000fT\u0019\u001b$^\u0005M\u0012IWx\u001bN\u0004O\u0012IWh\u0012I\u0001^\u0005\u001b\u0011Z\u001eW\u0012_W"), (Throwable)a2);
        }
    }

    public void stop() {
        MessagingClusterServer messagingClusterServer = this;
        if (messagingClusterServer.F != null) {
            messagingClusterServer.F.close();
        }
        messagingClusterServer.h.shutdown();
        try {
            if (!messagingClusterServer.e.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
                messagingClusterServer2.I.debug(UserController.d((Object)"}\u0018I\u0014^\u0011N\u001bW\u000e\u001b\u0004O\u0018K\u0007R\u0019\\Wx\u001bN\u0004O\u0012IWh\u0012I\u0001^\u0005"));
                messagingClusterServer2.e.shutdownNow();
            }
        }
        catch (InterruptedException a2) {
            messagingClusterServer.I.debug(TransientException.d((Object)"U\fh\u0007n\u0010i\u0012h\u0007xBx\u0017n\u000br\u0005<\u0011t\u0017h\u0006s\u0015rBs\u0004<\u000br\u0016y\u0010r\u0003pB]\u001as\fO\u0007n\u0014y\u0010"), (Throwable)a2);
            Thread.currentThread().interrupt();
        }
        messagingClusterServer.A = false;
        messagingClusterServer.I.info(UserController.d((Object)"z\u000fT\u0019\u001b$^\u0005M\u0012IWx\u001bN\u0004O\u0012IWh\u0012I\u0001^\u0005\u001b\u0004O\u0018K\u0007^\u0013"));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void d(NettyServerBuilder nettyServerBuilder, AxonServerInternalService axonServerInternalService) {
        void a2;
        NettyServerBuilder nettyServerBuilder2 = nettyServerBuilder;
        LinkedList a3 = new LinkedList(a2.interceptors());
        if (a2.requiresContextInterceptor()) {
            a3.add(new ContextInterceptor());
        }
        nettyServerBuilder2.addService(ServerInterceptors.intercept((BindableService)a2, (List)a3));
    }

    public boolean isAutoStartup() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public MessagingClusterServer(MessagingPlatformConfiguration messagingPlatformConfiguration, LogReplicationService logReplicationService, LeaderElectionService leaderElectionService, List<AxonServerInternalService> list, Supplier<ScheduledExecutorService> supplier, ApplicationEventPublisher applicationEventPublisher) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        MessagingClusterServer a7;
        MessagingClusterServer a8 = messagingPlatformConfiguration;
        MessagingClusterServer messagingClusterServer = a7 = this;
        MessagingClusterServer messagingClusterServer2 = a7;
        MessagingClusterServer messagingClusterServer3 = a7;
        MessagingClusterServer messagingClusterServer4 = a7;
        messagingClusterServer4.I = LoggerFactory.getLogger(MessagingClusterServer.class);
        messagingClusterServer4.K = a8;
        messagingClusterServer3.M = a6;
        messagingClusterServer3.a = a5;
        messagingClusterServer2.J = a4;
        messagingClusterServer2.E = a3;
        messagingClusterServer.l = a2;
        messagingClusterServer.h = Executors.newFixedThreadPool(a8.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(TransientException.d((Object)"\u0001p\u0017o\u0016y\u00101\u0007d\u0007\u007f\u0017h\rnO")));
    }

    public boolean isRunning() {
        MessagingClusterServer a2;
        return a2.A;
    }
}

