/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.cluster.util.AxonThreadFactory;
import io.axoniq.axonserver.config.ClusterConfiguration;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.events.serializer.XStreamEventSerializer;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalNode;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteNodesProvider;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.enterprise.cluster.internal.StubFactory;
import io.axoniq.axonserver.enterprise.replication.ReplicationGroupConfigurationMapping;
import io.axoniq.axonserver.grpc.ChannelExceptionHandler;
import io.axoniq.axonserver.grpc.internal.ConnectorCommand;
import io.axoniq.axonserver.grpc.internal.ConnectorResponse;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.plugin.PluginConfigurationManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class RemoteConnections
implements SmartLifecycle {
    private final ScheduledExecutorService B;
    private final ChannelExceptionHandler D;
    private static final BiConsumer<RemoteConnection, ConnectorResponse> d = (remoteConnection, connectorResponse) -> {
        RemoteConnection a2 = connectorResponse;
        connectorResponse = remoteConnection;
    };
    private final long c;
    private final AtomicBoolean m;
    private final ClusterConfiguration f;
    private final XStreamEventSerializer h;
    private final Set<String> e;
    private static final Logger l = LoggerFactory.getLogger(RemoteConnections.class);
    private final RemoteNodesProvider k;
    private final StubFactory J;
    private static final int A = 10;
    private final CurrentNodeProvider I;
    private final Map<String, RemoteConnection> E;
    private final ApplicationEventPublisher M;
    private boolean F;
    private final AtomicInteger K;
    private final Map<ConnectorResponse.ResponseCase, Set<BiConsumer<RemoteConnection, ConnectorResponse>>> a;

    @EventListener
    public void on(ClusterEvents.ReplicationGroupUpdated replicationGroupUpdated) {
        RemoteConnections a2 = replicationGroupUpdated;
        RemoteConnections a3 = this;
        a3.sync();
    }

    public boolean contains(String string) {
        Object a2 = string;
        RemoteConnections a3 = this;
        return a3.E.containsKey(a2);
    }

    /*
     * WARNING - void declaration
     */
    public RemoteConnections(ClusterConfiguration clusterConfiguration, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, StubFactory stubFactory, ChannelExceptionHandler channelExceptionHandler, XStreamEventSerializer xStreamEventSerializer, RemoteNodesProvider remoteNodesProvider, CurrentNodeProvider currentNodeProvider) {
        void a2;
        void remoteNodesProvider2;
        void xStreamEventSerializer2;
        void channelExceptionHandler2;
        void stubFactory2;
        void applicationEventPublisher2;
        RemoteConnections clusterConfiguration2;
        RemoteConnections remoteConnections = remoteConnections2;
        RemoteConnections remoteConnections2 = clusterConfiguration;
        RemoteConnections remoteConnections3 = clusterConfiguration2 = remoteConnections;
        RemoteConnections remoteConnections4 = clusterConfiguration2;
        RemoteConnections remoteConnections5 = clusterConfiguration2;
        RemoteConnections remoteConnections6 = clusterConfiguration2;
        clusterConfiguration2.E = new ConcurrentHashMap();
        RemoteConnections remoteConnections7 = clusterConfiguration2;
        remoteConnections6.K = new AtomicInteger(10);
        RemoteConnections remoteConnections8 = clusterConfiguration2;
        clusterConfiguration2.e = new HashSet();
        RemoteConnections remoteConnections9 = clusterConfiguration2;
        clusterConfiguration2.m = new AtomicBoolean();
        RemoteConnections remoteConnections10 = clusterConfiguration2;
        clusterConfiguration2.B = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new AxonThreadFactory(PluginConfigurationManager.d((Object)"#[5D4R2\u001a2R#X.Y%T4")));
        RemoteConnections remoteConnections11 = clusterConfiguration2;
        clusterConfiguration2.a = new ConcurrentHashMap();
        remoteConnections5.f = remoteConnections2;
        remoteConnections5.M = applicationEventPublisher2;
        remoteConnections4.J = stubFactory2;
        remoteConnections4.c = remoteConnections2.getConnectionWaitTime();
        remoteConnections3.D = channelExceptionHandler2;
        remoteConnections3.h = xStreamEventSerializer2;
        clusterConfiguration2.k = remoteNodesProvider2;
        clusterConfiguration2.I = a2;
        clusterConfiguration2.registerResponseHandler(ConnectorResponse.ResponseCase.CONFIRMATION, d);
    }

    public void updateNodeInfo(NodeInfo nodeInfo) {
        RemoteConnections a2 = nodeInfo;
        RemoteConnections a3 = this;
        Optional.ofNullable((RemoteConnection)a3.E.get(a2.getNodeName())).ifPresent(arg_0 -> RemoteConnections.d((NodeInfo)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void c(String string, RemoteConnection remoteConnection) {
        void a2;
        Object a3 = string;
        RemoteConnections a4 = this;
        a2.disconnect();
        if (!a4.e.contains(a3)) {
            a4.E.remove(a3);
        }
    }

    public RemoteConnection get(String string) {
        Object a2 = string;
        RemoteConnections a3 = this;
        return (RemoteConnection)a3.E.get(a2);
    }

    public Collection<RemoteConnection> connections() {
        RemoteConnections a2;
        return a2.E.values();
    }

    public Stream<RemoteConnection> activeConnections() {
        RemoteConnections a2;
        return a2.E.values().stream().filter(RemoteConnection::isConnected);
    }

    public void sync() {
        RemoteConnections remoteConnections = this;
        Set set = (Set)remoteConnections.k.get();
        TreeSet a2 = new TreeSet(remoteConnections.e);
        RemoteConnections remoteConnections2 = remoteConnections;
        remoteConnections2.e.clear();
        set.forEach(internalNode -> {
            RemoteConnectionImpl a2;
            RemoteConnections a3;
            RemoteConnections a4 = internalNode;
            RemoteConnections remoteConnections = a3 = this;
            a2.remove(a4.name());
            remoteConnections.e.add(a4.name());
            if (!remoteConnections.E.containsKey(a4.name())) {
                RemoteConnections remoteConnections2 = a3;
                a2 = new RemoteConnectionImpl(remoteConnections2, (InternalNode)a4, remoteConnections2.m.get());
                a3.E.put(a4.name(), a2);
                l.debug(ReplicationGroupConfigurationMapping.d((Object)"+-\u00167XyX=\u0016=\ft\u001b;\u0016:\u001d7\f=\u0017:XiX/\u0005"), (Object)a4);
                a2.d();
            }
        });
        l.debug(PluginConfigurationManager.d((Object)"d9Y#\u0017m\u0017-V.V'R`T/Y.R#C)X.D`\n`L=\u001b`C/\u00172R-X6R`\n`L="), (Object)remoteConnections.e, (Object)a2);
        a2.forEach(string -> {
            Object a2 = string;
            RemoteConnections a3 = this;
            Optional.ofNullable((RemoteConnection)a3.E.get(a2)).ifPresent(arg_0 -> a3.M((String)a2, arg_0));
        });
    }

    public void checkConnections() {
        RemoteConnections a2;
        a2.e.forEach(string -> {
            Object a2 = string;
            RemoteConnections a3 = this;
            Optional.ofNullable((RemoteConnection)a3.E.get(a2)).ifPresent(RemoteConnection::checkConnection);
        });
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void M(String string, RemoteConnection remoteConnection) {
        void a2;
        RemoteConnections a3 = remoteConnection;
        RemoteConnections a4 = this;
        a3.close();
        a4.E.remove(a2);
    }

    @EventListener
    public void on(ClusterEvents.ReplicationGroupDeleted replicationGroupDeleted) {
        RemoteConnections a2 = replicationGroupDeleted;
        RemoteConnections a3 = this;
        l.debug(ReplicationGroupConfigurationMapping.d((Object)"*1\b8\u00117\u0019 \u0011;\u0016t\u001f&\u0017!\bt\u001c1\u00141\f1\u001cnX/\u0005"), (Object)a2.replicationGroup());
        a3.B.schedule(() -> a3.sync(), 100L, TimeUnit.MILLISECONDS);
    }

    private static /* synthetic */ void d(ConnectorCommand connectorCommand, RemoteConnection remoteConnection) {
        ConnectorCommand a2 = remoteConnection;
        ConnectorCommand a3 = connectorCommand;
        a2.publish(a3);
    }

    public boolean isRunning() {
        RemoteConnections a2;
        return a2.F;
    }

    public void close(String string) {
        Object a2 = string;
        RemoteConnections a3 = this;
        Optional.ofNullable((RemoteConnection)a3.E.remove(a2)).ifPresent(RemoteConnection::close);
    }

    /*
     * WARNING - void declaration
     */
    public void connect(NodeInfo nodeInfo, boolean bl) {
        RemoteConnections a2 = nodeInfo;
        RemoteConnections a3 = this;
        if (!a3.E.containsKey(a2.getNodeName())) {
            void a4;
            RemoteConnections remoteConnections = a3;
            RemoteConnections remoteConnections2 = a3;
            RemoteConnectionImpl remoteConnectionImpl = new RemoteConnectionImpl(remoteConnections2, new InternalNode(a2.getNodeName(), a2.getInternalHostName(), a2.getGrpcInternalPort()), remoteConnections2.m.get());
            a3.E.put(a2.getNodeName(), remoteConnectionImpl);
            if (a4 != false) {
                remoteConnectionImpl.d();
            }
        }
    }

    private static /* synthetic */ void d(NodeInfo nodeInfo, RemoteConnection remoteConnection) {
        NodeInfo a2 = remoteConnection;
        NodeInfo a3 = nodeInfo;
        ((RemoteConnectionImpl)a2).d(a3);
    }

    public void publish(ConnectorCommand connectorCommand) {
        RemoteConnections a2 = connectorCommand;
        RemoteConnections a3 = this;
        a3.E.values().forEach(arg_0 -> RemoteConnections.d((ConnectorCommand)a2, arg_0));
    }

    public void stop() {
        RemoteConnections a2;
        RemoteConnections remoteConnections = a2;
        remoteConnections.B.shutdown();
        remoteConnections.closeAll();
        remoteConnections.F = false;
    }

    public Set<String> nodes() {
        RemoteConnections a2;
        return a2.E.keySet();
    }

    public void closeAll() {
        RemoteConnections a2;
        RemoteConnections remoteConnections = a2;
        remoteConnections.e.clear();
        remoteConnections.E.forEach((string, remoteConnection) -> {
            String a2 = remoteConnection;
            String a3 = string;
            a2.close();
        });
        a2.E.clear();
    }

    public void start() {
        RemoteConnections a2;
        a2.B.scheduleWithFixedDelay(() -> a2.checkConnections(), a2.f.getConnectionCheckDelay(), a2.f.getConnectionCheckInterval(), TimeUnit.MILLISECONDS);
        a2.F = true;
    }

    @EventListener
    public void on(ReplicationServerStarted replicationServerStarted) {
        RemoteConnections a2 = replicationServerStarted;
        RemoteConnections a3 = this;
        ((Set)a3.k.get()).forEach(internalNode -> {
            void a2;
            RemoteConnections remoteConnections;
            RemoteConnections remoteConnections2 = remoteConnections = this;
            RemoteConnections a3 = new RemoteConnectionImpl(remoteConnections2, (InternalNode)a2, remoteConnections2.m.get());
            remoteConnections.E.put(a2.name(), a3);
            remoteConnections.e.add(a2.name());
            a3.d();
        });
    }

    public int size() {
        RemoteConnections a2;
        return a2.E.size();
    }

    public void disconnect(String string) {
        Object a2 = string;
        RemoteConnections a3 = this;
        Optional.ofNullable((RemoteConnection)a3.E.get(a2)).ifPresent(arg_0 -> a3.c((String)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public void registerResponseHandler(ConnectorResponse.ResponseCase responseCase, BiConsumer<RemoteConnection, ConnectorResponse> biConsumer) {
        void a3;
        Object a4 = biConsumer;
        RemoteConnections a5 = this;
        a5.a.computeIfAbsent(a3, a2 -> new CopyOnWriteArraySet()).add(a4);
    }

    public void setReadyForConnections(boolean bl) {
        RemoteConnections a2;
        boolean a3 = bl;
        RemoteConnections remoteConnections = a2 = this;
        remoteConnections.m.set(a3);
        remoteConnections.E.forEach((string, remoteConnection) -> {
            RemoteConnection a2 = remoteConnection;
            boolean a3 = a3;
            a2.setReadyForConnections(a3);
        });
    }
}

