/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication;

import io.axoniq.axonserver.LifecycleController;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.StateChanged;
import io.axoniq.axonserver.cluster.grpc.RaftGroupManager;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.RaftProperties;
import io.axoniq.axonserver.configuration.runtime.ReplicationGroupMember;
import io.axoniq.axonserver.enterprise.cluster.GrpcRaftGroupFactory;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftGroup;
import io.axoniq.axonserver.enterprise.replication.RaftGroupRepositoryManager;
import io.axoniq.axonserver.enterprise.replication.group.ReplicationGroupController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.plugin.PluginPackageRequester;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.util.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;

@Controller
public class GrpcRaftController
implements SmartLifecycle,
RaftGroupManager {
    private final Map<String, Long> m;
    private final LifecycleController f;
    private final ApplicationEventPublisher h;
    private final RaftProperties e;
    private final FileSystemMonitor l;
    private final Logger k;
    public static final String J = "replication-logs";
    private final MessagingPlatformConfiguration A;
    private final GrpcRaftGroupFactory I;
    private final Map<String, RaftGroup> E;
    private final ReplicationGroupController M;
    private volatile boolean F;
    private final AtomicBoolean K;
    private final RaftGroupRepositoryManager a;

    public void stop() {
        GrpcRaftController a2;
        GrpcRaftController grpcRaftController = a2;
        grpcRaftController.l.unregisterPath(J);
        grpcRaftController.E.forEach((string, raftGroup) -> {
            String a2 = raftGroup;
            String a3 = string;
            a2.stop();
        });
        a2.F = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public RaftNode getOrCreateRaftNode(String string, String string2) {
        void a2;
        GrpcRaftController grpcRaftController = this;
        if (!grpcRaftController.F) {
            throw new IllegalStateException(TaskPublisher.d((Object)"\n]+N<JyK-Y+L,HvK1M-\\6O7\u00180VyH+W>J<K*"));
        }
        GrpcRaftController a3 = (RaftGroup)grpcRaftController.E.get(a2);
        if (a3 != null) {
            return a3.localNode();
        }
        Map map = grpcRaftController.E;
        synchronized (map) {
            a3 = (RaftGroup)grpcRaftController.E.get(a2);
            if (a3 == null) {
                void a4;
                if (grpcRaftController.d((String)a2)) {
                    throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, PluginPackageRequester.d((Object)"y\"[+B$J3B(EgL5D2[gO\"G\"_.D)\u000b.Eg[5D Y\"X4"));
                }
                a3 = grpcRaftController.d((String)a2, (String)a4);
                a3.startAndWait(null);
            }
        }
        return a3.localNode();
    }

    public Set<String> raftGroups() {
        GrpcRaftController a2;
        return a2.E.keySet();
    }

    @Scheduled(fixedDelay=1000L)
    public void syncStore() {
        GrpcRaftController a2;
        if (a2.F) {
            a2.E.forEach((string, raftGroup) -> {
                String a2 = raftGroup;
                String a3 = string;
                ((GrpcRaftGroup)a2).d();
            });
        }
    }

    public String getMyLabel(List<Node> list) {
        Object a2 = list;
        GrpcRaftController a3 = this;
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Node node = (Node)a2.next();
            if (!node.getNodeName().equals(a3.A.getName())) continue;
            return node.getNodeId();
        }
        throw new RuntimeException(TaskPublisher.d((Object)"{6M5\\yV6Ly^0V=\u0018:M+J<V-\u00187W=]yQ7\u00187W=]*"));
    }

    public Iterable<String> getAllNonAdminContexts() {
        GrpcRaftController a2;
        return a2.a.contexts();
    }

    private /* synthetic */ boolean d(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (a3.m.getOrDefault(a2, 0L) > System.currentTimeMillis()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(RaftNode raftNode, StateChanged stateChanged) {
        void a2;
        void a3;
        GrpcRaftController grpcRaftController = this;
        void v0 = a3;
        Object a4 = v0.d();
        long l2 = a2.c();
        if (v0.e() && !a3.m()) {
            grpcRaftController.h.publishEvent((Object)new ClusterEvents.LeaderStepDown((String)a4, l2));
            return;
        }
        if (a3.m() && !a3.e()) {
            grpcRaftController.h.publishEvent((Object)new ClusterEvents.BecomeLeader((String)a4, () -> ((RaftNode)a2).d(), l2));
            return;
        }
        if (a3.d()) {
            grpcRaftController.h.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, null, l2));
            return;
        }
        if (!StringUtils.isEmpty((String)a2.d())) {
            grpcRaftController.h.publishEvent((Object)new ClusterEvents.LeaderConfirmation((String)a4, a2.d(), l2));
        }
    }

    public RaftNode getRaftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if (!a3.F) {
            throw new IllegalStateException(TaskPublisher.d((Object)"q7Q-Q8T0B8L0W7\u00186JyK1M-\\6O7\u00180VyH+W>J<K*"));
        }
        if (!a3.E.containsKey(a2)) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.A.getName() + ": Not a member of " + (String)a2);
        }
        return ((RaftGroup)a3.E.get(a2)).localNode();
    }

    /*
     * WARNING - void declaration
     */
    public void prepareDeleteNodeFromReplicationGroup(String string, String string2) {
        void a2;
        GrpcRaftController a3;
        Object a4 = string2;
        GrpcRaftController grpcRaftController = a3 = this;
        grpcRaftController.a.prepareDeleteNodeFromReplicationGroup((String)a2, (String)a4);
        grpcRaftController.h.publishEvent((Object)new ClusterEvents.DeleteNodeFromReplicationGroupRequested((String)a2, (String)a4));
    }

    private /* synthetic */ MessagingPlatformException d(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, a3.A.getName() + ": Not a member of " + (String)a2);
    }

    public int getPhase() {
        return 100;
    }

    public RaftNode waitForLeader(RaftGroup raftGroup) {
        GrpcRaftController a2 = raftGroup;
        GrpcRaftController a3 = this;
        GrpcRaftController grpcRaftController = a2;
        while (!grpcRaftController.localNode().M() || a2.logEntryProcessor().d() == 0L) {
            try {
                Thread.sleep(100L);
                grpcRaftController = a2;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(PluginPackageRequester.d((Object)"b)_\"Y5^7_g\\/B+Ng\\&B3B)Lg_(\u000b%N$D*NgG\"J#N5"));
            }
        }
        return a2.localNode();
    }

    private /* synthetic */ void d(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        a3.m.put(a2, System.currentTimeMillis() + 2L * (long)a3.e.getMaxElectionTimeout());
    }

    /*
     * WARNING - void declaration
     */
    public RaftGroup initRaftGroup(String string, String string2, String string3) {
        void a2;
        Node a3;
        Object a4 = string2;
        GrpcRaftController a5 = this;
        a3 = Node.newBuilder().setNodeId((String)a4).setHost(a5.A.getFullyQualifiedInternalHostname()).setPort(a5.A.getInternalPort()).setNodeName((String)a3).setRole(Role.PRIMARY).build();
        GrpcRaftController grpcRaftController = a5;
        a4 = grpcRaftController.d((String)a2, (String)a4);
        a4.raftConfiguration().update(Collections.singletonList(a3));
        grpcRaftController.k.debug(TaskPublisher.d((Object)"\nL8J-\u0018?J6UyQ7Q-j8^-\u007f+W,HyC$"), (Object)a2);
        Object object = a4;
        object.startAndWait(Role.PRIMARY);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private /* synthetic */ RaftGroup d(String string, String string2) {
        Object a2 = string2;
        GrpcRaftController a3 = this;
        Map map = a3.E;
        synchronized (map) {
            void a4;
            block4: {
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.k.info(PluginPackageRequester.d((Object)"P:\u0011gB)B3\u000b5N7G.H&_.D)\u000b Y(^7"), (Object)a4);
                RaftGroup raftGroup = (RaftGroup)grpcRaftController.E.get(a4);
                if (raftGroup == null) break block4;
                return raftGroup;
            }
            a2 = a3.I.create((String)a4, (String)a2);
            a2.localNode().d(arg_0 -> a3.d((RaftGroup)a2, arg_0));
            a3.E.put(a4, a2);
            return a2;
        }
    }

    public RaftGroup getRaftGroup(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return (RaftGroup)a3.E.get(a2);
    }

    /*
     * WARNING - void declaration
     */
    public void delete(String string, boolean bl) {
        void a2;
        Object a3 = string;
        GrpcRaftController a4 = this;
        if (a2 == false) {
            a4.d((String)a3);
        }
        a4.E.remove(a3);
        GrpcRaftController grpcRaftController = a4;
        grpcRaftController.M.deleteReplicationGroup((String)a3, (boolean)a2);
        grpcRaftController.h.publishEvent((Object)new ClusterEvents.ReplicationGroupDeleted((String)a3, (boolean)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(RaftGroup raftGroup, StateChanged stateChanged) {
        void a2;
        GrpcRaftController a3 = stateChanged;
        GrpcRaftController a4 = this;
        a4.d(a2.localNode(), (StateChanged)a3);
    }

    public void start() {
        GrpcRaftController grpcRaftController = this;
        Object a2 = new File(grpcRaftController.e.getLogStorageFolder());
        GrpcRaftController grpcRaftController2 = grpcRaftController;
        FileUtils.d((File)a2);
        grpcRaftController2.l.registerPath(J, ((File)a2).toPath(), grpcRaftController.e.minFreeSpace(), grpcRaftController.e.warnFreeSpace());
        a2 = grpcRaftController2.a.getMyReplicationGroups();
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            a3.d(a2.groupId(), a2.nodeId());
        });
        grpcRaftController.F = true;
        AtomicInteger atomicInteger = new AtomicInteger(a2.size());
        a2.forEach(replicationGroupMember -> {
            GrpcRaftController a2 = replicationGroupMember;
            GrpcRaftController a3 = this;
            try {
                void a4;
                GrpcRaftController grpcRaftController = a3;
                grpcRaftController.k.info(PluginPackageRequester.d((Object)"P:\u0011gy\"[+B$J3B(EgL5D2[gX3J5_.E "), (Object)a2.groupId());
                ((RaftGroup)grpcRaftController.E.get(a2.groupId())).start(a2.role()).whenComplete((arg_0, arg_1) -> a3.d((ReplicationGroupMember)a2, (AtomicInteger)a4, arg_0, arg_1));
                return;
            }
            catch (Exception a4) {
                a3.k.warn(TaskPublisher.d((Object)"\"Ec\u0018\u001fY0T<\\yL6\u00180V0L0Y5Q#]yJ<H5Q:Y-Q6V\u001eJ6M)"), (Object)a2.groupId(), (Object)a4);
                return;
            }
        });
        grpcRaftController.k.info(PluginPackageRequester.d((Object)"y\"[+B$J3B(EgL5D2[gH(E3Y(G+N5\u000b5^)E.E "));
        if (a2.isEmpty()) {
            grpcRaftController.K.set(true);
        }
    }

    public boolean ready() {
        GrpcRaftController a2;
        return a2.K.get();
    }

    public String getMyName() {
        GrpcRaftController a2;
        return a2.A.getName();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(ReplicationGroupMember replicationGroupMember, AtomicInteger atomicInteger, Void void_, Throwable throwable) {
        Object a2;
        GrpcRaftController grpcRaftController = object;
        Object object = throwable;
        GrpcRaftController a3 = grpcRaftController;
        if (a2 == null) {
            void a4;
            a3.k.info(PluginPackageRequester.d((Object)"<V}\u000b\u0015N7G.H&_.D)\u000b Y(^7\u000b4_&Y3N#"), (Object)a.groupId());
            if (a4.decrementAndGet() == 0) {
                GrpcRaftController grpcRaftController2 = a3;
                grpcRaftController2.f.setCleanShutdown();
                grpcRaftController2.K.set(true);
                return;
            }
        } else {
            a3.k.warn(TaskPublisher.d((Object)"C$\u0002yj<H5Q:Y-Q6Vy_+W,HyK-Y+Ly^8Q5]="), (Object)a.groupId(), a2);
        }
    }

    public boolean isRunning() {
        GrpcRaftController a2;
        return a2.F;
    }

    public RaftNode getRaftNodeForContext(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.M.findReplicationGroupByContext((String)a2).map(arg_0 -> a3.getRaftNode(arg_0)).orElseThrow(() -> a3.d((String)a2));
    }

    public Optional<RaftNode> raftNode(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        if ((a2 = (RaftGroup)a3.E.get(a2)) != null) {
            return Optional.of(a2.localNode());
        }
        return Optional.empty();
    }

    public Collection<String> getRaftGroups() {
        GrpcRaftController a2;
        return a2.E.keySet();
    }

    public int electionTimeout() {
        GrpcRaftController a2;
        return a2.e.getMaxElectionTimeout();
    }

    /*
     * WARNING - void declaration
     */
    public GrpcRaftController(MessagingPlatformConfiguration messagingPlatformConfiguration, RaftProperties raftProperties, RaftGroupRepositoryManager raftGroupRepositoryManager, ApplicationEventPublisher applicationEventPublisher, ReplicationGroupController replicationGroupController, GrpcRaftGroupFactory grpcRaftGroupFactory, FileSystemMonitor fileSystemMonitor, LifecycleController lifecycleController) {
        GrpcRaftController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        GrpcRaftController a10;
        GrpcRaftController grpcRaftController = grpcRaftController2;
        GrpcRaftController grpcRaftController2 = lifecycleController;
        GrpcRaftController grpcRaftController3 = a10 = grpcRaftController;
        GrpcRaftController grpcRaftController4 = a10;
        GrpcRaftController grpcRaftController5 = a10;
        GrpcRaftController grpcRaftController6 = a10;
        GrpcRaftController grpcRaftController7 = a10;
        a10.k = LoggerFactory.getLogger(GrpcRaftController.class);
        GrpcRaftController grpcRaftController8 = a10;
        grpcRaftController7.E = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController9 = a10;
        grpcRaftController8.m = new ConcurrentHashMap();
        GrpcRaftController grpcRaftController10 = a10;
        grpcRaftController7.K = new AtomicBoolean();
        grpcRaftController6.A = a9;
        grpcRaftController6.a = a8;
        grpcRaftController5.M = a7;
        grpcRaftController5.e = a6;
        grpcRaftController4.h = a5;
        grpcRaftController4.I = a4;
        grpcRaftController3.l = a3;
        grpcRaftController3.f = a2;
    }

    public boolean isHealthy(String string) {
        Object a2 = string;
        GrpcRaftController a3 = this;
        return a3.getRaftNodeForContext((String)a2).c();
    }
}

