/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.admin;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.applicationevents.EventProcessorEvents;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.internal.AddressValidator;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalCommandMessageHandler;
import io.axoniq.axonserver.enterprise.replication.admin.LeaderElectionCheck;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.enterprise.replication.logconsumer.AdminNodeConsumer;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.DeleteNode;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.grpc.internal.UpdateLicense;
import io.axoniq.axonserver.licensing.LicenseManager;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.axoniq.axonserver.taskscheduler.task.NodeContext;
import io.axoniq.axonserver.taskscheduler.task.PrepareDeleteNodeFromContextTask;
import io.axoniq.axonserver.taskscheduler.task.UnregisterNodeTask;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClusterChangesHandler {
    private final ClusterController A;
    private final FeatureChecker I;
    private final Logger E;
    private final AddressValidator M;
    private final LicenseManager F;
    private final RaftGroupServiceFactory K;
    private final TaskPublisher a;

    /*
     * WARNING - void declaration
     */
    public ClusterChangesHandler(ClusterController clusterController, TaskPublisher taskPublisher, RaftGroupServiceFactory raftGroupServiceFactory, FeatureChecker featureChecker, AddressValidator addressValidator, LicenseManager licenseManager) {
        ClusterChangesHandler a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ClusterChangesHandler a8;
        ClusterChangesHandler clusterChangesHandler = clusterChangesHandler2;
        ClusterChangesHandler clusterChangesHandler2 = licenseManager;
        ClusterChangesHandler clusterChangesHandler3 = a8 = clusterChangesHandler;
        ClusterChangesHandler clusterChangesHandler4 = a8;
        ClusterChangesHandler clusterChangesHandler5 = a8;
        a8.E = LoggerFactory.getLogger(ClusterChangesHandler.class);
        clusterChangesHandler5.A = a7;
        clusterChangesHandler5.a = a6;
        clusterChangesHandler4.K = a5;
        clusterChangesHandler4.I = a4;
        clusterChangesHandler3.M = a3;
        clusterChangesHandler3.F = a2;
    }

    private /* synthetic */ void d(Duration duration) {
        Duration a22 = duration;
        ClusterChangesHandler a3 = this;
        try {
            Thread.sleep(a22.toMillis());
            return;
        }
        catch (InterruptedException a22) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(a22);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteNodeIfEmpty(String string) {
        void a3;
        ClusterChangesHandler clusterChangesHandler = this;
        ClusterChangesHandler a4 = clusterChangesHandler.A.getNode((String)a3);
        if (a4 == null) {
            return;
        }
        if (a4.getReplicationGroups().stream().anyMatch(a2 -> {
            if (a2.getReplicationGroup() != null) {
                if (a2.getReplicationGroup().getMembers().size() > 1) {
                    return true;
                }
            }
            return false;
        })) {
            throw new TransientException(InternalCommandMessageHandler.d((Object)"e\u001eO\u0014\u000b\u0002_\u0018G\u001d\u000b\u001cN\u001cI\u0014YQD\u0017\u000b\u0012D\u001f_\u0014S\u0005X_"));
        }
        clusterChangesHandler.K.appendToAdminAndWait(DeleteNode.class.getName(), DeleteNode.newBuilder().setNodeName((String)a3).build().toByteArray());
    }

    public void deleteNode(String string) {
        String a2 = string;
        ClusterChangesHandler a3 = this;
        ClusterNode clusterNode = a3.A.getNode(a2);
        if (clusterNode == null) {
            a3.E.info(EventProcessorEvents.d((Object)"\u0015\u0000=\u0000%\u0000q+>\u00014_q\u001e,E|E\u001f\n5\u0000q\u000b>\u0011q\u0003>\u0010?\u0001\u007f"), (Object)a2);
            return;
        }
        for (AdminReplicationGroupMember adminReplicationGroupMember2 : clusterNode.getReplicationGroups()) {
            if (LeaderElectionCheck.d((ClusterController)a3.A, (AdminReplicationGroup)adminReplicationGroupMember2.getReplicationGroup(), (String)a2)) continue;
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, "Cannot delete node at this moment, without the node there is no leader for " + adminReplicationGroupMember2.getReplicationGroup().getName());
        }
        a3.a.publishScheduledTask(RaftAdminGroup.d(), UnregisterNodeTask.class.getName(), (Object)a2, Duration.ofSeconds(1L));
        if (a2.equals(a3.A.getName())) {
            a3.d(Duration.ofSeconds(3L));
        }
        clusterNode.getReplicationGroups().forEach(adminReplicationGroupMember -> {
            void a2;
            ClusterChangesHandler a3 = adminReplicationGroupMember;
            ClusterChangesHandler a4 = this;
            a4.a.publishScheduledTask(RaftAdminGroup.d(), PrepareDeleteNodeFromContextTask.class.getName(), (Object)new NodeContext((String)a2, a3.getReplicationGroup().getName(), true), Duration.ZERO);
        });
    }

    private /* synthetic */ byte[] d() {
        ClusterChangesHandler a2;
        return a2.F.readLicense();
    }

    /*
     * WARNING - void declaration
     */
    public UpdateLicense join(NodeInfo nodeInfo) {
        void a2;
        ClusterChangesHandler clusterChangesHandler = this;
        clusterChangesHandler.I.getMaxClusterSize().ifPresent(n -> {
            Integer a2 = n;
            ClusterChangesHandler a3 = this;
            if (a3.A.nodes().count() >= (long)a2.intValue()) {
                throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached: " + a3.I.getMaxClusterSize());
            }
        });
        ClusterChangesHandler clusterChangesHandler2 = clusterChangesHandler;
        Object a3 = clusterChangesHandler2.K.getLeader(RaftAdminGroup.d());
        if (!clusterChangesHandler2.A.getName().equals(a3)) {
            throw new MessagingPlatformException(ErrorCode.NODE_IS_REPLICA, "Send join request to the leader of _admin context: " + (String)a3);
        }
        a3 = clusterChangesHandler.A.getNode(a2.getNodeName());
        if (!(a3 == null || a3.getInternalHostName().equals(a2.getInternalHostName()) && a3.getGrpcInternalPort().equals(a2.getGrpcInternalPort()))) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, InternalCommandMessageHandler.d((Object)"jQE\u001eO\u0014\u000b\u0006B\u0005CQ_\u0019NQX\u0010F\u0014\u000b\u001fJ\u001cNQJ\u001fOQO\u0018M\u0017N\u0003N\u001f_QB\u001f_\u0014Y\u001fJ\u001d\u000b\u0019D\u0002_QE\u0010F\u0014\u000b\u0010E\u0015\u000b\u0001D\u0003_QJ\u001dY\u0014J\u0015RQN\tB\u0002_\u0002"));
        }
        ClusterChangesHandler clusterChangesHandler3 = clusterChangesHandler;
        clusterChangesHandler3.M.validateAddress(a2.getInternalHostName(), a2.getGrpcInternalPort());
        a3 = clusterChangesHandler3.d();
        clusterChangesHandler3.K.appendToAdminAndWait(AdminNodeConsumer.class.getName(), a2.toByteArray());
        return UpdateLicense.newBuilder().setLicense(ByteString.copyFrom((byte[])a3)).build();
    }
}

