/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.admin;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.cluster.RaftGroup;
import io.axoniq.axonserver.cluster.RaftNode;
import io.axoniq.axonserver.cluster.util.RoleUtils;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.replication.GrpcRaftController;
import io.axoniq.axonserver.enterprise.replication.admin.AdminReplicationGroupController;
import io.axoniq.axonserver.enterprise.replication.admin.DeleteReplicationGroupPayload;
import io.axoniq.axonserver.enterprise.replication.admin.DeleteReplicationGroupTask;
import io.axoniq.axonserver.enterprise.replication.admin.LeaderElectionCheck;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.cluster.Node;
import io.axoniq.axonserver.grpc.cluster.Role;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.grpc.internal.NodeInfoWithLabel;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupConfiguration;
import io.axoniq.axonserver.grpc.internal.ReplicationGroupMember;
import io.axoniq.axonserver.localstorage.file.IndexNotFoundException;
import io.axoniq.axonserver.message.command.CommandMetricsWebSocket;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.util.CompetableFutureUtils;
import io.grpc.Status;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
public class ReplicationGroupChangesHandler {
    private final TaskPublisher J;
    private final Logger A;
    private final ClusterController I;
    private final int E = 1;
    private final FeatureChecker M;
    private final GrpcRaftController F;
    private final AdminReplicationGroupController K;
    private final RaftGroupServiceFactory a;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Node d(ClusterNode clusterNode, String string, Role role) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler a4 = clusterNode;
        ReplicationGroupChangesHandler a5 = this;
        return Node.newBuilder().setNodeId((String)a3).setHost(a4.getInternalHostName()).setPort(a4.getGrpcInternalPort().intValue()).setNodeName(a4.getName()).setRole(RoleUtils.d((Role)a2)).build();
    }

    /*
     * WARNING - void declaration
     */
    public void createReplicationGroup(String string, Collection<ReplicationGroupMember> collection) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        replicationGroupChangesHandler.d((String)a3, (Collection)a2);
        ArrayList arrayList = new ArrayList();
        AtomicReference a4 = new AtomicReference();
        a2.forEach(replicationGroupMember -> {
            void a2;
            void a3;
            ReplicationGroupChangesHandler a4;
            ReplicationGroupChangesHandler a5 = replicationGroupMember;
            ReplicationGroupChangesHandler replicationGroupChangesHandler = a4 = this;
            ClusterNode clusterNode = replicationGroupChangesHandler.I.getNode(a5.getNodeName());
            String string = replicationGroupChangesHandler.d(a5.getNodeName());
            a5 = replicationGroupChangesHandler.d(clusterNode, string, a5.getRole());
            if (a3.get() == null && Role.PRIMARY.equals((Object)a5.getRole())) {
                a3.set(a5);
            }
            a2.add(a5);
        });
        CompetableFutureUtils.d((CompletableFuture)((CompletableFuture)replicationGroupChangesHandler.a.getRaftGroupServiceForNode(((Node)a4.get()).getNodeName()).initReplicationGroup((String)a3, arrayList).thenAccept(replicationGroupConfiguration -> {
            ReplicationGroupChangesHandler a2 = replicationGroupConfiguration;
            ReplicationGroupChangesHandler a3 = this;
            a2 = a2.toBuilder().setPending(false).build();
            a3.a.appendToAdminAndWait(ReplicationGroupConfiguration.class.getName(), a2.toByteArray());
        })).exceptionally(arg_0 -> replicationGroupChangesHandler.d((String)a3, arg_0)));
    }

    private /* synthetic */ void M() {
        ReplicationGroupChangesHandler a2;
        if (a2.I.nodes().count() > (long)a2.M.getMaxClusterSize().orElse(1).intValue()) {
            throw new MessagingPlatformException(ErrorCode.LICENSE_ERROR, IndexNotFoundException.d((Object)"1*\ne\b$\u000b<E+\n!\u00006E,\u000be\u0006)\u00106\u0011 \u0017"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void d(ReplicationGroupConfiguration.Builder builder, AdminReplicationGroup adminReplicationGroup, AdminReplicationGroupMember adminReplicationGroupMember) {
        void a2;
        ReplicationGroupConfiguration.Builder a3 = adminReplicationGroupMember;
        ReplicationGroupConfiguration.Builder a4 = builder;
        a4.setPending(a2.isChangePending()).addNodes(NodeInfoWithLabel.newBuilder().setNode(a3.getClusterNode().toNodeInfo()).setLabel(a3.getClusterNodeLabel()).setRole(a3.getRole()).build());
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<Void> addNodeToReplicationGroup(String string, String string2, Role role) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler a4;
        Object a5 = string2;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = a4 = this;
        replicationGroupChangesHandler.A.info(CommandMetricsWebSocket.d((Object)"x\f]HW\u0007]\r\u0019\u001a\\\u0019L\rJ\u001c\u0019\u0001W\u001eV\u0003\\\f\u0019\u000eV\u001a\u0019\u0006V\f\\R\u0019\u0013DH\u0014HX\u0006]HZ\u0007W\u001c\\\u0010MR\u0019\u0013D"), a5, (Object)a3);
        if (!replicationGroupChangesHandler.I.isActive((String)a5)) {
            throw new MessagingPlatformException(ErrorCode.AXONSERVER_NODE_NOT_CONNECTED, (String)a5 + ": cannot add node to a replication group when it is not active");
        }
        if (a4.a.getLeader((String)a3) == null) {
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, (String)a3 + ": cannot add node to a replication group when it does not have a leader");
        }
        ClusterNode clusterNode = a4.I.getNode((String)a5);
        if (clusterNode == null) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a5;
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, String.format(IndexNotFoundException.d((Object)"+*\u0001 E`\u0016e\u000b*\u0011e\u0003*\u0010+\u0001"), objectArray));
        }
        Object object = a5;
        a4.d(Collections.singleton(object), (Role)a2);
        return a4.d((String)object, (Role)a2, (String)a3, clusterNode, 1);
    }

    @EventListener
    public void on(ClusterEvents.LeaderConfirmation leaderConfirmation) {
        ReplicationGroupChangesHandler a2 = leaderConfirmation;
        ReplicationGroupChangesHandler a3 = this;
        long l2 = a3.F.currentTerm(a2.replicationGroup()).orElse(-1L);
        if (a2.term() < l2) {
            return;
        }
        try {
            a3.M(a2.replicationGroup());
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void M(String string) {
        block3: {
            ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
            try {
                ReplicationGroupChangesHandler a2 = replicationGroupChangesHandler.F.getRaftNode(RaftAdminGroup.d());
                if (a2.M()) {
                    void a3;
                    replicationGroupChangesHandler.K.findByName((String)a3).ifPresent(arg_0 -> replicationGroupChangesHandler.d((RaftNode)a2, arg_0));
                    return;
                }
            }
            catch (MessagingPlatformException a2) {
                if (ErrorCode.REPLICATION_GROUP_NOT_FOUND.equals((Object)a2.getErrorCode())) break block3;
                replicationGroupChangesHandler.A.warn(IndexNotFoundException.d((Object)"\u0000\u00177\n7E&\r \u0006.\f+\u0002e\u0015 \u000b!\f+\u0002e\u0006-\u0004+\u0002 \u0016"), (Throwable)a2);
            }
        }
    }

    private static /* synthetic */ MessagingPlatformException d(String string, String string2) {
        String a2 = string2;
        String a3 = string;
        Object[] objectArray = new Object[2];
        objectArray[0] = a3;
        objectArray[1] = a2;
        return new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, String.format(IndexNotFoundException.d((Object)"\u000b\n!\u0000e@6E+\n1E#\n0\u000b!E,\u000be\u0017 \u0015)\f&\u00041\f*\u000b\u0002\u0017*\u00105E`\u0016"), objectArray));
    }

    /*
     * WARNING - void declaration
     */
    public List<String> joinReplicationGroups(NodeInfo nodeInfo, List<String> list) {
        void a2;
        List<String> a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        Object a4 = new LinkedList();
        if (a3.isEmpty()) {
            a3 = replicationGroupChangesHandler.K.findAll().map(AdminReplicationGroup::getName).toList();
        }
        ClusterNode clusterNode = replicationGroupChangesHandler.I.getNode(a2.getNodeName());
        a3.forEach(arg_0 -> replicationGroupChangesHandler.d((NodeInfo)a2, clusterNode, (List)a4, arg_0));
        return a4;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(ClusterEvents.BecomeLeader becomeLeader, Long l2) {
        void a2;
        ReplicationGroupChangesHandler a3 = becomeLeader;
        ReplicationGroupChangesHandler a4 = this;
        if (a3.term() < a2.longValue()) {
            return;
        }
        a4.M(a3.replicationGroup());
    }

    private static /* synthetic */ MessagingPlatformException c(String a2) {
        Object[] objectArray = new Object[1];
        objectArray[0] = a2;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, String.format(CommandMetricsWebSocket.d((Object)":\\\u0018U\u0001Z\tM\u0001V\u0006\u0019\u000fK\u0007L\u0018\u0019MJHW\u0007MH_\u0007L\u0006]"), objectArray));
    }

    private static /* synthetic */ MessagingPlatformException M(String a2) {
        Object[] objectArray = new Object[1];
        objectArray[0] = a2;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, String.format(CommandMetricsWebSocket.d((Object)":\\\u0018U\u0001Z\tM\u0001V\u0006\u0019\u000fK\u0007L\u0018\u0019MJHW\u0007MH_\u0007L\u0006]"), objectArray));
    }

    private /* synthetic */ String d(String string) {
        Object a2 = string;
        ReplicationGroupChangesHandler a3 = this;
        return (String)a2 + "-" + UUID.randomUUID();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(RaftNode raftNode, AdminReplicationGroup adminReplicationGroup) {
        ReplicationGroupChangesHandler a2 = adminReplicationGroup;
        ReplicationGroupChangesHandler a3 = this;
        if (a2.isChangePending()) {
            void a4;
            a2 = a3.d((AdminReplicationGroup)a2).setPending(false).build();
            a4.d(ReplicationGroupConfiguration.class.getName(), a2.toByteArray());
        }
    }

    /*
     * WARNING - void declaration
     */
    public ReplicationGroupChangesHandler(AdminReplicationGroupController adminReplicationGroupController, ClusterController clusterController, RaftGroupServiceFactory raftGroupServiceFactory, FeatureChecker featureChecker, TaskPublisher taskPublisher, GrpcRaftController grpcRaftController) {
        ReplicationGroupChangesHandler a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ReplicationGroupChangesHandler a8;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = replicationGroupChangesHandler2;
        ReplicationGroupChangesHandler replicationGroupChangesHandler2 = grpcRaftController;
        ReplicationGroupChangesHandler replicationGroupChangesHandler3 = a8 = replicationGroupChangesHandler;
        ReplicationGroupChangesHandler replicationGroupChangesHandler4 = a8;
        ReplicationGroupChangesHandler replicationGroupChangesHandler5 = a8;
        ReplicationGroupChangesHandler replicationGroupChangesHandler6 = a8;
        replicationGroupChangesHandler6.E = 1;
        replicationGroupChangesHandler6.A = LoggerFactory.getLogger(ReplicationGroupChangesHandler.class);
        replicationGroupChangesHandler5.K = a7;
        replicationGroupChangesHandler5.I = a6;
        replicationGroupChangesHandler4.a = a5;
        replicationGroupChangesHandler4.M = a4;
        replicationGroupChangesHandler3.J = a3;
        replicationGroupChangesHandler3.F = a2;
    }

    public void init(List<String> list) {
        List<String> a2 = list;
        Object a3 = this;
        if (!a3.d()) {
            throw new MessagingPlatformException(ErrorCode.ALREADY_MEMBER_OF_CLUSTER, IndexNotFoundException.d((Object)"+*\u0001 E,\u0016e\u0004)\u0017 \u0004!\u001ce\b \b'\u00007E*\u0003e\u0006)\u00106\u0011 \u0017e\n7E,\u000b,\u0011,\u0004)\f?\u0000!E'\u0000#\n7\u0000"));
        }
        ReplicationGroupChangesHandler replicationGroupChangesHandler = a3;
        replicationGroupChangesHandler.A.info(CommandMetricsWebSocket.d((Object)"p\u0006P\u001cP\tU\u0001C\tM\u0001V\u0006\u0019\u0007_HM\u0000P\u001b\u0019\u0006V\f\\HN\u0001M\u0000\u0019\u000eV\u0004U\u0007N\u0001W\u000f\u0019\u000bV\u0006M\rA\u001cJR\u0019\u0013D"), (Object)a2);
        replicationGroupChangesHandler.d(RaftAdminGroup.d());
        a2.forEach(string -> {
            ReplicationGroupConfiguration a2;
            ReplicationGroupChangesHandler replicationGroupChangesHandler;
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = replicationGroupChangesHandler = this;
            ReplicationGroupChangesHandler a3 = replicationGroupChangesHandler2.I.getMe();
            String string2 = replicationGroupChangesHandler2.d(a3.getName());
            RaftGroup raftGroup = replicationGroupChangesHandler2.F.initRaftGroup((String)a2, string2, a3.getName());
            a3 = a3.toNodeInfo();
            a2 = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName((String)a2).addNodes(NodeInfoWithLabel.newBuilder().setNode((NodeInfo)a3).setRole(Role.PRIMARY).setLabel(string2)).build();
            CompetableFutureUtils.d((CompletableFuture)replicationGroupChangesHandler2.F.waitForLeader(replicationGroupChangesHandler.F.getRaftGroup(RaftAdminGroup.d())).d(ReplicationGroupConfiguration.class.getName(), a2.toByteArray()));
            replicationGroupChangesHandler.F.waitForLeader(raftGroup);
        });
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Void d(String string, Throwable throwable) {
        void a2;
        Object a3 = throwable;
        ReplicationGroupChangesHandler a4 = this;
        a4.deleteReplicationGroup((String)a2, false);
        throw MessagingPlatformException.create((Throwable)a3);
    }

    private static /* synthetic */ void d(Map map, ReplicationGroupMember replicationGroupMember) {
        Map a3 = replicationGroupMember;
        Map a4 = map;
        a4.computeIfAbsent(a3.getRole(), a2 -> new HashSet()).add(a3.getNodeName());
    }

    private static /* synthetic */ boolean d(String string, NodeInfoWithLabel nodeInfoWithLabel) {
        String a2 = nodeInfoWithLabel;
        String a3 = string;
        if (!a2.getLabel().equals(a3)) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(String string, Collection collection, AdminReplicationGroup adminReplicationGroup, Void void_, Throwable throwable) {
        void a2;
        void a3;
        Object a222 = collection;
        ReplicationGroupChangesHandler a4 = this;
        ReplicationGroupConfiguration.Builder a5 = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName((String)a3);
        if (a2 != null) {
            void a6;
            Object[] objectArray = new Object[3];
            objectArray[0] = a3;
            objectArray[1] = String.join((CharSequence)CommandMetricsWebSocket.d((Object)"\u0015"), (Iterable<? extends CharSequence>)a222);
            objectArray[2] = a2;
            a4.A.warn(IndexNotFoundException.d((Object)">\u0018\u007fE\u0006\n0\t!E+\n1E!\u0000)\u00001\u0000e\u0017 \u0015)\f&\u00041\f*\u000be\u00027\n0\u0015e\u00037\n(E>\u0018"), objectArray);
            a6.getMembers().stream().filter(arg_0 -> ReplicationGroupChangesHandler.d((Collection)a222, arg_0)).forEach(adminReplicationGroupMember -> {
                ReplicationGroupConfiguration.Builder a2 = adminReplicationGroupMember;
                ReplicationGroupConfiguration.Builder a3 = a5;
                a3.addNodes(NodeInfoWithLabel.newBuilder().setLabel(a2.getClusterNodeLabel()).setNode(a2.getClusterNode().toNodeInfo()));
            });
        }
        try {
            a4.a.appendToAdminAndWait(ReplicationGroupConfiguration.class.getName(), a5.build().toByteArray());
            return;
        }
        catch (Exception a222) {
            a4.A.debug(IndexNotFoundException.d((Object)"\u001e8_e 7\u0017*\u0017e\u0012-\f)\u0000e\u00105\u0001$\u0011,\u000b\"E&\n+\u0003,\u00020\u0017$\u0011,\n+E>\u0018"), (Object)a3, (Object)a222.getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteNodeFromReplicationGroup(String string, String string2, boolean bl) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler a4;
        Object a5 = string;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = a4 = this;
        replicationGroupChangesHandler.A.info(IndexNotFoundException.d((Object)"! \t \u0011 E+\n!\u0000e\u00037\n(E7\u00005\t,\u0006$\u0011,\n+E\"\u0017*\u00105E,\u000b3\n.\u0000!E#\n7E7\u00005\t,\u0006$\u0011,\n+E\"\u0017*\u00105_e\u001e8EhE$\u000b!E+\n!\u0000\u007fE>\u0018"), a5, (Object)a3);
        if (replicationGroupChangesHandler.a.getLeader((String)a5) == null) {
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, (String)a5 + ": cannot delete node from a replication group when it does not have a leader");
        }
        AdminReplicationGroup adminReplicationGroup = (AdminReplicationGroup)a4.K.findByName((String)a5).orElseThrow(() -> ReplicationGroupChangesHandler.M((String)a5));
        String string3 = (String)adminReplicationGroup.getNodeLabel((String)a3).orElseThrow(() -> ReplicationGroupChangesHandler.d((String)a3, (String)a5));
        if (adminReplicationGroup.getMembers().size() == 1) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a3;
            objectArray[1] = a5;
            throw new MessagingPlatformException(ErrorCode.CANNOT_REMOVE_LAST_NODE, String.format(CommandMetricsWebSocket.d((Object)"&V\f\\H\u001c\u001b\u0019\u0001JHU\tJ\u001c\u0019\u0006V\f\\HP\u0006\u0019\u001a\\\u0018U\u0001Z\tM\u0001V\u0006\u0019\u000fK\u0007L\u0018\u0019MJD\u0019\u001cVH]\rU\rM\r\u0019\u001cQ\r\u0019\u001a\\\u0018U\u0001Z\tM\u0001V\u0006\u0019\u000fK\u0007L\u0018\u0019\u001dJ\r\u0019\u001dW\u001a\\\u000fP\u001bM\rKHZ\u0007W\u001c\\\u0010M"), objectArray));
        }
        if (!LeaderElectionCheck.d((ClusterController)a4.I, (AdminReplicationGroup)adminReplicationGroup, (String)a3)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a3;
            objectArray[1] = a5;
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, String.format(IndexNotFoundException.d((Object)"1-\u0000e\u000b*\u0001 E`\u0016e\u0006$\u000b+\n1E'\u0000e\u0001 \t \u0011 \u0001e\u00037\n(E1\r E7\u00005\t,\u0006$\u0011,\n+E\"\u0017*\u00105E`\u0016e\u00041E1\r,\u0016e\b*\b \u000b1Ie\u0017 \b$\f+\f+\u0002e\u000b*\u0001 \u0016e\u0006$\u000b+\n1E \t \u00061E$E+\u00002E)\u0000$\u0001 \u0017"), objectArray));
        }
        void v3 = a3;
        a4.M(adminReplicationGroup, (String)v3);
        CompetableFutureUtils.d((CompletableFuture)a4.d((String)a5, (String)v3, string3, (boolean)a2, 1), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private static /* synthetic */ boolean d(Collection collection, AdminReplicationGroupMember adminReplicationGroupMember) {
        Collection a2 = adminReplicationGroupMember;
        Collection a3 = collection;
        return a3.contains(a2.getClusterNode().getName());
    }

    @EventListener
    @Order(value=5)
    public void on(ClusterEvents.BecomeLeader becomeLeader) {
        ReplicationGroupChangesHandler a2 = becomeLeader;
        ReplicationGroupChangesHandler a3 = this;
        a3.F.currentTerm(a2.replicationGroup()).ifPresent(arg_0 -> a3.d((ClusterEvents.BecomeLeader)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ CompletionStage d(int n, String string, String string2, Role role, ClusterNode clusterNode, Throwable throwable) {
        void a2;
        Object a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = object;
        Object object = throwable;
        ReplicationGroupChangesHandler a4 = replicationGroupChangesHandler;
        if (ErrorCode.fromException((Throwable)a3).equals((Object)ErrorCode.CONCURRENT_MODIFICATIONS) && a2 > 0) {
            void a5;
            void a6;
            void a7;
            void a8;
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = a4;
            replicationGroupChangesHandler2.A.warn(IndexNotFoundException.d((Object)">\u0018\u007fE7\u00001\u0017<E$\u0001!\f+\u0002e\u000b*\u0001 E>\u0018"), (Object)a8, (Object)a7);
            return replicationGroupChangesHandler2.d((String)a7, (Role)a6, (String)a8, (ClusterNode)a5, (int)(a2 - true));
        }
        return CompletableFuture.failedFuture((Throwable)a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ CompletionStage d(int n, String string, String string2, String string3, boolean bl, Throwable throwable) {
        void a2;
        Object a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = object;
        Object object = throwable;
        ReplicationGroupChangesHandler a4 = replicationGroupChangesHandler;
        if (ErrorCode.fromException((Throwable)a3).equals((Object)ErrorCode.CONCURRENT_MODIFICATIONS) && a2 > 0) {
            void a5;
            void a6;
            void a7;
            void a8;
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = a4;
            replicationGroupChangesHandler2.A.warn(CommandMetricsWebSocket.d((Object)"\u0013DR\u0019\u001a\\\u001cK\u0011\u0019\f\\\u0004\\\u001cP\u0006^HW\u0007]\r\u0019\u0013D"), (Object)a8, (Object)a7);
            return replicationGroupChangesHandler2.d((String)a8, (String)a7, (String)a6, (boolean)a5, (int)(a2 - true));
        }
        return CompletableFuture.failedFuture((Throwable)a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ CompletableFuture<Void> d(String string, Role role, String string2, ClusterNode clusterNode, int n) {
        void a2;
        void a3;
        void a4;
        void a5;
        ReplicationGroupChangesHandler a62;
        void a7;
        ReplicationGroupChangesHandler replicationGroupChangesHandler;
        block3: {
            replicationGroupChangesHandler = this;
            try {
                a62 = (AdminReplicationGroup)replicationGroupChangesHandler.K.findByName((String)a7).orElseThrow(() -> ReplicationGroupChangesHandler.c((String)a7));
                if (!a62.getMemberNames().contains(a5)) break block3;
                replicationGroupChangesHandler.A.info(CommandMetricsWebSocket.d((Object)"\u0013DHX\u0004K\rX\f@HZ\u0007W\u001cX\u0001W\u001b\u0019\u0006V\f\\R\u0019\u0013D"), (Object)a7, (Object)a5);
                return CompletableFuture.completedFuture(null);
            }
            catch (MessagingPlatformException a62) {
                return CompletableFuture.failedFuture(a62);
            }
        }
        ReplicationGroupChangesHandler replicationGroupChangesHandler2 = replicationGroupChangesHandler;
        ReplicationGroupConfiguration.Builder builder = replicationGroupChangesHandler2.d((AdminReplicationGroup)a62);
        String string3 = replicationGroupChangesHandler2.d((String)a5);
        builder.addNodes(NodeInfoWithLabel.newBuilder().setNode(a4.toNodeInfo()).setLabel(string3).setRole((Role)a3));
        return replicationGroupChangesHandler2.a.appendToAdmin(ReplicationGroupConfiguration.class.getName(), builder.build().toByteArray()).exceptionallyCompose(arg_0 -> replicationGroupChangesHandler.d((int)a2, (String)a7, (String)a5, (Role)a3, (ClusterNode)a4, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Void M(String string, String string2, boolean bl, Throwable throwable) {
        void a2;
        void a3;
        void a4;
        Throwable a5;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = throwable2;
        Throwable throwable2 = throwable;
        ReplicationGroupChangesHandler a6 = replicationGroupChangesHandler;
        if (!Status.UNAVAILABLE.getCode().equals((Object)Status.fromThrowable((Throwable)a5).getCode())) {
            if (a5 instanceof RuntimeException) {
                throw (RuntimeException)a5;
            }
            throw new MessagingPlatformException(ErrorCode.OTHER, a5.getMessage(), a5);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = a4;
        objectArray[1] = a3;
        objectArray[2] = Status.fromThrowable((Throwable)a5);
        a6.A.warn(CommandMetricsWebSocket.d((Object)"+V\u001dU\f\u0019\u0006V\u001c\u0019\f\\\u0004\\\u001c\\HK\rI\u0004P\u000bX\u001cP\u0007WH^\u001aV\u001dIHB\u0015\u0019\u000eK\u0007THB\u0015\u0019\u001bM\tM\u001dJHB\u0015\u0015HI\u001d[\u0004P\u001bQ\u0001W\u000f\u0019\u001a\\\u001cK\u0011\u0019\u001cX\u001bR"), objectArray);
        a6.J.publishScheduledTask(RaftAdminGroup.d(), DeleteReplicationGroupTask.class.getName(), (Object)new DeleteReplicationGroupPayload((String)a3, (String)a4, (boolean)a2), Duration.ofSeconds(1L));
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void M(AdminReplicationGroup adminReplicationGroup, String string) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        Object a4 = a3.getMemberNames();
        Collection collection = replicationGroupChangesHandler.K.getNodeNames(RaftAdminGroup.d());
        Object object = a4 = new HashSet(a4);
        object.addAll(collection);
        object.forEach(arg_0 -> replicationGroupChangesHandler.d((AdminReplicationGroup)a3, (String)a2, arg_0));
    }

    private static /* synthetic */ MessagingPlatformException d(String a2) {
        Object[] objectArray = new Object[1];
        objectArray[0] = a2;
        return new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_NOT_FOUND, String.format(IndexNotFoundException.d((Object)"\u0017\u00005\t,\u0006$\u0011,\n+E\"\u0017*\u00105E`\u0016e\u000b*\u0011e\u0003*\u0010+\u0001"), objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(Role role, Set set, Integer n) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler a4;
        Set a5 = set;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = a4 = this;
        int n2 = replicationGroupChangesHandler.K.nrOfNodesInRole((Role)a3, a5);
        Object[] objectArray = new Object[4];
        objectArray[0] = n2;
        objectArray[1] = a3;
        objectArray[2] = a5;
        objectArray[3] = a2;
        replicationGroupChangesHandler.A.debug(IndexNotFoundException.d((Object)"\u001e8E+\n!\u00006E2\f1\re\u0017*\t E>\u0018e\u0003*\u0010+\u0001e\u0012-\f)\u0000e\u00117\u001c,\u000b\"E1\ne\u0004!\u0001e\u001e8Ie\b$\u001de\u0004)\t*\u0012 \u0001e\f6E>\u0018"), objectArray);
        if (n2 + a5.size() > a2.intValue()) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = a5.size();
            objectArray2[1] = a3;
            throw new MessagingPlatformException(ErrorCode.LICENSE_ERROR, String.format(CommandMetricsWebSocket.d((Object)"u\u0001Z\rW\u001b\\H]\u0007\\\u001b\u0019\u0006V\u001c\u0019\tU\u0004V\u001f\u0019\t]\fP\u0006^H\u001c\f\u0019\u0005V\u001a\\HW\u0007]\r\u0011\u001b\u0010HN\u0001M\u0000\u0019\u001aV\u0004\\R\u0019MJ"), objectArray2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(AdminReplicationGroup adminReplicationGroup, String string, String string2) {
        void a2;
        void a3;
        Object a4 = string2;
        ReplicationGroupChangesHandler a5 = this;
        a5.d((String)a4, a3.getName(), (String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(Set<String> set, Role role) {
        void a2;
        ReplicationGroupChangesHandler a3 = role;
        ReplicationGroupChangesHandler a4 = this;
        a4.M.getNrOfNodes((Role)a3).ifPresent(arg_0 -> a4.d((Role)a3, (Set)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(String string2, Collection<ReplicationGroupMember> collection) {
        void a3;
        Object a4 = string2;
        ReplicationGroupChangesHandler a5 = this;
        a5.K.findByName((String)a4).ifPresent(arg_0 -> ReplicationGroupChangesHandler.d((String)a4, arg_0));
        a5.d();
        a4 = new EnumMap(Role.class);
        a3.forEach(arg_0 -> ReplicationGroupChangesHandler.d((Map)a4, arg_0));
        a4.forEach((role, set) -> {
            void a2;
            Object a3 = set;
            ReplicationGroupChangesHandler a4 = this;
            a4.d((Set)a3, (Role)a2);
        });
        a4 = a3.stream().map(ReplicationGroupMember::getNodeName).filter(string -> {
            Object a2 = string;
            ReplicationGroupChangesHandler a3 = this;
            if (a3.I.getNode((String)a2) == null) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
        if (!a4.isEmpty()) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a4;
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, String.format(IndexNotFoundException.d((Object)"\u000b\n!\u0000m\u0016lE`\u0016e\u000b*\u0011e\u0003*\u0010+\u0001"), objectArray));
        }
        if (a3.stream().noneMatch(a2 -> a2.getRole().equals((Object)Role.PRIMARY))) {
            throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_CREATION_NOT_ALLOWED, CommandMetricsWebSocket.d((Object)"w\u0007\u0019\u0018K\u0001T\tK\u0011\u0019\u0006V\f\\\u001b\u0019\u0018K\u0007O\u0001]\r]"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(String string, boolean bl, String string2) {
        void a2;
        void a3;
        Object a4 = string2;
        ReplicationGroupChangesHandler a5 = this;
        a5.a.getRaftGroupServiceForNode((String)a4).deleteReplicationGroup((String)a3, (boolean)a2);
    }

    private /* synthetic */ void d() {
        ReplicationGroupChangesHandler a2;
        a2.M.getMaxReplicationGroups().ifPresent(n -> {
            Integer a2 = n;
            ReplicationGroupChangesHandler a3 = this;
            if (a3.K.count() > a2) {
                throw new MessagingPlatformException(ErrorCode.LICENSE_ERROR, IndexNotFoundException.d((Object)"\b\u0004=\f(\u0010(E+\u0010(\u0007 \u0017e\n#E7\u00005\t,\u0006$\u0011,\n+E\"\u0017*\u00105\u0016e\u0017 \u0004&\r \u0001"));
            }
        });
        a2.M();
    }

    private static /* synthetic */ void d(String string, AdminReplicationGroup adminReplicationGroup) {
        String a2 = adminReplicationGroup;
        String a3 = string;
        Object[] objectArray = new Object[1];
        objectArray[0] = a3;
        throw new MessagingPlatformException(ErrorCode.REPLICATION_GROUP_EXISTS, String.format(CommandMetricsWebSocket.d((Object)"k\rI\u0004P\u000bX\u001cP\u0007WH^\u001aV\u001dIH\u001c\u001b\u0019\tU\u001a\\\t]\u0011\u0019\rA\u0001J\u001cJ"), objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ReplicationGroupConfiguration.Builder d(AdminReplicationGroup adminReplicationGroup) {
        void a2;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        ReplicationGroupChangesHandler a3 = ReplicationGroupConfiguration.newBuilder().setReplicationGroupName(a2.getName());
        a2.getMembers().forEach(arg_0 -> ReplicationGroupChangesHandler.d((ReplicationGroupConfiguration.Builder)a3, (AdminReplicationGroup)a2, arg_0));
        return a3;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(NodeInfo nodeInfo, ClusterNode clusterNode, List list, String string) {
        void a2;
        void a3;
        ReplicationGroupChangesHandler a4 = nodeInfo;
        ReplicationGroupChangesHandler a5 = this;
        AdminReplicationGroup adminReplicationGroup = a5.K.findByName((String)a3).orElse(null);
        if (adminReplicationGroup != null) {
            void a6;
            if (adminReplicationGroup.getMemberNames().contains(a4.getNodeName())) {
                a5.A.info(CommandMetricsWebSocket.d((Object)"B\u0015\u0003Hw\u0007]\r\u0019\u0013DHP\u001b\u0019\tU\u001a\\\t]\u0011\u0019\u0005\\\u0005[\rK"), (Object)adminReplicationGroup, (Object)a4.getNodeName());
                return;
            }
            CompetableFutureUtils.d((CompletableFuture)a5.d(a4.getNodeName(), Role.PRIMARY, (String)a3, (ClusterNode)a6, 1));
            return;
        }
        a5.createReplicationGroup((String)a3, List.of(ReplicationGroupMember.newBuilder().setNodeName(a4.getNodeName()).setPort(a4.getGrpcInternalPort()).setHost(a4.getInternalHostName()).setRole(Role.PRIMARY).build()));
        a2.add(a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(AdminReplicationGroup adminReplicationGroup, String string) throws InterruptedException, ExecutionException {
        void a2;
        void a3;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        Object a4 = replicationGroupChangesHandler.a.getLeader(a3.getName());
        if (a3.getMembers().size() > 1 && a2.equals(a4)) {
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = replicationGroupChangesHandler;
            replicationGroupChangesHandler2.A.info(CommandMetricsWebSocket.d((Object)"\u0013DR\u0019\u0004\\\t]\rKHP\u001b\u0019\u0013D"), (Object)a3, a4);
            replicationGroupChangesHandler2.a.getRaftGroupService(a3.getName()).transferLeadership(a3.getName()).get();
            a4 = replicationGroupChangesHandler.a.getLeader(a3.getName());
            Object object = a4;
            for (int i2 = 25; (object == null || ((String)a4).equals(a2)) && i2 > 0; --i2) {
                Thread.sleep(250L);
                object = a4 = replicationGroupChangesHandler.a.getLeader(a3.getName());
            }
            if (a4 == null || ((String)a4).equals(a2)) {
                throw new MessagingPlatformException(ErrorCode.OTHER, IndexNotFoundException.d((Object)"\b\n3\f+\u0002e\t \u0004!\u00007E1\ne\n1\r \u0017e\u000b*\u0001 E#\u0004,\t \u0001"));
            }
            replicationGroupChangesHandler.A.info(CommandMetricsWebSocket.d((Object)"\u0013DR\u0019\u0004\\\t]\rKHZ\u0000X\u0006^\r]HM\u0007\u0019\u0013D"), (Object)a3, a4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(String string, String string2, String string3) {
        void a2;
        void a3;
        Object a4 = string3;
        ReplicationGroupChangesHandler a5 = this;
        try {
            CompetableFutureUtils.d((CompletableFuture)a5.a.getRaftGroupServiceForNode((String)a3).prepareDeleteNodeFromReplicationGroup((String)a2, (String)a4), (long)1L, (TimeUnit)TimeUnit.SECONDS);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a4;
            objectArray[1] = a2;
            objectArray[2] = a3;
            a5.A.info(CommandMetricsWebSocket.d((Object)".X\u0001U\r]HM\u0007\u0019\u001b\\\u0006]HI\u001a\\E]\rU\rM\r\u0019\u0013DH_\u001aV\u0005\u0019\u0013DHM\u0007\u0019\u0013D"), objectArray);
            return;
        }
    }

    private /* synthetic */ boolean d() {
        ReplicationGroupChangesHandler a2;
        if (a2.K.findAll().findAny().isEmpty() && a2.I.getRemoteConnections().isEmpty()) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Void d(String string, String string2, boolean bl, Throwable throwable) {
        Object a2;
        void a3;
        void a4;
        void a5;
        ReplicationGroupChangesHandler replicationGroupChangesHandler = object;
        Object object = throwable;
        ReplicationGroupChangesHandler a6 = replicationGroupChangesHandler;
        return a6.M((String)a5, (String)a4, (boolean)a3, (Throwable)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ CompletableFuture<Void> d(String string, String string2, String string3, boolean bl, int n) {
        ReplicationGroupChangesHandler replicationGroupChangesHandler = this;
        try {
            void a2;
            void a3;
            void a4;
            void a5;
            void a6;
            ReplicationGroupChangesHandler a7 = (AdminReplicationGroup)replicationGroupChangesHandler.K.findByName((String)a6).orElseThrow(() -> ReplicationGroupChangesHandler.d((String)a6));
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = replicationGroupChangesHandler;
            replicationGroupChangesHandler2.d((AdminReplicationGroup)a7, (String)a5);
            ReplicationGroupConfiguration.Builder builder = replicationGroupChangesHandler2.d((AdminReplicationGroup)a7);
            List<NodeInfoWithLabel> list = builder.getNodesList().stream().filter(arg_0 -> ReplicationGroupChangesHandler.d((String)a4, arg_0)).toList();
            builder.clearNodes();
            builder.addAllNodes(list);
            builder.setPreserveEventstore((boolean)a3);
            return replicationGroupChangesHandler.a.appendToAdmin(ReplicationGroupConfiguration.class.getName(), builder.build().toByteArray()).exceptionallyCompose(arg_0 -> replicationGroupChangesHandler.d((int)a2, (String)a6, (String)a5, (String)a4, (boolean)a3, arg_0));
        }
        catch (InterruptedException a7) {
            Thread.currentThread().interrupt();
            return CompletableFuture.failedFuture(a7);
        }
        catch (Exception a7) {
            return CompletableFuture.failedFuture(a7);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteReplicationGroup(String string, boolean bl) {
        Iterator iterator;
        void a2;
        Object a3 = string;
        ReplicationGroupChangesHandler a4 = this;
        Object object = a3;
        a4.A.info(IndexNotFoundException.d((Object)"\u0001\u0000)\u00001\u0000e\u0017 \u0015)\f&\u00041\f*\u000be\u00027\n0\u0015\u007fE>\u0018"), object);
        if (RaftAdminGroup.d((String)object)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a3;
            throw new MessagingPlatformException(ErrorCode.CANNOT_DELETE_INTERNAL_CONTEXT, String.format(CommandMetricsWebSocket.d((Object)"}\rU\rM\u0001V\u0006\u0019\u0007_HP\u0006M\rK\u0006X\u0004\u0019\u001a\\\u0018U\u0001Z\tM\u0001V\u0006\u0019\u000fK\u0007L\u0018\u0019MJHW\u0007MHX\u0004U\u0007N\r]"), objectArray));
        }
        AdminReplicationGroup adminReplicationGroup = a4.K.findByName((String)a3).orElse(null);
        if (adminReplicationGroup == null) {
            ReplicationGroupChangesHandler replicationGroupChangesHandler = a4;
            replicationGroupChangesHandler.A.warn(IndexNotFoundException.d((Object)"\u0006\n0\t!E+\n1E#\f+\u0001e\u0017 \u0015)\f&\u00041\f*\u000be\u00027\n0\u0015e\u001e8E,\u000be\u0004!\b,\u000be\u0011$\u0007)\u00006Ie\u0016 \u000b!\f+\u0002e\u0001 \t \u0011 7 \u0015)\f&\u00041\f*\u000b\u0002\u0017*\u00105E1\ne\u0004)\te\u000b*\u0001 \u0016"), a3);
            replicationGroupChangesHandler.I.remoteNodeNames().forEach(arg_0 -> a4.d((String)a3, (boolean)a2, arg_0));
            ReplicationGroupChangesHandler replicationGroupChangesHandler2 = a4;
            replicationGroupChangesHandler2.a.getRaftGroupServiceForNode(replicationGroupChangesHandler2.I.getName()).deleteReplicationGroup((String)a3, (boolean)a2);
            return;
        }
        Collection collection = adminReplicationGroup.getMemberNames();
        CompletableFuture[] completableFutureArray = new CompletableFuture[collection.size()];
        int n = 0;
        Iterator iterator2 = iterator = new HashSet(collection).iterator();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator.next();
            completableFutureArray[n] = a4.a.getRaftGroupServiceForNode(string2).deleteReplicationGroup((String)a3, (boolean)a2).exceptionally(arg_0 -> a4.d(string2, (String)a3, (boolean)a2, arg_0));
            CompletableFuture completableFuture = completableFutureArray[n];
            ++n;
            completableFuture.thenAccept(void_ -> {
                String a2 = string2;
                Collection a3 = collection;
                a3.remove(a2);
            });
            iterator2 = iterator;
        }
        CompetableFutureUtils.d((CompletableFuture)CompletableFuture.allOf(completableFutureArray).whenComplete((arg_0, arg_1) -> a4.d((String)a3, collection, adminReplicationGroup, arg_0, arg_1)));
    }
}

