/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.admin.application.api.ApplicationContextRoleRequest;
import io.axoniq.axonserver.admin.application.api.ApplicationRequest;
import io.axoniq.axonserver.configuration.admin.AdminApplication;
import io.axoniq.axonserver.configuration.admin.AdminApplicationContext;
import io.axoniq.axonserver.grpc.ApplicationProtoConverter;
import io.axoniq.axonserver.grpc.internal.Application;
import io.axoniq.axonserver.grpc.internal.ApplicationContextRole;
import io.axoniq.axonserver.rest.ApplicationJSON;
import java.util.List;
import java.util.stream.Collectors;

public class ApplicationProtoConverter {
    public static Application createApplication(AdminApplication adminApplication) {
        AdminApplication adminApplication2 = adminApplication;
        AdminApplication a2 = Application.newBuilder().setName(adminApplication2.getName());
        if (adminApplication2.getDescription() != null) {
            a2.setDescription(adminApplication2.getDescription());
        }
        if (adminApplication2.getHashedToken() != null) {
            a2.setToken(adminApplication2.getHashedToken());
        }
        if (adminApplication2.getTokenPrefix() != null) {
            a2.setTokenPrefix(adminApplication2.getTokenPrefix());
        }
        a2.putAllMetaData(adminApplication2.getMetaDataMap());
        adminApplication2.getContexts().stream().map(ApplicationProtoConverter::createApplicationContextRole).forEach(arg_0 -> ((Application.Builder)a2).addRolesPerContext(arg_0));
        return a2.build();
    }

    public static ApplicationContextRole createApplicationContextRole(ApplicationJSON.ApplicationRoleJSON applicationRoleJSON) {
        ApplicationJSON.ApplicationRoleJSON applicationRoleJSON2 = applicationRoleJSON;
        applicationRoleJSON2.toApplicationRole();
        Object a2 = applicationRoleJSON2.toApplicationRole().getRoles();
        return ApplicationContextRole.newBuilder().setContext(applicationRoleJSON2.getContext()).addAllRoles((Iterable)a2).build();
    }

    public static ApplicationContextRole createApplicationContextRole(AdminApplicationContext adminApplicationContext) {
        AdminApplicationContext adminApplicationContext2 = adminApplicationContext;
        Object a2 = adminApplicationContext2.getRoles();
        return ApplicationContextRole.newBuilder().setContext(adminApplicationContext2.getContext()).addAllRoles((Iterable)a2).build();
    }

    public static Application createApplication(ApplicationRequest applicationRequest) {
        ApplicationRequest applicationRequest2 = applicationRequest;
        ApplicationRequest a2 = Application.newBuilder().setName(applicationRequest2.name());
        if (applicationRequest2.description() != null) {
            a2.setDescription(applicationRequest2.description());
        }
        if (applicationRequest2.token() != null) {
            a2.setToken(applicationRequest2.token());
        }
        applicationRequest2.rolesPerContext().stream().map(ApplicationProtoConverter::createApplicationContextRole).forEach(arg_0 -> ((Application.Builder)a2).addRolesPerContext(arg_0));
        if (applicationRequest2.metaData() != null) {
            a2.putAllMetaData(applicationRequest2.metaData());
        }
        return a2.build();
    }

    public ApplicationProtoConverter() {
        ApplicationProtoConverter a2;
    }

    public static AdminApplicationContext createJpaApplicationContext(ApplicationContextRole a2) {
        return new ReadOnlyAdminApplicationContext(a2.getContext(), (List)a2.getRolesList());
    }

    public static ApplicationContextRole createApplicationContextRole(ApplicationContextRoleRequest applicationContextRoleRequest) {
        ApplicationContextRoleRequest applicationContextRoleRequest2 = applicationContextRoleRequest;
        Object a2 = applicationContextRoleRequest2.roles();
        return ApplicationContextRole.newBuilder().setContext(applicationContextRoleRequest2.context()).addAllRoles((Iterable)a2).build();
    }

    public static Application createApplication(ApplicationJSON applicationJSON) {
        ApplicationJSON applicationJSON2 = applicationJSON;
        ApplicationJSON a2 = Application.newBuilder().setName(applicationJSON2.getName());
        if (applicationJSON2.getDescription() != null) {
            a2.setDescription(applicationJSON2.getDescription());
        }
        if (applicationJSON2.getToken() != null) {
            a2.setToken(applicationJSON2.getToken());
        }
        applicationJSON2.getRoles().stream().map(ApplicationProtoConverter::createApplicationContextRole).forEach(arg_0 -> ((Application.Builder)a2).addRolesPerContext(arg_0));
        if (applicationJSON2.getMetaData() != null) {
            a2.putAllMetaData(applicationJSON2.getMetaData());
        }
        return a2.build();
    }

    public static AdminApplication createJpaApplication(Application application) {
        Application application2 = application;
        Object a2 = application2.getRolesPerContextList().stream().map(ApplicationProtoConverter::createJpaApplicationContext).collect(Collectors.toList());
        return new ReadonlyAdminApplication(application2.getName(), application2.getDescription(), application2.getTokenPrefix(), application2.getToken(), (List)a2, application2.getMetaDataMap());
    }
}

