/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.config.AxonServerRoutingConfiguration;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.CommandService;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcCommandDispatcherListener;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.grpc.SerializedCommandProviderInbound;
import io.axoniq.axonserver.grpc.SerializedCommandResponse;
import io.axoniq.axonserver.grpc.command.CommandProviderOutbound;
import io.axoniq.axonserver.grpc.command.CommandServiceGrpc;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.localstorage.transaction.PreparedTransaction;
import io.axoniq.axonserver.message.ByteStringMarshaller;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.axoniq.axonserver.topology.Topology;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.PreDestroy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service(value="CommandService")
public class CommandService
implements AxonServerClientService {
    private final InstructionAckSource<SerializedCommandProviderInbound> m;
    @Value(value="${axoniq.axonserver.command-threads:1}")
    private int f;
    private final ClientIdRegistry h;
    private static final MethodDescriptor<ByteString, SerializedCommandResponse> e = CommandServiceGrpc.getDispatchMethod().toBuilder((MethodDescriptor.Marshaller)ByteStringMarshaller.d(), ProtoUtils.marshaller((Message)SerializedCommandResponse.getDefaultInstance())).build();
    private final Map<ClientStreamIdentification, GrpcCommandDispatcherListener> l;
    private final ApplicationEventPublisher k;
    private final MeterFactory J;
    private final AuthenticationProvider A;
    private final AxonServerRoutingConfiguration I;
    private final Topology E;
    private static final MethodDescriptor<CommandProviderOutbound, SerializedCommandProviderInbound> M = CommandServiceGrpc.getOpenStreamMethod().toBuilder(ProtoUtils.marshaller((Message)CommandProviderOutbound.getDefaultInstance()), ProtoUtils.marshaller((Message)SerializedCommandProviderInbound.getDefaultInstance())).build();
    private final Logger F;
    private final CommandDispatcher K;
    private final ContextProvider a;

    /*
     * WARNING - void declaration
     */
    public CommandService(Topology topology, CommandDispatcher commandDispatcher, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, MeterFactory meterFactory, ApplicationEventPublisher applicationEventPublisher, @Qualifier(value="commandInstructionAckSource") InstructionAckSource<SerializedCommandProviderInbound> instructionAckSource, AxonServerRoutingConfiguration axonServerRoutingConfiguration) {
        void instructionAckSource2;
        void eventPublisher;
        void meterFactory2;
        void clientIdRegistry2;
        void authenticationProvider2;
        void contextProvider2;
        void commandDispatcher2;
        void topology2;
        CommandService a2;
        CommandService commandService = commandService2;
        CommandService commandService2 = axonServerRoutingConfiguration;
        CommandService commandService3 = a2 = commandService;
        CommandService commandService4 = a2;
        CommandService commandService5 = a2;
        CommandService commandService6 = a2;
        CommandService commandService7 = a2;
        a2.F = LoggerFactory.getLogger(CommandService.class);
        CommandService commandService8 = a2;
        a2.l = new ConcurrentHashMap();
        commandService7.f = 1;
        commandService7.E = topology2;
        commandService6.K = commandDispatcher2;
        commandService6.a = contextProvider2;
        commandService5.A = authenticationProvider2;
        commandService5.h = clientIdRegistry2;
        commandService4.J = meterFactory2;
        commandService4.k = eventPublisher;
        commandService3.m = instructionAckSource2;
        commandService3.I = commandService2;
    }

    private /* synthetic */ boolean d(InstructionAck instructionAck) {
        CommandService a2 = instructionAck;
        CommandService a3 = this;
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }

    public final ServerServiceDefinition bindService() {
        CommandService a2;
        return ServerServiceDefinition.builder((String)PreparedTransaction.d((Object)"\u0010zWt\u0001z\u0017|\b;\u0018m\u0016{\np\u000bc\u001cgWr\u000be\u001a;\u001az\u0014x\u0018{\u001d;:z\u0014x\u0018{\u001dF\u001cg\u000f|\u001ap")).addMethod(M, ServerCalls.asyncBidiStreamingCall(arg_0 -> a2.openStream(arg_0))).addMethod(e, ServerCalls.asyncUnaryCall((arg_0, arg_1) -> a2.dispatch(arg_0, arg_1))).build();
    }

    public Set<GrpcCommandDispatcherListener> listeners() {
        CommandService a2;
        return new HashSet<GrpcCommandDispatcherListener>(a2.l.values());
    }

    /*
     * WARNING - void declaration
     */
    public void completeStreamForInactivity(String string, ClientStreamIdentification clientStreamIdentification) {
        CommandService a2 = clientStreamIdentification;
        CommandService a3 = this;
        if (a3.l.containsKey(a2)) {
            void a4;
            String string2 = "Command stream inactivity for " + a2.d();
            string2 = new ApplicationInactivityException(string2);
            ((GrpcCommandDispatcherListener)a3.l.remove(a2)).cancelAndCompleteStreamExceptionally((Throwable)((Object)string2));
            CommandService commandService = a3;
            commandService.F.debug(PreparedTransaction.d((Object)":z\u0014x\u0018{\u001d5*a\u000bp\u0018xYv\u0015z\np\u001d5\u001fz\u000b5\u001ay\u0010p\u0017aC5\u0002h"), (Object)a2);
            commandService.k.publishEvent((Object)new TopologyEvents.CommandHandlerDisconnected(a2.c(), (String)a4, a2.d()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public StreamObserver<CommandProviderOutbound> openStream(StreamObserver<SerializedCommandProviderInbound> streamObserver) {
        void a2;
        CommandService commandService = this;
        String string = commandService.a.getContext();
        Object a3 = new ConcurrentHashMap();
        1 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        CommandService commandService2 = commandService;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    /*
     * WARNING - void declaration
     */
    public void dispatch(ByteString byteString, StreamObserver<SerializedCommandResponse> streamObserver) {
        void a2;
        CommandService a222 = byteString;
        CommandService a3 = this;
        a222 = new SerializedCommand((ByteString)a222);
        String string = a222.wrapped().getClientId();
        if (a3.F.isTraceEnabled()) {
            a3.F.trace(TransientException.d((Object)"g\u001f&BN\u0007\u007f\u0007u\u0014y\u0006<\u0001s\u000fq\u0003r\u0006&Bg\u001f"), (Object)string, (Object)a222.wrapped().getName());
        }
        try {
            CommandService commandService = a3;
            commandService.K.dispatch(commandService.a.getContext(), (Authentication)a3.A.get(), (SerializedCommand)a222, arg_0 -> a3.d(string, (StreamObserver)a2, arg_0));
            return;
        }
        catch (Exception a222) {
            Exception exception = a222;
            a3.F.warn(PreparedTransaction.d((Object)"=|\ne\u0018a\u001a}\u0010{\u001e5\u001ft\u0010y\u001cqYb\u0010a\u00115\f{\u001cm\tp\u001aa\u001cqYp\u000bg\u0016g"), (Throwable)exception);
            a2.onError((Throwable)GrpcExceptionBuilder.build((Throwable)exception));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(String string, StreamObserver streamObserver, SerializedCommandResponse serializedCommandResponse) {
        void a2;
        void a3;
        CommandService a4 = serializedCommandResponse;
        CommandService a5 = this;
        a5.d((String)a3, (SerializedCommandResponse)a4, (StreamObserver)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(String string, SerializedCommandResponse serializedCommandResponse, StreamObserver<SerializedCommandResponse> streamObserver) {
        CommandService a22 = serializedCommandResponse;
        CommandService a3 = this;
        try {
            void a4;
            void v0 = a4;
            v0.onNext((Object)a22);
            v0.onCompleted();
            return;
        }
        catch (RuntimeException a22) {
            void a5;
            a3.F.debug(TransientException.d((Object)"N\u0007o\u0012s\fo\u0007<\u0016sB\u007f\u000eu\u0007r\u0016<\u0019aBz\u0003u\u000ey\u0006"), (Object)a5, (Object)a22);
            return;
        }
    }

    @PreDestroy
    public void cleanup() {
        CommandService a2;
        a2.l.forEach((clientStreamIdentification, grpcCommandDispatcherListener) -> {
            ClientStreamIdentification a2 = grpcCommandDispatcherListener;
            ClientStreamIdentification a3 = clientStreamIdentification;
            a2.cancel();
        });
        a2.l.clear();
    }
}

