/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.AxonServerAccessController;
import io.axoniq.axonserver.LicenseAccessController;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AuthenticationInterceptor;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.grpc.LicenseInterceptor;
import io.axoniq.axonserver.managed.ManagedAxonServerDiskStatusService;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.rest.SubscriptionQueryMetricRestController;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerTransportFilter;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component(value="Gateway")
public class Gateway
implements SmartLifecycle {
    private final AxonServerAccessController h;
    private final Supplier<ScheduledExecutorService> e;
    private final List<ServerTransportFilter> l;
    private boolean k;
    private final Logger J;
    private final List<AxonServerClientService> A;
    private final LicenseAccessController I;
    private final ExecutorService E;
    private final MessagingPlatformConfiguration M;
    private AdvancedTlsX509KeyManager.Closeable F;
    private final MeterFactory K;
    private Server a;

    public int getPhase() {
        return 200;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        Gateway gateway = this;
        String string = SubscriptionQueryMetricRestController.d((Object)"!.o\u0012\u001c\r");
        try {
            Gateway a2;
            Gateway gateway2;
            if (gateway.M.getSsl() != null && gateway.M.getSsl().isEnabled()) {
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                gateway.F = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile(new File(gateway.M.getSsl().getPrivateKeyFile()), new File(gateway.M.getSsl().getCertChainFile()), 1L, TimeUnit.MINUTES, (ScheduledExecutorService)gateway.e.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                ServerCredentials serverCredentials = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                string = ManagedAxonServerDiskStatusService.d((Object)" \u0006?u\u0016;\u00127\u001f0\u0017");
                Gateway gateway3 = gateway;
                gateway2 = gateway3;
                a2 = NettyServerBuilder.forPort((int)gateway3.M.getPort(), (ServerCredentials)serverCredentials);
            } else {
                Gateway gateway4 = gateway;
                gateway2 = gateway4;
                a2 = NettyServerBuilder.forPort((int)gateway4.M.getPort());
            }
            if (gateway2.M.getMaxMessageSize() > 0) {
                a2.maxInboundMessageSize(gateway.M.getMaxMessageSize());
            }
            a2.permitKeepAliveWithoutCalls(true).permitKeepAliveTime(gateway.M.getMinKeepAliveTime(), TimeUnit.MILLISECONDS);
            gateway.A.forEach(arg_0 -> ((NettyServerBuilder)a2).addService(arg_0));
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(gateway.M.getGrpcBufferedMessages()));
            if (gateway.M.getAccesscontrol().isEnabled()) {
                Gateway gateway5 = gateway;
                a2.intercept((ServerInterceptor)new AuthenticationInterceptor(gateway5.h, gateway5.K));
            }
            a2.intercept((ServerInterceptor)new LicenseInterceptor(gateway.I));
            a2.intercept((ServerInterceptor)new ContextInterceptor());
            if (gateway.M.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(gateway.M.getKeepAliveTime(), TimeUnit.MILLISECONDS).keepAliveTimeout(gateway.M.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.executor((Executor)gateway.E);
            gateway.l.forEach(arg_0 -> ((NettyServerBuilder)a2).addTransportFilter(arg_0));
            gateway.a = a2.build();
            gateway.a.start();
            gateway.J.info(SubscriptionQueryMetricRestController.d((Object)"\u000e9 /o\u0012*39$=a\b ;$8 6a<5.3;$+a /o1 3;{o:2aba4<"), (Object)gateway.M.getPort(), (Object)string);
            gateway.k = true;
            return;
        }
        catch (Exception exception) {
            throw new FailedToStartException(ManagedAxonServerDiskStatusService.d((Object)" !\u0012'\u0007<\u001d2S\u0014\u000b:\u001du 0\u0001#\u0016'S\u0012\u0012!\u0016\"\u0012,S3\u0012<\u001f0\u0017"), (Throwable)exception);
        }
    }

    public boolean isRunning() {
        Gateway a2;
        return a2.k;
    }

    public void stop() {
        Gateway gateway = this;
        if (gateway.F != null) {
            gateway.F.close();
        }
        Gateway gateway2 = gateway;
        gateway2.E.shutdown();
        if (gateway2.k) {
            try {
                if (!gateway.a.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                    Gateway gateway3 = gateway;
                    gateway3.J.debug(ManagedAxonServerDiskStatusService.d((Object)"\u0013\u001c'\u00100\u0015 \u001f9\nu\u0000!\u001c%\u0003<\u001d2S\u0016\u001f \u0000!\u0016'S\u0006\u0016'\u00050\u0001"));
                    gateway3.a.shutdownNow();
                }
            }
            catch (InterruptedException a2) {
                gateway.J.debug(SubscriptionQueryMetricRestController.d((Object)"\u0006/;$=3:1;$+a+4=(!&o2'4;% 6!a 'o\u0006\u001d\u0011\fa<$=7*3"), (Throwable)a2);
                Thread.currentThread().interrupt();
            }
        }
        gateway.k = false;
        gateway.J.info(ManagedAxonServerDiskStatusService.d((Object)"2-\u001c;S\u0006\u0016'\u00050\u0001u44\u00070\u00044\nu\u0000!\u001c%\u00030\u0017"));
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, Supplier<ScheduledExecutorService> supplier, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        Gateway a9;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway gateway3 = a9 = gateway;
        Gateway gateway4 = a9;
        Gateway gateway5 = a9;
        Gateway gateway6 = a9;
        gateway6.J = LoggerFactory.getLogger(Gateway.class);
        gateway6.M = a8;
        gateway5.A = a7;
        gateway5.l = a6;
        gateway4.h = a5;
        gateway4.I = a4;
        a9.e = a3;
        gateway3.K = a2;
        gateway3.E = Executors.newFixedThreadPool(a9.M.getExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(SubscriptionQueryMetricRestController.d((Object)"(3?\"b$7$,4;.=l")));
    }

    /*
     * WARNING - void declaration
     */
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway a8 = gateway;
        a8((MessagingPlatformConfiguration)a7, (List)a6, (List)a5, (AxonServerAccessController)a4, (LicenseAccessController)a3, Executors::newSingleThreadScheduledExecutor, (MeterFactory)a2);
    }

    public boolean isAutoStartup() {
        return true;
    }
}

