/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc.heartbeat;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.grpc.ClientContext;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.grpc.Publisher;
import io.axoniq.axonserver.grpc.control.Heartbeat;
import io.axoniq.axonserver.grpc.control.PlatformInboundInstruction;
import io.axoniq.axonserver.grpc.control.PlatformOutboundInstruction;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatMonitor;
import io.axoniq.axonserver.grpc.heartbeat.HeartbeatPublisher;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.rest.json.UserInfo;
import io.axoniq.axonserver.util.ObjectUtils;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"axoniq.axonserver.heartbeat.enabled"})
public class HeartbeatMonitor {
    private final Clock A;
    private final long I;
    private final Map<ClientStreamIdentification, Instant> E;
    private final Map<ClientStreamIdentification, ClientInformation> M;
    private final ApplicationEventPublisher F;
    private final Logger K;
    private final Publisher<PlatformOutboundInstruction> a;

    @EventListener
    public void on(TopologyEvents.ApplicationConnected applicationConnected) {
        HeartbeatMonitor a2 = applicationConnected;
        HeartbeatMonitor a3 = this;
        ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a2.m(), a2.d());
        a3.M.put(clientStreamIdentification, new ClientInformation(a2.j(), a2.M(), a2.m()));
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-initial-delay:5000}", fixedRateString="${axoniq.axonserver.client-heartbeat-frequency:500}")
    public void sendHeartbeat() {
        HeartbeatMonitor a2;
        a2.a.publish((Object)PlatformOutboundInstruction.newBuilder().setHeartbeat(Heartbeat.newBuilder()).build());
    }

    /*
     * WARNING - void declaration
     */
    @Autowired
    public HeartbeatMonitor(PlatformService platformService, HeartbeatPublisher heartbeatPublisher, ApplicationEventPublisher applicationEventPublisher, @Value(value="${axoniq.axonserver.client-heartbeat-timeout:5000}") long l2) {
        void a2;
        void heartbeatPublisher2;
        void platformService2;
        HeartbeatMonitor heartbeatMonitor = heartbeatMonitor2;
        HeartbeatMonitor heartbeatMonitor2 = applicationEventPublisher;
        HeartbeatMonitor eventPublisher = heartbeatMonitor;
        eventPublisher(arg_0 -> HeartbeatMonitor.d((PlatformService)platformService2, arg_0), (ApplicationEventPublisher)heartbeatMonitor2, (Publisher)heartbeatPublisher2, (long)a2, Clock.systemUTC());
    }

    /*
     * WARNING - void declaration
     */
    public HeartbeatMonitor(Consumer<BiConsumer<ClientStreamIdentification, PlatformInboundInstruction>> consumer, ApplicationEventPublisher applicationEventPublisher, Publisher<PlatformOutboundInstruction> publisher, long l2, Clock clock) {
        void a2;
        void a3;
        void a4;
        Object a5;
        void a6;
        HeartbeatMonitor heartbeatMonitor = object;
        Object object = clock;
        HeartbeatMonitor a7 = heartbeatMonitor;
        a7.K = LoggerFactory.getLogger(HeartbeatMonitor.class);
        HeartbeatMonitor heartbeatMonitor2 = a7;
        a7.M = new ConcurrentHashMap();
        HeartbeatMonitor heartbeatMonitor3 = a7;
        heartbeatMonitor2.E = new ConcurrentHashMap();
        a6.accept((clientStreamIdentification, platformInboundInstruction) -> {
            HeartbeatMonitor a2;
            HeartbeatMonitor a3 = clientStreamIdentification;
            HeartbeatMonitor heartbeatMonitor = a2 = this;
            heartbeatMonitor.K.trace(UserInfo.d((Object)"*Z\u0003M\u0016}\u0007^\u0016\u001f\u0010Z\u0001Z\u000bI\u0007[BY\u0010P\u000f\u001f\u0019B"), (Object)a3);
            heartbeatMonitor.E.put(a3, Instant.now(a2.A));
        });
        HeartbeatMonitor heartbeatMonitor4 = a7;
        HeartbeatMonitor heartbeatMonitor5 = a7;
        heartbeatMonitor5.A = a5;
        heartbeatMonitor5.F = a4;
        heartbeatMonitor4.I = a3;
        heartbeatMonitor4.a = a2;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(Instant instant, ClientStreamIdentification clientStreamIdentification, Instant instant2) {
        void a2;
        void a3;
        HeartbeatMonitor a4 = clientStreamIdentification;
        HeartbeatMonitor a5 = this;
        if (a3.isBefore((Instant)a2) && a5.M.containsKey(a4)) {
            ClientInformation clientInformation = (ClientInformation)a5.M.get(a4);
            String string = clientInformation.a;
            String string2 = clientInformation.F;
            Object[] objectArray = new Object[4];
            objectArray[0] = a5.I;
            objectArray[1] = a4;
            objectArray[2] = a3;
            objectArray[3] = a2;
            a5.K.info(ObjectUtils.d((Object)"7`\u001di\u001axTe\u001am\u0017x\u001dz\u001dx\r,\u0010i\u0000i\u0017x\u0011hTj\u001b~Ta\u001b~\u0011,\u0000d\u0015bTw\t,\u0019e\u0018`\u001d\u007f\u0011o\u001bb\u0010\u007fZ,7`\u001di\u001axN,\u000fqX,\u0018m\u0007x5o\u0000e\u0002e\u0000uN,\u000fqX,\u0000e\u0019i\u001by\u00006Tw\t\"T"), objectArray);
            a5.F.publishEvent((Object)new TopologyEvents.ApplicationInactivityTimeout((ClientStreamIdentification)a4, string, new ClientContext(string2, clientInformation.K)));
        }
    }

    private static /* synthetic */ void d(PlatformService platformService, BiConsumer biConsumer) {
        Object a2 = biConsumer;
        PlatformService a3 = platformService;
        a3.onInboundInstruction(PlatformInboundInstruction.RequestCase.HEARTBEAT, (arg_0, arg_1) -> HeartbeatMonitor.d((BiConsumer)a2, arg_0, arg_1));
    }

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        HeartbeatMonitor a2 = applicationDisconnected;
        HeartbeatMonitor a3 = this;
        a2 = new ClientStreamIdentification(a2.m(), a2.c());
        a3.E.remove(a2);
        a3.M.remove(a2);
        a3.K.debug(UserInfo.d((Object)"1K\rOBR\rQ\u000bK\rM\u000bQ\u0005\u001f\nZ\u0003M\u0016]\u0007^\u0016\u001f\u0004P\u0010\u001f\u0001S\u000bZ\fKBD\u001f\u0011"), (Object)a2);
    }

    @Scheduled(initialDelayString="${axoniq.axonserver.client-heartbeat-check-initial-delay:10000}", fixedRateString="${axoniq.axonserver.client-heartbeat-check-rate:1000}")
    public void checkClientsStillAlive() {
        HeartbeatMonitor heartbeatMonitor;
        HeartbeatMonitor heartbeatMonitor2 = heartbeatMonitor = this;
        heartbeatMonitor2.K.debug(ObjectUtils.d((Object)"7d\u0011o\u001fe\u001akTo\u001bb\u001ai\u0017x\u0011hTo\u0018e\u0011b\u0000\u007fTm\u0006iT\u007f\u0000e\u0018`Tm\u0018e\u0002iZ\"Z"));
        HeartbeatMonitor heartbeatMonitor3 = heartbeatMonitor;
        Object a2 = Instant.now(heartbeatMonitor2.A).minus(heartbeatMonitor3.I, ChronoUnit.MILLIS);
        heartbeatMonitor3.E.forEach((arg_0, arg_1) -> heartbeatMonitor.d((Instant)a2, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void d(BiConsumer biConsumer, PlatformService.ClientComponent clientComponent, PlatformInboundInstruction platformInboundInstruction) {
        void a2;
        BiConsumer a3 = clientComponent;
        BiConsumer a4 = biConsumer;
        a4.accept(new ClientStreamIdentification(a3.getContext(), a3.getClientStreamId()), a2);
    }
}

