/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.applicationevents.UserEvents;
import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.file.AbstractFileStorageTier;
import io.axoniq.axonserver.localstorage.file.ByteBufferEventSource;
import io.axoniq.axonserver.localstorage.file.EmbeddedDBProperties;
import io.axoniq.axonserver.localstorage.file.EventInformation;
import io.axoniq.axonserver.localstorage.file.EventSource;
import io.axoniq.axonserver.localstorage.file.FilePreparedTransaction;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.Segment;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.StorageTier;
import io.axoniq.axonserver.localstorage.file.Synchronizer;
import io.axoniq.axonserver.localstorage.file.WritableEventSource;
import io.axoniq.axonserver.localstorage.file.WritePosition;
import io.axoniq.axonserver.localstorage.file.a;
import io.axoniq.axonserver.localstorage.transformation.EventTransformer;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.localstorage.transformation.ProcessedEvent;
import io.axoniq.axonserver.localstorage.transformation.WrappedEvent;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WritableFileStorageTier
extends AbstractFileStorageTier {
    private final FileSystemMonitor k;
    protected final AtomicReference<WritePosition> J;
    private final Gauge A;
    private final EventTransformer I;
    protected final AtomicLong E;
    private final MeterFactory M;
    private final Synchronizer F;
    protected final ConcurrentNavigableMap<Long, ByteBufferEventSource> K;
    private Path a;
    private static final Logger h = LoggerFactory.getLogger(WritableFileStorageTier.class);

    /*
     * WARNING - void declaration
     */
    public void c(long l2) {
        void a22;
        WritableFileStorageTier writableFileStorageTier = this;
        if (!writableFileStorageTier.K.containsKey((long)a22)) {
            return;
        }
        if (a22 == ((Long)writableFileStorageTier.K.firstKey()).longValue()) {
            h.info(EmbeddedDBProperties.d((Object)".bo?\u0013p'|<q2?;z-kul0x8z;kuk:?7zu|'z4k0{"), (Object)writableFileStorageTier.L);
            StorageProperties a22 = (StorageProperties)writableFileStorageTier.B.get();
            WritePosition writePosition2 = (WritePosition)writableFileStorageTier.J.getAndUpdate(writePosition -> {
                StorageProperties a2 = writePosition;
                StorageProperties a3 = a22;
                return a2.d(0, a3.getSegmentSize(), 0);
            });
            if (writePosition2.d(a22.getSegmentSize())) {
                h.debug(UserEvents.d((Object)"\u000f]N\u00007R\u0011A\u0000I\u001aGTN\u0011WTS\u0011G\u0019E\u001aTT[\t"), (Object)writableFileStorageTier.L, (Object)writePosition2.a);
                WritePosition writePosition3 = writePosition2;
                writePosition3.I.d(writePosition3.J, -1);
                WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier;
                WritableFileStorageTier a3 = writableFileStorageTier2.d(new FileVersion(writePosition2.a, 0), a22.getSegmentSize(), false);
                writableFileStorageTier.J.set(writePosition2.d((WritableEventSource)a3, 0));
                writableFileStorageTier2.F.M(new WritePosition(writePosition2.a, 0, 0, (WritableEventSource)a3, Long.valueOf(writePosition2.a), writePosition2.F));
            }
        }
        writableFileStorageTier.d();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FilePreparedTransaction d(List<Event> list, int n) {
        void a22;
        Object a3 = list;
        WritableFileStorageTier a4 = this;
        a3 = a3.stream().map(event -> {
            WritableFileStorageTier a2 = event;
            WritableFileStorageTier a3 = this;
            return new WrappedEvent((Event)a2, a3.I);
        }).collect(Collectors.toList());
        WritableFileStorageTier writableFileStorageTier = a4;
        int n2 = writableFileStorageTier.d((List)a3);
        WritePosition a22 = writableFileStorageTier.d(n2, a3.size(), (int)a22);
        return new FilePreparedTransaction(a22, n2, (List)a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ WritePosition d(int n, int n2, int n3) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        int n4 = (int)Math.ceil((double)a3 / 32767.0);
        if ((n4 = a4 + n4 * 11) > 0x7FFFFFF6 || a4 <= 0) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a4;
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, String.format(EmbeddedDBProperties.d((Object)"\u001cs9z2~9?!m4q&~6k<p;?&v/zo?p{"), objectArray));
        }
        do {
            if (!(a4 = (WritePosition)a5.J.getAndUpdate(arg_0 -> WritableFileStorageTier.d((int)a3, n4, (int)a2, arg_0))).d(n4) && !a4.c((int)a2)) continue;
            h.debug(UserEvents.d((Object)"\u000f]N\u00007R\u0011A\u0000I\u001aGTN\u0011WTS\u0011G\u0019E\u001aTT[\t"), (Object)a5.L, (Object)a4.a);
            WritePosition writePosition = a4;
            writePosition.I.d(writePosition.J, -1);
            WritableEventSource writableEventSource = a5.d(new FileVersion(a4.a, (int)a2), n4 + 5 + 4, true);
            a5.J.set(a4.d(writableEventSource, (int)a2));
        } while (!a4.M(n4) || a4.c((int)a2));
        return a4;
    }

    public void handover(Segment segment, Runnable runnable) {
        Runnable a2 = runnable;
        WritableFileStorageTier a3 = this;
        a2.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ FileVersion d(FileVersion fileVersion, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        WritableEventSource a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier2 = this;
        if (!writableFileStorageTier2.D.validIndex((FileVersion)a3)) {
            return a3;
        }
        a2 = writableFileStorageTier2.d((FileVersion)a3, a2.getSegmentSize(), false);
        long l2 = a3.d();
        try {
            WritableFileStorageTier a42222 = a2.createEventIterator(a3.d());
            try {
                while (a42222.hasNext()) {
                    a42222.d();
                    ++l2;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (a42222 != null) {
                    try {
                        a42222.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable a42222) {
                        throwable.addSuppressed(a42222);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        catch (Throwable a42222) {
            writableFileStorageTier2.K.remove(a3.d());
            a2.d(0L);
            throw a42222;
        }
        if (a42222 != null) {
            writableFileStorageTier = writableFileStorageTier2;
            a42222.close();
        } else {
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.K.remove(a3.d());
        a2.d(0L);
        return new FileVersion(l2, 0);
    }

    private static /* synthetic */ Boolean d(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.removeSegment(a2, a4);
    }

    private static /* synthetic */ Optional M(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    public SortedSet<FileVersion> segmentsWithoutIndex() {
        WritableFileStorageTier a2;
        return (SortedSet)a2.d(StorageTier::segmentsWithoutIndex, Collections.emptySortedSet());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(long l2, File file, long l3, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        int n;
        WritableFileStorageTier a3;
        HashMap<String, List> a222;
        WritableEventSource a4;
        FileVersion a5;
        long a6;
        WritableFileStorageTier writableFileStorageTier2;
        block10: {
            block8: {
                void a222;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier2 = this;
                a5 = writableFileStorageTier3.d(a6, (File)a5, new FileVersion((long)a222, 0), (StorageProperties)a4);
                writableFileStorageTier3.d(a5.d());
                a5 = writableFileStorageTier3.d(a5, (StorageProperties)a4);
                writableFileStorageTier3.d((T storageTier) -> {
                    FileVersion a2 = storageTier;
                    FileVersion a3 = a5;
                    a2.initSegments(a3.d());
                });
                WritableFileStorageTier writableFileStorageTier4 = writableFileStorageTier2;
                writableFileStorageTier4.M();
                a4 = writableFileStorageTier4.d(a5, a4.getSegmentSize(), false);
                writableFileStorageTier4.D.remove(a5);
                a6 = a5.d();
                a222 = new HashMap<String, List>();
                a3 = a4.createEventIterator();
                try {
                    WritableFileStorageTier writableFileStorageTier5 = a3;
                    while (writableFileStorageTier5.hasNext()) {
                        EventInformation eventInformation = a3.d();
                        if (eventInformation.d()) {
                            IndexEntry indexEntry = new IndexEntry(eventInformation.d().getAggregateSequenceNumber(), eventInformation.d(), a6);
                            a222.computeIfAbsent(eventInformation.d().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                        }
                        ++a6;
                        writableFileStorageTier5 = a3;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (a3 != null) {
                            try {
                                a3.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                n = a3.d();
                writableFileStorageTier2.E.set(a6 - 1L);
                if (a3 == null) break block8;
                writableFileStorageTier = writableFileStorageTier2;
                a3.close();
                break block10;
            }
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.D.addToActiveSegment(Long.valueOf(a5.d()), a222);
        a4.d(n, 0);
        a3 = new WritePosition(a6, n, a5.d(), a4, Long.valueOf(a5.d()), 0);
        WritableFileStorageTier writableFileStorageTier6 = writableFileStorageTier2;
        writableFileStorageTier6.J.set(a3);
        writableFileStorageTier6.F.d((WritePosition)a3);
        h.info(EmbeddedDBProperties.d((Object)".bo?\u0006z2r0q!luv;v!v4s<e0{"), (Object)writableFileStorageTier2.L);
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.d((long)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.d(arg_0 -> WritableFileStorageTier.d((long)a2, arg_0), Optional.empty());
    }

    protected Optional<EventSource> d(FileVersion fileVersion) {
        WritableFileStorageTier a2 = fileVersion;
        WritableFileStorageTier a3 = this;
        return a3.d(a2.d());
    }

    private static /* synthetic */ Optional d(long a2, StorageTier a3) {
        return a3.eventSource(a2);
    }

    private static /* synthetic */ Flux d(String string, StorageTier storageTier) {
        String a2 = storageTier;
        String a3 = string;
        return a2.fileVersions(a3);
    }

    public int d() {
        WritableFileStorageTier a2;
        return a2.K.size();
    }

    public long c() {
        WritableFileStorageTier a2;
        return a2.E.get();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ WritePosition d(int n, int n2, int n3, WritePosition writePosition) {
        void a2;
        void a3;
        WritePosition a4 = writePosition;
        int a5 = n;
        return a4.d(a5, (int)a3, (int)a2);
    }

    private static /* synthetic */ Stream M(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(WritePosition writePosition, StorageTier storageTier) {
        void a2;
        WritableFileStorageTier a3 = writePosition;
        WritableFileStorageTier a4 = this;
        a2.handover((Segment)new a(a4, (WritePosition)a3), () -> a4.d((WritePosition)a3));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(WritePosition writePosition) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.K.remove(a2.M);
        h.debug(EmbeddedDBProperties.d((Object)"\u001d~;{0{up#z'?.by?'z8~<q<q2?&z2r0q!lo?.b"), (Object)a2.M, (Object)writableFileStorageTier.getSegments());
        if (a3 != null) {
            a3.d((long)((StorageProperties)writableFileStorageTier.B.get()).getPrimaryCleanupDelay());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void M(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)writableFileStorageTier.K.remove((long)a2);
        int a3 = 0;
        if (byteBufferEventSource != null) {
            ByteBufferEventSource byteBufferEventSource2 = byteBufferEventSource;
            a3 = byteBufferEventSource2.d();
            byteBufferEventSource2.d(0L);
        }
        writableFileStorageTier.d((long)a2, a3).forEach(arg_0 -> writableFileStorageTier.d((long)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public WritableFileStorageTier(EventTypeContext eventTypeContext, IndexManager indexManager, Supplier<StorageProperties> supplier, Supplier<StorageTier> supplier2, MeterFactory meterFactory, ScheduledExecutorService scheduledExecutorService, String string, EventTransformerFactory eventTransformerFactory, FileSystemMonitor fileSystemMonitor) {
        void a2;
        void a3;
        void a4;
        void a5;
        WritableFileStorageTier a6;
        void a7;
        void a8;
        void a9;
        void a10;
        WritableFileStorageTier a11;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = meterFactory;
        WritableFileStorageTier writableFileStorageTier3 = a11 = writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier4 = a11;
        super((EventTypeContext)a10, (IndexManager)a9, (Supplier)a8, (Supplier)a7, (MeterFactory)a6, (String)a5);
        WritableFileStorageTier writableFileStorageTier5 = a11;
        writableFileStorageTier5.J = new AtomicReference();
        WritableFileStorageTier writableFileStorageTier6 = a11;
        writableFileStorageTier4.E = new AtomicLong(-1L);
        WritableFileStorageTier writableFileStorageTier7 = a11;
        writableFileStorageTier4.K = new ConcurrentSkipListMap(Comparator.reverseOrder());
        writableFileStorageTier4.M = a6;
        writableFileStorageTier3.k = a4;
        writableFileStorageTier3.I = a3.get(((StorageProperties)a8.get()).getFlags());
        WritableFileStorageTier writableFileStorageTier8 = a11;
        writableFileStorageTier8.F = new Synchronizer((EventTypeContext)a10, (StorageProperties)a8.get(), (MeterFactory)a6, (ScheduledExecutorService)a2, writePosition -> {
            WritableFileStorageTier a2;
            WritableFileStorageTier a3 = writePosition;
            WritableFileStorageTier writableFileStorageTier = a2 = this;
            writableFileStorageTier.D.complete(new FileVersion(a3.M.longValue(), 0));
            writableFileStorageTier.d(arg_0 -> writableFileStorageTier.d((WritePosition)a3, arg_0));
        });
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a10.d();
        stringArray[2] = "type";
        stringArray[3] = a10.d().name();
        a11.A = a6.gauge((MetricName)BaseMetricName.ba, Tags.of((String[])stringArray), (Object)a11.F, synchronizer -> {
            WritableFileStorageTier a2 = synchronizer;
            WritableFileStorageTier a3 = this;
            return (double)a3.E.get() - (double)a2.d();
        });
    }

    private /* synthetic */ void M() {
        WritableFileStorageTier writableFileStorageTier = this;
        Object a2 = writableFileStorageTier.segmentsWithoutIndex();
        if (a2.size() > 0) {
            writableFileStorageTier.d((SortedSet)a2);
        }
        h.info(UserEvents.d((Object)"\u000f]N\u0000=N\u0010E\f\u0000\u001bNTD\u001dS\u001f\u0000\u001dSTU\u0004\u0000\u0000OTD\u0015T\u0011"), (Object)writableFileStorageTier.L);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean d(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.K.remove((long)a2);
        if (byteBufferEventSource != null) {
            byteBufferEventSource.d(0L);
        }
        if (a4.D.remove(a3 = new FileVersion((long)a2, a3)) && FileUtils.d((File)a4.M(a3))) {
            return true;
        }
        return false;
    }

    private /* synthetic */ void d() {
        WritableFileStorageTier writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier = this;
        while (true) {
            if (writableFileStorageTier2.K.size() == 1) break;
            try {
                Thread.sleep(10L);
                writableFileStorageTier2 = writableFileStorageTier;
            }
            catch (InterruptedException a2) {
                Thread.currentThread().interrupt();
                throw new MessagingPlatformException(ErrorCode.OTHER, writableFileStorageTier.L + ": Interrupted while waiting for completion", (Throwable)a2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FileVersion d(long l2, File file, FileVersion fileVersion, StorageProperties storageProperties) {
        void a2;
        void a3;
        WritableFileStorageTier a4;
        void a5;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = storageProperties;
        WritableFileStorageTier a6 = writableFileStorageTier;
        return Arrays.stream(FileUtils.d((File)a5, (String)a4.getEventsSuffix())).map(FileUtils::d).filter(arg_0 -> WritableFileStorageTier.d((long)a3, arg_0)).max(FileVersion::d).orElse((FileVersion)a2);
    }

    protected Optional<EventSource> d(long a2) {
        WritableFileStorageTier a3;
        if (a3.K.containsKey(a2)) {
            return Optional.of((EventSource)a3.K.get(a2));
        }
        return Optional.empty();
    }

    private /* synthetic */ void d(SortedSet<FileVersion> sortedSet) {
        SortedSet<FileVersion> a2 = sortedSet;
        WritableFileStorageTier a3 = this;
        h.warn(EmbeddedDBProperties.d((Object)"d(%u] s>26m0~!v;xuv;{0guz;k'v0luy:mud(?&z2r0q!l"), (Object)a3.L, (Object)a2.size());
        Instant instant = Instant.now();
        if (a3.D.canBatchIndexParallel() && ((StorageProperties)a3.B.get()).isBulkIndexAllowParallel()) {
            h.info(UserEvents.d((Object)"[\t\u001aTi\u001aD\u0011X\u001dN\u0013\u0000\u0003I\u0000HTP\u0015R\u0015L\u0018E\u0018\u0000\u0007U\u0004P\u001bR\u0000"), (Object)a3.L);
            a2.parallelStream().forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.d(arg_0 -> WritableFileStorageTier.d((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.d());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.d();
                        if (!eventInformation.d()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.d().getAggregateSequenceNumber(), eventInformation.d(), eventInformation.d());
                        hashMap.computeIfAbsent(eventInformation.d().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.D.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        } else {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.L;
            objectArray[1] = a3.D.canBatchIndexParallel();
            objectArray[2] = ((StorageProperties)a3.B.get()).isBulkIndexAllowParallel();
            h.info(EmbeddedDBProperties.d((Object)"d(%uV;{0g<q2?&z$j0q!v4s9fu7\u0010i4s ~!v:qup3?%~'~9s0suv;{0g<q2%uv;{0g\u0016~%~7v9v!v0lod(?s9u|:q!z-k\u0006z!k<q2lod(6"), objectArray);
            a2.forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.d(arg_0 -> WritableFileStorageTier.d((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.d());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.d();
                        if (!eventInformation.d()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.d().getAggregateSequenceNumber(), eventInformation.d(), eventInformation.d());
                        hashMap.computeIfAbsent(eventInformation.d().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.D.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        }
        h.warn(UserEvents.d((Object)"\u000f]N\u00006U\u0018KYC\u0006E\u0015T\u001dN\u0013\u0000\u001dN\u0010E\f\u0000\u0000O\u001bKT[\t"), (Object)a3.L, (Object)Duration.between(instant, Instant.now()));
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    protected WritableEventSource d(FileVersion fileVersion, int n, boolean bl) {
        WritableEventSource a2322;
        Object a32222;
        Object object;
        void a4;
        WritableFileStorageTier writableFileStorageTier;
        block21: {
            void a223322;
            writableFileStorageTier = this;
            StorageProperties storageProperties = (StorageProperties)writableFileStorageTier.B.get();
            File file = storageProperties.dataFile(writableFileStorageTier.K, (FileVersion)a4);
            int n2 = Math.max(storageProperties.getSegmentSize(), (int)a223322);
            if (file.exists()) {
                void a2322;
                if (a2322 != false && file.length() < (long)a223322) {
                    object = (ByteBufferEventSource)writableFileStorageTier.K.remove(a4.d());
                    if (object != null) {
                        object.d(0L);
                    }
                    FileUtils.d((File)file);
                } else {
                    n2 = (int)file.length();
                }
            } else if (a4.d() > 0) {
                object = storageProperties.dataFile(writableFileStorageTier.K, new FileVersion(a4.d(), 0));
                if (((File)object).exists()) {
                    a32222 = (ByteBufferEventSource)writableFileStorageTier.K.remove(a4.d());
                    if (a32222 != null) {
                        a32222.d(0L);
                    }
                    FileUtils.d((File)object);
                }
            }
            object = new RandomAccessFile(file, EmbeddedDBProperties.d((Object)"'h"));
            a32222 = ((RandomAccessFile)object).getChannel();
            h.info(UserEvents.d((Object)"\u000f]N\u0000;P\u0011N\u001dN\u0013\u0000\u0012I\u0018ET[\t"), (Object)writableFileStorageTier.L, (Object)file);
            MappedByteBuffer mappedByteBuffer = ((FileChannel)a32222).map(FileChannel.MapMode.READ_WRITE, 0L, n2);
            mappedByteBuffer.put((byte)2);
            mappedByteBuffer.putInt(storageProperties.getFlags());
            WritableEventSource a223322 = new WritableEventSource(file.getAbsolutePath(), (ByteBuffer)mappedByteBuffer, a4.d(), a4.d(), writableFileStorageTier.I, storageProperties);
            writableFileStorageTier.K.put(a4.d(), a223322);
            a2322 = a223322;
            if (a32222 == null) break block21;
            ((AbstractInterruptibleChannel)a32222).close();
        }
        ((RandomAccessFile)object).close();
        return a2322;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Throwable throwable2;
                        block22: {
                            if (a32222 != null) {
                                try {
                                    ((AbstractInterruptibleChannel)a32222).close();
                                    throwable2 = throwable;
                                    break block22;
                                }
                                catch (Throwable a223322) {
                                    throwable.addSuppressed(a223322);
                                }
                            }
                            throwable2 = throwable;
                        }
                        throw throwable2;
                    }
                    catch (Throwable a32222) {
                        Throwable throwable3;
                        try {
                            ((RandomAccessFile)object).close();
                            throwable3 = a32222;
                        }
                        catch (Throwable throwable4) {
                            Throwable throwable5 = a32222;
                            throwable3 = throwable5;
                            throwable5.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Exception exception) {
                    throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, writableFileStorageTier.L + ": Failed to create segment: " + (FileVersion)a4, (Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void d(long l2, long l3) {
        void a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a4 = (StorageProperties)writableFileStorageTier.B.get();
        File file = new File(writableFileStorageTier.K);
        FileUtils.d((File)file);
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
        writableFileStorageTier.D.init();
        writableFileStorageTier2.d((long)a3, file, (long)a2, (StorageProperties)a4);
        writableFileStorageTier2.a = file.toPath();
        writableFileStorageTier2.k.registerPath(writableFileStorageTier.d(), writableFileStorageTier.a, a4.minFreeSpace(), a4.warnFreeSpace());
    }

    private static /* synthetic */ boolean d(long a2, FileVersion a3) {
        if (a3.d() < a2) {
            return true;
        }
        return false;
    }

    private static /* synthetic */ void d(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        a3.activateSegmentVersion(a2, a4);
    }

    public void initSegments(long a2) {
    }

    private /* synthetic */ String d() {
        WritableFileStorageTier a2;
        WritableFileStorageTier writableFileStorageTier = a2;
        return writableFileStorageTier.L + "-" + writableFileStorageTier.L.d().name().toLowerCase();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(ProcessedEvent processedEvent, long l2, int n, Map<String, List<IndexEntry>> map) {
        WritableFileStorageTier a3 = processedEvent;
        WritableFileStorageTier a4 = this;
        if (a3.isDomainEvent()) {
            void a5;
            void a6;
            void a7;
            a7.computeIfAbsent(a3.getAggregateIdentifier(), a2 -> new ArrayList()).add(new IndexEntry(a3.getAggregateSequenceNumber(), (int)a6, (long)a5));
        }
    }

    public long size() {
        WritableFileStorageTier a3;
        return a3.K.values().stream().mapToLong(a2 -> a2.J.capacity()).sum() + (Long)a3.d(StorageTier::size, (Object)0L);
    }

    public long d(List<Event> list, int n) {
        FilePreparedTransaction a2;
        WritableFileStorageTier a3;
        int a222 = n;
        WritableFileStorageTier writableFileStorageTier = a3 = this;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.k.checkFreeSpace(writableFileStorageTier2.a);
        HashMap hashMap = new HashMap();
        a2 = writableFileStorageTier.d((List)a2, a222);
        WritePosition a222 = a2.d();
        writableFileStorageTier2.d(a222, a2.d(), hashMap);
        writableFileStorageTier.D.addToActiveSegment(a222.M, hashMap);
        writableFileStorageTier.E.set(a222.a + (long)a2.d().size() - 1L);
        writableFileStorageTier.F.M(a222);
        return a222.a;
    }

    public long M() {
        WritableFileStorageTier a3;
        return (Long)a3.d((T a2) -> a2.allSegments().findFirst().orElse(-1L), (Object)-1L);
    }

    public void close(boolean bl) {
        boolean a2 = bl;
        WritableFileStorageTier a3 = this;
        File file = new File(a3.K);
        WritableFileStorageTier writableFileStorageTier = a3;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.k.unregisterPath(writableFileStorageTier2.d());
        writableFileStorageTier.M.remove((Meter)a3.A);
        writableFileStorageTier2.F.d();
        writableFileStorageTier.K.forEach((l2, byteBufferEventSource) -> {
            void a2;
            WritableFileStorageTier a3 = byteBufferEventSource;
            WritableFileStorageTier a4 = this;
            a3.d(0L);
            if (a2 != false) {
                void a5;
                a4.M(a5.longValue());
            }
        });
        a3.d((T storageTier) -> {
            StorageTier a2 = storageTier;
            boolean a3 = a2;
            a2.close(a3);
        });
        boolean bl2 = a2;
        a3.D.cleanup(bl2);
        if (bl2) {
            FileUtils.d((File)file);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(Map map, ProcessedEvent processedEvent, long l2, int n) {
        void a2;
        void a3;
        void a4;
        void a5;
        int n2 = n;
        WritableFileStorageTier a6 = this;
        a6.d((ProcessedEvent)a5, (long)a4, (int)a3, (Map)a2);
    }

    public long d() {
        WritableFileStorageTier a2;
        return ((WritePosition)a2.J.get()).a;
    }

    /*
     * WARNING - void declaration
     */
    public void activateSegmentVersion(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        a4.d(arg_0 -> WritableFileStorageTier.d((long)a2, a3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public Integer currentSegmentVersion(Long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.K.get(a2);
        if (a3 != null) {
            return a3.d();
        }
        return (Integer)writableFileStorageTier.d(arg_0 -> WritableFileStorageTier.d((Long)a2, arg_0), (Object)0);
    }

    private /* synthetic */ int d(List<ProcessedEvent> list) {
        Object a2 = list;
        WritableFileStorageTier a3 = this;
        long l2 = 0L;
        Object object = a2 = a2.iterator();
        while (object.hasNext()) {
            ProcessedEvent processedEvent = (ProcessedEvent)a2.next();
            l2 += (long)(4 + processedEvent.getSerializedSize());
            object = a2;
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, a3.L + ": Transaction size exceeds maximum size");
        }
        return (int)l2;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(WritePosition writePosition, List<ProcessedEvent> list, Map<String, List<IndexEntry>> map) {
        void a2;
        void a3;
        WritableFileStorageTier a4 = writePosition;
        WritableFileStorageTier a5 = this;
        WritableFileStorageTier writableFileStorageTier = a4;
        a4.I.d((List)a3, writableFileStorageTier.J, writableFileStorageTier.a, (arg_0, arg_1, arg_2) -> a5.d((Map)a2, arg_0, arg_1, arg_2));
    }

    private static /* synthetic */ Stream d(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeSegment(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        if (a4.K.containsKey((long)a2)) {
            return a4.d((long)a2, a3);
        }
        return (Boolean)a4.d(arg_0 -> WritableFileStorageTier.d((long)a2, a3, arg_0), (Object)true);
    }

    /*
     * WARNING - void declaration
     */
    public Stream<String> d(long l2, int n, boolean bl) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        if (a3 != false) {
            return Stream.concat(a5.K.entrySet().stream().map(entry -> {
                Map.Entry a2 = entry;
                Object a3 = this;
                return FileUtils.d((File)a3.M(new FileVersion(((Long)a2.getKey()).longValue(), ((ByteBufferEventSource)a2.getValue()).d())));
            }), (Stream)a5.d(arg_0 -> WritableFileStorageTier.d((long)a2, a4, arg_0), Stream.empty()));
        }
        return (Stream)a5.d(arg_0 -> WritableFileStorageTier.M((long)a2, a4, arg_0), Stream.empty());
    }

    public Flux<FileVersion> fileVersions(String string) {
        Object a2 = string;
        WritableFileStorageTier a3 = this;
        return (Flux)a3.d(arg_0 -> WritableFileStorageTier.d((String)a2, arg_0), (Object)Flux.empty());
    }

    private static /* synthetic */ Optional d(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    private static /* synthetic */ Integer d(Long l2, StorageTier storageTier) {
        Long a2 = storageTier;
        Long a3 = l2;
        return a2.currentSegmentVersion(a3);
    }

    public SortedSet<Long> getSegments() {
        WritableFileStorageTier a2;
        return a2.K.keySet();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void d(long l2, Integer n) {
        void a2;
        Integer a3 = n;
        WritableFileStorageTier a4 = this;
        a4.d((long)a2, a3.intValue());
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(FileVersion fileVersion) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.d((FileVersion)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.d(arg_0 -> WritableFileStorageTier.M((FileVersion)a2, arg_0), Optional.empty());
    }
}

