/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.enterprise.replication.admin.UserChangesHandler;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private static final Logger e;
    private final ClusterController l;
    private final ApplicationEventPublisher k;
    private final Predicate<String> J;
    private final DistributeLicenseService A;
    public static final String I = "_none";
    private static final Logger E;
    private final ClusterTopology M;
    private final ClusterTemplateController F;
    private final RaftConfigServiceFactory K;
    private final FeatureChecker a;

    static {
        E = AuditLog.getLogger();
        e = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    /*
     * WARNING - void declaration
     */
    public ClusterRestController(ClusterController clusterController, RaftConfigServiceFactory raftConfigServiceFactory, FeatureChecker featureChecker, DistributeLicenseService distributeLicenseService, ApplicationEventPublisher applicationEventPublisher, ClusterTopology clusterTopology, ClusterTemplateController clusterTemplateController) {
        ClusterRestController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        ClusterRestController a9;
        ClusterRestController clusterRestController = clusterRestController2;
        ClusterRestController clusterRestController2 = clusterTemplateController;
        ClusterRestController clusterRestController3 = a9 = clusterRestController;
        ClusterRestController clusterRestController4 = a9;
        ClusterRestController clusterRestController5 = a9;
        ClusterRestController clusterRestController6 = a9;
        a9.J = new ContextNameValidation();
        a9.l = a8;
        clusterRestController5.K = a7;
        clusterRestController5.a = a6;
        clusterRestController4.A = a5;
        clusterRestController4.k = a4;
        clusterRestController3.M = a3;
        clusterRestController3.F = a2;
    }

    @GetMapping
    public List<JsonClusterNode> d(@Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        E.info(UserChangesHandler.d((Object)"v3P\u0015\r\u001aH9X-^<\r<BhA!^<\r&B,H;\u0003"), (Object)AuditLog.username((Principal)object));
        return a2.l.nodes().map(clusterNode -> {
            ClusterRestController a2 = clusterNode;
            ClusterRestController a3 = this;
            ClusterRestController clusterRestController = a2;
            return JsonClusterNode.from((ClusterNode)clusterRestController, (boolean)a3.l.isActive(clusterRestController.getName()));
        }).collect(Collectors.toList());
    }

    @PostMapping
    public ResponseEntity<RestResponse> d(@Valid @RequestBody ClusterJoinRequest clusterJoinRequest, @Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController;
        NodeInfo.Builder a2;
        ClusterRestController clusterRestController2 = clusterRestController3;
        ClusterRestController clusterRestController3 = clusterJoinRequest;
        ClusterRestController jsonClusterNode = clusterRestController2;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = clusterRestController3.getInternalHostName();
        objectArray[2] = clusterRestController3.internalGrpcPort;
        E.info(UserChangesHandler.d((Object)"\u0013V5ph\u007f-\\=H;YhY'\r\"B!ChN$X;Y-_hL<\r3PrV5\u0003"), objectArray);
        a2 = NodeInfo.newBuilder((NodeInfo)jsonClusterNode.l.getMe().toNodeInfo());
        String string = clusterRestController3.getContext();
        if (string != null && !string.isEmpty()) {
            if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, TaskPublisher.d((Object)"\u001aY7V6Ly[6U;Q7]yR6Q7Q7_y[6V-]!LyO0L1\u00187W\u001aW7L<@-Kw"));
            }
            if (!RaftAdminGroup.d((String)string) && !jsonClusterNode.J.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            e.debug(UserChangesHandler.d((Object)")I,\u0005a\u0017h\u007f-J!^<H:D&Jh@1^-A.\r)C,\r)I,D&Jh@-\r<BhN'C<H0Yh\u000f3Pj\u0003"), (Object)string);
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
            e.debug(TaskPublisher.d((Object)"8\\=\u0010p\u0002yj<_0K-]+Q7_yU K<T?\u00188V=\u00188\\=Q7_yU<\u0018-WyV6\u0018:W7L<@-Kw"));
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            e.debug(UserChangesHandler.d((Object)")I,\u0005a\u0017h\u007f-J!^<H:D&Jh@1^-A.\r)C,\r)I,D&Jh@-\r<BhL$AhN'C<H0Y;\u0003"));
            clusterRestController = jsonClusterNode;
        }
        if (clusterRestController.l.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new RestResponse(false, TaskPublisher.d((Object)"v6\\<\u00188T+]8\\ \u0018+]>Q*L<J<\\yQ7\u00188\u0018:T,K-]+")));
        }
        try {
            ClusterRestController clusterRestController4 = jsonClusterNode;
            ClusterRestController clusterRestController5 = clusterRestController3;
            clusterRestController3 = clusterRestController4.K.getRaftConfigServiceStub(clusterRestController5.internalHostName, clusterRestController5.internalGrpcPort.intValue()).joinCluster(a2.build());
            clusterRestController4.k.publishEvent((Object)new ClusterEvents.LicenseUpdated(clusterRestController3.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, UserChangesHandler.d((Object)"\tN+H8Y-IhG'D&\r:H9X-^<\u0001h@)ThY)F-\r)\r?E!A-\r<Bh]:B+H;^")));
        }
        catch (Exception this2) {
            return new RestResponse(false, this2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)this2));
        }
    }

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void d(HttpServletResponse httpServletResponse, @Parameter(hidden=true) Principal principal) throws IOException {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        E.info(TaskPublisher.d((Object)"\u0002C$eyj<I,]*Ly[5M*L<JyL<U)T8L<\u0018=W.V5W8\\w"), (Object)AuditLog.username((Principal)object));
        if (a2.M.isAdminNode()) {
            ServletOutputStream resp;
            object = UserChangesHandler.d((Object)"+A=^<H:\u0000<H%]$L<HfT%A");
            String string = a2.F.buildYamlTemplate();
            void v1 = resp;
            resp = v1.getOutputStream();
            v1.setContentType(TaskPublisher.d((Object)"-]!LvH5Y0Vb\u0018:P8J*]-\u0005,L?\u0015a"));
            v1.addHeader(UserChangesHandler.d((Object)"n'C<H&Yei!^8B;D<D'C"), "attachment; filename=\"" + (String)object + "\"");
            ServletOutputStream servletOutputStream = resp;
            servletOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            servletOutputStream.flush();
            servletOutputStream.close();
            return;
        }
        throw new RuntimeException(TaskPublisher.d((Object)"\u0000W,\u0018:Y7\u0018,K<\u0018-P0Ky^,V:L0W7Y5Q-AyW7T \u0018?J6UyY=U0VyV6\\<"));
    }

    @GetMapping(path={"{name}"})
    public JsonClusterNode d(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        ClusterNode a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        E.info(TaskPublisher.d((Object)"\u0002C$eyj<I,]*LyV6\\<\u0018=]-Y0T*\u0018?W+\u0018\"Ew"), (Object)AuditLog.username((Principal)a2), object);
        a2 = name.l.getNode((String)object);
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + (String)object + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a2, (boolean)name.l.isActive((String)object));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/upload-license"})
    public void d(@RequestParam(value="licenseFile") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        void a2;
        ClusterRestController clusterRestController = this;
        E.info(UserChangesHandler.d((Object)"\u0013V5ph\u007f-\\=H;YhA!N-C;HhX8I)Y-\u0003"), (Object)AuditLog.username((Principal)a2));
        e.info(TaskPublisher.d((Object)"v<OyT0[<V*]yM)T6Y=]=\u0014yH<J?W+U0V>\u00185Q:]7K<\u0018,H=Y-]w\u0016w"));
        try {
            void licenseFile;
            clusterRestController.A.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, UserChangesHandler.d((Object)"c'\r$H)I-_hK'_hr)I%D&\u0003hh&^=_-\r<E)YhY Hhr)I%D&\r:H8A!N)Y!B&\r/_'X8\r!^hN:H)Y-IhO-K'_-\r=]$B)I!C/\r)\r$D+H&^-\u0003"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException messagingPlatformException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, messagingPlatformException.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"{name}"})
    public void d(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        E.info(TaskPublisher.d((Object)"\u0002C$eyj<I,]*LyL6\u0018=]5]-]yV6\\<\u0018\"Ew"), (Object)AuditLog.username((Principal)a2), object);
        name.K.getRaftConfigService().deleteNode((String)object);
    }
}

