/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.cli;

import io.axoniq.cli.AxonIQCliUtil;
import io.axoniq.cli.CommandOptions;
import io.axoniq.tools.ToolResult;
import io.axoniq.tools.http.NodeTool;
import io.axoniq.tools.http.json.ContextNode;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class ListContexts {
    private ListContexts() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void run(String[] args) throws Throwable {
        CommandLine commandLine = AxonIQCliUtil.processCommandLine((String)args[0], (String[])args, (Option[])new Option[]{CommandOptions.TOKEN});
        String serverHttpAddress = AxonIQCliUtil.getServerHttpAddress((CommandLine)commandLine);
        boolean connectInsecure = AxonIQCliUtil.getConnectInsecure((CommandLine)commandLine);
        String token = AxonIQCliUtil.getToken((CommandLine)commandLine);
        if (AxonIQCliUtil.jsonOutput((CommandLine)commandLine)) {
            ToolResult result = NodeTool.listContextsRaw((String)serverHttpAddress, (boolean)connectInsecure, (String)token);
            if (!result.isSuccess()) throw result.getFailure();
            System.out.println((String)result.getSuccessValue());
            return;
        } else {
            ToolResult result = NodeTool.listContexts((String)serverHttpAddress, (boolean)connectInsecure, (String)token);
            if (!result.isSuccess()) throw result.getFailure();
            System.out.printf("%-20s %-20s %-20s %-60s%n", "Name", "Leader", "Replication Group", "Members");
            for (ContextNode context : (List)result.getSuccessValue()) {
                System.out.printf("%-20s %-20s %-20s %-60s%n", context.getContext(), context.getLeader(), context.getReplicationGroup(), context.hasRoles() ? context.concatRoles() : context.concatNodes());
            }
        }
    }
}

