/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.migration.migrators;

import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.migration.MigrationBaseProperties;
import io.axoniq.axonserver.migration.destination.EventStoreStrategy;
import io.axoniq.axonserver.migration.migrators.EventMigratorStatisticsReporter;
import io.axoniq.axonserver.migration.migrators.Migrator;
import io.axoniq.axonserver.migration.migrators.db.MigrationStatus;
import io.axoniq.axonserver.migration.migrators.db.MigrationStatusRepository;
import io.axoniq.axonserver.migration.serialisation.EventSerializer;
import io.axoniq.axonserver.migration.source.BaseEvent;
import io.axoniq.axonserver.migration.source.DomainEvent;
import io.axoniq.axonserver.migration.source.EventProducer;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"axoniq.migration.migrateEvents"}, havingValue="true", matchIfMissing=true)
public class EventMigrator
implements Migrator {
    private static final Logger log = LoggerFactory.getLogger(EventMigrator.class);
    private final MigrationBaseProperties properties;
    private final EventProducer eventProducer;
    private final EventSerializer eventSerializer;
    private final MigrationStatusRepository migrationStatusRepository;
    private final EventStoreStrategy eventStoreStrategy;
    private final EventMigratorStatisticsReporter reporter;

    public void migrate() throws Exception {
        MigrationStatus migrationStatus = this.migrationStatusRepository.findById((Object)1L).orElse(new MigrationStatus());
        long lastProcessedToken = migrationStatus.getLastEventGlobalIndex();
        this.reporter.initialize(lastProcessedToken);
        String lastEventId = this.eventStoreStrategy.getLastEventId();
        boolean isFirstRun = true;
        while (true) {
            List result;
            if ((result = this.eventProducer.findEvents(lastProcessedToken, this.properties.getBatchSize())).isEmpty()) {
                log.info("No more events found");
                return;
            }
            if (isFirstRun && lastEventId != null) {
                Optional<DomainEvent> matchingEventOptional = result.stream().filter(e -> Objects.equals(e.getEventIdentifier(), lastEventId)).findFirst();
                if (matchingEventOptional.isPresent()) {
                    DomainEvent matchingEvent = matchingEventOptional.get();
                    int index = result.indexOf(matchingEvent);
                    log.info("Detected partially written batch because event id {}, found at index {}, was already written last time. Filtering the events to correct. ", (Object)lastEventId, (Object)index);
                    result = result.subList(index + 1, result.size());
                }
                isFirstRun = false;
                if (result.isEmpty()) continue;
            }
            if (this.recentGapIsPresent(lastProcessedToken, result)) {
                return;
            }
            DomainEvent lastEntry = (DomainEvent)result.get(result.size() - 1);
            lastProcessedToken = lastEntry.getGlobalIndex();
            List events = result.stream().map(e -> {
                try {
                    return this.buildEvent(e);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            this.storeEvents(events);
            migrationStatus.setLastEventGlobalIndex(lastProcessedToken);
            this.migrationStatusRepository.save((Object)migrationStatus);
            this.reporter.reportBatchSaved(lastProcessedToken, result.size(), events.size());
        }
    }

    private boolean recentGapIsPresent(long lastProcessedToken, List<? extends DomainEvent> result) {
        List recentGlobalIndexes = result.stream().filter(arg_0 -> this.isRecentEvent(arg_0)).map(DomainEvent::getGlobalIndex).collect(Collectors.toList());
        long maxNonRecentEvent = result.stream().filter(s -> !this.isRecentEvent(s)).map(DomainEvent::getGlobalIndex).max(Comparator.naturalOrder()).orElse(lastProcessedToken);
        for (int i = 1; i <= recentGlobalIndexes.size(); ++i) {
            if (recentGlobalIndexes.contains(maxNonRecentEvent + (long)i)) continue;
            log.error("Missing event at: {}. Found global indexes in batch: {}", (Object)(maxNonRecentEvent + (long)i), recentGlobalIndexes);
            log.error("This indicates that there is a gap in the database which occurred recently. Since we cannot guarantee data ordering, we are stopping the migration.");
            return true;
        }
        return false;
    }

    private boolean isAnIgnoredEventType(DomainEvent entry) {
        return this.properties.getIgnoredEvents().contains(entry.getPayloadType());
    }

    private Event buildEvent(DomainEvent entry) throws Exception {
        if (this.isAnIgnoredEventType(entry)) {
            return null;
        }
        Event.Builder eventBuilder = Event.newBuilder().setPayload(this.eventSerializer.toPayload((BaseEvent)entry)).setMessageIdentifier(entry.getEventIdentifier());
        if (entry.getType() != null) {
            String aggregateIdentifier = entry.getAggregateIdentifier();
            long nextSequenceNumber = this.properties.shouldRequestSequenceNumbers() ? entry.getSequenceNumber() : this.eventStoreStrategy.getNextSequenceNumber(aggregateIdentifier, Long.valueOf(entry.getSequenceNumber())).longValue();
            eventBuilder.setAggregateType(entry.getType()).setAggregateSequenceNumber(nextSequenceNumber).setAggregateIdentifier(aggregateIdentifier);
        }
        eventBuilder.setTimestamp(entry.getTimeStampAsLong());
        this.eventSerializer.convertMetadata(entry.getMetaData(), eventBuilder);
        return eventBuilder.build();
    }

    private void storeEvents(List<Event> events) throws Exception {
        if (events.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Storing {} events", (Object)events.size());
        }
        try {
            this.eventStoreStrategy.storeEvents(events);
        }
        catch (Exception exception) {
            List structure = events.stream().map(e -> String.format("%s___%d", e.getAggregateIdentifier(), e.getAggregateSequenceNumber())).collect(Collectors.toList());
            log.error("Exception while storing. The event list has the following structure: {}", structure);
            this.eventStoreStrategy.rollback();
            throw exception;
        }
    }

    private boolean isRecentEvent(DomainEvent entry) {
        return entry.getTimeStampAsLong() > System.currentTimeMillis() - (long)this.properties.getRecentMillis();
    }

    public EventMigrator(MigrationBaseProperties properties, EventProducer eventProducer, EventSerializer eventSerializer, MigrationStatusRepository migrationStatusRepository, EventStoreStrategy eventStoreStrategy, EventMigratorStatisticsReporter reporter) {
        this.properties = properties;
        this.eventProducer = eventProducer;
        this.eventSerializer = eventSerializer;
        this.migrationStatusRepository = migrationStatusRepository;
        this.eventStoreStrategy = eventStoreStrategy;
        this.reporter = reporter;
    }
}

