/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.tags.ClientTagsCache;
import io.axoniq.axonserver.enterprise.cluster.NodeSelector;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.ReadyForConnections;
import io.axoniq.axonserver.grpc.PlatformService;
import io.axoniq.axonserver.localstorage.file.AggregateWithoutSnapshotException;
import io.axoniq.axonserver.util.StreamObserverUtils;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AutoRebalancing {
    private final PlatformService a;
    private final NavigableSet<PlatformService.ClientComponent> I;
    private final ClientTagsCache A;
    private final Logger e;
    private final NodeSelector C;
    private final boolean g;

    @EventListener
    public void on(TopologyEvents.ApplicationDisconnected applicationDisconnected) {
        AutoRebalancing a2;
        AutoRebalancing a3 = applicationDisconnected;
        AutoRebalancing autoRebalancing = a2 = this;
        autoRebalancing.e.debug(StreamObserverUtils.L((Object)"dbU~LqDfL}K2a{VqJ|KwFf@v\u001f2^o"), (Object)a3.h());
        a3 = new PlatformService.ClientComponent(a3.h(), a3.A(), a3.a(), a3.j());
        autoRebalancing.I.remove(a3);
        a2.e.debug(AggregateWithoutSnapshotException.L((Object)"\u0019y'e+}'b:+nj3"), (Object)a2.I);
    }

    @EventListener
    public void on(ReadyForConnections readyForConnections) {
        AutoRebalancing a2 = readyForConnections;
        AutoRebalancing a3 = this;
        if (a2.ready()) {
            AutoRebalancing autoRebalancing = a3;
            autoRebalancing.I.clear();
            autoRebalancing.I.addAll(a3.a.getConnectedClients());
        }
    }

    /*
     * WARNING - void declaration
     */
    public AutoRebalancing(PlatformService platformService, ClientTagsCache clientTagsCache, NodeSelector nodeSelector, @Value(value="${axoniq.axonserver.cluster.auto-balancing:true}") boolean bl) {
        void nodeSelector2;
        void clientsTags;
        void platformService2;
        AutoRebalancing a2;
        boolean bl2 = bl;
        AutoRebalancing autoRebalancing = a2 = this;
        AutoRebalancing autoRebalancing2 = a2;
        a2.e = LoggerFactory.getLogger(AutoRebalancing.class);
        AutoRebalancing autoRebalancing3 = a2;
        a2.I = new ConcurrentSkipListSet();
        autoRebalancing2.a = platformService2;
        autoRebalancing2.A = clientsTags;
        autoRebalancing.C = nodeSelector2;
        autoRebalancing.g = this;
    }

    private /* synthetic */ Map<String, String> L(String string, String string2) {
        Object a2 = string2;
        AutoRebalancing a3 = this;
        return a3.A.apply((String)a2);
    }

    @Scheduled(fixedRateString="${axoniq.axonserver.cluster.balancing-rate:15000}")
    protected void L() {
        boolean bl;
        AutoRebalancing autoRebalancing = this;
        if (!autoRebalancing.g) {
            return;
        }
        autoRebalancing.e.debug(StreamObserverUtils.L((Object)"@@pD~D|Fw\u001f2^o"), (Object)autoRebalancing.I);
        boolean bl2 = false;
        do {
            AutoRebalancing a2;
            if ((a2 = (PlatformService.ClientComponent)autoRebalancing.I.pollFirst()) != null && autoRebalancing.C.canRebalance(a2.getClientId(), a2.getComponent(), a2.getContext(), autoRebalancing.L(a2.getContext(), a2.getClientStreamId()))) {
                bl = bl2;
                autoRebalancing.L((PlatformService.ClientComponent)a2);
                continue;
            }
            bl = bl2 = a2 != null;
        } while (bl);
    }

    private /* synthetic */ void L(PlatformService.ClientComponent clientComponent) {
        AutoRebalancing a2;
        AutoRebalancing a3 = clientComponent;
        AutoRebalancing autoRebalancing = a2 = this;
        autoRebalancing.e.info(AggregateWithoutSnapshotException.L((Object)"\u001ct?d+b:x vnc+r!\u007f t-enw!cnj3"), (Object)a3.getClientStreamId());
        autoRebalancing.a.requestReconnect((PlatformService.ClientComponent)a3, StreamObserverUtils.L((Object)"`@qJ|KwFf\u0005`@cPwVf@v\u0005p\\2DgQ}\u0005pD~D|F{Ku"));
    }

    @EventListener
    public void on(ClusterEvents.AxonServerNodeHealthChanged axonServerNodeHealthChanged) {
        AutoRebalancing a2;
        AutoRebalancing a3 = axonServerNodeHealthChanged;
        AutoRebalancing autoRebalancing = a2 = this;
        autoRebalancing.e.debug(AggregateWithoutSnapshotException.L((Object)"C+r+x8t*1&t/}:ynr&p v+unw!cnj3"), (Object)a3.getNode());
        autoRebalancing.I.clear();
        autoRebalancing.I.addAll(a2.a.getConnectedClients());
    }
}

