/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster;

import io.axoniq.axonserver.ClusterTagsCache;
import io.axoniq.axonserver.component.processor.ProcessorEventPublisher;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.admin.AdminConfigurationFactory;
import io.axoniq.axonserver.configuration.admin.AdminNodes;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.CurrentNodeProvider;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnection;
import io.axoniq.axonserver.enterprise.cluster.internal.RemoteConnections;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.Limits;
import io.axoniq.axonserver.localstorage.file.SegmentAndPosition;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
public class ClusterController
implements SmartLifecycle {
    private volatile boolean L;
    private final AdminConfigurationFactory m;
    private final Limits M;
    private final Logger i;
    private final ClusterTagsCache a;
    private final CurrentNodeProvider I;
    private final MessagingPlatformConfiguration A;
    private final AdminNodes e;
    private final ApplicationEventPublisher C;
    private final RemoteConnections g;

    @Transactional
    public synchronized void deleteNode(String string) {
        ClusterController clusterController;
        ClusterController a2;
        Object a3 = string;
        ClusterController clusterController2 = a2 = this;
        clusterController2.i.info(ProcessorEventPublisher.L((Object)"sb[bCb\u0017iXcR=\u0017|J"), a3);
        clusterController2.C.publishEvent((Object)new ClusterEvents.AxonServerNodeDeletionRequested((String)a3));
        if (clusterController2.A.getName().equals(a3)) {
            ClusterController clusterController3 = a2;
            clusterController = clusterController3;
            clusterController3.e.deleteAllByNameNot((String)a3);
            clusterController3.g.closeAll();
        } else {
            a2.e.findById((String)a3).ifPresent(arg_0 -> a2.L((String)a3, arg_0));
            clusterController = a2;
        }
        clusterController.C.publishEvent((Object)new ClusterEvents.AxonServerNodeDeleted((String)a3));
        a2.g.sync();
    }

    public Stream<ClusterNode> activeNodes() {
        ClusterController a2;
        return a2.nodes().filter(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            return a3.isActive(a2.getName());
        });
    }

    public ClusterNode getMe() {
        ClusterController a2;
        ClusterController clusterController = a2;
        return clusterController.L((ClusterNode)clusterController.I.get());
    }

    public Optional<RemoteConnection> getRemoteConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        return Optional.ofNullable(a3.g.get((String)a2));
    }

    private /* synthetic */ void L(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        if (a3.g.contains((String)a2) || a3.A.getName().equals(a2)) {
            return;
        }
        a3.M.getMaxClusterSize().ifPresent(arg_0 -> a3.L((String)a2, arg_0));
    }

    private /* synthetic */ void L() {
        Object a2;
        ClusterController clusterController;
        ClusterController clusterController2 = clusterController = this;
        Object object = clusterController2.e.findById(clusterController2.A.getName());
        if (((Optional)object).isEmpty()) {
            if (clusterController.e.findAll().findAny().isPresent()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = clusterController.A.getName();
                a2 = String.format(SegmentAndPosition.L((Object)"`\u000eQ\tF\u0015W[M\u0014G\u001e\u0003\u0015B\u0016F[K\u001aP[@\u0013B\u0015D\u001eGW\u0003\u0015F\f\u0003\u0015B\u0016F[\u0006\b\r[p\u000fB\tW[b\u0003L\u0015p\u001eQ\rF\t\u0003\fJ\u000fK[Q\u001e@\u0014U\u001eQ\u0002\u0003\u001dJ\u0017FU"), objectArray);
                throw new FailedToStartException((String)a2);
            }
            ClusterController clusterController3 = clusterController;
            a2 = clusterController3.m.clusterNode(clusterController3.A.getName(), clusterController.A.getFullyQualifiedHostname(), clusterController.A.getFullyQualifiedInternalHostname(), clusterController.A.getPort(), clusterController.A.getInternalPort(), clusterController.A.getHttpPort());
            clusterController3.e.save((ClusterNode)a2);
            return;
        }
        a2 = (ClusterNode)((Optional)object).get();
        if (!a2.getInternalHostName().equals(clusterController.A.getFullyQualifiedInternalHostname()) || !a2.getGrpcInternalPort().equals(clusterController.A.getInternalPort())) {
            Object[] objectArray = new Object[4];
            objectArray[0] = a2.getInternalHostName();
            objectArray[1] = a2.getGrpcInternalPort();
            objectArray[2] = clusterController.A.getFullyQualifiedInternalHostname();
            objectArray[3] = clusterController.A.getInternalPort();
            object = String.format(ProcessorEventPublisher.L((Object)"DBuEbYs\u0017iXcR D'^iCbEiVk\u0017oXtCiVjR(GhEs\u0017/\u0012t\r\"S.\u0017oVt\u0017d_fY`Rc\u001b'\u0017iRp\u0017qVkBbD'\u0012t\r\"S)\u0017TCfEs\u0017FOhYTRuAbE'@nCo\u0017uRdXqRuN'Qn[b\u0019"), objectArray);
            throw new FailedToStartException((String)object);
        }
    }

    public boolean isActive(String string) {
        String a2 = string;
        ClusterController a3 = this;
        if (a2.equals(a3.A.getName()) || a3.g.get(a2) != null && a3.g.get(a2).isConnected()) {
            return true;
        }
        return false;
    }

    Stream<RemoteConnection> activeConnections() {
        ClusterController a2;
        return a2.g.activeConnections();
    }

    private /* synthetic */ void L(String string, ClusterNode clusterNode) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.e.deleteById((String)a2);
    }

    public void deleteOtherNodes() {
        ClusterController a2;
        ClusterController clusterController = a2;
        a2.e.deleteAllByNameNot(clusterController.getName());
        clusterController.g.sync();
    }

    public boolean isRunning() {
        ClusterController a2;
        return a2.L;
    }

    private /* synthetic */ void L(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        if (a2.getNodeName().equals(a3.A.getName())) {
            return;
        }
        a3.g.connect((NodeInfo)a2, true);
    }

    public ClusterNode getNode(String string) {
        String a2 = string;
        Object a3 = this;
        if (a2.equals(a3.getName())) {
            return a3.getMe();
        }
        ClusterController clusterController = a3;
        return clusterController.L(clusterController.e.findById(a2).orElseGet(() -> {
            Object a2 = a2;
            ClusterController a3 = this;
            if ((a2 = a3.g.get((String)a2)) == null) {
                return null;
            }
            return a2.getClusterNode();
        }));
    }

    /*
     * WARNING - void declaration
     */
    public ClusterController(MessagingPlatformConfiguration messagingPlatformConfiguration, AdminNodes adminNodes, AdminConfigurationFactory adminConfigurationFactory, ClusterTagsCache clusterTagsCache, @Qualifier(value="localEventPublisher") ApplicationEventPublisher applicationEventPublisher, Limits limits, RemoteConnections remoteConnections, CurrentNodeProvider currentNodeProvider) {
        void remoteConnections2;
        void limits2;
        void applicationEventPublisher2;
        void clusterTagsCache2;
        void adminConfigurationFactory2;
        void clusterNodeRepository;
        void messagingPlatformConfiguration2;
        ClusterController a2;
        ClusterController clusterController = clusterController2;
        ClusterController clusterController2 = currentNodeProvider;
        ClusterController clusterController3 = a2 = clusterController;
        ClusterController clusterController4 = a2;
        ClusterController clusterController5 = a2;
        ClusterController clusterController6 = a2;
        a2.i = LoggerFactory.getLogger(ClusterController.class);
        clusterController6.A = messagingPlatformConfiguration2;
        clusterController6.e = clusterNodeRepository;
        clusterController5.m = adminConfigurationFactory2;
        clusterController5.a = clusterTagsCache2;
        clusterController4.C = applicationEventPublisher2;
        clusterController4.M = limits2;
        clusterController3.g = remoteConnections2;
        clusterController3.I = clusterController2;
    }

    public synchronized void handleRemoteConnection(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.L((NodeInfo)a3);
        clusterController.g.updateNodeInfo((NodeInfo)a3);
        clusterController.C.publishEvent((Object)new ClusterEvents.AxonServerNodeConnected((NodeInfo)a3));
    }

    public boolean isAdminNode() {
        ClusterController a2;
        return a2.I.isAdmin();
    }

    private /* synthetic */ ClusterNode L(NodeInfo nodeInfo) {
        ClusterController a2;
        ClusterController a3 = nodeInfo;
        ClusterController clusterController = a2 = this;
        clusterController.i.info(SegmentAndPosition.L((Object)":G\u001f\u0003\u0015L\u001fF[X\u0006"), (Object)a3);
        a3 = clusterController.m.clusterNode((NodeInfo)a3);
        return clusterController.e.save((ClusterNode)a3);
    }

    public Stream<ClusterNode> nodes() {
        ClusterController a2;
        return a2.e.findAll().peek(clusterNode -> {
            ClusterController a2 = clusterNode;
            ClusterController a3 = this;
            if (a2 == null) {
                return null;
            }
            a2.setTags(a3.a.getClusterTags().getOrDefault(a2.getName(), Collections.emptyMap()));
            return a2;
        });
    }

    public Set<String> remoteNodeNames() {
        ClusterController a2;
        return a2.g.nodes();
    }

    public int getPhase() {
        return 50;
    }

    public Collection<RemoteConnection> getRemoteConnections() {
        ClusterController a2;
        return a2.g.connections();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(String string, Integer n) {
        Integer a2 = n;
        ClusterController a3 = this;
        if (a3.g.size() + 1 >= a2) {
            void a4;
            throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached " + (String)a4);
        }
    }

    @Transactional
    public synchronized ClusterNode addConnection(NodeInfo nodeInfo) {
        ClusterController a2 = nodeInfo;
        ClusterController a3 = this;
        ClusterController clusterController = a2;
        a3.L(clusterController.getNodeName());
        if (clusterController.getNodeName().equals(a3.A.getName())) {
            ClusterController clusterController2 = a3;
            clusterController2.i.info(SegmentAndPosition.L((Object)"/Q\u0002J\u0015D[W\u0014\u0003\u0011L\u0012M[T\u0012W\u0013\u0003\u0018V\tQ\u001eM\u000f\u0003\u0015L\u001fF[M\u001aN\u001e\u0019[X\u0006"), (Object)a2.getNodeName());
            return clusterController2.getMe();
        }
        if (a2.getInternalHostName().equals(a3.A.getInternalHostname()) && a2.getGrpcInternalPort() == a3.A.getInternalPort()) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, ProcessorEventPublisher.L((Object)"DViYhC']h^i\u0017d[rDsRu\u0017p^s_'DfZb\u0017oXtCiVjR'ViS'^iCbEiVk\u0017wXuC"));
        }
        ClusterNode clusterNode = a3.e.findById(a2.getNodeName()).orElseGet(() -> a3.L((NodeInfo)a2));
        if (!a3.g.contains(a2.getNodeName())) {
            a3.L((NodeInfo)a2);
        }
        return clusterNode;
    }

    public void closeConnection(String string) {
        Object a2 = string;
        ClusterController a3 = this;
        a3.g.disconnect((String)a2);
    }

    public String getName() {
        ClusterController a2;
        return a2.getMe().getName();
    }

    @Transactional
    public void start() {
        ClusterController a2;
        a2.L();
        a2.L = true;
    }

    public void stop() {
        a.L = false;
    }

    public void publishEvent(Object object) {
        Object a2 = object;
        ClusterController a3 = this;
        a3.C.publishEvent(a2);
    }
}

