/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.cluster.internal;

import io.axoniq.axonserver.cluster.grpc.LeaderElectionService;
import io.axoniq.axonserver.cluster.grpc.LogReplicationService;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.enterprise.cluster.internal.InternalAuthenticationInterceptor;
import io.axoniq.axonserver.enterprise.cluster.internal.ReplicationServerStarted;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AxonServerInternalService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.plugin.PluginPackageRequester;
import io.axoniq.axonserver.rest.json.QueryRequestJson;
import io.axoniq.axonserver.util.DaemonThreadFactory;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="MessagingClusterServer")
public class MessagingClusterServer
implements SmartLifecycle {
    private AdvancedTlsX509KeyManager.Closeable k;
    private final Logger h;
    private Server L;
    private final ApplicationEventPublisher m;
    private final LogReplicationService M;
    private final List<AxonServerInternalService> i;
    private final LeaderElectionService a;
    private static final DataSize I = DataSize.ofMegabytes((long)32L);
    private boolean A;
    private final ExecutorService e;
    private final Supplier<ScheduledExecutorService> C;
    private final MessagingPlatformConfiguration g;

    /*
     * WARNING - void declaration
     */
    public MessagingClusterServer(MessagingPlatformConfiguration messagingPlatformConfiguration, LogReplicationService logReplicationService, LeaderElectionService leaderElectionService, List<AxonServerInternalService> list, Supplier<ScheduledExecutorService> supplier, ApplicationEventPublisher applicationEventPublisher) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        MessagingClusterServer a7;
        MessagingClusterServer a8 = messagingPlatformConfiguration;
        MessagingClusterServer messagingClusterServer = a7 = this;
        MessagingClusterServer messagingClusterServer2 = a7;
        MessagingClusterServer messagingClusterServer3 = a7;
        MessagingClusterServer messagingClusterServer4 = a7;
        messagingClusterServer4.h = LoggerFactory.getLogger(MessagingClusterServer.class);
        messagingClusterServer4.g = a8;
        messagingClusterServer3.M = a6;
        messagingClusterServer3.a = a5;
        messagingClusterServer2.i = a4;
        messagingClusterServer2.C = a3;
        messagingClusterServer.m = a2;
        messagingClusterServer.e = Executors.newFixedThreadPool(a8.getClusterExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(PluginPackageRequester.L((Object)"E\fS\u0013R\u0005TMC\u0018C\u0003S\u0014I\u0012\u000b")));
    }

    public void stop() {
        MessagingClusterServer messagingClusterServer = this;
        if (messagingClusterServer.k != null) {
            messagingClusterServer.k.close();
        }
        messagingClusterServer.e.shutdown();
        try {
            if (!messagingClusterServer.L.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
                messagingClusterServer2.h.debug(QueryRequestJson.L((Object)"CLw@`EpOiZ%PqLuSlMb\u0003FOpPqFw\u0003VFwU`Q"));
                messagingClusterServer2.L.shutdownNow();
            }
        }
        catch (InterruptedException a2) {
            messagingClusterServer.h.debug(PluginPackageRequester.L((Object)")H\u0014C\u0012T\u0015V\u0014C\u0004\u0006\u0004S\u0012O\u000eA@U\bS\u0014B\u000fQ\u000e\u0006\u000f@@O\u000eR\u0005T\u000eG\f\u0006!^\u000fH3C\u0012P\u0005T"), (Throwable)a2);
            Thread.currentThread().interrupt();
        }
        messagingClusterServer.A = false;
        messagingClusterServer.h.info(QueryRequestJson.L((Object)"D[jM%p`QsFw\u0003FOpPqFw\u0003VFwU`Q%PqLuS`G"));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void L(NettyServerBuilder nettyServerBuilder, AxonServerInternalService axonServerInternalService) {
        void a2;
        NettyServerBuilder nettyServerBuilder2 = nettyServerBuilder;
        LinkedList a3 = new LinkedList(a2.interceptors());
        if (a2.requiresContextInterceptor()) {
            a3.add(new ContextInterceptor());
        }
        nettyServerBuilder2.addService(ServerInterceptors.intercept((BindableService)a2, (List)a3));
    }

    public boolean isAutoStartup() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        MessagingClusterServer messagingClusterServer = this;
        try {
            NettyServerBuilder nettyServerBuilder;
            MessagingClusterServer a2;
            String string = PluginPackageRequester.L((Object)"\u000eI@u3j");
            if (messagingClusterServer.g.getSsl() != null && messagingClusterServer.g.getSsl().isEnabled()) {
                Object object = messagingClusterServer.g.getSsl().getInternalCertChainFile();
                if (object == null) {
                    throw new RuntimeException(QueryRequestJson.L((Object)"B}LkJt\rd[jMvFwU`Q+PvO+@`Qq\u000efKdJk\u000ecJiF%MjW%P`W"));
                }
                Object object2 = messagingClusterServer.g.getSsl().getInternalPrivateKeyFile();
                if (object2 == null) {
                    throw new RuntimeException(PluginPackageRequester.L((Object)"\u0001^\u000fH\tWNG\u0018I\u000eU\u0005T\u0016C\u0012\b\u0013U\f\b\u0010T\tP\u0001R\u0005\u000b\u000bC\u0019\u000b\u0006O\fC@H\u000fR@U\u0005R"));
                }
                object2 = new File((String)object2);
                object = new File((String)object);
                if (!((File)object2).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object2).getCanonicalPath());
                }
                if (!((File)object).canRead()) {
                    throw new RuntimeException("Cannot access " + ((File)object).getCanonicalPath());
                }
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                messagingClusterServer.k = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile((File)object2, (File)object, 1L, TimeUnit.MINUTES, (ScheduledExecutorService)messagingClusterServer.C.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                object = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.g.getInternalPort(), (ServerCredentials)object);
                string = QueryRequestJson.L((Object)"pVo%FkBgO`G");
                nettyServerBuilder = a2;
            } else {
                a2 = NettyServerBuilder.forPort((int)messagingClusterServer.g.getInternalPort());
                nettyServerBuilder = a2;
            }
            nettyServerBuilder.permitKeepAliveTime(messagingClusterServer.g.getMinKeepAliveTime(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(true);
            a2.maxInboundMessageSize((int)Math.max(I.toBytes(), Math.min(Integer.MAX_VALUE, (long)messagingClusterServer.g.getMaxMessageSize() + DataSize.ofMegabytes((long)1L).toBytes())));
            a2.intercept((ServerInterceptor)new InternalAuthenticationInterceptor(messagingClusterServer.g));
            messagingClusterServer.i.forEach(arg_0 -> MessagingClusterServer.L((NettyServerBuilder)a2, arg_0));
            MessagingClusterServer messagingClusterServer2 = messagingClusterServer;
            a2.addService((BindableService)messagingClusterServer.a);
            a2.addService((BindableService)messagingClusterServer2.M);
            if (messagingClusterServer2.g.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(messagingClusterServer.g.getKeepAliveTime(), TimeUnit.MILLISECONDS);
                a2.keepAliveTimeout(messagingClusterServer.g.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(messagingClusterServer.g.getGrpcBufferedMessages()));
            a2.executor((Executor)messagingClusterServer.e);
            if (Epoll.isAvailable()) {
                v3 = messagingClusterServer;
                a2.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(PluginPackageRequester.L((Object)"E\fS\u0013R\u0005TMD\u000fU\u0013\u000b"))));
                a2.workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(QueryRequestJson.L((Object)"@iVvW`Q(TjQnFw\u000e"))));
                a2.channelType(EpollServerSocketChannel.class);
            } else {
                a2.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)new DaemonThreadFactory(PluginPackageRequester.L((Object)"E\fS\u0013R\u0005TMD\u000fU\u0013\u000b"))));
                a2.workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(0, (ThreadFactory)new DaemonThreadFactory(QueryRequestJson.L((Object)"@iVvW`Q(TjQnFw\u000e"))));
                a2.channelType(NioServerSocketChannel.class);
                v3 = messagingClusterServer;
            }
            v3.L = a2.build();
            messagingClusterServer.L.start();
            messagingClusterServer.h.info(PluginPackageRequester.L((Object)"g\u0018I\u000e\u00063C\u0012P\u0005T@e\fS\u0013R\u0005T@u\u0005T\u0016C\u0012\u0006\u0013R\u0001T\u0014C\u0004\u0006\u000fH@V\u000fT\u0014\u001c@]\u001d\u0006M\u0006\u001b["), (Object)messagingClusterServer.g.getInternalPort(), (Object)string);
            messagingClusterServer.m.publishEvent((Object)new ReplicationServerStarted());
            messagingClusterServer.A = true;
            return;
        }
        catch (Exception a2) {
            throw new FailedToStartException(QueryRequestJson.L((Object)"pqBwWlMb\u0003D[jM%p`QsFw\u0003FOpPqFw\u0003VFwU`Q%EdJiFa\u0003"), (Throwable)a2);
        }
    }

    public int getPhase() {
        return 50;
    }

    public boolean isRunning() {
        MessagingClusterServer a2;
        return a2.A;
    }
}

