/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.enterprise.replication.admin;

import com.google.protobuf.ByteString;
import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroup;
import io.axoniq.axonserver.configuration.admin.AdminReplicationGroupMember;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.internal.AddressValidator;
import io.axoniq.axonserver.enterprise.replication.admin.LeaderElectionCheck;
import io.axoniq.axonserver.enterprise.replication.group.RaftGroupServiceFactory;
import io.axoniq.axonserver.enterprise.replication.logconsumer.AdminNodeConsumer;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.DeleteNode;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.grpc.internal.UpdateLicense;
import io.axoniq.axonserver.licensing.LicenseManager;
import io.axoniq.axonserver.localstorage.file.AggregateSequence;
import io.axoniq.axonserver.taskscheduler.TaskPublisher;
import io.axoniq.axonserver.taskscheduler.TransientException;
import io.axoniq.axonserver.taskscheduler.task.NodeContext;
import io.axoniq.axonserver.taskscheduler.task.PrepareDeleteNodeFromContextTask;
import io.axoniq.axonserver.taskscheduler.task.UnregisterNodeTask;
import io.axoniq.axonserver.transport.rest.v2.ReplicationRestControllerV2;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClusterChangesHandler {
    private final FeatureChecker i;
    private final RaftGroupServiceFactory a;
    private final LicenseManager I;
    private final TaskPublisher A;
    private final ClusterController e;
    private final Logger C;
    private final AddressValidator g;

    /*
     * WARNING - void declaration
     */
    public UpdateLicense join(NodeInfo nodeInfo) {
        void a2;
        ClusterChangesHandler clusterChangesHandler = this;
        clusterChangesHandler.i.getMaxClusterSize().ifPresent(n -> {
            Integer a2 = n;
            ClusterChangesHandler a3 = this;
            if (a3.e.nodes().count() >= (long)a2.intValue()) {
                throw new MessagingPlatformException(ErrorCode.MAX_CLUSTER_SIZE_REACHED, "Maximum allowed number of nodes reached: " + a3.i.getMaxClusterSize());
            }
        });
        ClusterChangesHandler clusterChangesHandler2 = clusterChangesHandler;
        Object a3 = clusterChangesHandler2.a.getLeader(RaftAdminGroup.L());
        if (!clusterChangesHandler2.e.getName().equals(a3)) {
            throw new MessagingPlatformException(ErrorCode.NODE_IS_REPLICA, "Send join request to the leader of _admin context: " + (String)a3);
        }
        a3 = clusterChangesHandler.e.getNode(a2.getNodeName());
        if (!(a3 == null || a3.getInternalHostName().equals(a2.getInternalHostName()) && a3.getGrpcInternalPort().equals(a2.getGrpcInternalPort()))) {
            throw new MessagingPlatformException(ErrorCode.SAME_NODE_NAME, AggregateSequence.L((Object)"ou@:J0\u000e\"G!FuZ=Ku]4C0\u000e;O8KuO;JuJ<H3K'K;ZuG;Z0\\;O9\u000e=A&Zu@4C0\u000e4@1\u000e%A'ZuO9\\0O1WuK-G&Z&"));
        }
        ClusterChangesHandler clusterChangesHandler3 = clusterChangesHandler;
        clusterChangesHandler3.g.validateAddress(a2.getInternalHostName(), a2.getGrpcInternalPort());
        a3 = clusterChangesHandler3.L();
        clusterChangesHandler3.a.appendToAdminAndWait(AdminNodeConsumer.class.getName(), a2.toByteArray());
        return UpdateLicense.newBuilder().setLicense(ByteString.copyFrom((byte[])a3)).build();
    }

    /*
     * WARNING - void declaration
     */
    public ClusterChangesHandler(ClusterController clusterController, TaskPublisher taskPublisher, RaftGroupServiceFactory raftGroupServiceFactory, FeatureChecker featureChecker, AddressValidator addressValidator, LicenseManager licenseManager) {
        ClusterChangesHandler a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ClusterChangesHandler a8;
        ClusterChangesHandler clusterChangesHandler = clusterChangesHandler2;
        ClusterChangesHandler clusterChangesHandler2 = licenseManager;
        ClusterChangesHandler clusterChangesHandler3 = a8 = clusterChangesHandler;
        ClusterChangesHandler clusterChangesHandler4 = a8;
        ClusterChangesHandler clusterChangesHandler5 = a8;
        a8.C = LoggerFactory.getLogger(ClusterChangesHandler.class);
        clusterChangesHandler5.e = a7;
        clusterChangesHandler5.A = a6;
        clusterChangesHandler4.a = a5;
        clusterChangesHandler4.i = a4;
        clusterChangesHandler3.g = a3;
        clusterChangesHandler3.I = a2;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteNodeIfEmpty(String string) {
        void a3;
        ClusterChangesHandler clusterChangesHandler = this;
        ClusterChangesHandler a4 = clusterChangesHandler.e.getNode((String)a3);
        if (a4 == null) {
            return;
        }
        if (a4.getReplicationGroups().stream().anyMatch(a2 -> {
            if (a2.getReplicationGroup() != null) {
                if (a2.getReplicationGroup().getMembers().size() > 1) {
                    return true;
                }
            }
            return false;
        })) {
            throw new TransientException(AggregateSequence.L((Object)"`:J0\u000e&Z<B9\u000e8K8L0\\uA3\u000e6A;Z0V!]{"));
        }
        clusterChangesHandler.a.appendToAdminAndWait(DeleteNode.class.getName(), DeleteNode.newBuilder().setNodeName((String)a3).build().toByteArray());
    }

    private /* synthetic */ void L(Duration duration) {
        Duration a22 = duration;
        ClusterChangesHandler a3 = this;
        try {
            Thread.sleep(a22.toMillis());
            return;
        }
        catch (InterruptedException a22) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(a22);
        }
    }

    public void deleteNode(String string) {
        String a2 = string;
        ClusterChangesHandler a3 = this;
        ClusterNode clusterNode = a3.e.getNode(a2);
        if (clusterNode == null) {
            a3.C.info(ReplicationRestControllerV2.L((Object)"N\nf\n~\n*!e\u000boU*\u0014wO'OD\u0000n\n*\u0001e\u001b*\te\u001ad\u000b$"), (Object)a2);
            return;
        }
        for (AdminReplicationGroupMember adminReplicationGroupMember2 : clusterNode.getReplicationGroups()) {
            if (LeaderElectionCheck.L((ClusterController)a3.e, (AdminReplicationGroup)adminReplicationGroupMember2.getReplicationGroup(), (String)a2)) continue;
            throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, "Cannot delete node at this moment, without the node there is no leader for " + adminReplicationGroupMember2.getReplicationGroup().getName());
        }
        a3.A.publishScheduledTask(RaftAdminGroup.L(), UnregisterNodeTask.class.getName(), (Object)a2, Duration.ofSeconds(1L));
        if (a2.equals(a3.e.getName())) {
            a3.L(Duration.ofSeconds(3L));
        }
        clusterNode.getReplicationGroups().forEach(adminReplicationGroupMember -> {
            void a2;
            ClusterChangesHandler a3 = adminReplicationGroupMember;
            ClusterChangesHandler a4 = this;
            a4.A.publishScheduledTask(RaftAdminGroup.L(), PrepareDeleteNodeFromContextTask.class.getName(), (Object)new NodeContext((String)a2, a3.getReplicationGroup().getName(), true), Duration.ZERO);
        });
    }

    private /* synthetic */ byte[] L() {
        ClusterChangesHandler a2;
        return a2.I.readLicense();
    }
}

