/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.config.AxonServerRoutingConfiguration;
import io.axoniq.axonserver.enterprise.cluster.ClientConnectionInformation;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.grpc.AuthenticationProvider;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.CommandService;
import io.axoniq.axonserver.grpc.ContextProvider;
import io.axoniq.axonserver.grpc.GrpcCommandDispatcherListener;
import io.axoniq.axonserver.grpc.GrpcExceptionBuilder;
import io.axoniq.axonserver.grpc.InstructionAck;
import io.axoniq.axonserver.grpc.InstructionAckSource;
import io.axoniq.axonserver.grpc.SerializedCommand;
import io.axoniq.axonserver.grpc.SerializedCommandProviderInbound;
import io.axoniq.axonserver.grpc.SerializedCommandResponse;
import io.axoniq.axonserver.grpc.command.CommandProviderOutbound;
import io.axoniq.axonserver.grpc.command.CommandServiceGrpc;
import io.axoniq.axonserver.grpc.heartbeat.ApplicationInactivityException;
import io.axoniq.axonserver.message.ByteStringMarshaller;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.transport.rest.v2.ScheduledEventsRestControllerV2;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.PreDestroy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service(value="CommandService")
public class CommandService
implements AxonServerClientService {
    private final Map<ClientStreamIdentification, GrpcCommandDispatcherListener> F;
    private final ApplicationEventPublisher G;
    private final InstructionAckSource<SerializedCommandProviderInbound> k;
    private final AxonServerRoutingConfiguration h;
    private final Logger L;
    private static final MethodDescriptor<ByteString, SerializedCommandResponse> m = CommandServiceGrpc.getDispatchMethod().toBuilder((MethodDescriptor.Marshaller)ByteStringMarshaller.L(), ProtoUtils.marshaller((Message)SerializedCommandResponse.getDefaultInstance())).build();
    private final CommandDispatcher M;
    @Value(value="${axoniq.axonserver.command-threads:1}")
    private int i;
    private static final MethodDescriptor<CommandProviderOutbound, SerializedCommandProviderInbound> a = CommandServiceGrpc.getOpenStreamMethod().toBuilder(ProtoUtils.marshaller((Message)CommandProviderOutbound.getDefaultInstance()), ProtoUtils.marshaller((Message)SerializedCommandProviderInbound.getDefaultInstance())).build();
    private final ContextProvider I;
    private final AuthenticationProvider A;
    private final Topology e;
    private final ClientIdRegistry C;
    private final MeterFactory g;

    @PreDestroy
    public void cleanup() {
        CommandService a2;
        a2.F.forEach((clientStreamIdentification, grpcCommandDispatcherListener) -> {
            ClientStreamIdentification a2 = grpcCommandDispatcherListener;
            ClientStreamIdentification a3 = clientStreamIdentification;
            a2.cancel();
        });
        a2.F.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void completeStreamForInactivity(String string, ClientStreamIdentification clientStreamIdentification) {
        CommandService a2 = clientStreamIdentification;
        CommandService a3 = this;
        if (a3.F.containsKey(a2)) {
            void a4;
            String string2 = "Command stream inactivity for " + a2.A();
            string2 = new ApplicationInactivityException(string2);
            ((GrpcCommandDispatcherListener)a3.F.remove(a2)).cancelAndCompleteStreamExceptionally((Throwable)((Object)string2));
            CommandService commandService = a3;
            commandService.L.debug(ScheduledEventsRestControllerV2.L((Object)"\u000eE G,D)\n\u001e^?O,GmI!E>O)\n+E?\n.F$O#^w\n6W"), (Object)a2);
            commandService.G.publishEvent((Object)new TopologyEvents.CommandHandlerDisconnected(a2.a(), (String)a4, a2.A()));
        }
    }

    public Set<GrpcCommandDispatcherListener> listeners() {
        CommandService a2;
        return new HashSet<GrpcCommandDispatcherListener>(a2.F.values());
    }

    /*
     * WARNING - void declaration
     */
    public StreamObserver<CommandProviderOutbound> openStream(StreamObserver<SerializedCommandProviderInbound> streamObserver) {
        void a2;
        CommandService commandService = this;
        String string = commandService.I.getContext();
        Object a3 = new ConcurrentHashMap();
        1 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        CommandService commandService2 = commandService;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public final ServerServiceDefinition bindService() {
        CommandService a2;
        return ServerServiceDefinition.builder((String)ScheduledEventsRestControllerV2.L((Object)"$EcK5E#C<\u0004,R\"D>O?\\(XcM?Z.\u0004.E G,D)\u0004\u000eE G,D)y(X;C.O")).addMethod(a, ServerCalls.asyncBidiStreamingCall(arg_0 -> a2.openStream(arg_0))).addMethod(m, ServerCalls.asyncUnaryCall((arg_0, arg_1) -> a2.dispatch(arg_0, arg_1))).build();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(String string, StreamObserver streamObserver, SerializedCommandResponse serializedCommandResponse) {
        void a2;
        void a3;
        CommandService a4 = serializedCommandResponse;
        CommandService a5 = this;
        a5.L((String)a3, (SerializedCommandResponse)a4, (StreamObserver)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void dispatch(ByteString byteString, StreamObserver<SerializedCommandResponse> streamObserver) {
        void a2;
        CommandService a222 = byteString;
        CommandService a3 = this;
        a222 = new SerializedCommand((ByteString)a222);
        String string = a222.wrapped().getClientId();
        if (a3.L.isTraceEnabled()) {
            a3.L.trace(ClientConnectionInformation.L((Object)"JT\u000b\tcLRLX_TM\u0011J^D\\H_M\u000b\tJT"), (Object)string, (Object)a222.wrapped().getName());
        }
        try {
            CommandService commandService = a3;
            commandService.M.dispatch(commandService.I.getContext(), (Authentication)a3.A.get(), (SerializedCommand)a222, arg_0 -> a3.L(string, (StreamObserver)a2, arg_0));
            return;
        }
        catch (Exception a222) {
            Exception exception = a222;
            a3.L.warn(ScheduledEventsRestControllerV2.L((Object)"\tC>Z,^.B$D*\n+K$F(Nm]$^%\n8D(R=O.^(NmO?X\"X"), (Throwable)exception);
            a2.onError((Throwable)GrpcExceptionBuilder.build((Throwable)exception));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(String string, SerializedCommandResponse serializedCommandResponse, StreamObserver<SerializedCommandResponse> streamObserver) {
        CommandService a22 = serializedCommandResponse;
        CommandService a3 = this;
        try {
            void a4;
            void v0 = a4;
            v0.onNext((Object)a22);
            v0.onCompleted();
            return;
        }
        catch (RuntimeException a22) {
            void a5;
            a3.L.debug(ClientConnectionInformation.L((Object)"cLBY^GBL\u0011]^\tREXL_]\u0011RL\tWHXETM"), (Object)a5, (Object)a22);
            return;
        }
    }

    private /* synthetic */ boolean L(InstructionAck instructionAck) {
        CommandService a2 = instructionAck;
        CommandService a3 = this;
        if (a2.hasError() && a2.getError().getErrorCode().equals(ErrorCode.UNSUPPORTED_INSTRUCTION.getCode())) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public CommandService(Topology topology, CommandDispatcher commandDispatcher, ContextProvider contextProvider, AuthenticationProvider authenticationProvider, ClientIdRegistry clientIdRegistry, MeterFactory meterFactory, ApplicationEventPublisher applicationEventPublisher, @Qualifier(value="commandInstructionAckSource") InstructionAckSource<SerializedCommandProviderInbound> instructionAckSource, AxonServerRoutingConfiguration axonServerRoutingConfiguration) {
        void instructionAckSource2;
        void eventPublisher;
        void meterFactory2;
        void clientIdRegistry2;
        void authenticationProvider2;
        void contextProvider2;
        void commandDispatcher2;
        void topology2;
        CommandService a2;
        CommandService commandService = commandService2;
        CommandService commandService2 = axonServerRoutingConfiguration;
        CommandService commandService3 = a2 = commandService;
        CommandService commandService4 = a2;
        CommandService commandService5 = a2;
        CommandService commandService6 = a2;
        CommandService commandService7 = a2;
        a2.L = LoggerFactory.getLogger(CommandService.class);
        CommandService commandService8 = a2;
        a2.F = new ConcurrentHashMap();
        commandService7.i = 1;
        commandService7.e = topology2;
        commandService6.M = commandDispatcher2;
        commandService6.I = contextProvider2;
        commandService5.A = authenticationProvider2;
        commandService5.C = clientIdRegistry2;
        commandService4.g = meterFactory2;
        commandService4.G = eventPublisher;
        commandService3.k = instructionAckSource2;
        commandService3.h = commandService2;
    }
}

