/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.grpc;

import io.axoniq.axonserver.AxonServerAccessController;
import io.axoniq.axonserver.LicenseAccessController;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.exception.FailedToStartException;
import io.axoniq.axonserver.grpc.AuthenticationInterceptor;
import io.axoniq.axonserver.grpc.AxonServerClientService;
import io.axoniq.axonserver.grpc.ContextInterceptor;
import io.axoniq.axonserver.grpc.GrpcBufferingInterceptor;
import io.axoniq.axonserver.grpc.LicenseInterceptor;
import io.axoniq.axonserver.message.command.CommandInformation;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.transport.rest.v2.SubscriptionQueriesRestControllerV2;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerTransportFilter;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.util.AdvancedTlsX509KeyManager;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component(value="Gateway")
public class Gateway
implements SmartLifecycle {
    private final MessagingPlatformConfiguration k;
    private final Supplier<ScheduledExecutorService> h;
    private final AxonServerAccessController L;
    private final ExecutorService m;
    private final List<AxonServerClientService> M;
    private final MeterFactory i;
    private boolean a;
    private AdvancedTlsX509KeyManager.Closeable I;
    private final LicenseAccessController A;
    private final Logger e;
    private Server C;
    private final List<ServerTransportFilter> g;

    /*
     * WARNING - void declaration
     */
    @Autowired
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, Supplier<ScheduledExecutorService> supplier, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        Gateway a9;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway gateway3 = a9 = gateway;
        Gateway gateway4 = a9;
        Gateway gateway5 = a9;
        Gateway gateway6 = a9;
        gateway6.e = LoggerFactory.getLogger(Gateway.class);
        gateway6.k = a8;
        gateway5.M = a7;
        gateway5.g = a6;
        gateway4.L = a5;
        gateway4.A = a4;
        a9.h = a3;
        gateway3.i = a2;
        gateway3.m = Executors.newFixedThreadPool(a9.k.getExecutorThreadCount(), (ThreadFactory)new CustomizableThreadFactory(CommandInformation.L((Object)"9(.9s?&?=/*5,w")));
    }

    public void stop() {
        Gateway gateway = this;
        if (gateway.I != null) {
            gateway.I.close();
        }
        Gateway gateway2 = gateway;
        gateway2.m.shutdown();
        if (gateway2.a) {
            try {
                if (!gateway.C.shutdown().awaitTermination(1L, TimeUnit.SECONDS)) {
                    Gateway gateway3 = gateway;
                    gateway3.e.debug(SubscriptionQueriesRestControllerV2.L((Object)"\u0001\r5\u0001\"\u00042\u000e+\u001bg\u00113\r7\u0012.\f B\u0004\u000e2\u00113\u00075B\u0014\u00075\u0014\"\u0010"));
                    gateway3.C.shutdownNow();
                }
            }
            catch (InterruptedException a2) {
                gateway.e.debug(CommandInformation.L((Object)"\u00174*?,(+**?:z:/,30=~)6/*>1-0z1<~\u001d\f\n\u001dz-?,,;("), (Throwable)a2);
                Thread.currentThread().interrupt();
            }
        }
        gateway.a = false;
        gateway.e.info(SubscriptionQueriesRestControllerV2.L((Object)"#?\r)B\u0014\u00075\u0014\"\u0010g%&\u0016\"\u0015&\u001bg\u00113\r7\u0012\"\u0006"));
    }

    public boolean isRunning() {
        Gateway a2;
        return a2.a;
    }

    public int getPhase() {
        return 200;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        Gateway gateway = this;
        String string = CommandInformation.L((Object)"05~\t\r\u0016");
        try {
            Gateway a2;
            Gateway gateway2;
            if (gateway.k.getSsl() != null && gateway.k.getSsl().isEnabled()) {
                AdvancedTlsX509KeyManager advancedTlsX509KeyManager = new AdvancedTlsX509KeyManager();
                gateway.I = advancedTlsX509KeyManager.updateIdentityCredentialsFromFile(new File(gateway.k.getSsl().getPrivateKeyFile()), new File(gateway.k.getSsl().getCertChainFile()), 1L, TimeUnit.MINUTES, (ScheduledExecutorService)gateway.h.get());
                KeyManager[] keyManagerArray = new KeyManager[1];
                keyManagerArray[0] = advancedTlsX509KeyManager;
                ServerCredentials serverCredentials = TlsServerCredentials.newBuilder().keyManager(keyManagerArray).clientAuth(TlsServerCredentials.ClientAuth.NONE).build();
                string = SubscriptionQueriesRestControllerV2.L((Object)"1\u0014.g\u0007)\u0003%\u000e\"\u0006");
                Gateway gateway3 = gateway;
                gateway2 = gateway3;
                a2 = NettyServerBuilder.forPort((int)gateway3.k.getPort(), (ServerCredentials)serverCredentials);
            } else {
                Gateway gateway4 = gateway;
                gateway2 = gateway4;
                a2 = NettyServerBuilder.forPort((int)gateway4.k.getPort());
            }
            if (gateway2.k.getMaxMessageSize() > 0) {
                a2.maxInboundMessageSize(gateway.k.getMaxMessageSize());
            }
            a2.permitKeepAliveWithoutCalls(true).permitKeepAliveTime(gateway.k.getMinKeepAliveTime(), TimeUnit.MILLISECONDS);
            gateway.M.forEach(arg_0 -> ((NettyServerBuilder)a2).addService(arg_0));
            a2.intercept((ServerInterceptor)new GrpcBufferingInterceptor(gateway.k.getGrpcBufferedMessages()));
            if (gateway.k.getAccesscontrol().isEnabled()) {
                Gateway gateway5 = gateway;
                a2.intercept((ServerInterceptor)new AuthenticationInterceptor(gateway5.L, gateway5.i));
            }
            a2.intercept((ServerInterceptor)new LicenseInterceptor(gateway.A));
            a2.intercept((ServerInterceptor)new ContextInterceptor());
            if (gateway.k.getKeepAliveTime() > 0L) {
                a2.keepAliveTime(gateway.k.getKeepAliveTime(), TimeUnit.MILLISECONDS).keepAliveTimeout(gateway.k.getKeepAliveTimeout(), TimeUnit.MILLISECONDS);
            }
            a2.executor((Executor)gateway.m);
            gateway.g.forEach(arg_0 -> ((NettyServerBuilder)a2).addTransportFilter(arg_0));
            gateway.C = a2.build();
            gateway.C.start();
            gateway.e.info(CommandInformation.L((Object)"\u001f\"14~\t;((?,z\u0019;*?);'z-.?(*?:z14~*1(*`~!#zsz%'"), (Object)gateway.k.getPort(), (Object)string);
            gateway.a = true;
            return;
        }
        catch (Exception exception) {
            throw new FailedToStartException(SubscriptionQueriesRestControllerV2.L((Object)"13\u00035\u0016.\f B\u0006\u001a(\fg1\"\u00101\u00075B\u0000\u00033\u00070\u0003>B!\u0003.\u000e\"\u0006"), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Gateway(MessagingPlatformConfiguration messagingPlatformConfiguration, List<AxonServerClientService> list, List<ServerTransportFilter> list2, AxonServerAccessController axonServerAccessController, LicenseAccessController licenseAccessController, MeterFactory meterFactory) {
        Gateway a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        Gateway gateway = gateway2;
        Gateway gateway2 = meterFactory;
        Gateway a8 = gateway;
        a8((MessagingPlatformConfiguration)a7, (List)a6, (List)a5, (AxonServerAccessController)a4, (LicenseAccessController)a3, Executors::newSingleThreadScheduledExecutor, (MeterFactory)a2);
    }

    public boolean isAutoStartup() {
        return true;
    }
}

