/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.access.application.AdminApplicationController;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.rest.json.CommandResponseJson;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class FileUtils {
    public static final Logger g = LoggerFactory.getLogger(FileUtils.class);

    public static String[] L(File file, String string) {
        String[] a2 = string;
        File a3 = file;
        if ((a2 = a3.list((arg_0, arg_1) -> FileUtils.L((String)a2, arg_0, arg_1))) == null) {
            throw new MessagingPlatformException(ErrorCode.DATAFILE_READ_ERROR, "Could not list files in " + a3.getAbsolutePath());
        }
        return a2;
    }

    public static boolean L(File file) {
        File file2 = file;
        if (!file2.exists()) {
            return true;
        }
        g.debug(CommandResponseJson.L((Object)"1n\u0019n\u0001nUm\u001cg\u0010+\u000ev"), (Object)file2.getAbsolutePath());
        try {
            Files.delete(file2.toPath());
        }
        catch (DirectoryNotEmptyException a2) {
            g.info(AdminApplicationController.L((Object)"\u0010}?p3xvh9<2y:y\"yvx?n3\u007f\"s$el<-az<?hvu%<8s\"<3q&h/"), (Object)file2);
            return false;
        }
        catch (IOException a2) {
            g.warn(CommandResponseJson.L((Object)"3j\u001cg\u0010oU\u007f\u001a+\u0011n\u0019n\u0001nO+\u000ev"), (Object)file2, (Object)a2);
            return false;
        }
        return true;
    }

    public static void L(File a2) {
        if (a2.exists() && !a2.isDirectory()) {
            throw new MessagingPlatformException(ErrorCode.DIRECTORY_CREATION_FAILED, "Could not setup directory " + a2.getAbsolutePath());
        }
        if (!a2.exists() && !a2.mkdirs()) {
            throw new MessagingPlatformException(ErrorCode.DIRECTORY_CREATION_FAILED, "Could not setup directory " + a2.getAbsolutePath());
        }
    }

    public static Mono<Void> L(File file, File file2) {
        File a2 = file2;
        File a3 = file;
        return Mono.create(monoSink -> {
            void a2;
            File file3 = a3;
            try {
                void v1;
                void a3;
                if (Files.getFileStore(file3.toPath()).equals(Files.getFileStore(a3.getParentFile().toPath()))) {
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.move(file3.toPath(), a3.toPath(), copyOptionArray);
                    v1 = a2;
                } else {
                    File a4 = File.createTempFile(a3.getName(), AdminApplicationController.L((Object)"2\"q&"), a3.getParentFile());
                    a4.deleteOnExit();
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.copy(file3.toPath(), a4.toPath(), copyOptionArray);
                    Files.delete(file3.toPath());
                    CopyOption[] copyOptionArray2 = new CopyOption[1];
                    copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.move(a4.toPath(), a3.toPath(), copyOptionArray2);
                    v1 = a2;
                }
                v1.success();
                return;
            }
            catch (Exception a4) {
                a2.error((Throwable)a4);
                return;
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }

    private /* synthetic */ FileUtils() {
        FileUtils a2;
    }

    private static /* synthetic */ boolean L(String string, File file, String string2) {
        String a2 = string2;
        String a3 = string;
        return a2.endsWith(a3);
    }

    public static FileVersion L(String string) {
        String string2 = string;
        String string3 = string2;
        String a2 = string3.substring(0, string3.indexOf(46));
        int n = a2.indexOf(95);
        if (n < 0) {
            return new FileVersion(Long.parseLong(a2), 0);
        }
        return new FileVersion(Long.parseLong(a2.substring(0, n)), Integer.parseInt(a2.substring(n + 1)));
    }

    public static String L(File a2) {
        try {
            return a2.getCanonicalFile().getAbsolutePath();
        }
        catch (IOException iOException) {
            return a2.getAbsolutePath();
        }
    }
}

