/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.localstorage.file;

import io.axoniq.axonserver.config.FileSystemMonitor;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ApplicationProtoConverter;
import io.axoniq.axonserver.grpc.event.Event;
import io.axoniq.axonserver.localstorage.EventTypeContext;
import io.axoniq.axonserver.localstorage.file.AbstractFileStorageTier;
import io.axoniq.axonserver.localstorage.file.ByteBufferEventSource;
import io.axoniq.axonserver.localstorage.file.EventInformation;
import io.axoniq.axonserver.localstorage.file.EventSource;
import io.axoniq.axonserver.localstorage.file.FilePreparedTransaction;
import io.axoniq.axonserver.localstorage.file.FileUtils;
import io.axoniq.axonserver.localstorage.file.FileVersion;
import io.axoniq.axonserver.localstorage.file.IndexEntry;
import io.axoniq.axonserver.localstorage.file.IndexManager;
import io.axoniq.axonserver.localstorage.file.L;
import io.axoniq.axonserver.localstorage.file.Segment;
import io.axoniq.axonserver.localstorage.file.StorageProperties;
import io.axoniq.axonserver.localstorage.file.StorageTier;
import io.axoniq.axonserver.localstorage.file.Synchronizer;
import io.axoniq.axonserver.localstorage.file.WritableEventSource;
import io.axoniq.axonserver.localstorage.file.WritePosition;
import io.axoniq.axonserver.localstorage.transformation.EventTransformer;
import io.axoniq.axonserver.localstorage.transformation.EventTransformerFactory;
import io.axoniq.axonserver.localstorage.transformation.ProcessedEvent;
import io.axoniq.axonserver.localstorage.transformation.WrappedEvent;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WritableFileStorageTier
extends AbstractFileStorageTier {
    private final EventTransformer m;
    private final MeterFactory M;
    protected final ConcurrentNavigableMap<Long, ByteBufferEventSource> i;
    protected final AtomicLong a;
    private Path I;
    private final FileSystemMonitor A;
    private final Gauge e;
    protected final AtomicReference<WritePosition> C;
    private static final Logger d = LoggerFactory.getLogger(WritableFileStorageTier.class);
    private final Synchronizer g;

    public Flux<FileVersion> fileVersions(String string) {
        Object a2 = string;
        WritableFileStorageTier a3 = this;
        return (Flux)a3.L(arg_0 -> WritableFileStorageTier.L((String)a2, arg_0), (Object)Flux.empty());
    }

    private static /* synthetic */ Boolean L(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.removeSegment(a2, a4);
    }

    public int L() {
        WritableFileStorageTier a2;
        return a2.i.size();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(WritePosition writePosition, List<ProcessedEvent> list, Map<String, List<IndexEntry>> map) {
        void a2;
        void a3;
        WritableFileStorageTier a4 = writePosition;
        WritableFileStorageTier a5 = this;
        WritableFileStorageTier writableFileStorageTier = a4;
        a4.e.L((List)a3, writableFileStorageTier.I, writableFileStorageTier.A, (arg_0, arg_1, arg_2) -> a5.L((Map)a2, arg_0, arg_1, arg_2));
    }

    public long a() {
        WritableFileStorageTier a2;
        return a2.a.get();
    }

    public long size() {
        WritableFileStorageTier a3;
        return a3.i.values().stream().mapToLong(a2 -> a2.A.capacity()).sum() + (Long)a3.L(StorageTier::size, (Object)0L);
    }

    public long A() {
        WritableFileStorageTier a3;
        return (Long)a3.L((T a2) -> a2.allSegments().findFirst().orElse(-1L), (Object)-1L);
    }

    public void close(boolean bl) {
        boolean a2 = bl;
        WritableFileStorageTier a3 = this;
        File file = new File(a3.M);
        WritableFileStorageTier writableFileStorageTier = a3;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.A.unregisterPath(writableFileStorageTier2.L());
        writableFileStorageTier.M.remove((Meter)a3.e);
        writableFileStorageTier2.g.A();
        writableFileStorageTier.i.forEach((l2, byteBufferEventSource) -> {
            void a2;
            WritableFileStorageTier a3 = byteBufferEventSource;
            WritableFileStorageTier a4 = this;
            a3.L(0L);
            if (a2 != false) {
                void a5;
                a4.A(a5.longValue());
            }
        });
        a3.L((T storageTier) -> {
            StorageTier a2 = storageTier;
            boolean a3 = a2;
            a2.close(a3);
        });
        boolean bl2 = a2;
        a3.K.cleanup(bl2);
        if (bl2) {
            FileUtils.L((File)file);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean L(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)a4.i.remove((long)a2);
        if (byteBufferEventSource != null) {
            byteBufferEventSource.L(0L);
        }
        if (a4.K.remove(a3 = new FileVersion((long)a2, a3)) && FileUtils.L((File)a4.L(a3))) {
            return true;
        }
        return false;
    }

    private /* synthetic */ String L() {
        WritableFileStorageTier a2;
        WritableFileStorageTier writableFileStorageTier = a2;
        return writableFileStorageTier.a + "-" + writableFileStorageTier.a.L().name().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ FileVersion L(FileVersion fileVersion, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        WritableEventSource a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier2 = this;
        if (!writableFileStorageTier2.K.validIndex((FileVersion)a3)) {
            return a3;
        }
        a2 = writableFileStorageTier2.L((FileVersion)a3, a2.getSegmentSize(), false);
        long l2 = a3.L();
        try {
            WritableFileStorageTier a42222 = a2.createEventIterator(a3.L());
            try {
                while (a42222.hasNext()) {
                    a42222.L();
                    ++l2;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (a42222 != null) {
                    try {
                        a42222.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable a42222) {
                        throwable.addSuppressed(a42222);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        catch (Throwable a42222) {
            writableFileStorageTier2.i.remove(a3.L());
            a2.L(0L);
            throw a42222;
        }
        if (a42222 != null) {
            writableFileStorageTier = writableFileStorageTier2;
            a42222.close();
        } else {
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.i.remove(a3.L());
        a2.L(0L);
        return new FileVersion(l2, 0);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(long l2, Integer n) {
        void a2;
        Integer a3 = n;
        WritableFileStorageTier a4 = this;
        a4.L((long)a2, a3.intValue());
    }

    private /* synthetic */ void A() {
        WritableFileStorageTier writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier = this;
        while (true) {
            if (writableFileStorageTier2.i.size() == 1) break;
            try {
                Thread.sleep(10L);
                writableFileStorageTier2 = writableFileStorageTier;
            }
            catch (InterruptedException a2) {
                Thread.currentThread().interrupt();
                throw new MessagingPlatformException(ErrorCode.OTHER, writableFileStorageTier.a + ": Interrupted while waiting for completion", (Throwable)a2);
            }
        }
    }

    public SortedSet<Long> getSegments() {
        WritableFileStorageTier a2;
        return a2.i.keySet();
    }

    /*
     * WARNING - void declaration
     */
    public Integer currentSegmentVersion(Long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.i.get(a2);
        if (a3 != null) {
            return a3.L();
        }
        return (Integer)writableFileStorageTier.L(arg_0 -> WritableFileStorageTier.L((Long)a2, arg_0), (Object)0);
    }

    /*
     * WARNING - void declaration
     */
    public WritableFileStorageTier(EventTypeContext eventTypeContext, IndexManager indexManager, Supplier<StorageProperties> supplier, Supplier<StorageTier> supplier2, MeterFactory meterFactory, ScheduledExecutorService scheduledExecutorService, String string, EventTransformerFactory eventTransformerFactory, FileSystemMonitor fileSystemMonitor) {
        void a2;
        void a3;
        void a4;
        void a5;
        WritableFileStorageTier a6;
        void a7;
        void a8;
        void a9;
        void a10;
        WritableFileStorageTier a11;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = meterFactory;
        WritableFileStorageTier writableFileStorageTier3 = a11 = writableFileStorageTier;
        WritableFileStorageTier writableFileStorageTier4 = a11;
        super((EventTypeContext)a10, (IndexManager)a9, (Supplier)a8, (Supplier)a7, (MeterFactory)a6, (String)a5);
        WritableFileStorageTier writableFileStorageTier5 = a11;
        writableFileStorageTier5.C = new AtomicReference();
        WritableFileStorageTier writableFileStorageTier6 = a11;
        writableFileStorageTier4.a = new AtomicLong(-1L);
        WritableFileStorageTier writableFileStorageTier7 = a11;
        writableFileStorageTier4.i = new ConcurrentSkipListMap(Comparator.reverseOrder());
        writableFileStorageTier4.M = a6;
        writableFileStorageTier3.A = a4;
        writableFileStorageTier3.m = a3.get(((StorageProperties)a8.get()).getFlags());
        WritableFileStorageTier writableFileStorageTier8 = a11;
        writableFileStorageTier8.g = new Synchronizer((EventTypeContext)a10, (StorageProperties)a8.get(), (MeterFactory)a6, (ScheduledExecutorService)a2, writePosition -> {
            WritableFileStorageTier a2;
            WritableFileStorageTier a3 = writePosition;
            WritableFileStorageTier writableFileStorageTier = a2 = this;
            writableFileStorageTier.K.complete(new FileVersion(a3.M.longValue(), 0));
            writableFileStorageTier.L(arg_0 -> writableFileStorageTier.L((WritePosition)a3, arg_0));
        });
        String[] stringArray = new String[4];
        stringArray[0] = "context";
        stringArray[1] = a10.L();
        stringArray[2] = "type";
        stringArray[3] = a10.L().name();
        a11.e = a6.gauge((MetricName)BaseMetricName.Ia, Tags.of((String[])stringArray), (Object)a11.g, synchronizer -> {
            WritableFileStorageTier a2 = synchronizer;
            WritableFileStorageTier a3 = this;
            return (double)a3.a.get() - (double)a2.L();
        });
    }

    /*
     * WARNING - void declaration
     */
    public void a(long l2) {
        void a22;
        WritableFileStorageTier writableFileStorageTier = this;
        if (!writableFileStorageTier.i.containsKey((long)a22)) {
            return;
        }
        if (a22 == ((Long)writableFileStorageTier.i.firstKey()).longValue()) {
            d.info(ApplicationProtoConverter.L((Object)"n(/uS:g6|;ru{0m!5&p2x0{!5!zuw056g0t!p1"), (Object)writableFileStorageTier.a);
            StorageProperties a22 = (StorageProperties)writableFileStorageTier.A.get();
            WritePosition writePosition2 = (WritePosition)writableFileStorageTier.C.getAndUpdate(writePosition -> {
                StorageProperties a2 = writePosition;
                StorageProperties a3 = a22;
                return a2.L(0, a3.getSegmentSize(), 0);
            });
            if (writePosition2.L(a22.getSegmentSize())) {
                d.debug(CommandDispatcher.L((Object)"\b^I\u00030Q\u0016B\u0007J\u001dDSM\u0016TSP\u0016D\u001eF\u001dWSX\u000e"), (Object)writableFileStorageTier.a, (Object)writePosition2.A);
                WritePosition writePosition3 = writePosition2;
                writePosition3.e.L(writePosition3.I, -1);
                WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier;
                WritableFileStorageTier a3 = writableFileStorageTier2.L(new FileVersion(writePosition2.A, 0), a22.getSegmentSize(), false);
                writableFileStorageTier.C.set(writePosition2.L((WritableEventSource)a3, 0));
                writableFileStorageTier2.g.L(new WritePosition(writePosition2.A, 0, 0, (WritableEventSource)a3, Long.valueOf(writePosition2.A), writePosition2.i));
            }
        }
        writableFileStorageTier.A();
    }

    public void initSegments(long a2) {
    }

    private static /* synthetic */ Optional L(long a2, StorageTier a3) {
        return a3.eventSource(a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(long l2, File file, long l3, StorageProperties storageProperties) {
        WritableFileStorageTier writableFileStorageTier;
        int n;
        WritableFileStorageTier a3;
        HashMap<String, List> a222;
        WritableEventSource a4;
        FileVersion a5;
        long a6;
        WritableFileStorageTier writableFileStorageTier2;
        block10: {
            block8: {
                void a222;
                WritableFileStorageTier writableFileStorageTier3 = writableFileStorageTier2 = this;
                a5 = writableFileStorageTier3.L(a6, (File)a5, new FileVersion((long)a222, 0), (StorageProperties)a4);
                writableFileStorageTier3.L(a5.L());
                a5 = writableFileStorageTier3.L(a5, (StorageProperties)a4);
                writableFileStorageTier3.L((T storageTier) -> {
                    FileVersion a2 = storageTier;
                    FileVersion a3 = a5;
                    a2.initSegments(a3.L());
                });
                WritableFileStorageTier writableFileStorageTier4 = writableFileStorageTier2;
                writableFileStorageTier4.L();
                a4 = writableFileStorageTier4.L(a5, a4.getSegmentSize(), false);
                writableFileStorageTier4.K.remove(a5);
                a6 = a5.L();
                a222 = new HashMap<String, List>();
                a3 = a4.createEventIterator();
                try {
                    WritableFileStorageTier writableFileStorageTier5 = a3;
                    while (writableFileStorageTier5.hasNext()) {
                        EventInformation eventInformation = a3.L();
                        if (eventInformation.L()) {
                            IndexEntry indexEntry = new IndexEntry(eventInformation.L().getAggregateSequenceNumber(), eventInformation.L(), a6);
                            a222.computeIfAbsent(eventInformation.L().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                        }
                        ++a6;
                        writableFileStorageTier5 = a3;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block9: {
                        if (a3 != null) {
                            try {
                                a3.close();
                                throwable2 = throwable;
                                break block9;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throwable2 = throwable;
                    }
                    throw throwable2;
                }
                n = a3.L();
                writableFileStorageTier2.a.set(a6 - 1L);
                if (a3 == null) break block8;
                writableFileStorageTier = writableFileStorageTier2;
                a3.close();
                break block10;
            }
            writableFileStorageTier = writableFileStorageTier2;
        }
        writableFileStorageTier.K.addToActiveSegment(Long.valueOf(a5.L()), a222);
        a4.L(n, 0);
        a3 = new WritePosition(a6, n, a5.L(), a4, Long.valueOf(a5.L()), 0);
        WritableFileStorageTier writableFileStorageTier6 = writableFileStorageTier2;
        writableFileStorageTier6.C.set(a3);
        writableFileStorageTier6.g.A((WritePosition)a3);
        d.info(ApplicationProtoConverter.L((Object)"n(/uF0r8p;a&5<{<a<t9|/p1"), (Object)writableFileStorageTier2.a);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeSegment(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        if (a4.i.containsKey((long)a2)) {
            return a4.L((long)a2, a3);
        }
        return (Boolean)a4.L(arg_0 -> WritableFileStorageTier.L((long)a2, a3, arg_0), (Object)true);
    }

    public long L(List<Event> list, int n) {
        FilePreparedTransaction a2;
        WritableFileStorageTier a3;
        int a222 = n;
        WritableFileStorageTier writableFileStorageTier = a3 = this;
        WritableFileStorageTier writableFileStorageTier2 = a3;
        writableFileStorageTier.A.checkFreeSpace(writableFileStorageTier2.I);
        HashMap hashMap = new HashMap();
        a2 = writableFileStorageTier.L((List)a2, a222);
        WritePosition a222 = a2.L();
        writableFileStorageTier2.L(a222, a2.L(), hashMap);
        writableFileStorageTier.K.addToActiveSegment(a222.M, hashMap);
        writableFileStorageTier.a.set(a222.A + (long)a2.L().size() - 1L);
        writableFileStorageTier.g.L(a222);
        return a222.A;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(WritePosition writePosition) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a3 = (ByteBufferEventSource)writableFileStorageTier.i.remove(a2.M);
        d.debug(ApplicationProtoConverter.L((Object)"]4{1p15:c0gun(9ug0x4|;|;ruf0r8p;a&/un("), (Object)a2.M, (Object)writableFileStorageTier.getSegments());
        if (a3 != null) {
            a3.L((long)((StorageProperties)writableFileStorageTier.A.get()).getPrimaryCleanupDelay());
        }
    }

    private static /* synthetic */ void L(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        a3.activateSegmentVersion(a2, a4);
    }

    private /* synthetic */ void L() {
        WritableFileStorageTier writableFileStorageTier = this;
        Object a2 = writableFileStorageTier.segmentsWithoutIndex();
        if (a2.size() > 0) {
            writableFileStorageTier.L((SortedSet)a2);
        }
        d.info(CommandDispatcher.L((Object)"\b^I\u0003:M\u0017F\u000b\u0003\u001cMSG\u001aP\u0018\u0003\u001aPSV\u0003\u0003\u0007LSG\u0012W\u0016"), (Object)writableFileStorageTier.a);
    }

    private /* synthetic */ void L(SortedSet<FileVersion> sortedSet) {
        SortedSet<FileVersion> a2 = sortedSet;
        WritableFileStorageTier a3 = this;
        d.warn(ApplicationProtoConverter.L((Object)".ho5\u0017`9~xv'p4a<{25<{1p-50{!g<p&53z'5.huf0r8p;a&"), (Object)a3.a, (Object)a2.size());
        Instant instant = Instant.now();
        if (a3.K.canBatchIndexParallel() && ((StorageProperties)a3.A.get()).isBulkIndexAllowParallel()) {
            d.info(CommandDispatcher.L((Object)"X\u000e\u0019Sj\u001dG\u0016[\u001aM\u0014\u0003\u0004J\u0007KSS\u0012Q\u0012O\u001fF\u001f\u0003\u0000V\u0003S\u001cQ\u0007"), (Object)a3.a);
            a2.parallelStream().forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.L(arg_0 -> WritableFileStorageTier.A((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.L());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.L();
                        if (!eventInformation.L()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.L().getAggregateSequenceNumber(), eventInformation.L(), eventInformation.L());
                        hashMap.computeIfAbsent(eventInformation.L().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.K.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        } else {
            Object[] objectArray = new Object[3];
            objectArray[0] = a3.a;
            objectArray[1] = a3.K.canBatchIndexParallel();
            objectArray[2] = ((StorageProperties)a3.A.get()).isBulkIndexAllowParallel();
            d.info(ApplicationProtoConverter.L((Object)".ho5\u001c{1p-|;ruf0d p;a<t9y,5}P#t9`4a<z;5:sue4g4y9p95<{1p-|;ro5<{1p-V4e4w<y<a<p&/.hu3s56z;a0m!F0a!|;r&/.h|"), objectArray);
            a2.forEach(fileVersion -> {
                HashMap<String, List> hashMap;
                void a3;
                Object object = this;
                Object a4 = (Optional)object.L(arg_0 -> WritableFileStorageTier.A((FileVersion)a3, arg_0), Optional.empty());
                if (!((Optional)a4).isPresent()) return;
                a4 = ((EventSource)((Optional)a4).get()).createEventIterator(a3.L());
                try {
                    hashMap = new HashMap<String, List>();
                    while (a4.hasNext()) {
                        EventInformation eventInformation = a4.L();
                        if (!eventInformation.L()) continue;
                        IndexEntry indexEntry = new IndexEntry(eventInformation.L().getAggregateSequenceNumber(), eventInformation.L(), eventInformation.L());
                        hashMap.computeIfAbsent(eventInformation.L().getAggregateIdentifier(), a2 -> new LinkedList()).add(indexEntry);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (a4 != null) {
                        try {
                            a4.close();
                            throwable2 = throwable;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throwable2 = throwable;
                    throw throwable2;
                }
                object.K.createIndex((FileVersion)a3, hashMap);
                if (a4 == null) return;
                a4.close();
            });
        }
        d.warn(CommandDispatcher.L((Object)"\b^I\u00031V\u001fH^@\u0001F\u0012W\u001aM\u0014\u0003\u001aM\u0017F\u000b\u0003\u0007L\u001cHSX\u000e"), (Object)a3.a, (Object)Duration.between(instant, Instant.now()));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(ProcessedEvent processedEvent, long l2, int n, Map<String, List<IndexEntry>> map) {
        WritableFileStorageTier a3 = processedEvent;
        WritableFileStorageTier a4 = this;
        if (a3.isDomainEvent()) {
            void a5;
            void a6;
            void a7;
            a7.computeIfAbsent(a3.getAggregateIdentifier(), a2 -> new ArrayList()).add(new IndexEntry(a3.getAggregateSequenceNumber(), (int)a6, (long)a5));
        }
    }

    private static /* synthetic */ boolean L(long a2, FileVersion a3) {
        if (a3.L() < a2) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ WritePosition L(int n, int n2, int n3) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        int n4 = (int)Math.ceil((double)a3 / 32767.0);
        if ((n4 = a4 + n4 * 11) > 0x7FFFFFF6 || a4 <= 0) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a4;
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, String.format(ApplicationProtoConverter.L((Object)"\\9y0r4yua't;f4v!|:{uf<o0/u01"), objectArray));
        }
        do {
            if (!(a4 = (WritePosition)a5.C.getAndUpdate(arg_0 -> WritableFileStorageTier.L((int)a3, n4, (int)a2, arg_0))).L(n4) && !a4.a((int)a2)) continue;
            d.debug(CommandDispatcher.L((Object)"\b^I\u00030Q\u0016B\u0007J\u001dDSM\u0016TSP\u0016D\u001eF\u001dWSX\u000e"), (Object)a5.a, (Object)a4.A);
            WritePosition writePosition = a4;
            writePosition.e.L(writePosition.I, -1);
            WritableEventSource writableEventSource = a5.L(new FileVersion(a4.A, (int)a2), n4 + 5 + 4, true);
            a5.C.set(a4.L(writableEventSource, (int)a2));
        } while (!a4.A(n4) || a4.a((int)a2));
        return a4;
    }

    private static /* synthetic */ Optional A(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.L((long)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.L(arg_0 -> WritableFileStorageTier.L((long)a2, arg_0), Optional.empty());
    }

    protected Optional<EventSource> L(FileVersion fileVersion) {
        WritableFileStorageTier a2 = fileVersion;
        WritableFileStorageTier a3 = this;
        return a3.L(a2.L());
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    protected WritableEventSource L(FileVersion fileVersion, int n, boolean bl) {
        WritableEventSource a2322;
        Object a32222;
        Object object;
        void a4;
        WritableFileStorageTier writableFileStorageTier;
        block21: {
            void a223322;
            writableFileStorageTier = this;
            StorageProperties storageProperties = (StorageProperties)writableFileStorageTier.A.get();
            File file = storageProperties.dataFile(writableFileStorageTier.M, (FileVersion)a4);
            int n2 = Math.max(storageProperties.getSegmentSize(), (int)a223322);
            if (file.exists()) {
                void a2322;
                if (a2322 != false && file.length() < (long)a223322) {
                    object = (ByteBufferEventSource)writableFileStorageTier.i.remove(a4.L());
                    if (object != null) {
                        object.L(0L);
                    }
                    FileUtils.L((File)file);
                } else {
                    n2 = (int)file.length();
                }
            } else if (a4.L() > 0) {
                object = storageProperties.dataFile(writableFileStorageTier.M, new FileVersion(a4.L(), 0));
                if (((File)object).exists()) {
                    a32222 = (ByteBufferEventSource)writableFileStorageTier.i.remove(a4.L());
                    if (a32222 != null) {
                        a32222.L(0L);
                    }
                    FileUtils.L((File)object);
                }
            }
            object = new RandomAccessFile(file, ApplicationProtoConverter.L((Object)"g\""));
            a32222 = ((RandomAccessFile)object).getChannel();
            d.info(CommandDispatcher.L((Object)"\b^I\u0003<S\u0016M\u001aM\u0014\u0003\u0015J\u001fFSX\u000e"), (Object)writableFileStorageTier.a, (Object)file);
            MappedByteBuffer mappedByteBuffer = ((FileChannel)a32222).map(FileChannel.MapMode.READ_WRITE, 0L, n2);
            mappedByteBuffer.put((byte)2);
            mappedByteBuffer.putInt(storageProperties.getFlags());
            WritableEventSource a223322 = new WritableEventSource(file.getAbsolutePath(), (ByteBuffer)mappedByteBuffer, a4.L(), a4.L(), writableFileStorageTier.m, storageProperties);
            writableFileStorageTier.i.put(a4.L(), a223322);
            a2322 = a223322;
            if (a32222 == null) break block21;
            ((AbstractInterruptibleChannel)a32222).close();
        }
        ((RandomAccessFile)object).close();
        return a2322;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        Throwable throwable2;
                        block22: {
                            if (a32222 != null) {
                                try {
                                    ((AbstractInterruptibleChannel)a32222).close();
                                    throwable2 = throwable;
                                    break block22;
                                }
                                catch (Throwable a223322) {
                                    throwable.addSuppressed(a223322);
                                }
                            }
                            throwable2 = throwable;
                        }
                        throw throwable2;
                    }
                    catch (Throwable a32222) {
                        Throwable throwable3;
                        try {
                            ((RandomAccessFile)object).close();
                            throwable3 = a32222;
                        }
                        catch (Throwable throwable4) {
                            Throwable throwable5 = a32222;
                            throwable3 = throwable5;
                            throwable5.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Exception exception) {
                    throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, writableFileStorageTier.a + ": Failed to create segment: " + (FileVersion)a4, (Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void activateSegmentVersion(long l2, int n) {
        void a2;
        int a3 = n;
        WritableFileStorageTier a4 = this;
        a4.L(arg_0 -> WritableFileStorageTier.L((long)a2, a3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public void L(long l2, long l3) {
        void a2;
        void a3;
        WritableFileStorageTier writableFileStorageTier = this;
        WritableFileStorageTier a4 = (StorageProperties)writableFileStorageTier.A.get();
        File file = new File(writableFileStorageTier.M);
        FileUtils.L((File)file);
        WritableFileStorageTier writableFileStorageTier2 = writableFileStorageTier;
        writableFileStorageTier.K.init();
        writableFileStorageTier2.L((long)a3, file, (long)a2, (StorageProperties)a4);
        writableFileStorageTier2.I = file.toPath();
        writableFileStorageTier2.A.registerPath(writableFileStorageTier.L(), writableFileStorageTier.I, a4.minFreeSpace(), a4.warnFreeSpace());
    }

    /*
     * WARNING - void declaration
     */
    public Optional<EventSource> eventSource(FileVersion fileVersion) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        Object a3 = writableFileStorageTier.L((FileVersion)a2);
        if (a3.isPresent()) {
            return a3;
        }
        return (Optional)writableFileStorageTier.L(arg_0 -> WritableFileStorageTier.L((FileVersion)a2, arg_0), Optional.empty());
    }

    private static /* synthetic */ Stream A(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(WritePosition writePosition, StorageTier storageTier) {
        void a2;
        WritableFileStorageTier a3 = writePosition;
        WritableFileStorageTier a4 = this;
        a2.handover((Segment)new L(a4, (WritePosition)a3), () -> a4.A((WritePosition)a3));
    }

    public void handover(Segment segment, Runnable runnable) {
        Runnable a2 = runnable;
        WritableFileStorageTier a3 = this;
        a2.run();
    }

    private static /* synthetic */ Flux L(String string, StorageTier storageTier) {
        String a2 = storageTier;
        String a3 = string;
        return a2.fileVersions(a3);
    }

    protected Optional<EventSource> L(long a2) {
        WritableFileStorageTier a3;
        if (a3.i.containsKey(a2)) {
            return Optional.of((EventSource)a3.i.get(a2));
        }
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FilePreparedTransaction L(List<Event> list, int n) {
        void a22;
        Object a3 = list;
        WritableFileStorageTier a4 = this;
        a3 = a3.stream().map(event -> {
            WritableFileStorageTier a2 = event;
            WritableFileStorageTier a3 = this;
            return new WrappedEvent((Event)a2, a3.m);
        }).collect(Collectors.toList());
        WritableFileStorageTier writableFileStorageTier = a4;
        int n2 = writableFileStorageTier.L((List)a3);
        WritePosition a22 = writableFileStorageTier.L(n2, a3.size(), (int)a22);
        return new FilePreparedTransaction(a22, n2, (List)a3);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ WritePosition L(int n, int n2, int n3, WritePosition writePosition) {
        void a2;
        void a3;
        WritePosition a4 = writePosition;
        int a5 = n;
        return a4.L(a5, (int)a3, (int)a2);
    }

    public long L() {
        WritableFileStorageTier a2;
        return ((WritePosition)a2.C.get()).A;
    }

    private static /* synthetic */ Integer L(Long l2, StorageTier storageTier) {
        Long a2 = storageTier;
        Long a3 = l2;
        return a2.currentSegmentVersion(a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(Map map, ProcessedEvent processedEvent, long l2, int n) {
        void a2;
        void a3;
        void a4;
        void a5;
        int n2 = n;
        WritableFileStorageTier a6 = this;
        a6.L((ProcessedEvent)a5, (long)a4, (int)a3, (Map)a2);
    }

    /*
     * WARNING - void declaration
     */
    public Stream<String> L(long l2, int n, boolean bl) {
        void a2;
        void a3;
        int a4 = n;
        WritableFileStorageTier a5 = this;
        if (a3 != false) {
            return Stream.concat(a5.i.entrySet().stream().map(entry -> {
                Map.Entry a2 = entry;
                Object a3 = this;
                return FileUtils.L((File)a3.L(new FileVersion(((Long)a2.getKey()).longValue(), ((ByteBufferEventSource)a2.getValue()).L())));
            }), (Stream)a5.L(arg_0 -> WritableFileStorageTier.L((long)a2, a4, arg_0), Stream.empty()));
        }
        return (Stream)a5.L(arg_0 -> WritableFileStorageTier.A((long)a2, a4, arg_0), Stream.empty());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ FileVersion L(long l2, File file, FileVersion fileVersion, StorageProperties storageProperties) {
        void a2;
        void a3;
        WritableFileStorageTier a4;
        void a5;
        WritableFileStorageTier writableFileStorageTier = writableFileStorageTier2;
        WritableFileStorageTier writableFileStorageTier2 = storageProperties;
        WritableFileStorageTier a6 = writableFileStorageTier;
        return Arrays.stream(FileUtils.L((File)a5, (String)a4.getEventsSuffix())).map(FileUtils::L).filter(arg_0 -> WritableFileStorageTier.L((long)a3, arg_0)).max(FileVersion::L).orElse((FileVersion)a2);
    }

    private static /* synthetic */ Stream L(long l2, int n, StorageTier storageTier) {
        long a2;
        StorageTier a3 = storageTier;
        int a4 = n;
        return a3.getBackupFilenames(a2, a4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(long l2) {
        void a2;
        WritableFileStorageTier writableFileStorageTier = this;
        ByteBufferEventSource byteBufferEventSource = (ByteBufferEventSource)writableFileStorageTier.i.remove((long)a2);
        int a3 = 0;
        if (byteBufferEventSource != null) {
            ByteBufferEventSource byteBufferEventSource2 = byteBufferEventSource;
            a3 = byteBufferEventSource2.L();
            byteBufferEventSource2.L(0L);
        }
        writableFileStorageTier.L((long)a2, a3).forEach(arg_0 -> writableFileStorageTier.L((long)a2, arg_0));
    }

    public SortedSet<FileVersion> segmentsWithoutIndex() {
        WritableFileStorageTier a2;
        return (SortedSet)a2.L(StorageTier::segmentsWithoutIndex, Collections.emptySortedSet());
    }

    private /* synthetic */ int L(List<ProcessedEvent> list) {
        Object a2 = list;
        WritableFileStorageTier a3 = this;
        long l2 = 0L;
        Object object = a2 = a2.iterator();
        while (object.hasNext()) {
            ProcessedEvent processedEvent = (ProcessedEvent)a2.next();
            l2 += (long)(4 + processedEvent.getSerializedSize());
            object = a2;
        }
        if (l2 > Integer.MAX_VALUE) {
            throw new MessagingPlatformException(ErrorCode.DATAFILE_WRITE_ERROR, a3.a + ": Transaction size exceeds maximum size");
        }
        return (int)l2;
    }

    private static /* synthetic */ Optional L(FileVersion fileVersion, StorageTier storageTier) {
        FileVersion a2 = storageTier;
        FileVersion a3 = fileVersion;
        return a2.eventSource(a3);
    }
}

