/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.transport.rest.v2.NodesRestControllerV2;
import io.axoniq.axonserver.transport.rest.v2.SubscriptionQueriesRestControllerV2;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component(value="QueryCache")
public class QueryCache
implements NonReplacingConstraintCache<String, ActiveQuery> {
    private final long I;
    private final int A = 25000;
    private final Map<String, ActiveQuery> e;
    private final Logger C;
    private final long g;

    public QueryCache(@Value(value="${axoniq.axonserver.default-query-timeout:300000}") long defaultQueryTimeout, @Value(value="${axoniq.axonserver.query-cache-capacity:0}") long a2) {
        QueryCache queryCache = this;
        QueryCache queryCache2 = this;
        queryCache2.C = LoggerFactory.getLogger(QueryCache.class);
        queryCache2.A = 25000;
        QueryCache queryCache3 = this;
        queryCache.e = new ConcurrentHashMap();
        queryCache.g = defaultQueryTimeout;
        if (a2 > 0L) {
            this.I = a2;
            return;
        }
        defaultQueryTimeout = DataSize.ofBytes((long)Runtime.getRuntime().maxMemory()).toGigabytes();
        this.I = defaultQueryTimeout > 0L ? 25000L * defaultQueryTimeout : 25000L;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected, String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3 = activeQuery;
        QueryCache a4 = this;
        a4.L((ActiveQuery)a3, a2.a());
    }

    public ActiveQuery get(String string) {
        Object a2 = string;
        QueryCache a3 = this;
        return (ActiveQuery)a3.e.get(a2);
    }

    private /* synthetic */ void L() {
        QueryCache a2;
        if ((long)a2.e.size() >= a2.I) {
            throw new InsufficientBufferCapacityException("Query buffer is full (" + a2.I + "/" + a2.I + ") Query handlers might be slow. Try increasing 'axoniq.axonserver.query-cache-capacity' property.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(ActiveQuery activeQuery, String string) {
        void a2;
        Object a3 = string;
        QueryCache a4 = this;
        a4.C.debug(NodesRestControllerV2.L((Object)"\u001cT2K3^+^\u007fJ*^-B\u007f@\"\u001b9T-\u001b.N:I&\u001b7Z1_3^-\u001b6_:U+R9R:_\u007fY&\u001b<W6^1O\fO-^>V\u0016_\u007f@\"\u0015"), (Object)a2.j(), a3);
        if (a2.A((String)a3)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a3;
            if (a2.L((String)a3, ErrorCode.CONNECTION_TO_HANDLER_LOST, String.format(SubscriptionQueriesRestControllerV2.L((Object)"!(\f)\u0007$\u0016.\r)B3\rg\n&\f#\u000e\"\u0010gG4B+\r4\u0016"), objectArray))) {
                a4.remove(a2.j());
            }
        }
    }

    @EventListener
    public void on(TopologyEvents.QueryHandlerDisconnected queryHandlerDisconnected) {
        QueryCache a2 = queryHandlerDisconnected;
        QueryCache a3 = this;
        a3.e.forEach((arg_0, arg_1) -> a3.L((TopologyEvents.QueryHandlerDisconnected)a2, arg_0, arg_1));
    }

    public Set<Map.Entry<String, ActiveQuery>> timedOut() {
        QueryCache a4;
        long l2 = System.currentTimeMillis() - a4.g;
        return a4.entrySet().stream().filter(a3 -> {
            if (((ActiveQuery)a3.getValue()).L() < l2) {
                return true;
            }
            return false;
        }).filter(a2 -> {
            if (!((ActiveQuery)a2.getValue()).A()) {
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
    }

    public ActiveQuery remove(String string) {
        QueryCache a2;
        Object a3 = string;
        QueryCache queryCache = a2 = this;
        queryCache.C.debug(SubscriptionQueriesRestControllerV2.L((Object)"0\"\u000f(\u0014\"B*\u00074\u0011&\u0005\"+#B<\u001f"), a3);
        return (ActiveQuery)queryCache.e.remove(a3);
    }

    public Collection<Map.Entry<String, ActiveQuery>> entrySet() {
        QueryCache a2;
        return a2.e.entrySet();
    }

    public int size() {
        QueryCache a2;
        return a2.e.size();
    }

    /*
     * WARNING - void declaration
     */
    public ActiveQuery putIfAbsent(String string, ActiveQuery activeQuery) {
        void a2;
        QueryCache a3;
        QueryCache a4 = activeQuery;
        QueryCache queryCache = a3 = this;
        queryCache.L();
        return (ActiveQuery)queryCache.e.putIfAbsent(a2, a4);
    }

    public boolean isEmpty() {
        QueryCache a2;
        return a2.e.isEmpty();
    }
}

