/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.message.query;

import io.axoniq.axonserver.ProcessingInstructionHelper;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.ErrorMessageFactory;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.ApplicationProtoConverter;
import io.axoniq.axonserver.grpc.ClientIdRegistry;
import io.axoniq.axonserver.grpc.SerializedQuery;
import io.axoniq.axonserver.grpc.query.QueryRequest;
import io.axoniq.axonserver.grpc.query.QueryResponse;
import io.axoniq.axonserver.interceptor.DefaultExecutionContext;
import io.axoniq.axonserver.interceptor.QueryInterceptors;
import io.axoniq.axonserver.localstorage.file.AggregateSequence;
import io.axoniq.axonserver.message.ClientStreamIdentification;
import io.axoniq.axonserver.message.DispatchQueueMetrics;
import io.axoniq.axonserver.message.FlowControlQueues;
import io.axoniq.axonserver.message.QueueMetrics;
import io.axoniq.axonserver.message.command.InsufficientBufferCapacityException;
import io.axoniq.axonserver.message.query.ActiveQuery;
import io.axoniq.axonserver.message.query.QueryDefinition;
import io.axoniq.axonserver.message.query.QueryHandler;
import io.axoniq.axonserver.message.query.QueryInstruction;
import io.axoniq.axonserver.message.query.QueryMetricsRegistry;
import io.axoniq.axonserver.message.query.QueryRegistrationCache;
import io.axoniq.axonserver.metric.BaseMetricName;
import io.axoniq.axonserver.metric.MeterFactory;
import io.axoniq.axonserver.metric.MetricName;
import io.axoniq.axonserver.plugin.ExecutionContext;
import io.axoniq.axonserver.util.ConstraintCache;
import io.axoniq.axonserver.util.NonReplacingConstraintCache;
import io.axoniq.axonserver.util.StringUtils;
import io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="QueryDispatcher")
public class QueryDispatcher {
    private final FlowControlQueues<QueryInstruction> M;
    private final Logger i;
    private final QueryRegistrationCache a;
    private final QueryMetricsRegistry I;
    private final QueryInterceptors A;
    private final NonReplacingConstraintCache<String, ActiveQuery> e;
    private final Map<String, AtomicInteger> C;
    private final DispatchQueueMetrics g;

    private /* synthetic */ boolean L(QueryResponse queryResponse) {
        QueryDispatcher a2 = queryResponse;
        QueryDispatcher a3 = this;
        if (ErrorCode.NO_HANDLER_FOR_QUERY.getCode().equals(a2.getErrorCode()) || ErrorCode.TOO_MANY_REQUESTS.getCode().equals(a2.getErrorCode()) || ErrorCode.OTHER.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_REJECTED_BY_INTERCEPTOR.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_TIMEOUT.getCode().equals(a2.getErrorCode()) || ErrorCode.CONNECTION_TO_HANDLER_LOST.getCode().equals(a2.getErrorCode()) || ErrorCode.QUERY_DUPLICATED.getCode().equals(a2.getErrorCode())) {
            return true;
        }
        return false;
    }

    public FlowControlQueues<QueryInstruction> getQueryQueue() {
        QueryDispatcher a2;
        return a2.M;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(DefaultExecutionContext defaultExecutionContext, Consumer consumer, QueryResponse queryResponse) {
        void a2;
        void a3;
        QueryDispatcher a4 = queryResponse;
        QueryDispatcher a5 = this;
        a5.L((DefaultExecutionContext)a3, (QueryResponse)a4, (Consumer)a2);
    }

    public MeterFactory.RateMeter queryRate(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        return a3.I.rateMeter((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(String string, ActiveQuery activeQuery) {
        void a2;
        QueryDispatcher queryDispatcher = this;
        try {
            queryDispatcher.i.trace(AggregateSequence.L((Object)"\u0011G&^4Z6F<@2\u000e$[0\\,\u000e.S{\u0000{"), (Object)a2.j());
            a2.A();
            return;
        }
        catch (MessagingPlatformException a3) {
            void a4;
            QueryDispatcher queryDispatcher2 = queryDispatcher;
            queryDispatcher2.i.debug(ApplicationProtoConverter.L((Object)"P'g:guq g<{251|&e4a6}<{25:sud p'lun(;uV4{6p9y<{25\"|!}up'g:g{"), (Object)a2.j(), (Object)a3);
            a2.L(a3.getErrorCode(), a3.getMessage());
            queryDispatcher2.e.remove((Object)a4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(DefaultExecutionContext defaultExecutionContext, QueryResponse queryResponse, Consumer<QueryResponse> consumer) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher queryDispatcher = this;
        try {
            a4.accept(queryDispatcher.A.queryResponse((QueryResponse)a3, (ExecutionContext)a2));
            return;
        }
        catch (Exception a5) {
            queryDispatcher.i.warn(AggregateSequence.L((Object)".So\u000e\u0010V6K%Z<A;\u000e<@u\\0]%A;]0\u000e<@!K'M0^!A'"), (Object)a2.contextName(), (Object)a5);
            Exception exception = a5;
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.EXCEPTION_IN_INTERCEPTOR.getCode()).setRequestIdentifier(a3.getRequestIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.L((String)exception.getMessage())).build());
            a2.compensate((Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Set<QueryHandler> L(String string, QueryRequest queryRequest) {
        void a2;
        QueryHandler queryHandler;
        void a3;
        QueryDispatcher queryDispatcher = this;
        Object a4 = ProcessingInstructionHelper.L((List)a3.getProcessingInstructionsList()) == 1 ? ((queryHandler = queryDispatcher.a.findOne((String)a2, (QueryRequest)a3)) == null ? Set.of() : Set.of(queryHandler)) : queryDispatcher.a.find((String)a2, (QueryRequest)a3);
        return a4;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void A(QueryHandler queryHandler, String string, String string2, long l2) {
        void a2;
        void a3;
        Object a4 = string2;
        QueryHandler a5 = queryHandler;
        a5.L((String)a3, (String)a4, (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void query(SerializedQuery serializedQuery, Authentication authentication, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        void a2;
        Consumer<String> a3;
        Consumer<QueryResponse> a4;
        void a5;
        QueryDispatcher queryDispatcher = this;
        Object a6 = a5.context();
        a4 = arg_0 -> queryDispatcher.L(a4, (SerializedQuery)a5, (String)a6, arg_0);
        a3 = arg_0 -> queryDispatcher.L(a3, (String)a6, arg_0);
        QueryDispatcher queryDispatcher2 = queryDispatcher;
        queryDispatcher2.queryRate((String)a6).A();
        queryDispatcher2.C.computeIfAbsent(a6, string -> {
            void a2;
            QueryDispatcher queryDispatcher = this;
            Object a3 = new AtomicInteger();
            queryDispatcher.I.gauge((MetricName)BaseMetricName.ha, Tags.of((String)"context", (String)a2), ((AtomicInteger)a3)::get);
            return a3;
        }).incrementAndGet();
        queryDispatcher.L((SerializedQuery)a5, (String)a6, (Authentication)a2, a4, a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(Consumer consumer, String string, String string2) {
        void a2;
        void a3;
        Object a4 = string2;
        QueryDispatcher a5 = this;
        a3.accept(a4);
        ((AtomicInteger)a5.C.get(a2)).decrementAndGet();
    }

    /*
     * WARNING - void declaration
     */
    public void flowControl(String string, long l2) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        if ((a2 = (ActiveQuery)a3.e.get(a2)) != null) {
            void a4;
            a2.A().forEach(arg_0 -> a3.L((ActiveQuery)a2, (long)a4, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(Consumer consumer, SerializedQuery serializedQuery, String string, QueryResponse queryResponse) {
        void a2;
        QueryDispatcher a3;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryResponse;
        QueryDispatcher a4 = queryDispatcher;
        QueryDispatcher queryDispatcher3 = a3;
        a2.accept(queryDispatcher3);
        if (a4.L((QueryResponse)queryDispatcher3)) {
            void a5;
            void a6;
            a4.I.error(a6.query().getQuery(), (String)a5, a3.getErrorCode());
        }
    }

    /*
     * WARNING - void declaration
     */
    public QueryDispatcher(QueryRegistrationCache queryRegistrationCache, NonReplacingConstraintCache<String, ActiveQuery> nonReplacingConstraintCache, QueryMetricsRegistry queryMetricsRegistry, QueryInterceptors queryInterceptors, MeterFactory meterFactory, ClientIdRegistry clientIdRegistry, @Value(value="${axoniq.axonserver.query-queue-capacity-per-client:10000}") int n) {
        void a2;
        void clientIdRegistry2;
        void meterFactory2;
        void queryInterceptors2;
        void queryCache;
        void registrationCache;
        QueryDispatcher queryMetricsRegistry2;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryMetricsRegistry;
        QueryDispatcher queryDispatcher3 = queryMetricsRegistry2 = queryDispatcher;
        QueryDispatcher queryDispatcher4 = queryMetricsRegistry2;
        queryMetricsRegistry2.i = LoggerFactory.getLogger(QueryDispatcher.class);
        QueryDispatcher queryDispatcher5 = queryMetricsRegistry2;
        queryMetricsRegistry2.C = new ConcurrentHashMap();
        queryDispatcher4.a = registrationCache;
        queryDispatcher4.I = queryDispatcher2;
        queryDispatcher3.e = queryCache;
        queryDispatcher3.A = queryInterceptors2;
        QueryDispatcher queryDispatcher6 = queryMetricsRegistry2;
        queryDispatcher3.g = new DispatchQueueMetrics((MeterFactory)meterFactory2, (MetricName)BaseMetricName.ca, (MetricName)BaseMetricName.ba, (ClientIdRegistry)clientIdRegistry2);
        QueryDispatcher queryDispatcher7 = queryMetricsRegistry2;
        queryDispatcher6.M = new FlowControlQueues(Comparator.comparing(QueryInstruction::L).reversed(), (int)a2, (QueueMetrics)queryMetricsRegistry2.g, ErrorCode.TOO_MANY_REQUESTS);
        queryDispatcher2.gauge((MetricName)BaseMetricName.s, (Object)queryCache, ConstraintCache::size);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(ActiveQuery activeQuery, long l2, QueryHandler queryHandler) {
        void a2;
        void a3;
        QueryDispatcher a4 = activeQuery;
        QueryDispatcher a5 = this;
        a5.L((QueryHandler)a3, a4.j(), a4.A(), (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void dispatchProxied(SerializedQuery serializedQuery, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        void a2;
        void a3;
        Object a4 = consumer2;
        QueryDispatcher a5 = this;
        a5.dispatchProxied((SerializedQuery)a3, (Consumer)a2, (Consumer)a4, true);
    }

    /*
     * WARNING - void declaration
     */
    public void completeWithError(String string, String string2, ErrorCode errorCode, String string3) {
        void a2;
        void a3;
        void a4;
        Object a5 = string;
        QueryDispatcher a6 = this;
        Object[] objectArray = new Object[4];
        objectArray[0] = a4;
        objectArray[1] = a5;
        objectArray[2] = a3.getCode();
        objectArray[3] = a2;
        a6.i.debug(AggregateSequence.L((Object)"\u0016A8^9K!G;IuY<Z=\u000e0\\'A'\u000e!F0\u000e6A8C @<M4Z<A;\u000e\"G!FuOu]%K6G3G6\u000e=O;J9K'\u000e\u000eM9G0@!}!\\0O8g1\u0013.S\b\u0002uH:\\uZ=Ku_ K'Wuu<JhU(s{\u000e\u0010\\'A'\u000e6A1Ko\u000e.S{\u000e\u0010\\'A'c0]&O2Ko\u000e.S{"), objectArray);
        ActiveQuery activeQuery = (ActiveQuery)a6.e.get(a5);
        if (activeQuery != null && activeQuery.L((String)a4, (ErrorCode)a3, (String)a2)) {
            a6.e.remove(a5);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(SerializedQuery serializedQuery, String string, Authentication authentication, Consumer<QueryResponse> consumer, Consumer<String> consumer2) {
        Set set;
        QueryDispatcher a2;
        QueryDispatcher queryDispatcher;
        block5: {
            void a3;
            SerializedQuery serializedQuery2;
            void a4;
            Consumer<QueryResponse> consumer3;
            void a5;
            block4: {
                DefaultExecutionContext a6;
                void a7;
                queryDispatcher = this;
                a6 = new DefaultExecutionContext((String)a7, (Authentication)a6);
                consumer3 = arg_0 -> queryDispatcher.L(a6, (Consumer)a5, arg_0);
                try {
                    QueryDispatcher queryDispatcher2 = queryDispatcher;
                    serializedQuery2 = queryDispatcher2.A.queryRequest((SerializedQuery)a4, (ExecutionContext)a6);
                    a2 = serializedQuery2.query();
                    set = queryDispatcher2.L((String)a7, (QueryRequest)a2);
                    if (!set.isEmpty()) break block4;
                    consumer3.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.NO_HANDLER_FOR_QUERY.getCode()).setRequestIdentifier(a2.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.L((String)("No handler for query: " + a2.getQuery()))).build());
                    a3.accept(ApplicationProtoConverter.L((Object)"[:V9|0{!"));
                    return;
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = a7;
                    objectArray[1] = a4.query().getQuery();
                    objectArray[2] = exception;
                    queryDispatcher.i.warn(AggregateSequence.L((Object)".So\u000e3O<B0JuZ:\u000e1G&^4Z6Fu_ K'WuU("), objectArray);
                    a2 = ErrorCode.fromException((Throwable)exception);
                    consumer3.accept(QueryResponse.newBuilder().setErrorCode(a2.getCode()).setRequestIdentifier(a4.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.L((String)StringUtils.getOrDefault((String)a2.getCode(), (String)exception.getClass().getName()))).build());
                    a3.accept(ApplicationProtoConverter.L((Object)"S4|9p1"));
                    a6.compensate((Throwable)exception);
                    return;
                }
            }
            set = new ActiveQuery(a2.getMessageIdentifier(), serializedQuery2, true, consumer3, (Consumer)a3, set, queryDispatcher.L((QueryRequest)a2));
            if (queryDispatcher.e.putIfAbsent((Object)a2.getMessageIdentifier(), (Object)set) == null) break block5;
            a5.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a4.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.L((String)AggregateSequence.L((Object)"\u007f K'WuY<Z=\u000e&[%^9G0Jug\u0011\u000e4B'K4J,\u000e%\\0]0@!"))).build());
            a3.accept(ApplicationProtoConverter.L((Object)"\u0011`%y<v4a0\\1"));
            return;
        }
        queryDispatcher.L(a2.getMessageIdentifier(), (ActiveQuery)set);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ActiveQuery L(String string, String string2) {
        Object a2 = string2;
        QueryDispatcher a3 = this;
        ActiveQuery activeQuery = (ActiveQuery)a3.e.get(a2);
        if (activeQuery == null) {
            void a4;
            a2 = (String)a2 + "/" + (String)a4;
            activeQuery = (ActiveQuery)a3.e.get(a2);
        }
        return activeQuery;
    }

    /*
     * WARNING - void declaration
     */
    public void dispatchProxied(SerializedQuery serializedQuery, Consumer<QueryResponse> consumer, Consumer<String> consumer2, boolean bl) {
        void a22;
        void a3;
        void a4;
        void a322;
        QueryDispatcher queryDispatcher = this;
        void v0 = a322;
        QueryRequest queryRequest = v0.query();
        String string = v0.context();
        Object a5 = v0.clientStreamId();
        if ((string = queryDispatcher.a.find(string, queryRequest, (String)a5)) == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a5;
            objectArray[1] = queryRequest.getQuery();
            a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.CLIENT_DISCONNECTED.getCode()).setRequestIdentifier(queryRequest.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.L((String)String.format(ApplicationProtoConverter.L((Object)"V9|0{!5pfu{:aus:`;qub=|9pue'z6p&f<{2/u0&"), objectArray))).build());
            a3.accept(a5);
            return;
        }
        a5 = queryDispatcher.L(queryRequest.getMessageIdentifier(), a322.clientStreamId());
        ActiveQuery a22 = new ActiveQuery((String)a5, (SerializedQuery)a322, false, (Consumer)a4, (Consumer)a3, Collections.singleton(string), a22 != false && queryDispatcher.L(queryRequest));
        try {
            if (queryDispatcher.e.putIfAbsent(a5, (Object)a22) != null) {
                a4.accept(QueryResponse.newBuilder().setErrorCode(ErrorCode.QUERY_DUPLICATED.getCode()).setRequestIdentifier(a322.getMessageIdentifier()).setMessageIdentifier(UUID.randomUUID().toString()).setErrorMessage(ErrorMessageFactory.L((String)AggregateSequence.L((Object)"\u007f K'WuY<Z=\u000e&[%^9G0Jug\u0011\u000e4B'K4J,\u000e%\\0]0@!"))).build());
                a3.accept(ApplicationProtoConverter.L((Object)"\u0011`%y<v4a0\\1"));
                return;
            }
            queryDispatcher.L((String)a5, a22);
            return;
        }
        catch (InsufficientBufferCapacityException a322) {
            a22.L(string.A(), ErrorCode.QUERY_DISPATCH_ERROR, a322.getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleComplete(String string, String string2, String string3) {
        void a2;
        void a3;
        QueryDispatcher queryDispatcher = this;
        QueryDispatcher a4 = queryDispatcher.L((String)a3, (String)a2);
        if (a4 != null) {
            if (a4.L((String)a3)) {
                queryDispatcher.e.remove((Object)a4.j());
            }
            long l2 = System.currentTimeMillis() - a4.L();
            if (a4.L()) {
                void a5;
                queryDispatcher.I.addHandlerResponseTime(a4.L(), a4.L(), (String)a5, a4.a(), l2);
                return;
            }
        } else {
            queryDispatcher.i.debug(ApplicationProtoConverter.L((Object)"\u001bzu=8z'p|5<{3z'x4a<z;53z'5.huz;56z8e9p!p1"), (Object)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String L(String string, String string2) {
        void a2;
        Object a3 = string2;
        QueryDispatcher a4 = this;
        return (String)a2 + "/" + (String)a3;
    }

    /*
     * WARNING - void declaration
     */
    public void flowControlProxied(String string, String string2, long l2, String string3, String string4) {
        void a2;
        void a3;
        void a4;
        void a5;
        Object a6 = string2;
        QueryDispatcher a7 = this;
        a7.L((String)a5, (String)a6, (String)a4, arg_0 -> a7.L((String)a3, (String)a6, (long)a2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(String string, String string2, String string3, Consumer<QueryHandler> consumer) {
        void a2;
        void a3;
        Object a4 = string;
        QueryDispatcher a5 = this;
        a4 = new QueryDefinition((String)a4, (String)a3);
        if ((a4 = a5.a.find((QueryDefinition)a4, (String)a2)) != null) {
            void a6;
            a6.accept(a4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(QueryHandler queryHandler, String string, String string2, long l2) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher a5 = queryHandler;
        QueryDispatcher a6 = this;
        void v0 = a4;
        a6.L((String)v0, a5.A(), () -> QueryDispatcher.A((QueryHandler)a5, (String)v0, (String)a3, (long)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(String string, String string2, Runnable runnable) {
        Runnable a22 = runnable;
        QueryDispatcher a3 = this;
        try {
            a22.run();
            return;
        }
        catch (MessagingPlatformException a22) {
            void a4;
            void a5;
            QueryDispatcher queryDispatcher = a3;
            queryDispatcher.i.debug(AggregateSequence.L((Object)"k'\\:\\uJ<]%O!M=G;IuH9A\"\u000e$[0\\,\u000e<@&Z'[6Z<A;\u000e!AuZ4\\2K!\u000e6B<K;ZuU("), (Object)a5);
            queryDispatcher.completeWithError((String)a4, (String)a5, a22.getErrorCode(), a22.getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(String string, String string2, long l2, QueryHandler queryHandler) {
        void a2;
        void a3;
        void a4;
        QueryDispatcher a5;
        QueryDispatcher queryDispatcher = queryDispatcher2;
        QueryDispatcher queryDispatcher2 = queryHandler;
        QueryDispatcher a6 = queryDispatcher;
        a6.L((QueryHandler)a5, (String)a4, (String)a3, (long)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void cancelProxied(String string, String string2) {
        void a2;
        QueryDispatcher a3;
        Object a4 = string2;
        QueryDispatcher queryDispatcher = a3 = this;
        queryDispatcher.cancel(queryDispatcher.L((String)a2, (String)a4));
    }

    private /* synthetic */ boolean L(QueryRequest queryRequest) {
        QueryDispatcher a2 = queryRequest;
        QueryDispatcher a3 = this;
        return ProcessingInstructionHelper.L((List)a2.getProcessingInstructionsList());
    }

    public void deleteMetrics(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        a3.C.remove(a2);
        QueryDispatcher queryDispatcher = a3;
        queryDispatcher.I.remove((MetricName)BaseMetricName.ha, (String)a2);
        queryDispatcher.I.removeForContext((String)a2);
    }

    /*
     * WARNING - void declaration
     */
    public void handleResponse(QueryResponse queryResponse, String string, String string2) {
        void a2;
        void a3;
        QueryDispatcher queryDispatcher = this;
        Object a4 = a3.getRequestIdentifier();
        if ((a4 = queryDispatcher.L((String)a2, (String)a4)) != null) {
            ClientStreamIdentification clientStreamIdentification = new ClientStreamIdentification(a4.a(), (String)a2);
            long l2 = System.currentTimeMillis() - a4.L();
            if (a4.L()) {
                void a5;
                queryDispatcher.I.addEndToEndResponseTime(a4.L(), a4.L(), (String)a5, clientStreamIdentification.a(), a4.A(), l2);
            }
            if (a4.L((QueryResponse)a3, (String)a2) && a4.A()) {
                a4.L((String)a2);
                return;
            }
        } else {
            queryDispatcher.i.debug(AggregateSequence.L((Object)"`:\u000e}C:\\0\u0007uG;H:\\8O!G:@uH:\\uU("), (Object)a3.getRequestIdentifier());
        }
    }

    public void cancel(String string) {
        Object a2 = string;
        QueryDispatcher a3 = this;
        if ((a2 = (ActiveQuery)a3.e.remove(a2)) != null) {
            a2.L();
        }
    }
}

