/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.RaftAdminGroup;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.configuration.admin.ClusterNode;
import io.axoniq.axonserver.enterprise.ClusterTemplateController;
import io.axoniq.axonserver.enterprise.cluster.ClusterController;
import io.axoniq.axonserver.enterprise.cluster.DistributeLicenseService;
import io.axoniq.axonserver.enterprise.cluster.events.ClusterEvents;
import io.axoniq.axonserver.enterprise.context.ContextNameValidation;
import io.axoniq.axonserver.enterprise.replication.admin.RaftConfigServiceFactory;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.grpc.internal.ContextRole;
import io.axoniq.axonserver.grpc.internal.NodeInfo;
import io.axoniq.axonserver.licensing.LicenseException;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.metric.Metrics;
import io.axoniq.axonserver.rest.ClusterRestController;
import io.axoniq.axonserver.rest.json.RestResponse;
import io.axoniq.axonserver.topology.ClusterTopology;
import io.axoniq.axonserver.transport.rest.v2.EventProcessorRestControllerV2;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 * Exception performing whole class analysis ignored.
 */
@CrossOrigin
@RestController(value="ClusterRestController")
@RequestMapping(value={"/v1/cluster"})
public class ClusterRestController {
    private static final Logger h;
    private final ClusterTopology L;
    private final FeatureChecker m;
    private final ClusterTemplateController M;
    private final Predicate<String> i;
    private static final Logger a;
    private final ApplicationEventPublisher I;
    public static final String A = "_none";
    private final DistributeLicenseService e;
    private final ClusterController C;
    private final RaftConfigServiceFactory g;

    static {
        a = AuditLog.getLogger();
        h = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    /*
     * WARNING - void declaration
     */
    public ClusterRestController(ClusterController clusterController, RaftConfigServiceFactory raftConfigServiceFactory, FeatureChecker featureChecker, DistributeLicenseService distributeLicenseService, ApplicationEventPublisher applicationEventPublisher, ClusterTopology clusterTopology, ClusterTemplateController clusterTemplateController) {
        ClusterRestController a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        ClusterRestController a9;
        ClusterRestController clusterRestController = clusterRestController2;
        ClusterRestController clusterRestController2 = clusterTemplateController;
        ClusterRestController clusterRestController3 = a9 = clusterRestController;
        ClusterRestController clusterRestController4 = a9;
        ClusterRestController clusterRestController5 = a9;
        ClusterRestController clusterRestController6 = a9;
        a9.i = new ContextNameValidation();
        a9.C = a8;
        clusterRestController5.g = a7;
        clusterRestController5.m = a6;
        clusterRestController4.e = a5;
        clusterRestController4.I = a4;
        clusterRestController3.L = a3;
        clusterRestController3.M = a2;
    }

    @GetMapping(value={"/download-template"})
    @ResponseBody
    public void L(HttpServletResponse httpServletResponse, @Parameter(hidden=true) Principal principal) throws IOException {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        a.info(Metrics.L((Object)"Qxw^*Qor\u007ffyw*`fvywoq*wonzokwo#nl}mflkg$"), (Object)AuditLog.username((Principal)object));
        if (a2.L.isAdminNode()) {
            ServletOutputStream resp;
            object = EventProcessorRestControllerV2.L((Object)",):6; =h; \"5#$; a<\")");
            String string = a2.M.buildYamlTemplate();
            void v1 = resp;
            resp = v1.getOutputStream();
            v1.setContentType(Metrics.L((Object)"~frw%sfbcm1#ikkqyf~>\u007fwl.2"));
            v1.addHeader(EventProcessorRestControllerV2.L((Object)"\u0006 +; !1b\u0001&6?*<,;, +"), "attachment; filename=\"" + (String)object + "\"");
            ServletOutputStream servletOutputStream = resp;
            servletOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
            servletOutputStream.flush();
            servletOutputStream.close();
            return;
        }
        throw new RuntimeException(Metrics.L((Object)"Sl\u007f#ibd#\u007fpo#~kcp*e\u007fmiwcldbfj~z*ldos#lqen*bnncm*mego"));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/upload-license"})
    public void L(@RequestParam(value="licenseFile") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        void a2;
        ClusterRestController clusterRestController = this;
        a.info(EventProcessorRestControllerV2.L((Object)"\u0014>2\u0018o\u0017*4: <1o)&&*+< o0?!.1*k"), (Object)AuditLog.username((Principal)a2));
        h.info(Metrics.L((Object)"Mot*oc`omyf*vzoebnfn/*soqllxncmm#fjifdpo#\u007fsnb~f$-$"));
        try {
            void licenseFile;
            clusterRestController.e.distributeLicense(licenseFile.getBytes());
            return;
        }
        catch (MessagingPlatformException messagingPlatformException) {
            if (ErrorCode.NO_LEADER_AVAILABLE.equals((Object)messagingPlatformException.getErrorCode())) {
                throw new MessagingPlatformException(ErrorCode.NO_LEADER_AVAILABLE, EventProcessorRestControllerV2.L((Object)"\u000b e# .!*7o# 7o\u001a.!\",!ko\u0000!6:7*e;-.1o1' o\u001a.!\",!e= ?)&&.1&*!e(7 0?e&6o&= .1*!o'*# 7*e:5#*.!&+(e.e#,, !6*k"));
            }
            throw messagingPlatformException;
        }
        catch (LicenseException messagingPlatformException) {
            throw new MessagingPlatformException(ErrorCode.INVALID_PROPERTY_VALUE, messagingPlatformException.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(path={"{name}"})
    public void L(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        void a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        a.info(Metrics.L((Object)"Qxw^*Qor\u007ffyw*we#nfff~f*mego#q~$"), (Object)AuditLog.username((Principal)a2), object);
        name.g.getRaftConfigService().deleteNode((String)object);
    }

    @PostMapping
    public ResponseEntity<RestResponse> L(@Valid @RequestBody ClusterJoinRequest clusterJoinRequest, @Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController;
        NodeInfo.Builder a2;
        ClusterRestController clusterRestController2 = clusterRestController3;
        ClusterRestController clusterRestController3 = clusterJoinRequest;
        ClusterRestController jsonClusterNode = clusterRestController2;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = clusterRestController3.getInternalHostName();
        objectArray[2] = clusterRestController3.internalGrpcPort;
        a.info(EventProcessorRestControllerV2.L((Object)"\u0014>2\u0018o\u0017*4: <1o1 e%*&+o&#0<1*7o$;e48u>2k"), objectArray);
        a2 = NodeInfo.newBuilder((NodeInfo)jsonClusterNode.C.getMe().toNodeInfo());
        String string = clusterRestController3.getContext();
        if (string != null && !string.isEmpty()) {
            if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, Metrics.L((Object)"Ibdmew*`enhjdf*iejdjdd*`em~frw*tcwb#dlIldwo{~p$"));
            }
            if (!RaftAdminGroup.L((String)string) && !jsonClusterNode.i.test(string)) {
                throw new MessagingPlatformException(ErrorCode.INVALID_CONTEXT_NAME, "Invalid context name: " + string);
            }
            h.debug(EventProcessorRestControllerV2.L((Object)".!+mf\u007fo\u0017*\"&6; =,!\"o(66*))e.++e.!+,!\"o(*e;*o& +; 71og48mk"), (Object)string);
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName(string).build());
        } else if (clusterRestController3.getNoContexts() != null && clusterRestController3.getNoContexts().booleanValue()) {
            h.debug(Metrics.L((Object)"kgn+#9*Qodcp~fxjdd*nspool#kmn#kgnjdd*no#~l*me#ildwo{~p$"));
            clusterRestController = jsonClusterNode;
            a2.addContexts(ContextRole.newBuilder().setName("_none").build());
        } else {
            h.debug(EventProcessorRestControllerV2.L((Object)".!+mf\u007fo\u0017*\"&6; =,!\"o(66*))e.++e.!+,!\"o(*e;*o$#)o& +; 71<k"));
            clusterRestController = jsonClusterNode;
        }
        if (clusterRestController.C.nodes().count() > 1L) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new RestResponse(false, Metrics.L((Object)"Mego#koxfkgs#xfmjywoqog*jd#k#io\u007fp~fx")));
        }
        try {
            ClusterRestController clusterRestController4 = jsonClusterNode;
            ClusterRestController clusterRestController5 = clusterRestController3;
            clusterRestController3 = clusterRestController4.g.getRaftConfigServiceStub(clusterRestController5.internalHostName, clusterRestController5.internalGrpcPort.intValue()).joinCluster(a2.build());
            clusterRestController4.I.publishEvent((Object)new ClusterEvents.LicenseUpdated(clusterRestController3.getLicense().toByteArray()));
            return ResponseEntity.accepted().body((Object)new RestResponse(true, EventProcessorRestControllerV2.L((Object)"\u000e&, ?1*!o/ ,!e= >0*6;io(.<o1..*e.e8-&)*e;*o5=*, <6")));
        }
        catch (Exception this2) {
            return new RestResponse(false, this2.getMessage()).asResponseEntity(ErrorCode.fromException((Throwable)this2));
        }
    }

    @GetMapping(path={"{name}"})
    public JsonClusterNode L(@PathVariable(value="name") String string, @Parameter(hidden=true) Principal principal) {
        ClusterNode a2;
        ClusterRestController clusterRestController = object;
        Object object = string;
        ClusterRestController name = clusterRestController;
        a.info(Metrics.L((Object)"Qxw^*Qor\u007ffyw*mego#nf~bcoy#llx#q~$"), (Object)AuditLog.username((Principal)a2), object);
        a2 = name.C.getNode((String)object);
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.NO_SUCH_NODE, "Node " + (String)object + " not found");
        }
        return JsonClusterNode.from((ClusterNode)a2, (boolean)name.C.isActive((String)object));
    }

    @GetMapping
    public List<JsonClusterNode> L(@Parameter(hidden=true) Principal principal) {
        ClusterRestController clusterRestController = object;
        Object object = principal;
        ClusterRestController a2 = clusterRestController;
        a.info(EventProcessorRestControllerV2.L((Object)"\u001e48\u0012e\u001d >0*6;e;*o)&6;e!*+ <k"), (Object)AuditLog.username((Principal)object));
        return a2.C.nodes().map(clusterNode -> {
            ClusterRestController a2 = clusterNode;
            ClusterRestController a3 = this;
            ClusterRestController clusterRestController = a2;
            return JsonClusterNode.from((ClusterNode)clusterRestController, (boolean)a3.C.isActive(clusterRestController.getName()));
        }).collect(Collectors.toList());
    }
}

