/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.axoniq.axonserver.applicationevents.TopologyEvents;
import io.axoniq.axonserver.component.processor.ProcessorEventPublisher;
import io.axoniq.axonserver.config.GrpcContextAuthenticationProvider;
import io.axoniq.axonserver.grpc.event.GetAggregateEventsRequest;
import io.axoniq.axonserver.grpc.event.GetAggregateSnapshotsRequest;
import io.axoniq.axonserver.grpc.event.GetEventsRequest;
import io.axoniq.axonserver.localstorage.SerializedEvent;
import io.axoniq.axonserver.localstorage.SerializedEventWithToken;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.message.event.EventDispatcher;
import io.axoniq.axonserver.rest.EventsRestController;
import io.axoniq.axonserver.util.ObjectUtils;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import jakarta.validation.Valid;
import java.security.Principal;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

@RestController(value="EventsRestController")
@RequestMapping(value={"/v1"})
public class EventsRestController {
    private final Logger e;
    private final EventDispatcher C;
    private static final Logger g = AuditLog.getLogger();

    /*
     * WARNING - void declaration
     */
    @GetMapping(path={"events"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public SseEmitter L(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String string, @RequestParam(value="aggregateId", required=false) String string2, @RequestParam(value="initialSequence", defaultValue="0", required=false) long l2, @RequestParam(value="allowSnapshots", defaultValue="true", required=false) boolean bl, @RequestParam(value="trackingToken", defaultValue="0", required=false) long l3, @RequestParam(value="timeout", defaultValue="3600", required=false) long l4, @RequestParam(value="maxEvents", defaultValue="10000", required=false) long l5, @Parameter(hidden=true) Authentication authentication) {
        void a2;
        EventsRestController eventsRestController;
        void a222;
        void trackingToken;
        void initialSequence;
        Disposable aggregateId;
        void context;
        void a3;
        EventsRestController eventsRestController2 = eventsRestController;
        Object[] objectArray = new Object[5];
        objectArray[0] = AuditLog.username((Principal)a3);
        objectArray[1] = context;
        objectArray[2] = aggregateId;
        objectArray[3] = (long)initialSequence;
        objectArray[4] = (long)trackingToken;
        g.info(ProcessorEventPublisher.L((Object)"l|JGLzj'ebFrRtC'QhE'Vi\u0017bAbYs\u001atCuRfZ'Xa\u0017fP`EbPfCb\u0017%Lz\u0015+\u0017tCfEs^iP'Vs\u0017tRvBbYdR'Lz\u001b'Ch\\bY'Lz\u0019"), objectArray);
        SseEmitter a222 = new SseEmitter(Long.valueOf(TimeUnit.SECONDS.toMillis((long)a222)));
        if (aggregateId != null) {
            void allowSnapshots;
            GetAggregateEventsRequest getAggregateEventsRequest = GetAggregateEventsRequest.newBuilder().setAggregateId((String)aggregateId).setAllowSnapshots((boolean)allowSnapshots).setInitialSequence((long)initialSequence).build();
            eventsRestController = new ObjectMapper();
            aggregateId = eventsRestController2.C.aggregateEvents((String)context, (Authentication)ObjectUtils.L((Object)a3, (Object)GrpcContextAuthenticationProvider.C), getAggregateEventsRequest).subscribe(arg_0 -> eventsRestController2.A(a222, (ObjectMapper)eventsRestController, arg_0), arg_0 -> ((SseEmitter)a222).completeWithError(arg_0), () -> {
                EventsRestController a2 = a222;
                EventsRestController a3 = this;
                a3.a((SseEmitter)a2);
            });
            eventsRestController2.L(a222, () -> ((Disposable)aggregateId).dispose());
            return a222;
        }
        GetEventsRequest getEventsRequest = GetEventsRequest.newBuilder().setTrackingToken((long)trackingToken).setNumberOfPermits((long)a2).setClientId(TopologyEvents.L((Object)"203!")).build();
        eventsRestController = Sinks.many().unicast().onBackpressureBuffer();
        eventsRestController2.C.events((String)context, (Authentication)ObjectUtils.L((Object)a3, (Object)GrpcContextAuthenticationProvider.C), eventsRestController.asFlux()).subscribe(serializedEventWithToken -> {
            void a2;
            EventsRestController a3 = serializedEventWithToken;
            EventsRestController a4 = this;
            a4.L((SseEmitter)a2, (SerializedEventWithToken)a3);
        }, arg_0 -> ((SseEmitter)a222).completeWithError(arg_0), () -> {
            EventsRestController a2 = a222;
            EventsRestController a3 = this;
            a3.a((SseEmitter)a2);
        });
        eventsRestController.emitNext((Object)getEventsRequest, Sinks.EmitFailureHandler.FAIL_FAST);
        eventsRestController2.L(a222, () -> EventsRestController.L((Sinks.Many)eventsRestController));
        return a222;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"events"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public Mono<Void> L(@RequestHeader(value="AxonIQ-Context", required=false, defaultValue="default") String string, @Valid @RequestBody JsonEventList jsonEventList, @Parameter(hidden=true) Authentication authentication) {
        void a3;
        void context;
        EventsRestController eventsRestController = eventsRestController2;
        EventsRestController eventsRestController2 = jsonEventList;
        EventsRestController jsonEvents = eventsRestController;
        if (eventsRestController2.messages.isEmpty()) {
            throw new IllegalArgumentException(ProcessorEventPublisher.L((Object)"J^tDnY`\u0017jRtDfPbD"));
        }
        eventsRestController2 = Flux.fromStream(eventsRestController2.messages.stream().map(a2 -> new SerializedEvent(a2.asEvent())));
        return jsonEvents.C.appendEvent((String)context, (Authentication)a3, (Flux)eventsRestController2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void A(SseEmitter sseEmitter, ObjectMapper objectMapper, SerializedEvent serializedEvent) {
        void a2;
        void a3;
        EventsRestController a4 = serializedEvent;
        EventsRestController a5 = this;
        a5.L((SseEmitter)a3, (ObjectMapper)a2, (SerializedEvent)a4);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(SseEmitter sseEmitter, SerializedEvent serializedEvent) {
        EventsRestController a22 = sseEmitter;
        EventsRestController a3 = this;
        try {
            void a4;
            a22.send(SseEmitter.event().data((Object)new JsonEvent(a4.L())));
            return;
        }
        catch (Exception a22) {
            a3.e.debug(TopologyEvents.L((Object)"0\u0018\u0016\u0005\u0005\u0014\u001c\u000f\u001b@\u001a\u000eU\u0013\u0010\u000e\u0011\t\u001b\u0007U\u0005\u0003\u0005\u001b\u0014UMU\u001b\b"), (Object)a22.getMessage(), (Object)a22);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(path={"snapshots"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public SseEmitter L(@RequestHeader(value="AxonIQ-Context", defaultValue="default", required=false) String string, @RequestParam(value="aggregateId", required=true) String string2, @RequestParam(value="maxSequence", defaultValue="-1", required=false) long l2, @RequestParam(value="initialSequence", defaultValue="0", required=false) long l3, @Parameter(hidden=true) Authentication authentication) {
        long maxSequence;
        void a2;
        GetAggregateSnapshotsRequest aggregateId;
        void context;
        void a3;
        EventsRestController eventsRestController = eventsRestController2;
        Object[] objectArray = new Object[5];
        objectArray[0] = AuditLog.username((Principal)a3);
        objectArray[1] = context;
        objectArray[2] = aggregateId;
        objectArray[3] = (long)a2;
        objectArray[4] = maxSequence;
        g.info(TopologyEvents.L((Object)";\u000e\u001d5\u001b\b=U2\u0010\u0011\u0000\u0005\u0006\u0014U\u0006\u001a\u0012U\f\u001c\u0013\u0001@\u001a\u0006U\u0013\u001b\u0001\u0005\u0013\u001d\u000f\u0001\u0013U\u000f\u0013@\u0014\u0007\u0012\u0012\u0010\u0007\u0014\u0014\u0010@W\u001b\bBY@.\u001b\bM\u000e\u001d("), objectArray);
        EventsRestController eventsRestController2 = new SseEmitter();
        aggregateId = GetAggregateSnapshotsRequest.newBuilder().setAggregateId((String)aggregateId).setInitialSequence((long)a2).setMaxSequence(maxSequence >= 0L ? maxSequence : Long.MAX_VALUE).build();
        eventsRestController.C.aggregateSnapshots(StringUtils.getOrDefault((String)context, (String)"default"), (Authentication)ObjectUtils.L((Object)a3, (Object)GrpcContextAuthenticationProvider.C), aggregateId).doOnError(arg_0 -> ((SseEmitter)eventsRestController2).completeWithError(arg_0)).doOnComplete(() -> eventsRestController.A((SseEmitter)eventsRestController2)).subscribe(arg_0 -> eventsRestController.L((SseEmitter)eventsRestController2, arg_0));
        return eventsRestController2;
    }

    public EventsRestController(EventDispatcher eventDispatcher) {
        EventsRestController a2;
        EventsRestController a3 = eventDispatcher;
        EventsRestController eventsRestController = a2 = this;
        eventsRestController.e = LoggerFactory.getLogger(EventsRestController.class);
        eventsRestController.C = a3;
    }

    private static /* synthetic */ void L(Runnable runnable, Throwable throwable) {
        Throwable a2 = throwable;
        Runnable a3 = runnable;
        a3.run();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void a(SseEmitter sseEmitter) {
        void a2;
        EventsRestController eventsRestController = this;
        try {
            a2.send(SseEmitter.event().comment(ProcessorEventPublisher.L((Object)"riS'Xa\u0017tCuRfZ")));
            return;
        }
        catch (Exception a3) {
            eventsRestController.e.debug(TopologyEvents.L((Object)"%\u0007\u0012\u001a\u0012U\u000f\u001b@\u0006\u0005\u001b\u0004\u001c\u000e\u0012@\u0016\u000f\u0018\u0010\u0019\u0005\u0001\u0005\u0011"), (Throwable)a3);
            return;
        }
        finally {
            a2.complete();
        }
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"snapshot"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    @Deprecated
    public Mono<Void> A(@RequestHeader(value="AxonIQ-Context", required=false, defaultValue="default") String string, @RequestBody @Valid JsonEvent jsonEvent, @Parameter(hidden=true) Authentication authentication) {
        void jsonEvent2;
        void context;
        EventsRestController eventsRestController = eventsRestController2;
        EventsRestController eventsRestController2 = authentication;
        EventsRestController a2 = eventsRestController;
        g.warn(TopologyEvents.L((Object)".\u001b\b \u000e\u001d(@'\u0005\u0004\u0015\u0010\u0013\u0001@\u0001\u000fU\u0001\u0005\u0010\u0010\u000e\u0011@\u0010\u0016\u0010\u000e\u0001H\u0006IU\u0015\u0006\t\u001b\u0007U\u0004\u0010\u0010\u0007\u0005\u0016\u0001\u0001\u0005\u0011@40<"), (Object)AuditLog.username((Principal)eventsRestController2), (Object)context);
        return a2.L((String)context, (JsonEvent)jsonEvent2, (Authentication)eventsRestController2);
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"snapshots"})
    @Parameters(value={@Parameter(name="AxonIQ-Access-Token", description="Access Token", in=ParameterIn.HEADER)})
    public Mono<Void> L(@RequestHeader(value="AxonIQ-Context", required=false, defaultValue="default") String string, @RequestBody @Valid JsonEvent jsonEvent, @Parameter(hidden=true) Authentication authentication) {
        void jsonEvent2;
        void context;
        EventsRestController eventsRestController = eventsRestController2;
        EventsRestController eventsRestController2 = authentication;
        EventsRestController a2 = eventsRestController;
        g.info(ProcessorEventPublisher.L((Object)"\\Lzw|JZ\u0017URvBbDs\u0017sX'VwGbYc\u0017bAbYs\u001ft\u001e"), (Object)AuditLog.username((Principal)eventsRestController2), (Object)context);
        return a2.C.appendSnapshot(StringUtils.getOrDefault((String)context, (String)"default"), jsonEvent2.asEvent(), (Authentication)ObjectUtils.L((Object)eventsRestController2, (Object)GrpcContextAuthenticationProvider.C));
    }

    private /* synthetic */ void A(SseEmitter sseEmitter) {
        EventsRestController a2 = sseEmitter;
        EventsRestController a3 = this;
        a3.a((SseEmitter)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(SseEmitter sseEmitter, Runnable runnable) {
        void a2;
        Object a3 = runnable;
        EventsRestController a4 = this;
        a2.onError(arg_0 -> EventsRestController.L((Runnable)a3, arg_0));
        a2.onCompletion(((Runnable)a3)::run);
        a2.onTimeout(((Runnable)a3)::run);
    }

    private static /* synthetic */ void L(Sinks.Many a2) {
        a2.emitComplete(Sinks.EmitFailureHandler.FAIL_FAST);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(SseEmitter sseEmitter, ObjectMapper objectMapper, SerializedEvent serializedEvent) {
        EventsRestController a22 = sseEmitter;
        EventsRestController a3 = this;
        try {
            void a4;
            void a5;
            a22.send(SseEmitter.event().data((Object)a5.writeValueAsString((Object)new JsonEvent(a4.L()))));
            return;
        }
        catch (Exception a22) {
            a3.e.debug(ProcessorEventPublisher.L((Object)"r\u007fTbGs^hY'Xi\u0017tRiSnY`\u0017bAbYs\u0017*\u0017|J"), (Object)a22.getMessage(), (Object)a22);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void L(SseEmitter sseEmitter, SerializedEventWithToken serializedEventWithToken) {
        void a2;
        EventsRestController a222 = serializedEventWithToken;
        EventsRestController a3 = this;
        try {
            a2.send(SseEmitter.event().id(String.valueOf(a222.L() + 1L)).data((Object)new JsonEvent(a222.L())));
            return;
        }
        catch (Exception a222) {
            Exception exception = a222;
            a3.e.debug(TopologyEvents.L((Object)"0\u0018\u0016\u0005\u0005\u0014\u001c\u000f\u001b@\u001a\u000eU\u0013\u0010\u000e\u0011\t\u001b\u0007U\u0005\u0003\u0005\u001b\u0014UMU\u001b\b"), (Object)exception.getMessage(), (Object)a222);
            a2.completeWithError((Throwable)exception);
            return;
        }
    }
}

