/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.access.application.ReplicationGroupApplicationController;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.configuration.common.PluginKey;
import io.axoniq.axonserver.exception.ErrorCode;
import io.axoniq.axonserver.exception.MessagingPlatformException;
import io.axoniq.axonserver.localstorage.file.multitier.MultiTierInformationProvider;
import io.axoniq.axonserver.logging.AuditLog;
import io.axoniq.axonserver.plugin.PluginController;
import io.axoniq.axonserver.plugin.PluginInfo;
import io.axoniq.axonserver.plugin.SimplePluginKey;
import io.axoniq.axonserver.rest.PluginConfigurationJSON;
import io.axoniq.axonserver.rest.PluginPropertyGroup;
import io.axoniq.axonserver.util.StringUtils;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"v1/plugins"})
@CrossOrigin
public class PluginsRestController {
    private final PluginController a;
    private final boolean I;
    public static final String A = "Plugins disabled";
    private final Logger e;
    private static final Logger C = AuditLog.getLogger();
    private final FeatureChecker g;

    @GetMapping
    public Iterable<PluginInfo> L(@Parameter(hidden=true) Principal principal) {
        PluginsRestController pluginsRestController = object;
        Object object = principal;
        PluginsRestController a2 = pluginsRestController;
        C.info(MultiTierInformationProvider.L((Object)"\u0019j?LbC'`7t1ebe-1.x1ebr7c0t,eba.d%x,bl1"), (Object)AuditLog.username((Principal)object));
        return a2.a.listPlugins();
    }

    private /* synthetic */ String L(String string) {
        String a2 = string;
        PluginsRestController a3 = this;
        if (a2 == null) {
            throw new MessagingPlatformException(ErrorCode.OTHER, ReplicationGroupApplicationController.L((Object)"P`>\u007frzyfp/nn}d\u007fh{/n}qywk{k"));
        }
        if (a2.contains(File.separator)) {
            throw new MessagingPlatformException(ErrorCode.OTHER, MultiTierInformationProvider.L((Object)"W+}'\u007f#|'11y-d.ub\u007f-ebr-\u007f6p+\u007fbu+c'r6~0hbb'a#c#e-c"));
        }
        int n = a2.lastIndexOf(46);
        if (n > 0) {
            return a2.substring(0, n) + "-" + System.currentTimeMillis() + a2.substring(n);
        }
        return (String)a2 + "-" + System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"configuration"})
    public void L(@RequestBody PluginConfigurationJSON pluginConfigurationJSON, @Parameter(hidden=true) Principal principal) {
        void a2;
        PluginsRestController pluginsRestController = pluginsRestController2;
        PluginsRestController pluginsRestController2 = pluginConfigurationJSON;
        PluginsRestController configurationJSON = pluginsRestController;
        if (!configurationJSON.I || !configurationJSON.g.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, A);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)pluginsRestController2.getName());
        objectArray[2] = StringUtils.sanitize((String)pluginsRestController2.getVersion());
        C.info(ReplicationGroupApplicationController.L((Object)"TerC/Ljoz{|j/j`>znk\u007f{{/}`piwhk}\u007f{w`p/qi>tc er0/"), objectArray);
        configurationJSON.a.updateConfiguration((PluginKey)new SimplePluginKey(pluginsRestController2.getName(), pluginsRestController2.getVersion()), pluginsRestController2.getContext(), pluginsRestController2.getProperties());
    }

    @PostMapping(consumes={"multipart/form-data"})
    public PluginKey L(@RequestPart(value="bundle") MultipartFile multipartFile, @Parameter(hidden=true) Principal principal) throws IOException {
        PluginKey pluginBundle2;
        block6: {
            PluginsRestController pluginsRestController = object;
            Object object = principal;
            PluginsRestController a2 = pluginsRestController;
            if (!a2.I || !a2.g.plugins()) {
                throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, A);
            }
            C.info(MultiTierInformationProvider.L((Object)"J9l\u001f1\u0010t3d'b616~bx,b6p.}ba.d%x,19ll1"), (Object)AuditLog.username((Principal)object), (Object)StringUtils.sanitize((String)pluginBundle2.getOriginalFilename()));
            object = pluginBundle2.getInputStream();
            try {
                PluginsRestController pluginsRestController2 = a2;
                String string = pluginsRestController2.L(pluginBundle2.getOriginalFilename());
                pluginBundle2 = pluginsRestController2.a.addPlugin(string, (InputStream)object);
                if (object == null) break block6;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                block7: {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                            throwable2 = throwable;
                            break block7;
                        }
                        catch (Throwable pluginBundle2) {
                            throwable.addSuppressed(pluginBundle2);
                        }
                    }
                    throwable2 = throwable;
                }
                throw throwable2;
            }
            ((InputStream)object).close();
        }
        return pluginBundle2;
    }

    /*
     * WARNING - void declaration
     */
    public PluginsRestController(PluginController pluginController, MessagingPlatformConfiguration messagingPlatformConfiguration, FeatureChecker featureChecker) {
        void a2;
        void a3;
        PluginsRestController a4;
        PluginsRestController a5 = featureChecker;
        PluginsRestController pluginsRestController = a4 = this;
        PluginsRestController pluginsRestController2 = a4;
        pluginsRestController2.e = LoggerFactory.getLogger(PluginsRestController.class);
        pluginsRestController2.I = a3.isPluginsEnabled();
        pluginsRestController.a = a2;
        pluginsRestController.g = a5;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"configuration"})
    public Iterable<PluginPropertyGroup> L(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = this;
        if (!pluginsRestController.I || !pluginsRestController.g.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, A);
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        C.info(MultiTierInformationProvider.L((Object)"J9l\u001f1\u0010t3d'b61$~01!~,w+v7c#e+~,1-wbj?>9ll1"), objectArray);
        try {
            void context;
            return pluginsRestController.a.listProperties((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context);
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = name;
            objectArray2[1] = version;
            objectArray2[2] = runtimeException;
            pluginsRestController.e.warn(ReplicationGroupApplicationController.L((Object)"I\u007ffrjz/j`>}{{lf{y{/n}q\u007f{}jf{|>iq}>tc5er"), objectArray2);
            throw runtimeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"context"})
    public void L(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @Parameter(hidden=true) Principal principal) {
        void version;
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string3;
        PluginsRestController context = pluginsRestController;
        if (!context.I || !context.g.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, A);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)version);
        objectArray[3] = StringUtils.sanitize((String)object);
        C.info(ReplicationGroupApplicationController.L((Object)"TerC/Ljoz{|j/j`>zp}{hw|jjl/nckhwa>tc er>iq}>lqajjf{>tc!"), objectArray);
        context.a.unregisterPluginForContext((PluginKey)new SimplePluginKey((String)name, (String)version), (String)object);
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping
    public void L(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @Parameter(hidden=true) Principal principal) {
        void name;
        void a2;
        PluginsRestController pluginsRestController = object;
        Object object = string2;
        PluginsRestController version = pluginsRestController;
        Object[] objectArray = new Object[3];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = StringUtils.sanitize((String)name);
        objectArray[2] = StringUtils.sanitize((String)object);
        C.info(ReplicationGroupApplicationController.L((Object)"EtcR>]{~kjm{>{q/kawam{\u007fcr/nckhwa>tc er0/"), objectArray);
        version.a.uninstallPlugin((PluginKey)new SimplePluginKey((String)name, (String)object));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"status"})
    public void L(@RequestParam(value="name") String string, @RequestParam(value="version") String string2, @RequestParam(required=false, name="targetContext") String string3, @RequestParam(value="active") boolean bl, @Parameter(hidden=true) Principal principal) {
        void context;
        void version;
        void name;
        void a2;
        boolean bl2 = bl;
        PluginsRestController active = this;
        if (!active.I || !active.g.plugins()) {
            throw new MessagingPlatformException(ErrorCode.PLUGINS_DISABLED, A);
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = AuditLog.username((Principal)a2);
        objectArray[1] = this != false ? ReplicationGroupApplicationController.L((Object)"|jnl{") : MultiTierInformationProvider.L((Object)"1e-a");
        objectArray[2] = StringUtils.sanitize((String)name);
        objectArray[3] = StringUtils.sanitize((String)version);
        C.info(MultiTierInformationProvider.L((Object)"J9l\u001f1\u0010t3d'b616~bj?12}7v+\u007fbj?>9ll1"), objectArray);
        active.a.updatePluginStatus((PluginKey)new SimplePluginKey((String)name, (String)version), (String)context, (boolean)this);
    }
}

