/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.rest;

import io.axoniq.axonserver.config.AccessControlConfiguration;
import io.axoniq.axonserver.config.FeatureChecker;
import io.axoniq.axonserver.config.MessagingPlatformConfiguration;
import io.axoniq.axonserver.config.SslConfiguration;
import io.axoniq.axonserver.localstorage.file.AggregateSequence;
import io.axoniq.axonserver.message.command.CommandDispatcher;
import io.axoniq.axonserver.message.event.EventDispatcher;
import io.axoniq.axonserver.message.query.QueryDispatcher;
import io.axoniq.axonserver.message.query.subscription.metric.HubSubscriptionMetrics;
import io.axoniq.axonserver.message.query.subscription.metric.SubscriptionQueryMetricRegistry;
import io.axoniq.axonserver.rest.LicenseInfo;
import io.axoniq.axonserver.rest.PublicRestController;
import io.axoniq.axonserver.rest.json.NodeConfiguration;
import io.axoniq.axonserver.rest.json.StatusInfo;
import io.axoniq.axonserver.rest.json.UserInfo;
import io.axoniq.axonserver.rest.svg.mapping.AxonServer;
import io.axoniq.axonserver.topology.Topology;
import io.axoniq.axonserver.version.VersionInfo;
import io.axoniq.axonserver.version.VersionInfoProvider;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@CrossOrigin
@RestController(value="PublicRestController")
@RequestMapping(value={"/v1/public"})
public class PublicRestController {
    private final boolean G;
    private final VersionInfoProvider k;
    private final Map<String, Boolean> h;
    private final Function<Predicate<String>, Stream<AxonServer>> L;
    private final EventDispatcher m;
    private final FeatureChecker M;
    @Value(value="${axoniq.axonserver.devmode.enabled:false}")
    private boolean i;
    private final QueryDispatcher a;
    private final SslConfiguration I;
    private final CommandDispatcher A;
    private final AccessControlConfiguration e;
    private final SubscriptionQueryMetricRegistry C;
    private final Topology g;

    @GetMapping(path={"version"})
    @Operation(summary="Retrieves version information of the product")
    public VersionInfo L() {
        PublicRestController a2;
        return a2.k.get();
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(path={"status"})
    @Operation(summary="Retrieves status information, used by UI")
    public StatusInfo L(@RequestParam(value="context", defaultValue="default", required=false) String string) {
        void a2;
        PublicRestController publicRestController = this;
        HubSubscriptionMetrics hubSubscriptionMetrics = publicRestController.C.get((String)a2);
        PublicRestController publicRestController2 = this = new StatusInfo();
        publicRestController2.setCommandRate(publicRestController.A.commandRate((String)a2));
        publicRestController2.setQueryRate(publicRestController.a.queryRate((String)a2));
        if (!a2.startsWith(AggregateSequence.L((Object)"\n"))) {
            PublicRestController publicRestController3 = this;
            PublicRestController publicRestController4 = publicRestController;
            this.setEventRate(publicRestController.m.eventRate((String)a2));
            this.setSnapshotRate(publicRestController4.m.snapshotRate((String)a2));
            publicRestController3.setNrOfEvents(publicRestController4.m.getNrOfEvents((String)a2));
            publicRestController3.setEventTrackers(publicRestController.m.eventTrackerStatus((String)a2));
        }
        PublicRestController publicRestController5 = this;
        HubSubscriptionMetrics hubSubscriptionMetrics2 = hubSubscriptionMetrics;
        this.setNrOfActiveSubscriptionQueries(hubSubscriptionMetrics2.activesCount().longValue());
        publicRestController5.setNrOfSubscriptionQueries(hubSubscriptionMetrics2.totalCount().longValue());
        publicRestController5.setNrOfSubscriptionQueriesUpdates(hubSubscriptionMetrics.updatesCount().longValue());
        return this;
    }

    @GetMapping
    @Operation(summary="Retrieves all nodes in the cluster that the current node knows about.", description="For _admin nodes the result contains all nodes, for non _admin nodes theresult only contains nodes from contexts available on this node and the _admin nodes.")
    public List<JsonServerNode> L() {
        PublicRestController a2;
        return ((Stream)a2.L.apply(null)).map(JsonServerNode::new).sorted(Comparator.comparing(JsonServerNode::getName)).collect(Collectors.toList());
    }

    @GetMapping(path={"license"})
    @Operation(summary="Retrieves license information")
    public LicenseInfo L() {
        PublicRestController a2;
        PublicRestController publicRestController = this;
        PublicRestController publicRestController2 = a2 = new LicenseInfo();
        PublicRestController publicRestController3 = publicRestController;
        a2.setExpiryDate(publicRestController.M.getExpiryDate());
        a2.setEdition(publicRestController3.M.getEdition());
        publicRestController2.setLicensee(publicRestController3.M.getLicensee());
        publicRestController2.setFeatureList(publicRestController.M.getFeatureList());
        return publicRestController2;
    }

    @GetMapping(path={"mycontexts"})
    @Operation(summary="Retrieves names for all storage (non admin) contexts for the current node")
    public Iterable<String> L() {
        PublicRestController a2;
        return a2.g.getMyStorageContextNames();
    }

    /*
     * WARNING - void declaration
     */
    public PublicRestController(Function<Predicate<String>, Stream<AxonServer>> function, Topology topology, CommandDispatcher commandDispatcher, QueryDispatcher queryDispatcher, EventDispatcher eventDispatcher, FeatureChecker featureChecker, MessagingPlatformConfiguration messagingPlatformConfiguration, VersionInfoProvider versionInfoProvider, SubscriptionQueryMetricRegistry subscriptionQueryMetricRegistry) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        PublicRestController a10;
        PublicRestController a11;
        PublicRestController publicRestController = publicRestController2;
        PublicRestController publicRestController2 = messagingPlatformConfiguration;
        PublicRestController publicRestController3 = a11 = publicRestController;
        PublicRestController publicRestController4 = a11;
        PublicRestController publicRestController5 = a10;
        PublicRestController publicRestController6 = a11;
        PublicRestController publicRestController7 = a11;
        PublicRestController publicRestController8 = a11;
        a11.L = a9;
        publicRestController8.g = a8;
        publicRestController8.A = a7;
        publicRestController7.a = a6;
        publicRestController7.m = a5;
        publicRestController6.M = a4;
        publicRestController6.I = a10.getSsl();
        a11.e = publicRestController5.getAccesscontrol();
        publicRestController4.G = publicRestController5.isPluginsEnabled();
        publicRestController4.k = a3;
        publicRestController3.C = a2;
        publicRestController3.h = a10.getPreview();
    }

    @GetMapping(path={"user"})
    @Operation(summary="Retrieves information on the user logged in in the current Http Session")
    public UserInfo L(HttpServletRequest httpServletRequest) {
        PublicRestController a2 = httpServletRequest;
        PublicRestController a3 = this;
        if (a2.getUserPrincipal() instanceof Authentication) {
            a2 = (Authentication)a2.getUserPrincipal();
            return new UserInfo(a2.getName(), a2.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet()));
        }
        return null;
    }

    @GetMapping(path={"me"})
    @Operation(summary="Retrieves general information on the configuration of the current node, including hostnames and ports for the gRPC and HTTP connections and contexts")
    public NodeConfiguration L() {
        PublicRestController a2;
        PublicRestController publicRestController = this;
        PublicRestController publicRestController2 = a2 = new NodeConfiguration(publicRestController.g.getMe());
        PublicRestController publicRestController3 = publicRestController;
        PublicRestController publicRestController4 = a2;
        PublicRestController publicRestController5 = publicRestController;
        a2.setAuthentication(publicRestController.e.isEnabled());
        a2.setSsl(publicRestController5.I.isEnabled());
        publicRestController4.setAdminNode(publicRestController5.g.isAdminNode());
        publicRestController4.setDevelopmentMode(publicRestController.i);
        a2.setContextNames(publicRestController3.g.getMyContextNames());
        publicRestController2.setStorageContextNames(publicRestController3.g.getMyStorageContextNames());
        publicRestController2.setPluginsEnabled(publicRestController.G && publicRestController.M.plugins());
        PublicRestController publicRestController6 = a2;
        PublicRestController publicRestController7 = publicRestController;
        a2.setInitialized(publicRestController.g.initialized());
        a2.setMaxApplications(publicRestController7.M.getMaxApplications());
        publicRestController6.setMaxConnections(publicRestController7.M.maxConnections());
        publicRestController6.setMaxContexts(publicRestController.M.getMaxContexts().orElse(Integer.MAX_VALUE).intValue());
        a2.setMaxReplicationGroups(publicRestController.M.getMaxReplicationGroups().orElse(Integer.MAX_VALUE).intValue());
        PublicRestController publicRestController8 = a2;
        publicRestController8.setMaxUsers(publicRestController.M.getMaxUsers());
        return publicRestController8;
    }
}

